-- ===========================
-- Migration script
-- from version 109 to version 110
-- ===========================

CREATE TABLE WebPage (
	id INTEGER PRIMARY KEY AUTOINCREMENT ,
	pos DECIMAL DEFAULT -1,
	title TEXT NOT NULL,
	image_path TEXT NOT NULL,
	current_page_url_id INTEGER DEFAULT -1,
	current_page_icon_path TEXT NOT NULL,
	is_select INTEGER DEFAULT 0
);

CREATE TABLE WebPageUrl (
	id INTEGER PRIMARY KEY AUTOINCREMENT ,
	web_page_id INTEGER DEFAULT -1,
	url_index INTEGER DEFAULT -1,
	title TEXT NOT NULL,
	url TEXT NOT NULL,
	ori_url TEXT NOT NULL
);

CREATE TABLE BrowserHistory (
	id INTEGER PRIMARY KEY AUTOINCREMENT ,
	update_time NUMERIC DEFAULT -1,
	url TEXT NOT NULL,
	title TEXT NOT NULL,
	icon_path TEXT NOT NULL
);

CREATE INDEX browser_history_update_time_idx ON BrowserHistory(update_time);
CREATE INDEX web_page_pos_idx ON WebPage(pos);