-- ===========================
-- Migration script
-- from version 66 to version 67
-- ===========================

CREATE TABLE DeletedMessage (
	global_id INTEGER PRIMARY KEY ,
	server_time NUMERIC NOT NULL ,
	is_deleted INTEGER DEFAULT 0
);

CREATE TABLE DeletedChatroom (
	chatroom_name TEXT PRIMARY KEY ,
	delete_time NUMERIC NOT NULL ,
	is_deleted INTEGER DEFAULT 0
);

CREATE TABLE Setting (
	setting_key TEXT PRIMARY KEY ,
	setting_value TEXT NOT NULL
);

CREATE TABLE UnFinishedControl (
	id INTEGER PRIMARY KEY AUTOINCREMENT,
	control_type INTEGER NOT NULL ,
	payload TEXT NOT NULL
);

CREATE INDEX deleted_message_time_idx ON DeletedMessage(server_time);
CREATE INDEX deleted_message_is_deleted ON DeletedMessage(is_deleted);
CREATE INDEX deleted_chatroom_is_deleted ON DeletedMessage(is_deleted);
