/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.filter.Filter;
import com.sun.jna.Platform;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.SplashScreen;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Date;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.jdesktop.beansbinding.ELProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.Log4jBackstop;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.ThresholdLoggerFilter;
import org.tinymediamanager.TmmOsUtils;
import org.tinymediamanager.UpgradeTasks;
import org.tinymediamanager.cli.TinyMediaManagerCLI;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmDateFormat;
import org.tinymediamanager.core.TmmModuleManager;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.http.TmmHttpServer;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettingsDefaults;
import org.tinymediamanager.core.movie.tasks.MovieUpdateDatasourceTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettingsDefaults;
import org.tinymediamanager.core.tvshow.tasks.TvShowUpdateDatasourceTask;
import org.tinymediamanager.license.License;
import org.tinymediamanager.scraper.MediaProviders;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.thirdparty.KodiRPC;
import org.tinymediamanager.thirdparty.upnp.Upnp;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmTaskbar;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.TmmUILogCollector;
import org.tinymediamanager.ui.dialogs.MessageDialog;
import org.tinymediamanager.ui.dialogs.WhatsNewDialog;
import org.tinymediamanager.ui.images.LogoCircle;
import org.tinymediamanager.ui.wizard.TinyMediaManagerWizard;

public final class TinyMediaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TinyMediaManager.class);

    public static void main(final String[] args) {
        try {
            License.getInstance().init();
        }
        catch (Exception e) {
            LOGGER.error("Could not initialize license module!");
        }
        if (args != null && args.length > 0) {
            LOGGER.debug("TMM started with: {}", (Object)Arrays.toString(args));
            if (!TinyMediaManagerCLI.checkArgs(args)) {
                TinyMediaManager.shutdownLogger();
                System.exit(0);
            }
            System.setProperty("java.awt.headless", "true");
        } else {
            String head = System.getProperty("java.awt.headless");
            if (head != null && head.equals("true")) {
                LOGGER.info("TMM started 'headless', and without params -> displaying syntax ");
                TinyMediaManagerCLI.printHelp();
                TinyMediaManager.shutdownLogger();
                System.exit(0);
            }
            TinyMediaManager.setConsoleLogLevel();
        }
        try {
            RandomAccessFile f = new RandomAccessFile("access.test", "rw");
            f.close();
            Files.deleteIfExists(Paths.get("access.test", new String[0]));
        }
        catch (Exception e2) {
            String msg = "Cannot write to TMM directory, have no rights - exiting.";
            if (!GraphicsEnvironment.isHeadless()) {
                JOptionPane.showMessageDialog(null, msg);
            } else {
                System.out.println(msg);
            }
            TinyMediaManager.shutdownLogger();
            System.exit(1);
        }
        Path license = Paths.get(Globals.DATA_FOLDER, "tmm.lic");
        if (Files.exists(license, new LinkOption[0])) {
            try {
                License.getInstance().setLicenseCode(Utils.readFileToString(license));
            }
            catch (Exception e) {
                LOGGER.warn("unable to decode license file - {}", (Object)e.getMessage());
            }
        }
        LOGGER.info("=======================================================");
        LOGGER.info("=== tinyMediaManager (c) 2012 - 2023 Manuel Laggner ===");
        LOGGER.info("=======================================================");
        LOGGER.info("tmm.version      : {}", (Object)ReleaseInfo.getRealVersion());
        if (!ReleaseInfo.isGitBuild()) {
            LOGGER.info("tmm.build        : {}", (Object)ReleaseInfo.getRealBuildDate());
        }
        if (Globals.isDocker()) {
            LOGGER.info("tmm.docker       : true");
        }
        LOGGER.info("os.name          : {}", (Object)System.getProperty("os.name"));
        LOGGER.info("os.version       : {}", (Object)System.getProperty("os.version"));
        LOGGER.info("os.arch          : {}", (Object)System.getProperty("os.arch"));
        LOGGER.info("java.version     : {}", (Object)System.getProperty("java.version"));
        LOGGER.info("java.maxMem      : {} MiB", (Object)(Runtime.getRuntime().maxMemory() / 1024L / 1024L));
        if (Globals.isRunningJavaWebStart()) {
            LOGGER.info("java.webstart    : true");
        }
        if (Globals.isRunningWebSwing()) {
            LOGGER.info("java.webswing    : true");
        }
        TinyMediaManager.debugCharacterEncoding("current encoding : ");
        Locale.setDefault(Utils.getLocaleFromLanguage(Settings.getInstance().getLanguage()));
        LOGGER.info("System language  : {}_{}", (Object)System.getProperty("user.language"), (Object)System.getProperty("user.country"));
        LOGGER.info("GUI language     : {}_{}", (Object)Locale.getDefault().getLanguage(), (Object)Locale.getDefault().getCountry());
        LOGGER.info("Scraper language : {}", (Object)MovieModuleManager.getInstance().getSettings().getScraperLanguage());
        LOGGER.info("TV Scraper lang  : {}", (Object)TvShowModuleManager.getInstance().getSettings().getScraperLanguage());
        if (args != null) {
            LOGGER.info("Start parameters : {}", (Object)String.join((CharSequence)" ", args));
        }
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        LOGGER.info("JVM parameters   : {}", (Object)String.join((CharSequence)" ", runtimeMXBean.getInputArguments()));
        EventQueue.invokeLater(new Runnable(){
            private SplashScreen splash = null;
            private Graphics2D splashG2d = null;

            @Override
            public void run() {
                boolean newVersion = !Settings.getInstance().isCurrentVersion();
                try {
                    Upnp u;
                    Thread.setDefaultUncaughtExceptionHandler(new Log4jBackstop());
                    if (!GraphicsEnvironment.isHeadless()) {
                        Thread.currentThread().setName("main");
                        TmmTaskbar.setImage(new LogoCircle(512).getImage());
                    } else {
                        Thread.currentThread().setName("headless");
                        LOGGER.debug("starting without GUI...");
                    }
                    if (!GraphicsEnvironment.isHeadless()) {
                        TinyMediaManager.setLookAndFeel();
                    }
                    this.doStartupTasks();
                    org.jdesktop.beansbinding.util.logging.Logger.getLogger((String)ELProperty.class.getName()).setLevel(java.util.logging.Level.SEVERE);
                    TmmUILogCollector.init();
                    LOGGER.info("=====================================================");
                    this.initSplash();
                    this.updateProgress("starting tinyMediaManager", 0);
                    LOGGER.info("starting tinyMediaManager");
                    UpgradeTasks.setOldVersion();
                    if (newVersion) {
                        LOGGER.info("Upgrade from '{}' to '{}'", (Object)UpgradeTasks.getOldVersion(), (Object)ReleaseInfo.getVersion());
                        this.updateProgress("upgrading to new version", 10);
                        UpgradeTasks.performUpgradeTasksBeforeDatabaseLoading();
                        Settings.getInstance().setCurrentVersion();
                        Settings.getInstance().saveSettings();
                    }
                    this.updateProgress("loading internals", 20);
                    TmmOsUtils.loadNativeLibs();
                    if (License.getInstance().validUntil() != null) {
                        LOGGER.info("{}", (Object)License.getInstance().sig());
                        LOGGER.info("{}", (Object)License.getInstance().dat());
                    }
                    MediaGenres.init();
                    LanguageUtils.init();
                    if (Settings.getInstance().isEnableHttpServer()) {
                        try {
                            TmmHttpServer.getInstance();
                        }
                        catch (Exception e) {
                            LOGGER.error("could not start webserver: {}", (Object)e.getMessage());
                        }
                    }
                    this.updateProgress("loading movie module", 30);
                    TmmModuleManager.getInstance().startUp();
                    TmmModuleManager.getInstance().registerModule(MovieModuleManager.getInstance());
                    TmmModuleManager.getInstance().enableModule(MovieModuleManager.getInstance());
                    this.updateProgress("loading TV show module", 40);
                    TmmModuleManager.getInstance().registerModule(TvShowModuleManager.getInstance());
                    TmmModuleManager.getInstance().enableModule(TvShowModuleManager.getInstance());
                    this.updateProgress("loading plugins", 50);
                    MediaProviders.loadMediaProviders();
                    if (Settings.getInstance().isNewConfig()) {
                        MovieSettingsDefaults.setDefaultScrapers();
                        TvShowSettingsDefaults.setDefaultScrapers();
                    }
                    this.updateProgress("starting services", 60);
                    try {
                        if (Settings.getInstance().isUpnpShareLibrary()) {
                            u = Upnp.getInstance();
                            u.startWebServer();
                            u.createUpnpService();
                            u.startMediaServer();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Could not start UPNP - '{}'", (Object)e.getMessage());
                    }
                    try {
                        if (Settings.getInstance().isUpnpRemotePlay()) {
                            u = Upnp.getInstance();
                            u.createUpnpService();
                            u.sendPlayerSearchRequest();
                            u.startWebServer();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Could not start UPNP - '{}'", (Object)e.getMessage());
                    }
                    try {
                        KodiRPC.getInstance().connect();
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                    }
                    if (newVersion) {
                        this.updateProgress("upgrading database to new version", 70);
                        UpgradeTasks.performUpgradeTasksAfterDatabaseLoading();
                    }
                    this.updateProgress("loading ui", 80);
                    if (!GraphicsEnvironment.isHeadless()) {
                        TmmThreadPool task;
                        LocalDate validUntil;
                        MainWindow window = MainWindow.getInstance();
                        this.updateProgress("finished starting :)", 100);
                        TmmUILayoutStore.getInstance().loadSettings(window);
                        window.setVisible(true);
                        LOGGER.info("UI loaded");
                        if (Settings.getInstance().isNewConfig()) {
                            TinyMediaManagerWizard wizard = new TinyMediaManagerWizard();
                            wizard.setLocationRelativeTo(null);
                            wizard.setVisible(true);
                        } else if (Settings.getInstance().isEnableAutomaticUpdate() && !Boolean.parseBoolean(System.getProperty("tmm.noupdate")) && TmmUIHelper.shouldCheckForUpdate()) {
                            TmmUIHelper.checkForUpdate(5);
                        }
                        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                            LOGGER.info("received shutdown signal");
                            if (!GraphicsEnvironment.isHeadless()) {
                                MainWindow.getInstance().saveWindowLayout();
                            }
                            TinyMediaManager.shutdown();
                            TinyMediaManager.shutdownLogger();
                        }));
                        if (newVersion && !ReleaseInfo.getVersion().equals(UpgradeTasks.getOldVersion())) {
                            SwingUtilities.invokeLater(WhatsNewDialog::showChangelog);
                        }
                        if (newVersion && UpgradeTasks.getOldVersion().startsWith("3")) {
                            TmmUIHelper.restartWarningAfterV4Upgrade();
                        }
                        if (License.getInstance().isValidLicense() && (validUntil = License.getInstance().validUntil()) != null && validUntil.minus(7L, ChronoUnit.DAYS).isBefore(LocalDate.now())) {
                            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(window, TmmResourceBundle.getString("tmm.renewlicense").replace("{}", TmmDateFormat.MEDIUM_DATE_FORMAT.format(Date.valueOf(validUntil)))));
                        }
                        if (MovieModuleManager.getInstance().getSettings().isUpdateOnStart()) {
                            task = new MovieUpdateDatasourceTask();
                            TmmTaskManager.getInstance().addMainTask(task);
                        }
                        if (TvShowModuleManager.getInstance().getSettings().isUpdateOnStart()) {
                            task = new TvShowUpdateDatasourceTask();
                            TmmTaskManager.getInstance().addMainTask(task);
                        }
                    } else {
                        TinyMediaManager.setConsoleLogLevel();
                        TinyMediaManagerCLI.start(args);
                        while (TmmTaskManager.getInstance().poolRunning()) {
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (InterruptedException window) {}
                        }
                        LOGGER.info("bye bye");
                        TinyMediaManager.shutdown();
                        TinyMediaManager.shutdownLogger();
                        System.exit(0);
                    }
                }
                catch (IllegalStateException e) {
                    LOGGER.error("IllegalStateException", (Throwable)e);
                    if (!GraphicsEnvironment.isHeadless() && e.getMessage().contains("file is locked")) {
                        JOptionPane.showMessageDialog(null, TmmResourceBundle.getString("tmm.nostart") + "\n" + TmmResourceBundle.getString("tmm.nostart.instancerunning"), TmmResourceBundle.getString("tmm.nostart"), 0, new LogoCircle());
                    }
                    TinyMediaManager.shutdownLogger();
                    System.exit(1);
                }
                catch (Exception e) {
                    LOGGER.error("Exception while start of tmm", (Throwable)e);
                    if (!GraphicsEnvironment.isHeadless()) {
                        MessageDialog.showExceptionWindow(e);
                    }
                    TinyMediaManager.shutdownLogger();
                    System.exit(1);
                }
            }

            private void initSplash() {
                if (!GraphicsEnvironment.isHeadless()) {
                    this.splash = SplashScreen.getSplashScreen();
                }
                if (this.splash != null) {
                    this.splashG2d = this.splash.createGraphics();
                    if (this.splashG2d != null) {
                        Font font = new Font("Dialog", 0, 11);
                        this.splashG2d.setFont(font);
                        this.splashG2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        this.splashG2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                        this.splashG2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
                    } else {
                        LOGGER.debug("got no graphics from splash");
                    }
                } else {
                    LOGGER.debug("no splash found");
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void updateProgress(String text, int progress) {
                if (this.splashG2d == null) {
                    return;
                }
                this.splashG2d.setComposite(AlphaComposite.Clear);
                this.splashG2d.fillRect(50, 350, 230, 100);
                this.splashG2d.setPaintMode();
                this.splashG2d.setColor(new Color(134, 134, 134));
                this.splashG2d.drawString(text + "...", 51, 390);
                int l = this.splashG2d.getFontMetrics().stringWidth(ReleaseInfo.getRealVersion());
                this.splashG2d.drawString(ReleaseInfo.getRealVersion(), 277 - l, 443);
                this.splashG2d.setColor(new Color(20, 20, 20));
                this.splashG2d.fillRoundRect(51, 400, 227, 6, 6, 6);
                this.splashG2d.setColor(new Color(134, 134, 134));
                this.splashG2d.fillRoundRect(51, 400, 227 * progress / 100, 6, 6, 6);
                LOGGER.debug("Startup ({}%) {}", (Object)progress, (Object)text);
                Class<SplashScreen> clazz = SplashScreen.class;
                synchronized (SplashScreen.class) {
                    if (this.splash.isVisible()) {
                        this.splash.update();
                    }
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
            }

            private void doStartupTasks() {
                UpgradeTasks.renameDownloadedFiles();
                Utils.cleanOldLogs();
                Path db = Paths.get(Settings.getInstance().getSettingsFolder(), new String[0]);
                Utils.createBackupFile(db);
                Utils.deleteOldBackupFile(db, 5);
                if (Platform.isLinux() && !TmmOsUtils.existsDesktopFileForLinux()) {
                    Path desktopFile = Paths.get(System.getProperty("user.home"), ".local", "share", "applications", "tinyMediaManager.desktop").toAbsolutePath();
                    if (Files.isWritable(desktopFile.getParent())) {
                        TmmOsUtils.createDesktopFileForLinux(desktopFile.toFile());
                    } else {
                        TmmOsUtils.createDesktopFileForLinux(new File("tinyMediaManager.desktop"));
                    }
                }
            }
        });
    }

    public static void setLookAndFeel() {
        try {
            Font font = Font.decode(Settings.getInstance().getFontFamily());
            Font savedFont = new Font(font.getFamily(), font.getStyle(), Settings.getInstance().getFontSize());
            UIManager.put("defaultFont", savedFont);
        }
        catch (Exception e) {
            LOGGER.warn("could not set default font - {}", (Object)e.getMessage());
        }
        try {
            TmmUIHelper.setTheme();
            ToolTipManager.sharedInstance().setInitialDelay(300);
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize LaF - {}", (Object)e.getMessage());
        }
    }

    public static void shutdown() {
        try {
            TmmProperties.getInstance().writeProperties();
            TmmTaskManager.getInstance().shutdown();
            TmmModuleManager.getInstance().saveSettings();
            TmmTaskManager.getInstance().shutdownNow();
            TmmModuleManager.getInstance().shutDown();
        }
        catch (Exception ex) {
            LOGGER.warn("Problem in shutdown", (Throwable)ex);
        }
    }

    public static void shutdownLogger() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        loggerContext.stop();
    }

    public static void setConsoleLogLevel() {
        Level level;
        String loglevelAsString;
        switch (loglevelAsString = System.getProperty("tmm.consoleloglevel", "")) {
            case "OFF": {
                level = null;
                break;
            }
            case "ERROR": {
                level = Level.ERROR;
                break;
            }
            case "WARN": {
                level = Level.WARN;
                break;
            }
            case "INFO": {
                level = Level.INFO;
                break;
            }
            case "DEBUG": {
                level = Level.DEBUG;
                break;
            }
            case "TRACE": {
                level = Level.TRACE;
                break;
            }
            default: {
                return;
            }
        }
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        Appender consoleAppender = lc.getLogger("ROOT").getAppender("CONSOLE");
        if (consoleAppender instanceof ConsoleAppender) {
            if (level == null) {
                consoleAppender.stop();
            } else {
                ThresholdLoggerFilter filter = new ThresholdLoggerFilter(level);
                filter.start();
                consoleAppender.clearAllFilters();
                consoleAppender.addFilter((Filter)filter);
            }
        }
    }

    private static void debugCharacterEncoding(String text) {
        String defaultCharacterEncoding = System.getProperty("file.encoding");
        byte[] bArray = new byte[]{119};
        ByteArrayInputStream is = new ByteArrayInputStream(bArray);
        InputStreamReader reader = new InputStreamReader(is);
        LOGGER.info(text + defaultCharacterEncoding + " | " + reader.getEncoding() + " | " + Charset.defaultCharset());
    }
}

