/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.LauncherExtraConfig;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.filenaming.MovieExtraFanartNaming;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.filenaming.TvShowExtraFanartNaming;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.ui.TmmUILayoutStore;

public class UpgradeTasks {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeTasks.class);
    private static String oldVersion;

    private UpgradeTasks() {
        throw new IllegalAccessError();
    }

    public static void setOldVersion() {
        oldVersion = Settings.getInstance().getVersion();
    }

    public static String getOldVersion() {
        return oldVersion;
    }

    public static boolean isNewVersion() {
        return StrgUtils.compareVersion(oldVersion, ReleaseInfo.getVersion()) == 0;
    }

    public static void performUpgradeTasksBeforeDatabaseLoading() {
        Object v = oldVersion;
        if (StringUtils.isBlank((CharSequence)v)) {
            v = "4.0";
        }
        if (((String)v).startsWith("3")) {
            UpgradeTasks.createV3Backup();
        }
        if (StrgUtils.compareVersion((String)v, "4.0") < 0) {
            LOGGER.info("Performing upgrade tasks to version 4.0");
            Path extraTxt = Paths.get("extra.txt", new String[0]);
            if (Files.exists(extraTxt, new LinkOption[0])) {
                try {
                    List jvmOpts = FileUtils.readLines((File)extraTxt.toFile(), (Charset)StandardCharsets.UTF_8);
                    LauncherExtraConfig extraConfig = LauncherExtraConfig.readFile(Paths.get("launcher-extra.yml", new String[0]).toFile());
                    extraConfig.jvmOpts.addAll(jvmOpts);
                    extraConfig.save();
                    Files.deleteIfExists(extraTxt);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Utils.deleteFileSafely(Paths.get("tinyMediaManagerCMDUpd.exe", new String[0]));
            Utils.deleteFileSafely(Paths.get("tinyMediaManagerUpd.exe", new String[0]));
            Utils.deleteFileSafely(Paths.get("tinyMediaManagerCMD.sh", new String[0]));
            Utils.deleteFileSafely(Paths.get("tinyMediaManagerUpdater.sh", new String[0]));
            Utils.deleteFileSafely(Paths.get("tinyMediaManagerUpdaterCMD.sh", new String[0]));
            Utils.deleteFileSafely(Paths.get("tinyMediaManagerCMD-OSX.sh", new String[0]));
            Utils.deleteFileSafely(Paths.get("tinyMediaManagerOSX.sh", new String[0]));
            Utils.deleteFileSafely(Paths.get("tinyMediaManagerUpdaterCMD-OSX.sh", new String[0]));
            Utils.deleteFileSafely(Paths.get("getdown.jar", new String[0]));
        }
        if (StrgUtils.compareVersion((String)v, "4.0.2") < 0) {
            LOGGER.info("Performing upgrade tasks to version 4.0.2");
            Settings.getInstance().setIgnoreSSLProblems(true);
            Settings.getInstance().saveSettings();
        }
        if (StrgUtils.compareVersion((String)v, "4.1") < 0) {
            LOGGER.info("Performing upgrade tasks to version 4.1");
            Path config = Paths.get("data/scraper_anidb.conf", new String[0]);
            if (Files.exists(config, new LinkOption[0])) {
                UpgradeTasks.copyFileSilently(config, Paths.get("data/scraper_anidb_tvshow.conf", new String[0]));
                Utils.deleteFileSafely(config);
            }
            if (Files.exists(config = Paths.get("data/scraper_fanarttv.conf", new String[0]), new LinkOption[0])) {
                UpgradeTasks.copyFileSilently(config, Paths.get("data/scraper_fanarttv_movie_artwork.conf", new String[0]));
                UpgradeTasks.copyFileSilently(config, Paths.get("data/scraper_fanarttv_tvshow_artwork.conf", new String[0]));
                Utils.deleteFileSafely(config);
            }
            if (Files.exists(config = Paths.get("data/scraper_hd-trailers.conf", new String[0]), new LinkOption[0])) {
                UpgradeTasks.copyFileSilently(config, Paths.get("data/scraper_hd-trailers_movie_trailer.conf", new String[0]));
                Utils.deleteFileSafely(config);
            }
            if (Files.exists(config = Paths.get("data/scraper_imdb.conf", new String[0]), new LinkOption[0])) {
                UpgradeTasks.copyFileSilently(config, Paths.get("data/scraper_imdb_movie.conf", new String[0]));
                UpgradeTasks.copyFileSilently(config, Paths.get("data/scraper_imdb_movie_artwork.conf", new String[0]));
                UpgradeTasks.copyFileSilently(config, Paths.get("data/scraper_imdb_tvshow.conf", new String[0]));
                UpgradeTasks.copyFileSilently(config, Paths.get("data/scraper_imdb_tvshow_artwork.conf", new String[0]));
                Utils.deleteFileSafely(config);
            }
            if (Files.exists(config = Paths.get("data/scraper_moviemeter.conf", new String[0]), new LinkOption[0])) {
                UpgradeTasks.copyFileSilently(config, Paths.get("data/scraper_moviemeter_movie.conf", new String[0]));
                Utils.deleteFileSafely(config);
            }
            if (Files.exists(config = Paths.get("data/scraper_mpdbtv.conf", new String[0]), new LinkOption[0])) {
                UpgradeTasks.copyFileSilently(config, Paths.get("data/scraper_mpdbtv_movie.conf", new String[0]));
                UpgradeTasks.copyFileSilently(config, Paths.get("data/scraper_mpdbtv_movie_artwork.conf", new String[0]));
                Utils.deleteFileSafely(config);
            }
            if (Files.exists(config = Paths.get("data/scraper_ofdb.conf", new String[0]), new LinkOption[0])) {
                UpgradeTasks.copyFileSilently(config, Paths.get("data/scraper_ofdb_movie.conf", new String[0]));
                UpgradeTasks.copyFileSilently(config, Paths.get("data/scraper_ofdb_movie_trailer.conf", new String[0]));
                Utils.deleteFileSafely(config);
            }
            if (Files.exists(config = Paths.get("data/scraper_omdbapi.conf", new String[0]), new LinkOption[0])) {
                UpgradeTasks.copyFileSilently(config, Paths.get("data/scraper_omdbapi_movie.conf", new String[0]));
                Utils.deleteFileSafely(config);
            }
            if (Files.exists(config = Paths.get("data/scraper_opensubtitles.conf", new String[0]), new LinkOption[0])) {
                UpgradeTasks.copyFileSilently(config, Paths.get("data/scraper_opensubtitles_movie_subtitle.conf", new String[0]));
                UpgradeTasks.copyFileSilently(config, Paths.get("data/scraper_opensubtitles_tvshow_subtitle.conf", new String[0]));
                Utils.deleteFileSafely(config);
            }
            if (Files.exists(config = Paths.get("data/scraper_tvdb.conf", new String[0]), new LinkOption[0])) {
                UpgradeTasks.copyFileSilently(config, Paths.get("data/scraper_tvdb_tvshow.conf", new String[0]));
                UpgradeTasks.copyFileSilently(config, Paths.get("data/scraper_tvdb_tvshow_artwork.conf", new String[0]));
                Utils.deleteFileSafely(config);
            }
            if (Files.exists(config = Paths.get("data/scraper_tmdb.conf", new String[0]), new LinkOption[0])) {
                UpgradeTasks.copyFileSilently(config, Paths.get("data/scraper_tmdb_movie.conf", new String[0]));
                UpgradeTasks.copyFileSilently(config, Paths.get("data/scraper_tmdb_movie_artwork.conf", new String[0]));
                UpgradeTasks.copyFileSilently(config, Paths.get("data/scraper_tmdb_movie_trailer.conf", new String[0]));
                UpgradeTasks.copyFileSilently(config, Paths.get("data/scraper_tmdb_tvshow.conf", new String[0]));
                UpgradeTasks.copyFileSilently(config, Paths.get("data/scraper_tmdb_tvshow_artwork.conf", new String[0]));
                UpgradeTasks.copyFileSilently(config, Paths.get("data/scraper_tmdb_tvshow_trailer.conf", new String[0]));
                Utils.deleteFileSafely(config);
            }
            if (Files.exists(config = Paths.get("data/scraper_trakt.conf", new String[0]), new LinkOption[0])) {
                UpgradeTasks.copyFileSilently(config, Paths.get("data/scraper_trakt_movie.conf", new String[0]));
                UpgradeTasks.copyFileSilently(config, Paths.get("data/scraper_trakt_tvshow.conf", new String[0]));
                Utils.deleteFileSafely(config);
            }
        }
        if (StrgUtils.compareVersion((String)v, "4.3") < 0) {
            File[] files;
            LOGGER.info("Performing upgrade tasks to version 4.3");
            if (MovieModuleManager.getInstance().getSettings().isArdAfterScrape() || TvShowModuleManager.getInstance().getSettings().isArdAfterScrape()) {
                Settings.getInstance().setArdEnabled(true);
                MovieModuleManager.getInstance().getSettings().setArdAfterScrape(false);
                TvShowModuleManager.getInstance().getSettings().setArdAfterScrape(false);
            }
            if ((files = Paths.get("native/addons", new String[0]).toFile().listFiles()) != null) {
                for (File file : files) {
                    if (!file.getName().contains("ffmpeg")) continue;
                    try {
                        if (file.isFile()) {
                            Files.delete(file.toPath());
                            continue;
                        }
                        Utils.deleteDirectoryRecursive(file.toPath());
                    }
                    catch (Exception e) {
                        LOGGER.debug("could not delete file '{}' - '{}'", (Object)file.getName(), (Object)e.getMessage());
                    }
                }
            }
        }
        if (StrgUtils.compareVersion((String)v, "4.3.4") < 0) {
            LOGGER.info("Performing upgrade tasks to version 4.3.4");
            Utils.deleteFileSafely(Paths.get(Globals.LOG_FOLDER, new String[0]).resolve("trace.log"));
        }
    }

    private static void copyFileSilently(Path source, Path destination) {
        try {
            FileUtils.copyFile((File)source.toFile(), (File)destination.toFile());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void performUpgradeTasksAfterDatabaseLoading() {
        MovieList movieList = MovieModuleManager.getInstance().getMovieList();
        TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();
        Object v = oldVersion;
        if (StringUtils.isBlank((CharSequence)v)) {
            v = "4.0";
        }
        if (StrgUtils.compareVersion((String)v, "4.0.6") < 0) {
            if (MovieModuleManager.getInstance().getSettings().isImageExtraFanart() && MovieModuleManager.getInstance().getSettings().getExtraFanartFilenames().isEmpty()) {
                MovieModuleManager.getInstance().getSettings().addExtraFanartFilename(MovieExtraFanartNaming.FOLDER_EXTRAFANART);
                MovieModuleManager.getInstance().getSettings().saveSettings();
            }
            if (TvShowModuleManager.getInstance().getSettings().isImageExtraFanart() && TvShowModuleManager.getInstance().getSettings().getExtraFanartFilenames().isEmpty()) {
                TvShowModuleManager.getInstance().getSettings().addExtraFanartFilename(TvShowExtraFanartNaming.FOLDER_EXTRAFANART);
                TvShowModuleManager.getInstance().getSettings().saveSettings();
            }
            for (Movie movie : movieList.getMovies()) {
                boolean dirty = false;
                for (MediaFile mediaFile : movie.getMediaFiles(MediaFileType.VIDEO)) {
                    dirty = dirty || UpgradeTasks.upgradeContainerFormat(mediaFile);
                }
                if (!dirty) continue;
                movie.saveToDb();
                movie.firePropertyChange("mediaInformation", false, true);
            }
            for (TvShow tvShow : tvShowList.getTvShows()) {
                for (TvShowEpisode tvShowEpisode : tvShow.getEpisodes()) {
                    boolean bl = false;
                    for (MediaFile mediaFile : tvShowEpisode.getMediaFiles(MediaFileType.VIDEO)) {
                        bl = bl || UpgradeTasks.upgradeContainerFormat(mediaFile);
                    }
                    if (!bl) continue;
                    tvShowEpisode.saveToDb();
                    tvShowEpisode.firePropertyChange("mediaInformation", false, true);
                }
            }
        }
        if (StrgUtils.compareVersion((String)v, "4.1") < 0) {
            for (Movie movie : movieList.getMovies()) {
                UpgradeTasks.repairRatings(movie);
            }
            for (TvShow tvShow : tvShowList.getTvShows()) {
                UpgradeTasks.repairRatings(tvShow);
                for (TvShowEpisode tvShowEpisode : tvShow.getEpisodes()) {
                    UpgradeTasks.repairRatings(tvShowEpisode);
                }
            }
            if (StringUtils.isBlank((CharSequence)MovieModuleManager.getInstance().getSettings().getReleaseDateCountry())) {
                MovieModuleManager.getInstance().getSettings().setReleaseDateCountry(Locale.getDefault().getCountry());
            }
            if (StringUtils.isBlank((CharSequence)TvShowModuleManager.getInstance().getSettings().getReleaseDateCountry())) {
                TvShowModuleManager.getInstance().getSettings().setReleaseDateCountry(Locale.getDefault().getCountry());
            }
        }
        if (StrgUtils.compareVersion((String)v, "4.1.2") < 0 && !ReleaseInfo.isGitBuild()) {
            String filenamePattern;
            String folderPattern = MovieModuleManager.getInstance().getSettings().getRenamerPathname();
            if (folderPattern.contains("${hdr}")) {
                MovieModuleManager.getInstance().getSettings().setRenamerPathname(folderPattern.replace("${hdr}", "${hdrformat}"));
                MovieModuleManager.getInstance().getSettings().saveSettings();
            }
            if ((filenamePattern = MovieModuleManager.getInstance().getSettings().getRenamerFilename()).contains("${hdr}")) {
                MovieModuleManager.getInstance().getSettings().setRenamerFilename(filenamePattern.replace("${hdr}", "${hdrformat}"));
                MovieModuleManager.getInstance().getSettings().saveSettings();
            }
            if ((filenamePattern = TvShowModuleManager.getInstance().getSettings().getRenamerFilename()).contains("${hdr}")) {
                TvShowModuleManager.getInstance().getSettings().setRenamerFilename(filenamePattern.replace("${hdr}", "${hdrformat}"));
                TvShowModuleManager.getInstance().getSettings().saveSettings();
            }
        }
        if (StrgUtils.compareVersion((String)v, "4.2.6") < 0 && !ReleaseInfo.isGitBuild()) {
            if (!MovieModuleManager.getInstance().getSettings().getSkipFolder().contains("MAKEMKV")) {
                MovieModuleManager.getInstance().getSettings().addSkipFolder("MAKEMKV");
                MovieModuleManager.getInstance().getSettings().saveSettings();
            }
            if (!TvShowModuleManager.getInstance().getSettings().getSkipFolder().contains("MAKEMKV")) {
                TvShowModuleManager.getInstance().getSettings().addSkipFolder("MAKEMKV");
                TvShowModuleManager.getInstance().getSettings().saveSettings();
            }
        }
        if (StrgUtils.compareVersion((String)v, "4.2.8") < 0) {
            LinkedHashSet<String> tvShowDataSources;
            LinkedHashSet<String> movieDataSources = new LinkedHashSet<String>(MovieModuleManager.getInstance().getSettings().getMovieDataSource());
            if (movieDataSources.size() != MovieModuleManager.getInstance().getSettings().getMovieDataSource().size()) {
                MovieModuleManager.getInstance().getSettings().setMovieDataSources(movieDataSources);
                MovieModuleManager.getInstance().getSettings().saveSettings();
            }
            if ((tvShowDataSources = new LinkedHashSet<String>(TvShowModuleManager.getInstance().getSettings().getTvShowDataSource())).size() != TvShowModuleManager.getInstance().getSettings().getTvShowDataSource().size()) {
                TvShowModuleManager.getInstance().getSettings().setTvShowDataSources(tvShowDataSources);
                TvShowModuleManager.getInstance().getSettings().saveSettings();
            }
        }
        if (StrgUtils.compareVersion((String)v, "4.3") < 0) {
            for (Movie movie : movieList.getMovies()) {
                Object value = movie.getId("imdbId");
                if (value != null && movie.getId("imdb") == null) {
                    movie.setId("imdb", value);
                }
                movie.setId("imdbId", null);
                for (Map.Entry<String, MediaRating> entry : movie.getRatings().entrySet()) {
                    entry.getValue().setRating(entry.getValue().getRating());
                }
                movie.saveToDb();
            }
            for (TvShow tvShow : tvShowList.getTvShows()) {
                Object value = tvShow.getId("imdbId");
                if (value != null && tvShow.getId("imdb") == null) {
                    tvShow.setId("imdb", value);
                }
                tvShow.setId("imdbId", null);
                for (Map.Entry<String, MediaRating> entry : tvShow.getRatings().entrySet()) {
                    entry.getValue().setRating(entry.getValue().getRating());
                }
                tvShow.saveToDb();
                for (TvShowEpisode tvShowEpisode : tvShow.getEpisodes()) {
                    value = tvShowEpisode.getId("imdbId");
                    if (value != null && tvShowEpisode.getId("imdb") == null) {
                        tvShowEpisode.setId("imdb", value);
                    }
                    tvShowEpisode.setId("imdbId", null);
                    for (Map.Entry entry : tvShowEpisode.getRatings().entrySet()) {
                        ((MediaRating)entry.getValue()).setRating(((MediaRating)entry.getValue()).getRating());
                    }
                    tvShowEpisode.saveToDb();
                }
            }
        }
        if (StrgUtils.compareVersion((String)v, "4.3.3") < 0 && !ReleaseInfo.isGitBuild()) {
            TmmUILayoutStore.getInstance().hideNewColumn("movies.movieTable", "top250");
        }
        if (StrgUtils.compareVersion((String)v, "4.3.9") < 0) {
            movieList.reevaluateMMD();
            for (TvShow tvShow : tvShowList.getTvShows()) {
                HashSet<TvShowEpisode> cleanup = new HashSet<TvShowEpisode>();
                for (TvShowEpisode tvShowEpisode : tvShow.getEpisodes()) {
                    List<MediaFile> mfs = tvShowEpisode.getMediaFiles(MediaFileType.VIDEO);
                    if (mfs.size() <= 1 || tvShowEpisode.isDisc()) continue;
                    for (MediaFile mf : mfs) {
                        if (mf.getStacking() != 0) continue;
                        cleanup.add(tvShowEpisode);
                    }
                }
                for (TvShowEpisode tvShowEpisode : cleanup) {
                    tvShow.removeEpisode(tvShowEpisode);
                    LOGGER.info("Removed invalid episode '{}' (S{} E{}) from show /{}", new Object[]{tvShowEpisode.getTitle(), tvShowEpisode.getSeason(), tvShowEpisode.getEpisode(), tvShow.getPathNIO().getFileName()});
                }
            }
        }
        if (StrgUtils.compareVersion((String)v, "4.3.9.1") < 0) {
            for (TvShow tvShow : tvShowList.getTvShows()) {
                for (TvShowEpisode tvShowEpisode : tvShow.getEpisodes()) {
                    boolean bl = false;
                    for (MediaFile mediaFile : tvShowEpisode.getMediaFiles(MediaFileType.GRAPHIC)) {
                        mediaFile.setType(MediaFileType.THUMB);
                        bl = true;
                    }
                    if (!bl) continue;
                    tvShowEpisode.saveToDb();
                }
            }
        }
        if (StrgUtils.compareVersion((String)v, "4.3.11") < 0) {
            for (Movie movie : movieList.getMovies()) {
                if (!movie.isStacked()) continue;
                boolean dirty = false;
                for (MediaFile mediaFile : movie.getMediaFiles(MediaFileType.SUBTITLE)) {
                    String old = mediaFile.getStackingMarker();
                    mediaFile.detectStackingInformation();
                    if (old.equals(mediaFile.getStackingMarker())) continue;
                    dirty = true;
                }
                if (!dirty) continue;
                movie.saveToDb();
                movie.firePropertyChange("mediaInformation", false, true);
            }
        }
    }

    private static boolean upgradeContainerFormat(MediaFile mediaFile) {
        switch (mediaFile.getContainerFormat().toLowerCase()) {
            case "video_ts": 
            case "mpeg-ps": 
            case "dvd-video": {
                mediaFile.setContainerFormat("DVD Video");
                return true;
            }
            case "bdav": {
                mediaFile.setContainerFormat("Blu-ray Video");
                return true;
            }
            case "matroska": {
                mediaFile.setContainerFormat("Matroska");
                return true;
            }
            case "mpeg-4": {
                mediaFile.setContainerFormat("MPEG-4");
                return true;
            }
        }
        return false;
    }

    private static void repairRatings(MediaEntity entity) {
        boolean dirty = false;
        HashMap<String, MediaRating> ratings = new HashMap<String, MediaRating>(entity.getRatings());
        for (Map.Entry entry : ratings.entrySet()) {
            MediaRating mediaRating;
            MediaRating rating = (MediaRating)entry.getValue();
            if (rating.getRating() < 0.0f) {
                entity.removeRating((String)entry.getKey());
                dirty = true;
                continue;
            }
            if ("rottenTomatoes".equalsIgnoreCase((String)entry.getKey())) {
                entity.removeRating((String)entry.getKey());
                mediaRating = new MediaRating("tomatometerallcritics", rating.getRating(), rating.getVotes(), rating.getMaxValue());
                entity.setRating(mediaRating);
                dirty = true;
                continue;
            }
            if (!"metascore".equalsIgnoreCase((String)entry.getKey())) continue;
            entity.removeRating((String)entry.getKey());
            mediaRating = new MediaRating("metacritic", rating.getRating(), rating.getVotes(), rating.getMaxValue());
            entity.setRating(mediaRating);
            dirty = true;
        }
        if (dirty) {
            entity.saveToDb();
        }
    }

    public static void renameDownloadedFiles() {
        if (SystemUtils.IS_OS_MAC) {
            Path macOS;
            File cur;
            File file = new File("macOS/MacOS/tinyMediaManager");
            if (file.exists() && file.length() > 0L) {
                cur = new File("../../MacOS/tinyMediaManager");
                try {
                    FileUtils.copyFile((File)file, (File)cur);
                    cur.setExecutable(true);
                }
                catch (IOException e) {
                    LOGGER.error("Could not update MacOS/tinyMediaManager");
                }
            }
            if ((file = new File("macOS/MacOS/JavaApplicationStub")).exists() && file.length() > 0L) {
                cur = new File("../../MacOS/JavaApplicationStub");
                try {
                    FileUtils.copyFile((File)file, (File)cur);
                    cur.setExecutable(true);
                }
                catch (IOException e) {
                    LOGGER.error("Could not update MacOS/JavaApplicationStub");
                }
            }
            if ((file = new File("macOS/Info.plist")).exists() && file.length() > 0L) {
                cur = new File("../../Info.plist");
                try {
                    FileUtils.copyFile((File)file, (File)cur);
                }
                catch (IOException e) {
                    LOGGER.error("Could not update Info.plist");
                }
            }
            if ((file = new File("macOS/Resources/tmm.icns")).exists() && file.length() > 0L) {
                cur = new File("../tmm.icns");
                try {
                    FileUtils.copyFile((File)file, (File)cur);
                }
                catch (IOException e) {
                    LOGGER.error("Could not update tmm.icns");
                }
            }
            if (Files.exists(macOS = Paths.get("macOS", new String[0]), new LinkOption[0])) {
                try {
                    Utils.deleteDirectoryRecursive(macOS);
                }
                catch (Exception e) {
                    LOGGER.error("could not delete macOS folder - {}", (Object)e.getMessage());
                }
            }
        }
    }

    private static void createV3Backup() {
        Path backup = Paths.get(Globals.BACKUP_FOLDER, new String[0]);
        Path dataFolder = Paths.get(Settings.getInstance().getSettingsFolder(), new String[0]);
        try {
            if (!Files.exists(backup, new LinkOption[0])) {
                Files.createDirectory(backup, new FileAttribute[0]);
            }
            if (!Files.exists(backup = backup.resolve("v3-backup.zip"), new LinkOption[0])) {
                Utils.createZip(backup, dataFolder);
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not backup file {}: {}", (Object)dataFolder, (Object)e.getMessage());
        }
    }
}

