/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaCertification;

public enum CertificationStyle {
    SHORT,
    SHORT_MPAA,
    MEDIUM,
    MEDIUM_FULL,
    LARGE,
    LARGE_FULL,
    TECHNICAL;


    public static String formatCertification(MediaCertification cert, CertificationStyle style) {
        if (cert == MediaCertification.UNKNOWN) {
            return "";
        }
        switch (style) {
            case SHORT: {
                return cert.getName();
            }
            case SHORT_MPAA: {
                if (cert.getCountry() == CountryCode.US) {
                    return MediaCertification.getMPAAString(cert);
                }
                return cert.getName();
            }
            case MEDIUM: {
                return cert.getCountry().getAlpha2() + ": " + cert.getName();
            }
            case MEDIUM_FULL: {
                return cert.getCountry().getName() + ": " + cert.getName();
            }
            case LARGE: {
                return MediaCertification.generateCertificationStringWithAlternateNames(cert);
            }
            case LARGE_FULL: {
                return MediaCertification.generateCertificationStringWithAlternateNames(cert, true);
            }
            case TECHNICAL: {
                return cert.name();
            }
        }
        return "";
    }
}

