/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jdesktop.observablecollections.ObservableCollections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.core.AbstractSettings;
import org.tinymediamanager.core.ArdSettings;
import org.tinymediamanager.core.AspectRatio;
import org.tinymediamanager.core.DateField;
import org.tinymediamanager.core.EncryptedStringDeserializer;
import org.tinymediamanager.core.EncryptedStringSerializer;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.WolDevice;
import org.tinymediamanager.core.http.TmmHttpServer;
import org.tinymediamanager.scraper.http.ProxySettings;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.util.StrgUtils;

public final class Settings
extends AbstractSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(Settings.class);
    private static final String TITLE_PREFIX = "titlePrefixes";
    private static final String VIDEO_FILE_TYPE = "videoFileType";
    private static final String AUDIO_FILE_TYPE = "audioFileType";
    private static final String SUBTITLE_FILE_TYPE = "subtitleFileType";
    private static final String CLEANUP_FILE_TYPE = "cleanupFileType";
    private static final String WOL_DEVICES = "wolDevices";
    private static final String CUSTOM_ASPECT_RATIOS = "customAspectRatios";
    private static final String CONFIG_FILE = "tmm.json";
    private static Settings instance;
    private final List<String> titlePrefixes = ObservableCollections.observableList(new ArrayList());
    private final List<String> videoFileTypes = ObservableCollections.observableList(new ArrayList());
    private final List<String> audioFileTypes = ObservableCollections.observableList(new ArrayList());
    private final List<String> subtitleFileTypes = ObservableCollections.observableList(new ArrayList());
    private final List<String> cleanupFileTypes = ObservableCollections.observableList(new ArrayList());
    private final List<WolDevice> wolDevices = ObservableCollections.observableList(new ArrayList());
    private final List<String> customAspectRatios = ObservableCollections.observableList(new ArrayList());
    private String version = "";
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private int maximumDownloadThreads = 2;
    private String traktAccessToken = "";
    private String traktRefreshToken = "";
    private DateField traktDateField = DateField.DATE_ADDED;
    private String kodiHost = "";
    private int kodiHttpPort = 8080;
    private int kodiTcpPort = 9090;
    private String kodiUsername = "";
    private String kodiPassword = "";
    private boolean imageCache = true;
    private ImageCache.CacheSize imageCacheSize = ImageCache.CacheSize.BIG;
    private ImageCache.CacheType imageCacheType = ImageCache.CacheType.QUALITY;
    private String language;
    private String mediaPlayer = "";
    private boolean useInternalMediaFramework = true;
    private String mediaFramework = "";
    private Integer ffmpegPercentage = 50;
    private String theme = "Light";
    private int fontSize = 12;
    private String fontFamily = "Dialog";
    private boolean imageChooserUseEntityFolder = false;
    private boolean storeWindowPreferences = true;
    private DateField dateField = DateField.DATE_ADDED;
    private boolean enableTrash = true;
    private boolean deleteTrashOnExit = false;
    private boolean showMemory = true;
    private boolean enableHttpServer = false;
    private int httpServerPort = 7878;
    private String httpApiKey = UUID.randomUUID().toString();
    private boolean upnpShareLibrary = false;
    private boolean upnpRemotePlay = false;
    private boolean ignoreSSLProblems = true;
    private boolean writeMediaInfoXml = false;
    boolean ardEnabled = false;
    private ArdSettings.Mode ardMode = ArdSettings.Mode.DEFAULT;
    private Map<ArdSettings.Mode, ArdSettings.SampleSetting> ardSampleSettings = ArdSettings.defaultSampleSettings();
    private float ardIgnoreBeginningPct = 2.0f;
    private float ardIgnoreEndPct = 8.0f;
    private boolean ardRoundUp = false;
    private float ardRoundUpThresholdPct = 4.0f;
    private int ardMFMode = 0;
    private float ardMFThresholdPct = 6.0f;
    private float ardPlausiWidthPct = 50.0f;
    private float ardPlausiHeightPct = 60.0f;
    private float ardPlausiWidthDeltaPct = 1.5f;
    private float ardPlausiHeightDeltaPct = 2.0f;
    private float ardSecondaryDelta = 0.15f;
    private float ardDarkLevelPct = 7.0f;
    private float ardDarkLevelMaxPct = 13.0f;
    private boolean enableAutomaticUpdate = true;
    private int automaticUpdateInterval = 1;

    public Settings() {
        this.addPropertyChangeListener(evt -> this.setDirty());
    }

    @Override
    protected ObjectWriter createObjectWriter() {
        return objectMapper.writerFor(Settings.class);
    }

    @Override
    public String getConfigFilename() {
        return CONFIG_FILE;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected void afterLoading() {
        this.setProxy();
        System.setProperty("tmm.trustallcerts", Boolean.toString(this.ignoreSSLProblems));
        TmmHttpClient.recreateHttpClient();
    }

    @Override
    protected void writeDefaultSettings() {
        this.version = ReleaseInfo.getVersion();
        this.videoFileTypes.clear();
        this.videoFileTypes.addAll(MediaFileHelper.DEFAULT_VIDEO_FILETYPES);
        Collections.sort(this.videoFileTypes);
        this.firePropertyChange(VIDEO_FILE_TYPE, null, this.videoFileTypes);
        this.audioFileTypes.clear();
        this.audioFileTypes.addAll(MediaFileHelper.DEFAULT_AUDIO_FILETYPES);
        Collections.sort(this.audioFileTypes);
        this.firePropertyChange(AUDIO_FILE_TYPE, null, this.audioFileTypes);
        this.subtitleFileTypes.clear();
        this.subtitleFileTypes.addAll(MediaFileHelper.DEFAULT_SUBTITLE_FILETYPES);
        Collections.sort(this.subtitleFileTypes);
        this.firePropertyChange(SUBTITLE_FILE_TYPE, null, this.subtitleFileTypes);
        this.customAspectRatios.clear();
        this.customAspectRatios.addAll(AspectRatio.getDefaultValues().stream().map(Object::toString).collect(Collectors.toList()));
        Collections.sort(this.customAspectRatios);
        this.firePropertyChange(CUSTOM_ASPECT_RATIOS, null, this.customAspectRatios);
        this.titlePrefixes.clear();
        this.addTitlePrefix("A");
        this.addTitlePrefix("An");
        this.addTitlePrefix("The");
        this.addTitlePrefix("Der");
        this.addTitlePrefix("Die");
        this.addTitlePrefix("Das");
        this.addTitlePrefix("Ein");
        this.addTitlePrefix("Eine");
        this.addTitlePrefix("Le");
        this.addTitlePrefix("La");
        this.addTitlePrefix("Les");
        this.addTitlePrefix("L'");
        this.addTitlePrefix("L\u00b4");
        this.addTitlePrefix("L`");
        this.addTitlePrefix("Un");
        this.addTitlePrefix("Une");
        this.addTitlePrefix("Des");
        this.addTitlePrefix("Du");
        this.addTitlePrefix("D'");
        this.addTitlePrefix("D\u00b4");
        this.addTitlePrefix("D`");
        Collections.sort(this.titlePrefixes);
        this.cleanupFileTypes.clear();
        this.addCleanupFileType(".txt$");
        this.addCleanupFileType(".url$");
        this.addCleanupFileType(".html$");
        Collections.sort(this.cleanupFileTypes);
        this.ardSampleSettings = ArdSettings.defaultSampleSettings();
        this.setProxyFromSystem();
        this.findFfmpegPath();
        this.saveSettings();
    }

    private void findFfmpegPath() {
        if (SystemUtils.IS_OS_LINUX) {
            Path ffmpeg = Paths.get("/usr/bin/ffmpeg", new String[0]);
            if (Files.exists(ffmpeg, new LinkOption[0]) && Files.isExecutable(ffmpeg)) {
                this.mediaFramework = ffmpeg.toString();
            } else {
                ffmpeg = Paths.get("/usr/local/bin/ffmpeg", new String[0]);
                if (Files.exists(ffmpeg, new LinkOption[0]) && Files.isExecutable(ffmpeg)) {
                    this.mediaFramework = ffmpeg.toString();
                }
            }
        }
    }

    public static synchronized Settings getInstance() {
        return Settings.getInstance(Globals.DATA_FOLDER);
    }

    static synchronized Settings getInstance(String folder) {
        if (instance == null) {
            instance = (Settings)Settings.getInstance(folder, CONFIG_FILE, Settings.class);
        }
        return instance;
    }

    static void clearInstance() {
        instance = null;
    }

    public boolean isCurrentVersion() {
        return StrgUtils.compareVersion(this.version, ReleaseInfo.getVersion()) == 0;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setCurrentVersion() {
        this.version = ReleaseInfo.getVersion();
        this.setDirty();
    }

    private void clearDirty() {
        this.dirty = false;
    }

    public void addTitlePrefix(String prfx) {
        if (!this.titlePrefixes.contains(prfx)) {
            this.titlePrefixes.add(prfx);
            this.firePropertyChange(TITLE_PREFIX, null, this.titlePrefixes);
        }
    }

    public void removeTitlePrefix(String prfx) {
        this.titlePrefixes.remove(prfx);
        this.firePropertyChange(TITLE_PREFIX, null, this.titlePrefixes);
    }

    public List<String> getTitlePrefix() {
        return this.titlePrefixes;
    }

    public void addVideoFileType(String type) {
        if (!((String)type).startsWith(".")) {
            type = "." + (String)type;
        }
        if (!this.videoFileTypes.contains(type)) {
            this.videoFileTypes.add((String)type);
            this.firePropertyChange(VIDEO_FILE_TYPE, null, this.videoFileTypes);
        }
    }

    public void removeVideoFileType(String type) {
        this.videoFileTypes.remove(type);
        this.firePropertyChange(VIDEO_FILE_TYPE, null, this.videoFileTypes);
    }

    public List<String> getVideoFileType() {
        return this.videoFileTypes;
    }

    public void addAudioFileType(String type) {
        if (!((String)type).startsWith(".")) {
            type = "." + (String)type;
        }
        if (!this.audioFileTypes.contains(type)) {
            this.audioFileTypes.add((String)type);
            this.firePropertyChange(AUDIO_FILE_TYPE, null, this.audioFileTypes);
        }
    }

    public void removeAudioFileType(String type) {
        this.audioFileTypes.remove(type);
        this.firePropertyChange(AUDIO_FILE_TYPE, null, this.audioFileTypes);
    }

    public List<String> getAudioFileType() {
        return this.audioFileTypes;
    }

    public void addSubtitleFileType(String type) {
        if (!((String)type).startsWith(".")) {
            type = "." + (String)type;
        }
        if (!this.subtitleFileTypes.contains(type)) {
            this.subtitleFileTypes.add((String)type);
            this.firePropertyChange(SUBTITLE_FILE_TYPE, null, this.subtitleFileTypes);
        }
    }

    public void removeSubtitleFileType(String type) {
        if (!((String)type).startsWith(".")) {
            type = "." + (String)type;
        }
        this.subtitleFileTypes.remove(type);
        this.firePropertyChange(SUBTITLE_FILE_TYPE, null, this.subtitleFileTypes);
    }

    public List<String> getSubtitleFileType() {
        return this.subtitleFileTypes;
    }

    public void addCleanupFileType(String type) {
        if (!this.cleanupFileTypes.contains(type)) {
            this.cleanupFileTypes.add(type);
            this.firePropertyChange(CLEANUP_FILE_TYPE, null, this.cleanupFileTypes);
        }
    }

    public void removeCleanupFileType(String type) {
        this.cleanupFileTypes.remove(type);
        this.firePropertyChange(CLEANUP_FILE_TYPE, null, this.cleanupFileTypes);
    }

    public List<String> getCleanupFileType() {
        return this.cleanupFileTypes;
    }

    public void setCleanupFileTypes(List<String> newValues) {
        this.cleanupFileTypes.clear();
        this.cleanupFileTypes.addAll(newValues);
        this.firePropertyChange(CLEANUP_FILE_TYPE, null, this.cleanupFileTypes);
    }

    public List<String> getAllSupportedFileTypes() {
        HashSet<String> set = new HashSet<String>();
        set.addAll(MediaFileHelper.DEFAULT_VIDEO_FILETYPES);
        set.addAll(MediaFileHelper.DEFAULT_AUDIO_FILETYPES);
        set.addAll(MediaFileHelper.DEFAULT_SUBTITLE_FILETYPES);
        MediaFileHelper.SUPPORTED_ARTWORK_FILETYPES.forEach(type -> set.add("." + type));
        set.addAll(this.getAudioFileType());
        set.addAll(this.getVideoFileType());
        set.addAll(this.getSubtitleFileType());
        set.add(".nfo");
        return new ArrayList<String>(set);
    }

    @Override
    public void saveSettings() {
        super.saveSettings();
        this.setProxy();
        this.setHttpApi();
        this.clearDirty();
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String newValue) {
        String oldValue = this.proxyHost;
        this.proxyHost = newValue;
        this.firePropertyChange("proxyHost", oldValue, newValue);
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String newValue) {
        String oldValue = this.proxyPort;
        this.proxyPort = newValue;
        this.firePropertyChange("proxyPort", oldValue, newValue);
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String newValue) {
        String oldValue = this.proxyUsername;
        this.proxyUsername = newValue;
        this.firePropertyChange("proxyUsername", oldValue, newValue);
    }

    @JsonSerialize(using=EncryptedStringSerializer.class)
    @JsonDeserialize(using=EncryptedStringDeserializer.class)
    public String getProxyPassword() {
        return StringEscapeUtils.unescapeXml((String)this.proxyPassword);
    }

    public void setProxyPassword(String newValue) {
        newValue = StringEscapeUtils.escapeXml10((String)newValue);
        String oldValue = this.proxyPassword;
        this.proxyPassword = newValue;
        this.firePropertyChange("proxyPassword", oldValue, newValue);
    }

    public void setProxyFromSystem() {
        String[] proxyPortEnvs;
        String[] proxyEnvs;
        for (String pe : proxyEnvs = new String[]{"http.proxyHost", "https.proxyHost", "proxyHost", "socksProxyHost"}) {
            String val;
            if (!StringUtils.isBlank((CharSequence)this.getProxyHost()) || !StringUtils.isNotBlank((CharSequence)(val = System.getProperty(pe, "")))) continue;
            this.setProxyHost(val);
        }
        for (String ppe : proxyPortEnvs = new String[]{"http.proxyPort", "https.proxyPort", "proxyPort", "socksProxyPort"}) {
            String val;
            if (!StringUtils.isBlank((CharSequence)this.getProxyPort()) || !StringUtils.isNotBlank((CharSequence)(val = System.getProperty(ppe, "")))) continue;
            this.setProxyPort(val);
        }
    }

    private void setProxy() {
        if (this.useProxy()) {
            System.setProperty("proxyHost", this.getProxyHost());
            if (StringUtils.isNotEmpty((CharSequence)this.getProxyPort())) {
                System.setProperty("proxyPort", this.getProxyPort());
            }
            if (StringUtils.isNotEmpty((CharSequence)this.getProxyUsername())) {
                System.setProperty("http.proxyUser", this.getProxyUsername());
                System.setProperty("https.proxyUser", this.getProxyUsername());
            }
            if (StringUtils.isNotEmpty((CharSequence)this.getProxyPassword())) {
                System.setProperty("http.proxyPassword", this.getProxyPassword());
                System.setProperty("https.proxyPassword", this.getProxyPassword());
            }
        }
        try {
            ProxySettings.setProxySettings(this.getProxyHost(), this.getProxyPort() == null ? 0 : Integer.parseInt(this.getProxyPort().trim()), this.getProxyUsername(), this.getProxyPassword());
        }
        catch (NumberFormatException e) {
            LOGGER.error("could not parse proxy port: {}", (Object)e.getMessage());
        }
    }

    public boolean useProxy() {
        return StringUtils.isNotBlank((CharSequence)this.getProxyHost());
    }

    public boolean isImageCache() {
        return this.imageCache;
    }

    public void setImageCache(boolean newValue) {
        boolean oldValue = this.imageCache;
        this.imageCache = newValue;
        this.firePropertyChange("imageCache", oldValue, newValue);
    }

    public ImageCache.CacheSize getImageCacheSize() {
        return this.imageCacheSize;
    }

    public void setImageCacheSize(ImageCache.CacheSize newValue) {
        ImageCache.CacheSize oldValue = this.imageCacheSize;
        this.imageCacheSize = newValue;
        this.firePropertyChange("imageCacheSize", (Object)oldValue, (Object)newValue);
    }

    public ImageCache.CacheType getImageCacheType() {
        return this.imageCacheType;
    }

    public void setImageCacheType(ImageCache.CacheType newValue) {
        ImageCache.CacheType oldValue = this.imageCacheType;
        this.imageCacheType = newValue;
        this.firePropertyChange("imageCacheType", (Object)oldValue, (Object)newValue);
    }

    public boolean isUpnpShareLibrary() {
        return this.upnpShareLibrary;
    }

    public void setUpnpShareLibrary(boolean upnpShareLibrary) {
        boolean old = this.upnpShareLibrary;
        this.upnpShareLibrary = upnpShareLibrary;
        this.firePropertyChange("upnpShareLibrary", old, upnpShareLibrary);
    }

    public boolean isUpnpRemotePlay() {
        return this.upnpRemotePlay;
    }

    public void setUpnpRemotePlay(boolean upnpRemotePlay) {
        boolean old = this.upnpRemotePlay;
        this.upnpRemotePlay = upnpRemotePlay;
        this.firePropertyChange("upnpRemotePlay", old, upnpRemotePlay);
    }

    public String getLanguage() {
        if (this.language == null || this.language.isEmpty()) {
            return Locale.getDefault().getLanguage();
        }
        return this.language;
    }

    public void setLanguage(String language) {
        String oldValue = this.language;
        this.language = language;
        Locale.setDefault(Utils.getLocaleFromLanguage(language));
        this.firePropertyChange("language", oldValue, language);
    }

    public void addWolDevices(WolDevice newDevice) {
        this.wolDevices.add(newDevice);
        this.firePropertyChange(WOL_DEVICES, null, this.wolDevices);
    }

    public void removeWolDevices(WolDevice device) {
        this.wolDevices.remove(device);
        this.firePropertyChange(WOL_DEVICES, null, this.wolDevices);
    }

    public List<WolDevice> getWolDevices() {
        return this.wolDevices;
    }

    public void setWolDevices(List<WolDevice> newValues) {
        this.wolDevices.clear();
        this.wolDevices.addAll(newValues);
        this.firePropertyChange(WOL_DEVICES, null, this.wolDevices);
    }

    @JsonSerialize(using=EncryptedStringSerializer.class)
    @JsonDeserialize(using=EncryptedStringDeserializer.class)
    public String getTraktAccessToken() {
        return this.traktAccessToken;
    }

    public void setTraktAccessToken(String newValue) {
        String oldValue = this.traktAccessToken;
        this.traktAccessToken = newValue.trim();
        this.firePropertyChange("traktAccessToken", oldValue, newValue);
    }

    @JsonSerialize(using=EncryptedStringSerializer.class)
    @JsonDeserialize(using=EncryptedStringDeserializer.class)
    public String getTraktRefreshToken() {
        return this.traktRefreshToken;
    }

    public void setTraktRefreshToken(String newValue) {
        String oldValue = this.traktRefreshToken;
        this.traktRefreshToken = newValue;
        this.firePropertyChange("traktRefreshToken", oldValue, newValue);
    }

    public DateField getTraktDateField() {
        return this.traktDateField;
    }

    public void setTraktDateField(DateField newValue) {
        DateField oldValue = this.traktDateField;
        this.traktDateField = newValue;
        this.firePropertyChange("traktDateField", (Object)oldValue, (Object)newValue);
    }

    public String getKodiHost() {
        return this.kodiHost;
    }

    public void setKodiHost(String newValue) {
        String oldValue = this.kodiHost;
        this.kodiHost = newValue;
        this.firePropertyChange("kodiHost", oldValue, newValue);
    }

    public int getKodiHttpPort() {
        return this.kodiHttpPort == 0 ? 8080 : this.kodiHttpPort;
    }

    public void setKodiHttpPort(int kodiHttpPort) {
        int oldValue = this.kodiHttpPort;
        this.kodiHttpPort = kodiHttpPort;
        this.firePropertyChange("kodiHttpPort", oldValue, kodiHttpPort);
    }

    public int getKodiTcpPort() {
        return this.kodiTcpPort == 0 ? 9090 : this.kodiTcpPort;
    }

    public void setKodiTcpPort(int kodiTcpPort) {
        int oldValue = this.kodiHttpPort;
        this.kodiTcpPort = kodiTcpPort;
        this.firePropertyChange("kodiTcpPort", oldValue, kodiTcpPort);
    }

    public String getKodiUsername() {
        return this.kodiUsername;
    }

    public void setKodiUsername(String newValue) {
        String oldValue = this.kodiUsername;
        this.kodiUsername = newValue;
        this.firePropertyChange("kodiUsername", oldValue, newValue);
    }

    @JsonSerialize(using=EncryptedStringSerializer.class)
    @JsonDeserialize(using=EncryptedStringDeserializer.class)
    public String getKodiPassword() {
        return this.kodiPassword;
    }

    public void setKodiPassword(String newValue) {
        String oldValue = this.kodiPassword;
        this.kodiPassword = newValue;
        this.firePropertyChange("kodiPassword", oldValue, newValue);
    }

    public void setMediaPlayer(String newValue) {
        String oldValue = this.mediaPlayer;
        this.mediaPlayer = newValue;
        this.firePropertyChange("mediaPlayer", oldValue, newValue);
    }

    public boolean isUseInternalMediaFramework() {
        return this.useInternalMediaFramework;
    }

    public void setUseInternalMediaFramework(boolean newValue) {
        boolean oldvalue = this.useInternalMediaFramework;
        this.useInternalMediaFramework = newValue;
        this.firePropertyChange("useInternalMediaFramework", oldvalue, newValue);
    }

    public void setMediaFramework(String newValue) {
        String oldValue = this.mediaFramework;
        this.mediaFramework = newValue;
        this.firePropertyChange("mediaFramework", oldValue, newValue);
    }

    public String getMediaFramework() {
        return this.mediaFramework;
    }

    public void setFfmpegPercentage(Integer newValue) {
        Integer oldValue = this.ffmpegPercentage;
        this.ffmpegPercentage = newValue;
        this.firePropertyChange("ffmpegPercentage", oldValue, newValue);
    }

    public Integer getFfmpegPercentage() {
        return this.ffmpegPercentage;
    }

    public String getMediaPlayer() {
        return this.mediaPlayer;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String newValue) {
        String oldValue = this.theme;
        this.theme = newValue;
        this.firePropertyChange("theme", oldValue, newValue);
    }

    public void setFontSize(int newValue) {
        int oldValue = this.fontSize;
        this.fontSize = newValue;
        this.firePropertyChange("fontSize", oldValue, newValue);
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontFamily(String newValue) {
        String oldValue = this.fontFamily;
        this.fontFamily = newValue;
        this.firePropertyChange("fontFamily", oldValue, newValue);
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setEnableTrash(boolean newValue) {
        boolean oldValue = this.enableTrash;
        this.enableTrash = newValue;
        this.firePropertyChange("enableTrash", oldValue, newValue);
    }

    public boolean isEnableTrash() {
        return this.enableTrash;
    }

    public void setDeleteTrashOnExit(boolean newValue) {
        boolean oldValue = this.deleteTrashOnExit;
        this.deleteTrashOnExit = newValue;
        this.firePropertyChange("deleteTrashOnExit", oldValue, newValue);
    }

    public boolean isDeleteTrashOnExit() {
        return this.deleteTrashOnExit;
    }

    public void setStoreWindowPreferences(boolean newValue) {
        boolean oldValue = this.storeWindowPreferences;
        this.storeWindowPreferences = newValue;
        this.firePropertyChange("storeWindowPreferences", oldValue, newValue);
    }

    public boolean isStoreWindowPreferences() {
        return this.storeWindowPreferences;
    }

    public boolean isImageChooserUseEntityFolder() {
        return this.imageChooserUseEntityFolder;
    }

    public void setImageChooserUseEntityFolder(boolean newValue) {
        boolean oldvalue = this.imageChooserUseEntityFolder;
        this.imageChooserUseEntityFolder = newValue;
        this.firePropertyChange("imageChooserUseEntityFolder", oldvalue, newValue);
    }

    public boolean isShowMemory() {
        return this.showMemory;
    }

    public void setShowMemory(boolean newValue) {
        boolean oldValue = this.showMemory;
        this.showMemory = newValue;
        this.firePropertyChange("showMemory", oldValue, newValue);
    }

    public boolean isIgnoreSSLProblems() {
        return this.ignoreSSLProblems;
    }

    public DateField getDateField() {
        return this.dateField;
    }

    public void setDateField(DateField newValue) {
        DateField oldValue = this.dateField;
        this.dateField = newValue;
        this.firePropertyChange("dateField", (Object)oldValue, (Object)newValue);
    }

    public void setIgnoreSSLProblems(boolean ignoreSSLProblems) {
        boolean old = this.ignoreSSLProblems;
        this.ignoreSSLProblems = ignoreSSLProblems;
        this.firePropertyChange("ignoreSSLProblems", old, ignoreSSLProblems);
        System.setProperty("tmm.trustallcerts", Boolean.toString(ignoreSSLProblems));
        if (old != ignoreSSLProblems) {
            TmmHttpClient.recreateHttpClient();
        }
    }

    public int getMaximumDownloadThreads() {
        return Math.max(this.maximumDownloadThreads, 1);
    }

    public void setMaximumDownloadThreads(int newValue) {
        int oldValue = this.maximumDownloadThreads;
        this.maximumDownloadThreads = newValue;
        this.firePropertyChange("maximumDownloadThreads", oldValue, newValue);
    }

    public boolean isWriteMediaInfoXml() {
        return this.writeMediaInfoXml;
    }

    public void setWriteMediaInfoXml(boolean newValue) {
        boolean oldValue = this.writeMediaInfoXml;
        this.writeMediaInfoXml = newValue;
        this.firePropertyChange("writeMediaInfoXml", oldValue, newValue);
    }

    public void setArdEnabled(boolean newValue) {
        boolean oldValue = this.ardEnabled;
        this.ardEnabled = newValue;
        this.firePropertyChange("ardAfterScrape", oldValue, newValue);
    }

    public boolean isArdEnabled() {
        return this.ardEnabled;
    }

    public void setArdMode(ArdSettings.Mode newValue) {
        ArdSettings.Mode oldValue = this.ardMode;
        this.ardMode = newValue;
        this.firePropertyChange("ardMode", (Object)oldValue, (Object)newValue);
    }

    public ArdSettings.Mode getArdMode() {
        return this.ardMode;
    }

    public void setArdIgnoreBeginningPct(float newValue) {
        float oldValue = this.ardIgnoreBeginningPct;
        this.ardIgnoreBeginningPct = newValue;
        this.firePropertyChange("ardIgnoreBeginningPct", Float.valueOf(oldValue), Float.valueOf(newValue));
    }

    public float getArdIgnoreBeginningPct() {
        return this.ardIgnoreBeginningPct;
    }

    public void setArdIgnoreEndPct(float newValue) {
        float oldValue = this.ardIgnoreEndPct;
        this.ardIgnoreEndPct = newValue;
        this.firePropertyChange("ardIgnoreEndPct", Float.valueOf(oldValue), Float.valueOf(newValue));
    }

    public float getArdIgnoreEndPct() {
        return this.ardIgnoreEndPct;
    }

    public void setArdPlausiWidthPct(float newValue) {
        float oldValue = this.ardPlausiWidthPct;
        this.ardPlausiWidthPct = newValue;
        this.firePropertyChange("ardPlausiWidthPct", Float.valueOf(oldValue), Float.valueOf(newValue));
    }

    public float getArdPlausiWidthPct() {
        return this.ardPlausiWidthPct;
    }

    public void setArdPlausiHeightPct(float newValue) {
        float oldValue = this.ardPlausiHeightPct;
        this.ardPlausiHeightPct = newValue;
        this.firePropertyChange("ardPlausiHeightPct", Float.valueOf(oldValue), Float.valueOf(newValue));
    }

    public float getArdPlausiHeightPct() {
        return this.ardPlausiHeightPct;
    }

    public void setArdPlausiWidthDeltaPct(float newValue) {
        float oldValue = this.ardPlausiWidthDeltaPct;
        this.ardPlausiWidthDeltaPct = newValue;
        this.firePropertyChange("ardPlausiWidthDeltaPct", Float.valueOf(oldValue), Float.valueOf(newValue));
    }

    public float getArdPlausiWidthDeltaPct() {
        return this.ardPlausiWidthDeltaPct;
    }

    public void setArdPlausiHeightDeltaPct(float newValue) {
        float oldValue = this.ardPlausiHeightDeltaPct;
        this.ardPlausiHeightDeltaPct = newValue;
        this.firePropertyChange("ardPlausiHeightDeltaPct", Float.valueOf(oldValue), Float.valueOf(newValue));
    }

    public float getArdPlausiHeightDeltaPct() {
        return this.ardPlausiHeightDeltaPct;
    }

    public void setArdSecondaryDelta(float newValue) {
        float oldValue = this.ardSecondaryDelta;
        this.ardSecondaryDelta = newValue;
        this.firePropertyChange("ardSecondaryDelta", Float.valueOf(oldValue), Float.valueOf(newValue));
    }

    public float getArdSecondaryDelta() {
        return this.ardSecondaryDelta;
    }

    public void setArdRoundUp(boolean newValue) {
        boolean oldValue = this.ardRoundUp;
        this.ardRoundUp = newValue;
        this.firePropertyChange("ardRoundUp", oldValue, newValue);
    }

    public boolean isArdRoundUp() {
        return this.ardRoundUp;
    }

    public void setArdRoundUpThresholdPct(float newValue) {
        float oldValue = this.ardRoundUpThresholdPct;
        this.ardRoundUpThresholdPct = newValue;
        this.firePropertyChange("ardRoundUpThresholdPct", Float.valueOf(oldValue), Float.valueOf(newValue));
    }

    public float getArdRoundUpThresholdPct() {
        return this.ardRoundUpThresholdPct;
    }

    public void addCustomAspectRatios(String aspectRatio) {
        try {
            if (!this.customAspectRatios.contains(aspectRatio)) {
                this.customAspectRatios.add(aspectRatio);
                this.firePropertyChange(CUSTOM_ASPECT_RATIOS, null, this.customAspectRatios);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeCustomAspectRatios(String aspectRatio) {
        this.customAspectRatios.remove(aspectRatio);
        this.firePropertyChange(CUSTOM_ASPECT_RATIOS, null, this.customAspectRatios);
    }

    public void setCustomAspectRatios(List<String> newValues) {
        this.customAspectRatios.clear();
        this.customAspectRatios.addAll(newValues);
        this.firePropertyChange(CUSTOM_ASPECT_RATIOS, null, this.customAspectRatios);
    }

    public List<String> getCustomAspectRatios() {
        return this.customAspectRatios;
    }

    public void setArdMFMode(int newValue) {
        int oldValue = this.ardMFMode;
        this.ardMFMode = newValue;
        this.firePropertyChange("ardMFMode", oldValue, newValue);
    }

    public int getArdMFMode() {
        return this.ardMFMode;
    }

    public void setArdMFThresholdPct(float newValue) {
        float oldValue = this.ardMFThresholdPct;
        this.ardMFThresholdPct = newValue;
        this.firePropertyChange("ardMFThresholdPct", Float.valueOf(oldValue), Float.valueOf(newValue));
    }

    public float getArdMFThresholdPct() {
        return this.ardMFThresholdPct;
    }

    public void setArdDarkLevelPct(float newValue) {
        float oldValue = this.ardDarkLevelPct;
        this.ardDarkLevelPct = newValue;
        this.firePropertyChange("ardDarkLevelPct", Float.valueOf(oldValue), Float.valueOf(newValue));
    }

    public float getArdDarkLevelPct() {
        return this.ardDarkLevelPct;
    }

    public void setArdDarkLevelMaxPct(float newValue) {
        float oldValue = this.ardDarkLevelMaxPct;
        this.ardDarkLevelMaxPct = newValue;
        this.firePropertyChange("ardDarkLevelMaxPct", Float.valueOf(oldValue), Float.valueOf(newValue));
    }

    public float getArdDarkLevelMaxPct() {
        return this.ardDarkLevelMaxPct;
    }

    public Map<ArdSettings.Mode, ArdSettings.SampleSetting> getArdSampleSettings() {
        return this.ardSampleSettings;
    }

    public ArdSettings.SampleSetting getArdSampleSetting(ArdSettings.Mode mode) {
        return this.ardSampleSettings.get((Object)mode);
    }

    public boolean isEnableHttpServer() {
        return this.enableHttpServer;
    }

    public void setEnableHttpServer(boolean newValue) {
        boolean oldValue = this.enableHttpServer;
        this.enableHttpServer = newValue;
        this.firePropertyChange("enableHttpServer", oldValue, newValue);
    }

    public int getHttpServerPort() {
        return this.httpServerPort;
    }

    public void setHttpServerPort(int newValue) {
        int oldValue = this.httpServerPort;
        this.httpServerPort = newValue;
        this.firePropertyChange("httpServerPort", oldValue, newValue);
    }

    public void setHttpServerPort(String port) {
        try {
            this.setHttpServerPort(Integer.parseInt(port));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getHttpApiKey() {
        return this.httpApiKey;
    }

    public void setHttpApiKey(String newValue) {
        String oldValue = this.httpApiKey;
        this.httpApiKey = newValue;
        this.firePropertyChange("httpApiKey", oldValue, newValue);
    }

    private void setHttpApi() {
        try {
            TmmHttpServer.getInstance().updateConfiguration(this.enableHttpServer, this.httpServerPort, this.httpApiKey);
        }
        catch (Exception e) {
            LOGGER.error("could not update HTTP server configuration - '{}'", (Object)e.getMessage());
        }
    }

    public boolean isEnableAutomaticUpdate() {
        return this.enableAutomaticUpdate;
    }

    public void setEnableAutomaticUpdate(boolean newValue) {
        boolean oldValue = this.enableAutomaticUpdate;
        this.enableAutomaticUpdate = newValue;
        this.firePropertyChange("enableAutomaticUpdate", oldValue, newValue);
    }

    public int getAutomaticUpdateInterval() {
        return this.automaticUpdateInterval;
    }

    public void setAutomaticUpdateInterval(int newValue) {
        int oldValue = this.automaticUpdateInterval;
        this.automaticUpdateInterval = newValue;
        this.firePropertyChange("automaticUpdateInterval", oldValue, newValue);
    }
}

