/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Settings;

public class TmmProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmmProperties.class);
    private static final String PROPERTIES_FILE = "tmm.prop";
    private static TmmProperties instance;
    private final Properties properties = new SortedProperties();
    private boolean dirty;

    private TmmProperties() {
        try (FileInputStream input2 = new FileInputStream(new File(Settings.getInstance().getSettingsFolder(), PROPERTIES_FILE));){
            this.properties.load(input2);
        }
        catch (FileNotFoundException input2) {
        }
        catch (Exception e) {
            LOGGER.warn("unable to read properties file: {}", (Object)e.getMessage());
        }
        this.dirty = false;
    }

    public static synchronized TmmProperties getInstance() {
        if (instance == null) {
            instance = new TmmProperties();
        }
        return instance;
    }

    public void writeProperties() {
        if (!this.dirty) {
            return;
        }
        try (FileOutputStream output = new FileOutputStream(new File(Settings.getInstance().getSettingsFolder(), PROPERTIES_FILE));){
            this.properties.store(output, null);
        }
        catch (IOException e) {
            LOGGER.warn("failed to store properties file: {}", (Object)e.getMessage());
        }
    }

    public void putProperty(String key, String value) {
        this.properties.put(key, value);
        this.dirty = true;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public Boolean getPropertyAsBoolean(String key) {
        String value = this.properties.getProperty(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return Boolean.FALSE;
        }
        return Boolean.parseBoolean(value);
    }

    public Integer getPropertyAsInteger(String key) {
        String value = this.properties.getProperty(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private static class SortedProperties
    extends Properties {
        private SortedProperties() {
        }

        @Override
        public Set<Object> keySet() {
            return Collections.unmodifiableSet(new TreeSet<Object>(super.keySet()));
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            Set<Map.Entry<Object, Object>> set1 = super.entrySet();
            LinkedHashSet<Map.Entry<Object, Object>> set2 = new LinkedHashSet<Map.Entry<Object, Object>>(set1.size());
            Iterator iterator = set1.stream().sorted(Comparator.comparing(o -> o.getKey().toString())).iterator();
            while (iterator.hasNext()) {
                set2.add((Map.Entry)iterator.next());
            }
            return set2;
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            return Collections.enumeration(new TreeSet<Object>(super.keySet()));
        }
    }
}

