/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.scraper.DynaEnum;

public class MediaSource
extends DynaEnum<MediaSource> {
    private static final Comparator<MediaSource> COMPARATOR = new MediaSourceComparator();
    private static final Comparator<MediaSource> COMP_LENGTH = new MediaSourceLengthComparator();
    public static final MediaSource UHD_BLURAY = new MediaSource("UHD_BLURAY", 0, "UHD Blu-ray", "(uhd|ultrahd)[ .\\-]?(bluray|blueray|bdrip|brrip|dbrip|bd25|bd50|bdmv|blu\\-ray)");
    public static final MediaSource BLURAY = new MediaSource("BLURAY", 1, "Blu-ray", "(bluray|blueray|bdrip|brrip|dbrip|bd25|bd50|bdmv|blu\\-ray)");
    public static final MediaSource DVD = new MediaSource("DVD", 2, "DVD", "(dvd|video_ts|dvdrip|dvdr)");
    public static final MediaSource HDDVD = new MediaSource("HDDVD", 3, "HDDVD", "(hddvd|hddvdrip)");
    public static final MediaSource TV = new MediaSource("TV", 4, "TV", "(tv|hdtv|pdtv|dsr|dtb|dtt|dttv|dtv|hdtvrip|tvrip|dvbrip)");
    public static final MediaSource VHS = new MediaSource("VHS", 5, "VHS", "(vhs|vhsrip)");
    public static final MediaSource LASERDISC = new MediaSource("LASERDISC", 6, "LaserDisc", "(laserdisc|ldrip)");
    public static final MediaSource D_VHS = new MediaSource("D_VHS", 7, "D-VHS");
    public static final MediaSource HDRIP = new MediaSource("HDRIP", 8, "HDRip", "(hdrip)");
    public static final MediaSource CAM = new MediaSource("CAM", 9, "Cam", "(cam)");
    public static final MediaSource TS = new MediaSource("TS", 10, "Telesync", "(ts|telesync|hdts|ht\\-ts)");
    public static final MediaSource TC = new MediaSource("TC", 11, "Telecine", "(tc|telecine|hdtc|ht\\-tc)");
    public static final MediaSource DVDSCR = new MediaSource("DVDSCR", 12, "DVD Screener", "(dvdscr)");
    public static final MediaSource R5 = new MediaSource("R5", 13, "R5", "(r5)");
    public static final MediaSource WEBRIP = new MediaSource("WEBRIP", 14, "Webrip", "(webrip)");
    public static final MediaSource WEB_DL = new MediaSource("WEB_DL", 15, "Web-DL", "(web-dl|webdl|web)");
    public static final MediaSource STREAM = new MediaSource("STREAM", 16, "Stream");
    public static final MediaSource UNKNOWN = new MediaSource("UNKNOWN", 17, "");
    private static final String START_TOKEN = "[\\/\\\\ _,.()\\[\\]-]";
    private static final String END_TOKEN = "([\\/\\\\ _,.()\\[\\]-]|$)";
    private final String title;
    private final Pattern pattern;
    private final Pattern patternWoDelim;

    private MediaSource(String enumName, int ordinal, String title) {
        this(enumName, ordinal, title, "");
    }

    private MediaSource(String enumName, int ordinal, String title, String pattern) {
        super(enumName, ordinal);
        this.title = title;
        if (StringUtils.isNotBlank((CharSequence)pattern)) {
            this.pattern = Pattern.compile(START_TOKEN + pattern + END_TOKEN, 2);
            this.patternWoDelim = Pattern.compile("^" + pattern + "$", 2);
        } else {
            this.pattern = null;
            this.patternWoDelim = null;
        }
        this.addElement();
    }

    @Override
    public String toString() {
        return this.title;
    }

    @JsonValue
    public String getName() {
        return this.name();
    }

    public static MediaSource[] values() {
        MediaSource[] mediaSources = MediaSource.values(MediaSource.class);
        Arrays.sort(mediaSources, COMPARATOR);
        return mediaSources;
    }

    @JsonCreator
    public static synchronized MediaSource getMediaSource(String name) {
        for (MediaSource mediaSource : MediaSource.values()) {
            if (mediaSource.name().equals(name)) {
                return mediaSource;
            }
            if (!mediaSource.title.equalsIgnoreCase(name)) continue;
            return mediaSource;
        }
        return new MediaSource(name, MediaSource.values(MediaSource.class).length, name, "");
    }

    public static MediaSource parseMediaSource(String filename) {
        String ext;
        block9: {
            String fn = filename.toLowerCase(Locale.ROOT);
            MediaSource[] s = MediaSource.values();
            Arrays.sort(s, COMP_LENGTH);
            try {
                Path p = Paths.get(fn, new String[0]);
                for (MediaSource mediaSource : s) {
                    for (Path work = p; work != null; work = work.getParent()) {
                        String name = work.getName(work.getNameCount() - 1).toString();
                        if (mediaSource.pattern != null && mediaSource.pattern.matcher(name).find()) {
                            return mediaSource;
                        }
                        if (mediaSource.patternWoDelim == null || !mediaSource.patternWoDelim.matcher(name).find()) continue;
                        return mediaSource;
                    }
                }
            }
            catch (Exception e) {
                for (MediaSource mediaSource : s) {
                    if (mediaSource.pattern == null || !mediaSource.pattern.matcher(filename).find()) continue;
                    return mediaSource;
                }
            }
            ext = "";
            try {
                ext = FilenameUtils.getExtension((String)fn);
            }
            catch (Exception e) {
                int i = filename.lastIndexOf(46);
                if (i <= 0) break block9;
                ext = filename.substring(i + 1);
            }
        }
        if (ext.equals("strm")) {
            return STREAM;
        }
        return UNKNOWN;
    }

    public static void addListener(DynaEnum.DynaEnumEventListener<MediaSource> listener) {
        MediaSource.addListener(MediaSource.class, listener);
    }

    public static void removeListener(DynaEnum.DynaEnumEventListener<MediaSource> listener) {
        MediaSource.removeListener(MediaSource.class, listener);
    }

    private static class MediaSourceLengthComparator
    implements Comparator<MediaSource> {
        private MediaSourceLengthComparator() {
        }

        @Override
        public int compare(MediaSource o1, MediaSource o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1.name() == null) {
                return 1;
            }
            if (o2.name() == null) {
                return -1;
            }
            return Integer.compare(o2.name().length(), o1.name().length());
        }
    }

    private static class MediaSourceComparator
    implements Comparator<MediaSource> {
        private MediaSourceComparator() {
        }

        @Override
        public int compare(MediaSource o1, MediaSource o2) {
            if (o1.toString() == null && o2.toString() == null) {
                return 0;
            }
            if (o1.toString() == null) {
                return 1;
            }
            if (o2.toString() == null) {
                return -1;
            }
            return o1.toString().compareTo(o2.toString());
        }
    }
}

