/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.sun.net.httpserver.HttpExchange;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.tinymediamanager.core.http.ITmmCommandHandler;
import org.tinymediamanager.core.http.TmmCommandResponse;

public abstract class AbstractCommandHandler
implements ITmmCommandHandler {
    private final ObjectReader commandsObjectReader;
    private final ObjectReader singleCommandObjectReader;

    protected AbstractCommandHandler() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setTimeZone(TimeZone.getDefault());
        this.commandsObjectReader = objectMapper.readerFor((TypeReference)new TypeReference<List<Command>>(){});
        this.singleCommandObjectReader = objectMapper.readerFor(Command.class);
    }

    @Override
    public TmmCommandResponse post(HttpExchange httpExchange) throws Exception {
        List<Command> commands;
        String postContent = "";
        try (InputStream is = httpExchange.getRequestBody();){
            postContent = new String(is.readAllBytes(), StandardCharsets.UTF_8);
            commands = new ArrayList<Command>((Collection)this.commandsObjectReader.readValue(postContent));
        }
        catch (Exception e) {
            Command command = (Command)this.singleCommandObjectReader.readValue(postContent);
            commands = Collections.singletonList(command);
        }
        return this.processCommands(commands);
    }

    protected abstract TmmCommandResponse processCommands(List<Command> var1) throws Exception;

    public static class CommandScope {
        public String name;
        public String[] args;
    }

    public static class Command {
        public String action;
        public CommandScope scope = new CommandScope();
        public Map<String, String> args = new HashMap<String, String>();
    }
}

