/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.apache.commons.io.FilenameUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieRenamer;
import org.tinymediamanager.core.movie.MovieRenamerPreviewContainer;
import org.tinymediamanager.core.movie.entities.Movie;

public class MovieRenamerPreview {
    private MovieRenamerPreview() {
        throw new IllegalAccessError();
    }

    public static MovieRenamerPreviewContainer renameMovie(Movie movie) {
        MovieRenamerPreviewContainer container = new MovieRenamerPreviewContainer(movie);
        LinkedHashMap<String, MediaFile> oldFiles = new LinkedHashMap<String, MediaFile>();
        LinkedHashSet<MediaFile> newFiles = new LinkedHashSet<MediaFile>();
        boolean newDestIsMultiMovieDir = movie.isMultiMovieDir();
        String pattern = MovieModuleManager.getInstance().getSettings().getRenamerPathname();
        if (!pattern.isEmpty()) {
            boolean bl = newDestIsMultiMovieDir = !MovieRenamer.isFolderPatternUnique(pattern);
        }
        if (movie.isDisc()) {
            for (MediaFile mf : movie.getMediaFiles()) {
                oldFiles.put(mf.getFileAsPath().toString(), new MediaFile(mf));
                newFiles.add(mf);
            }
        } else {
            String newVideoBasename = "";
            if (MovieModuleManager.getInstance().getSettings().getRenamerFilename().trim().isEmpty()) {
                newVideoBasename = movie.getVideoBasenameWithoutStacking();
            } else {
                MediaFile ftr = MovieRenamer.generateFilename(movie, movie.getMainVideoFile(), newVideoBasename).get(0);
                newVideoBasename = FilenameUtils.getBaseName((String)ftr.getFilenameWithoutStacking());
            }
            for (MediaFile mf : movie.getMediaFiles(MediaFileType.VIDEO)) {
                oldFiles.put(mf.getFileAsPath().toString(), new MediaFile(mf));
                MediaFile ftr = MovieRenamer.generateFilename(movie, mf, newVideoBasename).get(0);
                newFiles.add(ftr);
            }
            boolean old = movie.isMultiMovieDir();
            movie.setMultiMovieDir(newDestIsMultiMovieDir);
            for (MediaFile mf : movie.getMediaFilesExceptType(MediaFileType.VIDEO)) {
                oldFiles.put(mf.getFileAsPath().toString(), new MediaFile(mf));
                newFiles.addAll(MovieRenamer.generateFilename(movie, mf, newVideoBasename));
            }
            movie.setMultiMovieDir(old);
        }
        Path oldMovieFolder = movie.getPathNIO();
        if (pattern.isEmpty()) {
            container.newPath = Paths.get(movie.getDataSource(), new String[0]).relativize(movie.getPathNIO());
        } else {
            try {
                container.newPath = Paths.get(MovieRenamer.createDestinationForFoldername(pattern, movie), new String[0]);
            }
            catch (Exception e) {
                container.newPath = movie.getPathNIO();
            }
        }
        Path newMovieFolder = Paths.get(movie.getDataSource(), new String[0]).resolve(container.newPath);
        if (!oldMovieFolder.equals(newMovieFolder)) {
            container.needsRename = true;
            for (MediaFile omf : oldFiles.values()) {
                omf.replacePathForRenamedFolder(oldMovieFolder, newMovieFolder);
            }
        }
        for (MediaFile mf : newFiles) {
            if (oldFiles.containsKey(mf.getFileAsPath().toString())) continue;
            container.needsRename = true;
            break;
        }
        for (MediaFile mf : oldFiles.values()) {
            if (newFiles.contains(mf)) continue;
            container.needsRename = true;
            break;
        }
        container.newMediaFiles.addAll(newFiles);
        return container;
    }
}

