/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieRenamer;
import org.tinymediamanager.core.movie.MovieSetScraperMetadataConfig;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.movie.filenaming.IMovieSetFileNaming;
import org.tinymediamanager.core.tasks.ImageCacheTask;
import org.tinymediamanager.core.tasks.MediaFileInformationFetcherTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.http.Url;

public class MovieSetArtworkHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSetArtworkHelper.class);
    private static final List<MediaFileType> SUPPORTED_ARTWORK_TYPES = Arrays.asList(MediaFileType.POSTER, MediaFileType.FANART, MediaFileType.BANNER, MediaFileType.LOGO, MediaFileType.CLEARLOGO, MediaFileType.CLEARART, MediaFileType.THUMB, MediaFileType.DISC);
    private static final String[] SUPPORTED_ARTWORK_FILETYPES = new String[]{"jpg", "png", "tbn", "webp"};

    private MovieSetArtworkHelper() {
    }

    public static void updateArtwork(MovieSet movieSet) {
        MovieSetArtworkHelper.findArtworkInArtworkFolder(movieSet);
        for (Movie movie : new ArrayList<Movie>(movieSet.getMovies())) {
            MovieSetArtworkHelper.findArtworkInMovieFolder(movieSet, movie);
        }
    }

    public static void cleanupArtwork(MovieSet movieSet) {
        Path artworkFolder = MovieSetArtworkHelper.getArtworkFolder();
        ArrayList<MediaFile> cleanup = new ArrayList<MediaFile>();
        TreeSet<MediaFile> needed = new TreeSet<MediaFile>();
        for (MediaFileType type : SUPPORTED_ARTWORK_TYPES) {
            MediaFile artworkFile;
            List<IMovieSetFileNaming> fileNamings = MovieSetArtworkHelper.getFileNamingsForMediaFileType(type);
            if (fileNamings.isEmpty()) continue;
            List<MediaFile> mediaFiles = movieSet.getMediaFiles(type);
            cleanup.addAll(mediaFiles);
            if ((mediaFiles = mediaFiles.stream().filter(mf -> {
                if (mf.getFilesize() == 0L) {
                    return false;
                }
                return Files.exists(mf.getFile(), new LinkOption[0]);
            }).collect(Collectors.toList())).isEmpty() || (artworkFile = MovieSetArtworkHelper.getArtworkFromMediaFiles(movieSet, mediaFiles, type, fileNamings)) == null) continue;
            for (Path path : MovieSetArtworkHelper.createArtworkPathsInArtworkFolder(movieSet, fileNamings, artworkFile.getExtension())) {
                try {
                    MediaFile newFile = new MediaFile(artworkFile);
                    newFile.setFile(path);
                    boolean ok = MovieRenamer.copyFile(artworkFile.getFileAsPath(), newFile.getFileAsPath());
                    if (ok) {
                        needed.add(newFile);
                        continue;
                    }
                    needed.add(artworkFile);
                }
                catch (Exception e) {
                    LOGGER.warn("could not write files", (Throwable)e);
                }
            }
            for (IMovieSetFileNaming filenaming : fileNamings) {
                if (filenaming.getFolderLocation() != IMovieSetFileNaming.Location.MOVIE_FOLDER) continue;
                String filename = filenaming.getFilename("", artworkFile.getExtension());
                for (Movie movie : movieSet.getMovies()) {
                    try {
                        if (!movie.isMultiMovieDir()) {
                            MediaFile newFile = new MediaFile(artworkFile);
                            newFile.setFile(movie.getPathNIO().resolve(filename));
                            boolean ok = MovieRenamer.copyFile(artworkFile.getFileAsPath(), newFile.getFileAsPath());
                            if (ok) {
                                needed.add(newFile);
                                continue;
                            }
                            needed.add(artworkFile);
                            continue;
                        }
                        LOGGER.trace("not writing movie set artwork file to MMD - '{}'", (Object)movie.getPathNIO());
                    }
                    catch (Exception e) {
                        LOGGER.warn("could not write files", (Throwable)e);
                    }
                }
            }
        }
        if (!needed.isEmpty() && Settings.getInstance().isImageCache()) {
            ImageCacheTask task = new ImageCacheTask(new ArrayList<MediaFile>(needed));
            TmmTaskManager.getInstance().addUnnamedTask(task);
        }
        cleanup.forEach(movieSet::removeFromMediaFiles);
        movieSet.addToMediaFiles(new ArrayList<MediaFile>(needed));
        for (int i = cleanup.size() - 1; i >= 0; --i) {
            MediaFile cl = (MediaFile)cleanup.get(i);
            if (needed.contains(cl)) continue;
            LOGGER.debug("Deleting {}", (Object)cl.getFileAsPath());
            Utils.deleteFileSafely(cl.getFileAsPath());
            ImageCache.invalidateCachedImage(cl);
            try {
                if (artworkFolder == null || artworkFolder.equals(cl.getFile().getParent()) || !Utils.isFolderEmpty(cl.getFile().getParent())) continue;
                LOGGER.debug("Deleting empty Directory {}", (Object)cl.getFileAsPath().getParent());
                Files.delete(cl.getFileAsPath().getParent());
                continue;
            }
            catch (IOException e) {
                LOGGER.warn("could not search for empty dir: {}", (Object)e.getMessage());
            }
        }
        movieSet.saveToDb();
    }

    private static Path getArtworkFolder() {
        String artworkFolder = MovieModuleManager.getInstance().getSettings().getMovieSetDataFolder();
        if (StringUtils.isBlank((CharSequence)artworkFolder)) {
            return null;
        }
        return Paths.get(artworkFolder, new String[0]);
    }

    private static List<Path> createArtworkPathsInArtworkFolder(MovieSet movieSet, List<IMovieSetFileNaming> filenamings, String extension) {
        Path artworkFolder = MovieSetArtworkHelper.getArtworkFolder();
        if (artworkFolder == null) {
            return Collections.emptyList();
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        String movieSetName = movieSet.getTitleForStorage();
        for (IMovieSetFileNaming fileNaming : filenamings) {
            if (fileNaming.getFolderLocation() == IMovieSetFileNaming.Location.KODI_STYLE_FOLDER) {
                paths.add(Paths.get(artworkFolder.toString(), movieSetName, fileNaming.getFilename(movieSetName, extension)));
                continue;
            }
            if (fileNaming.getFolderLocation() != IMovieSetFileNaming.Location.AUTOMATOR_STYLE_FOLDER) continue;
            paths.add(Paths.get(artworkFolder.toString(), fileNaming.getFilename(movieSetName, extension)));
        }
        return paths;
    }

    private static MediaFile getArtworkFromMediaFiles(MovieSet movieSet, List<MediaFile> mediaFiles, MediaFileType type, List<IMovieSetFileNaming> fileNamings) {
        Path artworkFolder = MovieSetArtworkHelper.getArtworkFolder();
        if (artworkFolder != null) {
            for (IMovieSetFileNaming fileNaming : fileNamings) {
                for (MediaFile mediaFile : mediaFiles) {
                    String movieSetName = MovieRenamer.replaceInvalidCharacters(movieSet.getTitle());
                    movieSetName = MovieRenamer.replacePathSeparators(movieSetName);
                    if (MovieSetArtworkHelper.isMediaFileInArtworkFolder(movieSetName = movieSetName.replaceAll(" +", " ").trim(), artworkFolder, fileNaming, mediaFile)) {
                        return mediaFile;
                    }
                    movieSetName = movieSet.getTitleForStorage();
                    if (!MovieSetArtworkHelper.isMediaFileInArtworkFolder(movieSetName, artworkFolder, fileNaming, mediaFile)) continue;
                    return mediaFile;
                }
            }
        }
        for (MediaFile mediaFile : mediaFiles) {
            if (mediaFile.getType() != type) continue;
            return mediaFile;
        }
        return null;
    }

    private static boolean isMediaFileInArtworkFolder(String cleanMovieSetName, Path artworkFolder, IMovieSetFileNaming fileNaming, MediaFile mediaFile) {
        if (fileNaming.getFolderLocation() == IMovieSetFileNaming.Location.KODI_STYLE_FOLDER) {
            Path path = Paths.get(artworkFolder.toString(), cleanMovieSetName, fileNaming.getFilename(cleanMovieSetName, ""));
            return mediaFile.getFileAsPath().toAbsolutePath().startsWith(path);
        }
        if (fileNaming.getFolderLocation() == IMovieSetFileNaming.Location.AUTOMATOR_STYLE_FOLDER) {
            Path path = Paths.get(artworkFolder.toString(), fileNaming.getFilename(cleanMovieSetName, ""));
            return mediaFile.getFileAsPath().toAbsolutePath().startsWith(path);
        }
        return mediaFile.getFilename().contains(fileNaming.getFilename("", ""));
    }

    private static void findArtworkInArtworkFolder(MovieSet movieSet) {
        MediaFile mediaFile;
        Path artworkFile;
        String artworkFileName;
        String movieSetName;
        String artworkFolder = MovieModuleManager.getInstance().getSettings().getMovieSetDataFolder();
        if (StringUtils.isBlank((CharSequence)artworkFolder)) {
            return;
        }
        for (MediaFileType type : SUPPORTED_ARTWORK_TYPES) {
            for (String fileType : SUPPORTED_ARTWORK_FILETYPES) {
                movieSetName = MovieRenamer.replaceInvalidCharacters(movieSet.getTitle());
                movieSetName = MovieRenamer.replacePathSeparators(movieSetName);
                movieSetName = movieSetName.replaceAll(" +", " ").trim();
                artworkFileName = movieSetName + "-" + type.name().toLowerCase(Locale.ROOT) + "." + fileType;
                artworkFile = Paths.get(artworkFolder, artworkFileName);
                if (Files.exists(artworkFile, new LinkOption[0])) {
                    mediaFile = new MediaFile(artworkFile, type);
                    TmmTaskManager.getInstance().addUnnamedTask(new MediaFileInformationFetcherTask(mediaFile, movieSet, false));
                    movieSet.addToMediaFiles(mediaFile);
                }
                movieSetName = movieSet.getTitleForStorage();
                artworkFileName = movieSetName + "-" + type.name().toLowerCase(Locale.ROOT) + "." + fileType;
                artworkFile = Paths.get(artworkFolder, artworkFileName);
                if (!Files.exists(artworkFile, new LinkOption[0])) continue;
                mediaFile = new MediaFile(artworkFile, type);
                TmmTaskManager.getInstance().addUnnamedTask(new MediaFileInformationFetcherTask(mediaFile, movieSet, false));
                movieSet.addToMediaFiles(mediaFile);
            }
        }
        for (MediaFileType type : SUPPORTED_ARTWORK_TYPES) {
            for (String fileType : SUPPORTED_ARTWORK_FILETYPES) {
                movieSetName = MovieRenamer.replaceInvalidCharacters(movieSet.getTitle());
                movieSetName = MovieRenamer.replacePathSeparators(movieSetName);
                movieSetName = movieSetName.replaceAll(" +", " ").trim();
                artworkFileName = type.name().toLowerCase(Locale.ROOT) + "." + fileType;
                artworkFile = Paths.get(artworkFolder, movieSetName, artworkFileName);
                if (Files.exists(artworkFile, new LinkOption[0])) {
                    mediaFile = new MediaFile(artworkFile, type);
                    TmmTaskManager.getInstance().addUnnamedTask(new MediaFileInformationFetcherTask(mediaFile, movieSet, false));
                    movieSet.addToMediaFiles(mediaFile);
                }
                movieSetName = movieSet.getTitleForStorage();
                artworkFileName = type.name().toLowerCase(Locale.ROOT) + "." + fileType;
                artworkFile = Paths.get(artworkFolder, movieSetName, artworkFileName);
                if (!Files.exists(artworkFile, new LinkOption[0])) continue;
                mediaFile = new MediaFile(artworkFile, type);
                TmmTaskManager.getInstance().addUnnamedTask(new MediaFileInformationFetcherTask(mediaFile, movieSet, false));
                movieSet.addToMediaFiles(mediaFile);
            }
        }
    }

    private static void findArtworkInMovieFolder(MovieSet movieSet, Movie movie) {
        for (MediaFileType type : SUPPORTED_ARTWORK_TYPES) {
            if (!movieSet.getMediaFiles(type).isEmpty()) continue;
            for (String fileType : SUPPORTED_ARTWORK_FILETYPES) {
                String artworkFileName = "movieset-" + type.name().toLowerCase(Locale.ROOT) + "." + fileType;
                Path artworkFile = movie.getPathNIO().resolve(artworkFileName);
                if (!Files.exists(artworkFile, new LinkOption[0])) continue;
                MediaFile mediaFile = new MediaFile(artworkFile, type);
                TmmTaskManager.getInstance().addUnnamedTask(new MediaFileInformationFetcherTask(mediaFile, movieSet, false));
                movieSet.addToMediaFiles(mediaFile);
            }
        }
    }

    public static void setArtwork(MovieSet movieSet, List<MediaArtwork> artwork, List<MovieSetScraperMetadataConfig> config) {
        if (!ScraperMetadataConfig.containsAnyArtwork(config)) {
            return;
        }
        if (config.contains(MovieSetScraperMetadataConfig.POSTER)) {
            MovieSetArtworkHelper.setBestPoster(movieSet, artwork);
        }
        if (config.contains(MovieSetScraperMetadataConfig.FANART)) {
            MovieSetArtworkHelper.setBestFanart(movieSet, artwork);
        }
        if (config.contains(MovieSetScraperMetadataConfig.LOGO)) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.LOGO);
        }
        if (config.contains(MovieSetScraperMetadataConfig.CLEARLOGO)) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.CLEARLOGO);
        }
        if (config.contains(MovieSetScraperMetadataConfig.CLEARART)) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.CLEARART);
        }
        if (config.contains(MovieSetScraperMetadataConfig.BANNER)) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.BANNER);
        }
        if (config.contains(MovieSetScraperMetadataConfig.THUMB)) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.THUMB);
        }
        if (config.contains(MovieSetScraperMetadataConfig.DISCART)) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.DISC);
        }
        movieSet.saveToDb();
        movieSet.writeNFO();
    }

    private static List<MediaArtwork> sortArtwork(List<MediaArtwork> artwork, MediaArtwork.MediaArtworkType type, int sizeOrder, String language) {
        ArrayList<MediaArtwork> sortedArtwork = new ArrayList<MediaArtwork>();
        for (MediaArtwork art : artwork) {
            if (sortedArtwork.contains(art) || art.getType() != type || !art.getLanguage().equals(language) || art.getSizeOrder() != sizeOrder) continue;
            sortedArtwork.add(art);
        }
        if (MovieModuleManager.getInstance().getSettings().isImageLanguagePriority()) {
            int newOrder = sizeOrder;
            for (int counter = 1; counter <= 2; ++counter) {
                newOrder /= 2;
                for (MediaArtwork art : artwork) {
                    if (art.getType() != type || !art.getLanguage().equals(language) || art.getSizeOrder() != newOrder) continue;
                    sortedArtwork.add(art);
                }
            }
        }
        for (MediaArtwork art : artwork) {
            if (sortedArtwork.contains(art) || art.getType() != type || art.getSizeOrder() != sizeOrder) continue;
            sortedArtwork.add(art);
        }
        int newOrder = sizeOrder;
        for (int counter = 1; counter <= 2; ++counter) {
            newOrder /= 2;
            for (MediaArtwork art : artwork) {
                if (sortedArtwork.contains(art) || art.getType() != type || art.getSizeOrder() != newOrder) continue;
                sortedArtwork.add(art);
            }
        }
        if (sortedArtwork.isEmpty() && !artwork.isEmpty()) {
            for (MediaArtwork art : artwork) {
                if (sortedArtwork.contains(art) || art.getType() != type) continue;
                sortedArtwork.add(art);
            }
        }
        return sortedArtwork;
    }

    private static void setBestPoster(MovieSet movieSet, List<MediaArtwork> artwork) {
        String preferredLanguage;
        int preferredSizeOrder = MovieModuleManager.getInstance().getSettings().getImagePosterSize().getOrder();
        List<MediaArtwork> sortedPosters = MovieSetArtworkHelper.sortArtwork(artwork, MediaArtwork.MediaArtworkType.POSTER, preferredSizeOrder, preferredLanguage = MovieModuleManager.getInstance().getSettings().getImageScraperLanguage().getLanguage());
        if (!sortedPosters.isEmpty()) {
            MediaArtwork foundPoster = sortedPosters.get(0);
            movieSet.setArtworkUrl(foundPoster.getDefaultUrl(), MediaFileType.POSTER);
        }
    }

    private static void setBestFanart(MovieSet movieSet, List<MediaArtwork> artwork) {
        String preferredLanguage;
        int preferredSizeOrder = MovieModuleManager.getInstance().getSettings().getImageFanartSize().getOrder();
        List<MediaArtwork> sortedFanarts = MovieSetArtworkHelper.sortArtwork(artwork, MediaArtwork.MediaArtworkType.BACKGROUND, preferredSizeOrder, preferredLanguage = MovieModuleManager.getInstance().getSettings().getImageScraperLanguage().getLanguage());
        if (!sortedFanarts.isEmpty()) {
            MediaArtwork foundfanart = sortedFanarts.get(0);
            movieSet.setArtworkUrl(foundfanart.getDefaultUrl(), MediaFileType.FANART);
        }
    }

    private static void setBestArtwork(MovieSet movieSet, List<MediaArtwork> artwork, MediaArtwork.MediaArtworkType type) {
        int preferredSizeOrder = MovieModuleManager.getInstance().getSettings().getImageFanartSize().getOrder();
        String preferredLanguage = MovieModuleManager.getInstance().getSettings().getImageScraperLanguage().getLanguage();
        List<MediaArtwork> sortedArtworks = MovieSetArtworkHelper.sortArtwork(artwork, type, preferredSizeOrder, preferredLanguage);
        for (MediaArtwork art : sortedArtworks) {
            if (art.getType() != type) continue;
            movieSet.setArtworkUrl(art.getDefaultUrl(), MediaFileType.getMediaFileType(type));
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadArtwork(MovieSet movieSet, MediaFileType type) {
        String url = movieSet.getArtworkUrl(type);
        if (StringUtils.isBlank((CharSequence)url)) {
            return;
        }
        try {
            MovieSetImageFetcherTask task = new MovieSetImageFetcherTask(movieSet, url, type);
            TmmTaskManager.getInstance().addImageDownloadTask(task);
        }
        finally {
            if (url.startsWith("file:")) {
                movieSet.removeArtworkUrl(type);
            }
        }
    }

    public static void writeImagesToMovieFolder(MovieSet movieSet, List<Movie> movies) {
        for (MediaFileType type : SUPPORTED_ARTWORK_TYPES) {
            List<IMovieSetFileNaming> fileNamings = MovieSetArtworkHelper.getFileNamingsForMediaFileType(type);
            for (IMovieSetFileNaming fileNaming : fileNamings) {
                String url;
                if (fileNaming.getFolderLocation() != IMovieSetFileNaming.Location.MOVIE_FOLDER || StringUtils.isBlank((CharSequence)(url = movieSet.getArtworkUrl(type)))) continue;
                MovieSetImageFetcherTask task = new MovieSetImageFetcherTask(movieSet, url, type, Collections.singletonList(fileNaming), movies);
                TmmTaskManager.getInstance().addImageDownloadTask(task);
            }
        }
    }

    public static void cleanMovieSetArtworkInMovieFolder(Movie movie) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(movie.getPathNIO());){
            for (Path entry : stream) {
                Matcher matcher = MediaFileHelper.MOVIESET_ARTWORK_PATTERN.matcher(entry.getFileName().toString());
                if (!matcher.find()) continue;
                Utils.deleteFileSafely(entry);
            }
        }
        catch (Exception e) {
            LOGGER.error("remove movie set artwork: {}", (Object)e.getMessage());
        }
    }

    public static void removeMovieSetArtwork(MovieSet movieSet) {
        List subfolders;
        for (MediaFile mediaFile : movieSet.getMediaFiles()) {
            if (!mediaFile.isGraphic()) continue;
            Utils.deleteFileSafely(mediaFile.getFile());
        }
        if (StringUtils.isBlank((CharSequence)MovieModuleManager.getInstance().getSettings().getMovieSetDataFolder())) {
            return;
        }
        Path movieSetArtworkFolder = Paths.get(MovieModuleManager.getInstance().getSettings().getMovieSetDataFolder(), new String[0]);
        try (Stream<Path> stream = Files.walk(movieSetArtworkFolder, 1, new FileVisitOption[0]);){
            subfolders = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.warn("could not clean movie set artwork subfolders - '{}'", (Object)e.getMessage());
            return;
        }
        for (Path path : subfolders) {
            if (path.equals(movieSetArtworkFolder)) continue;
            try {
                Utils.deleteEmptyDirectoryRecursive(path);
            }
            catch (Exception e) {
                LOGGER.warn("could not clean empty subfolder '{}' - '{}'", (Object)path, (Object)e.getMessage());
            }
        }
    }

    public static boolean hasMissingArtwork(MovieSet movieSet) {
        if (!MovieModuleManager.getInstance().getSettings().getPosterFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.POSTER).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.getInstance().getSettings().getFanartFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.FANART).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.getInstance().getSettings().getBannerFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.BANNER).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.getInstance().getSettings().getDiscartFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.DISC).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.getInstance().getSettings().getLogoFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.LOGO).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.getInstance().getSettings().getClearlogoFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.CLEARLOGO).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.getInstance().getSettings().getClearartFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.CLEARART).isEmpty()) {
            return true;
        }
        return !MovieModuleManager.getInstance().getSettings().getThumbFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.THUMB).isEmpty();
    }

    public static void getMissingArtwork(MovieSet movieSet, List<MediaArtwork> artwork) {
        if (movieSet.getMediaFiles(MediaFileType.POSTER).isEmpty()) {
            MovieSetArtworkHelper.setBestPoster(movieSet, artwork);
        }
        if (movieSet.getMediaFiles(MediaFileType.FANART).isEmpty()) {
            MovieSetArtworkHelper.setBestFanart(movieSet, artwork);
        }
        if (movieSet.getMediaFiles(MediaFileType.LOGO).isEmpty()) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.LOGO);
        }
        if (movieSet.getMediaFiles(MediaFileType.CLEARLOGO).isEmpty()) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.CLEARLOGO);
        }
        if (movieSet.getMediaFiles(MediaFileType.CLEARART).isEmpty()) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.CLEARART);
        }
        if (movieSet.getMediaFiles(MediaFileType.BANNER).isEmpty()) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.BANNER);
        }
        if (movieSet.getMediaFiles(MediaFileType.THUMB).isEmpty()) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.THUMB);
        }
        if (movieSet.getMediaFiles(MediaFileType.DISC).isEmpty()) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.DISC);
        }
        movieSet.saveToDb();
    }

    private static List<IMovieSetFileNaming> getFileNamingsForMediaFileType(MediaFileType type) {
        ArrayList<IMovieSetFileNaming> fileNamings = new ArrayList<IMovieSetFileNaming>(0);
        switch (type) {
            case FANART: {
                fileNamings.addAll(MovieModuleManager.getInstance().getSettings().getMovieSetFanartFilenames());
                break;
            }
            case POSTER: {
                fileNamings.addAll(MovieModuleManager.getInstance().getSettings().getMovieSetPosterFilenames());
                break;
            }
            case LOGO: {
                fileNamings.addAll(MovieModuleManager.getInstance().getSettings().getMovieSetLogoFilenames());
                break;
            }
            case CLEARLOGO: {
                fileNamings.addAll(MovieModuleManager.getInstance().getSettings().getMovieSetClearlogoFilenames());
                break;
            }
            case BANNER: {
                fileNamings.addAll(MovieModuleManager.getInstance().getSettings().getMovieSetBannerFilenames());
                break;
            }
            case CLEARART: {
                fileNamings.addAll(MovieModuleManager.getInstance().getSettings().getMovieSetClearartFilenames());
                break;
            }
            case THUMB: {
                fileNamings.addAll(MovieModuleManager.getInstance().getSettings().getMovieSetThumbFilenames());
                break;
            }
            case DISC: {
                fileNamings.addAll(MovieModuleManager.getInstance().getSettings().getMovieSetDiscartFilenames());
                break;
            }
        }
        return fileNamings;
    }

    private static class MovieSetImageFetcherTask
    implements Runnable {
        private final MovieSet movieSet;
        private final String urlToArtwork;
        private final MediaFileType type;
        private final List<IMovieSetFileNaming> fileNamings = new ArrayList<IMovieSetFileNaming>();
        private final List<Movie> movies = new ArrayList<Movie>();
        private final List<MediaFile> writtenArtworkFiles = new ArrayList<MediaFile>();

        private MovieSetImageFetcherTask(MovieSet movieSet, String url, MediaFileType type) {
            this(movieSet, url, type, movieSet.getMovies());
        }

        private MovieSetImageFetcherTask(MovieSet movieSet, String url, MediaFileType type, List<Movie> movies) {
            this(movieSet, url, type, MovieSetArtworkHelper.getFileNamingsForMediaFileType(type), movies);
        }

        private MovieSetImageFetcherTask(MovieSet movieSet, String url, MediaFileType type, List<IMovieSetFileNaming> fileNamings, List<Movie> movies) {
            this.movieSet = movieSet;
            this.urlToArtwork = url;
            this.type = type;
            this.fileNamings.addAll(fileNamings);
            this.movies.addAll(movies);
        }

        @Override
        public void run() {
            try {
                Url url = new Url(this.urlToArtwork);
                try (InputStream is = url.getInputStream();){
                    byte[] bytes = IOUtils.toByteArray((InputStream)is);
                    String extension = Utils.getArtworkExtensionFromContentType(url.getHeader("content-type"));
                    if (StringUtils.isBlank((CharSequence)extension)) {
                        extension = Utils.getArtworkExtensionFromUrl(this.urlToArtwork);
                    }
                    List<MediaFile> oldMediaFiles = this.movieSet.getMediaFiles(this.type);
                    this.movieSet.removeAllMediaFiles(this.type);
                    for (MediaFile mediaFile : oldMediaFiles) {
                        ImageCache.invalidateCachedImage(mediaFile.getFile());
                        Utils.deleteFileSafely(mediaFile.getFile());
                    }
                    if (!this.fileNamings.isEmpty()) {
                        this.writeImageToArtworkFolder(bytes, extension);
                        this.writeImageToMovieFolders(bytes, extension);
                    } else {
                        this.writeImageToCacheFolder(bytes);
                    }
                    this.movieSet.addToMediaFiles(this.writtenArtworkFiles);
                    this.movieSet.saveToDb();
                }
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.error("fetch image: {} - {}", (Object)this.urlToArtwork, (Object)e.getMessage());
            }
        }

        private void writeImageToArtworkFolder(byte[] bytes, String extension) {
            List<Path> paths = MovieSetArtworkHelper.createArtworkPathsInArtworkFolder(this.movieSet, this.fileNamings, extension);
            for (Path path : paths) {
                if (!Files.exists(path.getParent(), new LinkOption[0])) {
                    try {
                        Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        LOGGER.warn("could not create directory '{}' - {} ", (Object)path.getParent(), (Object)e.getMessage());
                    }
                }
                try {
                    this.writeImage(bytes, path);
                    MediaFile artwork = new MediaFile(path, this.type);
                    artwork.gatherMediaInformation();
                    this.writtenArtworkFiles.add(artwork);
                    ImageCache.invalidateCachedImage(artwork);
                    ImageCache.cacheImageSilently(artwork);
                }
                catch (Exception e) {
                    LOGGER.warn("could not write file", (Throwable)e);
                }
            }
        }

        private void writeImageToMovieFolders(byte[] bytes, String extension) {
            if (this.movies.isEmpty()) {
                return;
            }
            List movieFileNamings = this.fileNamings.stream().filter(fileNaming -> fileNaming.getFolderLocation() == IMovieSetFileNaming.Location.MOVIE_FOLDER).collect(Collectors.toList());
            for (IMovieSetFileNaming fileNaming2 : movieFileNamings) {
                String filename = fileNaming2.getFilename("", extension);
                for (Movie movie : this.movies) {
                    try {
                        if (movie.isMultiMovieDir()) continue;
                        Path imageFile = movie.getPathNIO().resolve(filename);
                        this.writeImage(bytes, imageFile);
                        MediaFile artwork = new MediaFile(imageFile, this.type);
                        artwork.gatherMediaInformation();
                        this.writtenArtworkFiles.add(artwork);
                        ImageCache.invalidateCachedImage(artwork);
                        ImageCache.cacheImageSilently(artwork);
                    }
                    catch (Exception e) {
                        LOGGER.warn("could not write files", (Throwable)e);
                    }
                }
            }
        }

        private void writeImageToCacheFolder(byte[] bytes) {
            String filename = ImageCache.getMD5WithSubfolder(this.urlToArtwork);
            try {
                this.writeImage(bytes, ImageCache.getCacheDir().resolve(filename + ".jpg"));
            }
            catch (Exception e) {
                LOGGER.warn("error in image fetcher", (Throwable)e);
            }
        }

        private void writeImage(byte[] bytes, Path pathAndFilename) throws IOException {
            try (FileOutputStream outputStream = new FileOutputStream(pathAndFilename.toFile());
                 ByteArrayInputStream is = new ByteArrayInputStream(bytes);){
                IOUtils.copy((InputStream)is, (OutputStream)outputStream);
                outputStream.flush();
                try {
                    outputStream.getFD().sync();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

