/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.filenaming;

import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.movie.filenaming.IMovieSetFileNaming;

public enum MovieSetClearartNaming implements IMovieSetFileNaming
{
    MOVIE_CLEARART{

        @Override
        public String getFilename(String basename, String extension) {
            return "movieset-clearart." + extension;
        }

        @Override
        public IMovieSetFileNaming.Location getFolderLocation() {
            return IMovieSetFileNaming.Location.MOVIE_FOLDER;
        }
    }
    ,
    KODI_CLEARART{

        @Override
        public String getFilename(String basename, String extension) {
            return "clearart." + extension;
        }

        @Override
        public IMovieSetFileNaming.Location getFolderLocation() {
            return IMovieSetFileNaming.Location.KODI_STYLE_FOLDER;
        }
    }
    ,
    AUTOMATOR_CLEARART{

        @Override
        public String getFilename(String basename, String extension) {
            return StringUtils.isNotBlank((CharSequence)basename) ? basename + "-clearart." + extension : "";
        }

        @Override
        public IMovieSetFileNaming.Location getFolderLocation() {
            return IMovieSetFileNaming.Location.AUTOMATOR_STYLE_FOLDER;
        }
    };

}

