/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.filenaming;

import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.movie.filenaming.IMovieSetFileNaming;

public enum MovieSetLogoNaming implements IMovieSetFileNaming
{
    MOVIE_LOGO{

        @Override
        public String getFilename(String basename, String extension) {
            return "movieset-logo." + extension;
        }

        @Override
        public IMovieSetFileNaming.Location getFolderLocation() {
            return IMovieSetFileNaming.Location.MOVIE_FOLDER;
        }
    }
    ,
    KODI_LOGO{

        @Override
        public String getFilename(String basename, String extension) {
            return "logo." + extension;
        }

        @Override
        public IMovieSetFileNaming.Location getFolderLocation() {
            return IMovieSetFileNaming.Location.KODI_STYLE_FOLDER;
        }
    }
    ,
    AUTOMATOR_LOGO{

        @Override
        public String getFilename(String basename, String extension) {
            return StringUtils.isNotBlank((CharSequence)basename) ? basename + "-logo." + extension : "";
        }

        @Override
        public IMovieSetFileNaming.Location getFolderLocation() {
            return IMovieSetFileNaming.Location.AUTOMATOR_STYLE_FOLDER;
        }
    };

}

