/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.LanguageStyle;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tasks.SubtitleDownloadTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.SubtitleSearchAndScrapeOptions;
import org.tinymediamanager.scraper.SubtitleSearchResult;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieSubtitleProvider;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;

public class MovieSubtitleSearchAndDownloadTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSubtitleSearchAndDownloadTask.class);
    private final List<Movie> movies;
    private final List<MediaScraper> subtitleScrapers;
    private final MediaLanguages language;
    private boolean forceBestMatch;

    public MovieSubtitleSearchAndDownloadTask(List<Movie> movies, MediaLanguages language) {
        super(TmmResourceBundle.getString("movie.download.subtitles"));
        this.movies = movies;
        this.language = language;
        this.subtitleScrapers = new ArrayList<MediaScraper>();
        for (String scraperId : MovieModuleManager.getInstance().getSettings().getSubtitleScrapers()) {
            MediaScraper scraper = MediaScraper.getMediaScraperById(scraperId, ScraperType.MOVIE_SUBTITLE);
            if (scraper == null) continue;
            this.subtitleScrapers.add(scraper);
        }
    }

    public MovieSubtitleSearchAndDownloadTask(List<Movie> movies, List<MediaScraper> subtitleScrapers, MediaLanguages language) {
        super(TmmResourceBundle.getString("movie.download.subtitles"));
        this.movies = movies;
        this.subtitleScrapers = subtitleScrapers;
        this.language = language;
    }

    public void setForceBestMatch(boolean forceBestMatch) {
        this.forceBestMatch = forceBestMatch;
    }

    @Override
    protected void doInBackground() {
        if (!this.isFeatureEnabled()) {
            return;
        }
        this.initThreadPool(3, "searchAndDownloadSubtitles");
        this.start();
        for (Movie movie : this.movies) {
            this.submitTask(new Worker(movie));
        }
        this.waitForCompletionOrCancel();
        LOGGER.info("Done searching and downloading subtitles");
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    private class Worker
    implements Runnable {
        private final Movie movie;

        public Worker(Movie movie) {
            this.movie = movie;
        }

        @Override
        public void run() {
            try {
                for (MediaScraper scraper : MovieSubtitleSearchAndDownloadTask.this.subtitleScrapers) {
                    try {
                        MediaFile mf = this.movie.getMediaFiles(MediaFileType.VIDEO).get(0);
                        IMovieSubtitleProvider subtitleProvider = (IMovieSubtitleProvider)scraper.getMediaProvider();
                        SubtitleSearchAndScrapeOptions options = new SubtitleSearchAndScrapeOptions(MediaType.MOVIE);
                        options.setFile(mf.getFileAsPath().toFile());
                        options.setSearchQuery(this.movie.getOriginalTitle());
                        options.setLanguage(MovieSubtitleSearchAndDownloadTask.this.language);
                        options.setImdbId(this.movie.getImdbId());
                        List<SubtitleSearchResult> searchResults = subtitleProvider.search(options);
                        if (searchResults.isEmpty()) continue;
                        Collections.sort(searchResults);
                        Collections.reverse(searchResults);
                        SubtitleSearchResult result = this.getBestResult(searchResults);
                        if (result == null) continue;
                        String lang = LanguageStyle.getLanguageCodeForStyle(MovieSubtitleSearchAndDownloadTask.this.language.name(), MovieModuleManager.getInstance().getSettings().getSubtitleLanguageStyle());
                        if (StringUtils.isBlank((CharSequence)lang)) {
                            lang = MovieSubtitleSearchAndDownloadTask.this.language.name();
                        }
                        String filename = FilenameUtils.getBaseName((String)mf.getFilename()) + "." + lang;
                        TmmTaskManager.getInstance().addDownloadTask(new SubtitleDownloadTask(result.getUrl(), this.movie.getPathNIO().resolve(filename), this.movie));
                    }
                    catch (MissingIdException mf) {
                    }
                    catch (ScrapeException e) {
                        LOGGER.error("getSubtitles", (Throwable)e);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.movie, "message.scrape.subtitlefailed", new String[]{":", e.getLocalizedMessage()}));
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Thread crashed", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"SubtitleDownloader", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
            }
        }

        private SubtitleSearchResult getBestResult(List<SubtitleSearchResult> searchResults) {
            if (ListUtils.isEmpty(searchResults)) {
                return null;
            }
            SubtitleSearchResult hashMatch = searchResults.stream().filter(result -> result.getScore() == 1.0f && StringUtils.isNotBlank((CharSequence)result.getUrl())).findFirst().orElse(null);
            if (hashMatch != null || !MovieSubtitleSearchAndDownloadTask.this.forceBestMatch) {
                return hashMatch;
            }
            List filteredResults = searchResults.stream().filter(result -> {
                if (this.movie.isStacked() && result.getStackCount() > 1) {
                    return true;
                }
                return !this.movie.isStacked() && result.getStackCount() == 1;
            }).collect(Collectors.toList());
            if (filteredResults.isEmpty()) {
                return null;
            }
            if (StringUtils.isNotBlank((CharSequence)this.movie.getOriginalFilename())) {
                String basename = FilenameUtils.getBaseName((String)this.movie.getOriginalFilename());
                for (SubtitleSearchResult result2 : filteredResults) {
                    float score = MetadataUtil.calculateScore(result2.getReleaseName(), basename);
                    if (!(score > 0.8f)) continue;
                    return result2;
                }
            }
            return (SubtitleSearchResult)filteredResults.get(0);
        }
    }
}

