/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tasks;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.EmptyFileException;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.threading.TmmThreadPool;

public class ImageCacheTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageCacheTask.class);
    private final Collection<MediaFile> filesToCache = new ArrayList<MediaFile>();

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    public ImageCacheTask(Collection<MediaFile> files) {
        super(TmmResourceBundle.getString("tmm.rebuildimagecache"));
        this.filesToCache.addAll(files);
    }

    @Override
    protected void doInBackground() {
        if (!Settings.getInstance().isImageCache()) {
            return;
        }
        int threadCount = Runtime.getRuntime().availableProcessors() - 1;
        if (threadCount < 2) {
            threadCount = 2;
        }
        this.initThreadPool(threadCount, "imageCache");
        for (MediaFile fileToCache : this.filesToCache) {
            if (this.cancel) {
                return;
            }
            this.submitTask(new CacheTask(fileToCache));
        }
        this.waitForCompletionOrCancel();
    }

    private static class CacheTask
    implements Callable<Object> {
        private final MediaFile fileToCache;

        CacheTask(MediaFile fileToCache) {
            this.fileToCache = fileToCache;
        }

        @Override
        public Object call() {
            try {
                Thread.sleep(50L);
                ImageCache.cacheImage(this.fileToCache);
            }
            catch (EmptyFileException e) {
                LOGGER.debug("failed to cache file (file is empty): {}", (Object)this.fileToCache);
            }
            catch (FileNotFoundException e) {
            }
            catch (Exception e) {
                LOGGER.warn("failed to cache file: {} - {}", (Object)this.fileToCache.getFile(), (Object)e.getMessage());
            }
            return null;
        }
    }
}

