/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tasks;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.threading.TmmTaskManager;

public class MediaFileInformationFetcherTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaFileInformationFetcherTask.class);
    protected final MediaFile mediaFile;
    protected final MediaEntity mediaEntity;
    private final long uniqueId;
    private final boolean forceUpdate;

    public MediaFileInformationFetcherTask(MediaFile mediaFile, MediaEntity mediaEntity, boolean forceUpdate) {
        this.mediaFile = mediaFile;
        this.mediaEntity = mediaEntity;
        this.forceUpdate = forceUpdate;
        this.uniqueId = TmmTaskManager.getInstance().GLOB_THRD_CNT.incrementAndGet();
    }

    @Override
    public void run() {
        try {
            Path xmlFile;
            MediaFile mainVideoFile;
            Object name = Thread.currentThread().getName();
            if (!((String)name).contains("-G")) {
                name = (String)name + "-G0";
            }
            name = ((String)name).replaceAll("\\-G\\d+", "-G" + this.uniqueId);
            Thread.currentThread().setName((String)name);
            this.mediaFile.gatherMediaInformation(this.forceUpdate);
            if ((this.mediaFile.getType() == MediaFileType.SUBTITLE || this.mediaFile.getType() == MediaFileType.AUDIO) && StringUtils.isNotBlank((CharSequence)(mainVideoFile = this.mediaEntity.getMainFile()).getBasename()) && this.mediaFile.getFilename().startsWith(mainVideoFile.getBasename())) {
                MediaFileHelper.gatherLanguageInformation(this.mediaFile, mainVideoFile.getBasename());
            }
            if (this.mediaFile.hasSubtitles()) {
                this.mediaEntity.firePropertyChange("hasSubtitles", false, true);
            }
            if (Settings.getInstance().isWriteMediaInfoXml() && Files.exists(xmlFile = Paths.get(this.mediaFile.getPath(), FilenameUtils.getBaseName((String)this.mediaFile.getFilename()) + "-mediainfo.xml"), new LinkOption[0])) {
                this.mediaEntity.addToMediaFiles(new MediaFile(xmlFile));
            }
        }
        catch (Exception e) {
            LOGGER.error("Thread crashed: ", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"MediaInformation", "message.mediainfo.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
        }
        if (this.mediaEntity != null) {
            this.mediaEntity.callbackForGatheredMediainformation(this.mediaFile);
            this.mediaEntity.saveToDb();
            this.mediaEntity.firePropertyChange("mediaInformation", false, true);
        }
        this.callbackForGatheredMediainformation();
    }

    public void callbackForGatheredMediainformation() {
    }
}

