/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.threading;

import java.util.LinkedList;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskListener;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;

public class TmmTaskChain
implements TmmTaskListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmmTaskChain.class);
    private final Queue<TmmTask> tasks = new LinkedList<TmmTask>();

    public TmmTaskChain add(TmmTask task) {
        task.addListener(this);
        this.tasks.add(task);
        return this;
    }

    public void run() {
        this.startNextTask();
    }

    @Override
    public void processTaskEvent(TmmTaskHandle task) {
        switch (task.getState()) {
            case CANCELLED: 
            case FAILED: {
                LOGGER.debug("Task '{}' {} - continue with next", (Object)task.getClass().getName(), (Object)task.getState());
                this.startNextTask();
                break;
            }
            case FINISHED: {
                this.startNextTask();
                break;
            }
        }
    }

    private void startNextTask() {
        TmmTask nextTask = this.tasks.poll();
        if (nextTask != null) {
            if (nextTask instanceof TmmThreadPool) {
                TmmTaskManager.getInstance().addMainTask((TmmThreadPool)nextTask);
            } else {
                TmmTaskManager.getInstance().addUnnamedTask(nextTask);
            }
        }
    }
}

