/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.ParserUtils;

public class TvShowEpisodeAndSeasonParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowEpisodeAndSeasonParser.class);
    private static final Pattern date1 = Pattern.compile("([0-9]{4})[.-]([0-9]{2})[.-]([0-9]{2})", 2);
    private static final Pattern date2 = Pattern.compile("([0-9]{2})[.-]([0-9]{2})[.-]([0-9]{4})", 2);
    public static final Pattern SEASON_LONG = Pattern.compile("(staffel|season|saison|series|temporada)[\\s_.-]?(\\d{1,4})", 2);
    public static final Pattern SEASON_ONLY = Pattern.compile("[\\s_.-]s[\\s_.-]?(\\d{1,4})", 2);
    public static final Pattern EPISODE_ONLY = Pattern.compile("[\\s_.-]ep?[\\s_.-]?(\\d{1,4})", 2);
    private static final Pattern episodePattern = Pattern.compile("[epx_-]+(\\d{1,4})", 2);
    private static final Pattern episodePattern2 = Pattern.compile("(?:episode|ep)[\\. _-]*(\\d{1,4})", 2);
    private static final Pattern romanPattern = Pattern.compile("(part|pt)[\\._\\s]+([MDCLXVI]+)", 2);
    private static final Pattern seasonMultiEP = Pattern.compile("s(\\d{1,4})[ ]?((?:([epx_.-]+\\d{1,4})+))", 2);
    private static final Pattern seasonMultiEP2 = Pattern.compile("(\\d{1,4})(?=x)((?:([epx]+\\d{1,4})+))", 2);
    private static final Pattern numbers2Pattern = Pattern.compile("([0-9]{2})", 2);
    private static final Pattern numbers3Pattern = Pattern.compile("([0-9])([0-9]{2})", 2);

    private TvShowEpisodeAndSeasonParser() {
        throw new IllegalAccessError();
    }

    public static String cleanEpisodeTitle(String titleToClean, String tvShowName) {
        Object basename = ParserUtils.removeStopwordsAndBadwordsFromTvEpisodeName(titleToClean.replaceAll("([\":<>|?*])", ""));
        basename = Utils.cleanFolderStackingMarkers((String)basename);
        Pattern regex = Pattern.compile("(.*[\\/\\\\])");
        Matcher m = regex.matcher((CharSequence)basename);
        if (m.find()) {
            basename = ((String)basename).replaceAll(regex.pattern(), "");
        }
        basename = (String)basename + " ";
        if (tvShowName != null && !tvShowName.isEmpty()) {
            basename = ((String)basename).replaceAll("(?i)^" + Pattern.quote(tvShowName), "");
        }
        basename = ((String)basename).replaceFirst("\\.\\w{1,4}$", "");
        basename = ((String)basename).replaceFirst("[\\(\\[]\\d{4}[\\)\\]]", "");
        basename = ((String)basename).replaceFirst("[\\(\\[][A-Fa-f0-9]{8}[\\)\\]]", "");
        return TvShowEpisodeAndSeasonParser.removeEpisodeVariantsFromTitle((String)basename);
    }

    private static String removeEpisodeVariantsFromTitle(String title) {
        String[] splitted;
        StringBuilder backup = new StringBuilder(title);
        StringBuilder ret = new StringBuilder();
        title = title.replaceAll("[Ss]([0-9]+)[\\]\\[ _.-]*[Ee]([0-9]+)", "");
        title = title.replaceAll("[ _.-]()[Ee][Pp]?_?([0-9]+)", "");
        title = title.replaceAll("([0-9]{4})[.-]([0-9]{2})[.-]([0-9]{2})", "");
        title = title.replaceAll("([0-9]{2})[.-]([0-9]{2})[.-]([0-9]{4})", "");
        title = title.replaceAll("[\\\\/\\._ \\[\\(-]([0-9]+)x([0-9]+)", "");
        title = title.replaceAll("[\\/ _.-]p(?:ar)?t[ _.-]()([ivx]+)", "");
        title = title.replaceAll("[epx_-]+(\\d{1,3})", "");
        title = title.replaceAll("episode[\\. _-]*(\\d{1,3})", "");
        title = title.replaceAll("(part|pt)[\\._\\s]+([MDCLXVI]+)", "");
        title = title.replaceAll("(staffel|season|saison|series|temporada)[\\s_.-]*(\\d{1,4})", "");
        title = title.replaceAll("s(\\d{1,4})[ ]?((?:([epx_.-]+\\d{1,3})+))", "");
        title = title.replaceAll("(\\d{1,4})(?=x)((?:([epx]+\\d{1,3})+))", "");
        for (String s : splitted = StringUtils.split((String)title, (String)"[\\[\\]() _,.-]")) {
            if (MediaIdUtil.isValidImdbId(s)) {
                s = "";
            }
            ret.append(" ").append(s);
        }
        if (StringUtils.isEmpty((CharSequence)(ret = new StringBuilder(ret.toString().trim())).toString())) {
            String[] b = StringUtils.split((String)backup.toString(), (String)"[\\[\\]() _,.-]");
            backup = new StringBuilder();
            for (String s : b) {
                backup.append(" ").append(s);
            }
            ret = new StringBuilder(backup.toString().trim());
        }
        return ret.toString();
    }

    public static EpisodeMatchingResult detectEpisodeFromFilenameAlternative(String name, String showname) {
        EpisodeMatchingResult result = TvShowEpisodeAndSeasonParser.detect(FilenameUtils.getName((String)name), showname);
        if (!result.episodes.isEmpty() && result.season == -1) {
            EpisodeMatchingResult result2 = TvShowEpisodeAndSeasonParser.detect(name, showname);
            result.season = result2.season;
        } else if (result.season == -1 && result.episodes.isEmpty()) {
            result = TvShowEpisodeAndSeasonParser.detect(name, showname);
        }
        return result;
    }

    private static EpisodeMatchingResult detect(String name, String showname) {
        int i;
        LOGGER.debug("parsing '{}'", (Object)name);
        EpisodeMatchingResult result = new EpisodeMatchingResult();
        String filename = FilenameUtils.getName((String)name);
        if (filename.toLowerCase(Locale.ROOT).matches("(video_ts|vts_\\d\\d_\\d)\\.(vob|bup|ifo)") || filename.toLowerCase(Locale.ROOT).matches("(index\\.bdmv|movieobject\\.bdmv|\\d{5}\\.m2ts)")) {
            name = FilenameUtils.getPath((String)name);
        }
        Object basename = ParserUtils.removeStopwordsAndBadwordsFromTvEpisodeName(name);
        Object foldername = "";
        Pattern regex = Pattern.compile("(.*[\\/\\\\])");
        Matcher m = regex.matcher((CharSequence)basename);
        if (m.find()) {
            foldername = m.group(1);
            basename = ((String)basename).replaceAll(regex.pattern(), "");
        }
        if (((String)basename).isEmpty() && ((String)foldername).isEmpty()) {
            return result;
        }
        basename = ((String)basename).replaceFirst("\\.\\w{1,4}$", "");
        basename = ((String)basename).replaceFirst("[\\(\\[]\\d{4}[\\)\\]]", "");
        basename = ((String)basename).replaceFirst("[\\(\\[][A-Fa-f0-9]{8}[\\)\\]]", "");
        basename = " " + (String)basename + " ";
        foldername = " " + (String)foldername + " ";
        result.stackingMarkerFound = !Utils.getStackingMarker(filename).isEmpty();
        result.name = ((String)basename).trim();
        result = TvShowEpisodeAndSeasonParser.parseSeasonLong(result, (String)basename + (String)foldername);
        if (result.season != -1) {
            basename = ((String)basename).replaceAll("(?i)" + SEASON_LONG.toString(), "");
            foldername = ((String)foldername).replaceAll("(?i)" + SEASON_LONG.toString(), "");
        }
        result = TvShowEpisodeAndSeasonParser.parseSeasonMultiEP(result, (String)basename + (String)foldername);
        result = TvShowEpisodeAndSeasonParser.parseSeasonMultiEP2(result, (String)basename + (String)foldername);
        result = TvShowEpisodeAndSeasonParser.parseEpisodePattern(result, (String)basename);
        if (!result.episodes.isEmpty()) {
            return TvShowEpisodeAndSeasonParser.postClean(result);
        }
        if (showname != null && !showname.isEmpty()) {
            basename = ((String)basename).replaceAll("(?i)[^ES]" + Pattern.quote(showname), "");
            foldername = ((String)foldername).replaceAll("(?i)[^ES]" + Pattern.quote(showname), "");
            try {
                showname = showname.replaceAll("[ _.-]", "[ _.-]");
                foldername = ((String)foldername).replaceAll("(?i)" + showname, "");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        result = TvShowEpisodeAndSeasonParser.parseRoman(result, (String)basename);
        if (!result.episodes.isEmpty()) {
            return TvShowEpisodeAndSeasonParser.postClean(result);
        }
        result = TvShowEpisodeAndSeasonParser.parseDatePattern(result, (String)basename);
        if (result.date != null) {
            return TvShowEpisodeAndSeasonParser.postClean(result);
        }
        MediaFile mf = new MediaFile();
        mf.setFilename(filename);
        if (mf.isDiscFile()) {
            return TvShowEpisodeAndSeasonParser.postClean(result);
        }
        if (result.season == -1) {
            result = TvShowEpisodeAndSeasonParser.parseSeasonOnly(result, (String)foldername);
            if (result.season != -1) {
                foldername = ((String)foldername).replaceAll("(?i)" + SEASON_ONLY.toString(), "");
            }
        }
        if (result.episodes.isEmpty()) {
            result = TvShowEpisodeAndSeasonParser.parseEpisodeOnly(result, (String)basename);
        }
        if (!result.episodes.isEmpty()) {
            return TvShowEpisodeAndSeasonParser.postClean(result);
        }
        ArrayList<String> numbersOnly = new ArrayList<String>();
        String optionals = "[\\[\\{](.*?)[\\]\\}]";
        String woOptionals = ((String)basename).replaceAll(optionals, "");
        numbersOnly.addAll(Arrays.asList(woOptionals.split("[\\s\\|_.-]")));
        for (i = numbersOnly.size() - 1; i >= 0; --i) {
            if (!((String)numbersOnly.get(i)).isEmpty() && !((String)numbersOnly.get(i)).matches(".*?\\D.*?")) continue;
            numbersOnly.remove(i);
        }
        if (numbersOnly.size() == 0) {
            regex = Pattern.compile(optionals);
            m = regex.matcher((CharSequence)basename);
            while (m.find()) {
                String delimitedNumbers = " " + m.group(1) + " ";
                numbersOnly.addAll(Arrays.asList(delimitedNumbers.split("[\\s\\|_.-]")));
            }
        }
        for (i = numbersOnly.size() - 1; i >= 0; --i) {
            if (!((String)numbersOnly.get(i)).isEmpty() && !((String)numbersOnly.get(i)).matches(".*?\\D.*?")) continue;
            numbersOnly.remove(i);
        }
        Collections.reverse(numbersOnly);
        result = TvShowEpisodeAndSeasonParser.parseNumbers4(result, numbersOnly);
        if (!result.episodes.isEmpty()) {
            return TvShowEpisodeAndSeasonParser.postClean(result);
        }
        result = TvShowEpisodeAndSeasonParser.parseNumbers3(result, numbersOnly);
        if (!result.episodes.isEmpty()) {
            return TvShowEpisodeAndSeasonParser.postClean(result);
        }
        result = TvShowEpisodeAndSeasonParser.parseNumbers2(result, numbersOnly);
        if (!result.episodes.isEmpty()) {
            return TvShowEpisodeAndSeasonParser.postClean(result);
        }
        result = TvShowEpisodeAndSeasonParser.parseNumbers1(result, numbersOnly);
        return TvShowEpisodeAndSeasonParser.postClean(result);
    }

    private static EpisodeMatchingResult parseNumbers1(EpisodeMatchingResult result, List<String> numbersOnly) {
        for (String num : numbersOnly) {
            if (num.length() != 1) continue;
            int ep = Integer.parseInt(num);
            if (ep > 0 && !result.episodes.contains(ep)) {
                result.episodes.add(ep);
                LOGGER.trace("add found EP '{}'", (Object)ep);
            }
            return result;
        }
        return result;
    }

    private static EpisodeMatchingResult parseNumbers2(EpisodeMatchingResult result, List<String> numbersOnly) {
        for (String num : numbersOnly) {
            if (num.length() != 2) continue;
            int ep = Integer.parseInt(num);
            if (ep > 0 && !result.episodes.contains(ep)) {
                result.episodes.add(ep);
                LOGGER.trace("add found EP '{}'", (Object)ep);
            }
            return result;
        }
        return result;
    }

    private static EpisodeMatchingResult parseNumbers3(EpisodeMatchingResult result, List<String> numbersOnly) {
        for (String num : numbersOnly) {
            if (num.length() != 3) continue;
            int s = Integer.parseInt(num.substring(0, 1));
            int ep = Integer.parseInt(num.substring(1));
            if (result.season != -1 && result.season != s) continue;
            if (ep > 0 && !result.episodes.contains(ep)) {
                result.episodes.add(ep);
                LOGGER.trace("add found EP '{}'", (Object)ep);
            }
            LOGGER.trace("add found season '{}'", (Object)s);
            result.season = s;
        }
        return result;
    }

    private static EpisodeMatchingResult parseNumbers4(EpisodeMatchingResult result, List<String> numbersOnly) {
        for (String num : numbersOnly) {
            if (num.length() != 4) continue;
            int s = Integer.parseInt(num.substring(0, 2));
            int ep = Integer.parseInt(num.substring(2));
            if (result.season != s || ep <= 0 || result.episodes.contains(ep)) continue;
            result.episodes.add(ep);
            LOGGER.trace("add found EP '{}'", (Object)ep);
        }
        return result;
    }

    private static EpisodeMatchingResult parseDatePattern(EpisodeMatchingResult result, String name) {
        Matcher m;
        if (result.season == -1 && (m = date1.matcher(name)).find()) {
            int s = result.season;
            try {
                s = Integer.parseInt(m.group(1));
                result.date = new SimpleDateFormat("yyyy-MM-dd").parse(m.group(1) + "-" + m.group(2) + "-" + m.group(3));
            }
            catch (NumberFormatException | ParseException exception) {
                // empty catch block
            }
            result.season = s;
            LOGGER.trace("add found year as season '{}', date: '{}'", (Object)s, (Object)result.date);
            return result;
        }
        if (result.season == -1 && (m = date2.matcher(name)).find()) {
            int s = result.season;
            try {
                s = Integer.parseInt(m.group(3));
                result.date = new SimpleDateFormat("dd-MM-yyyy").parse(m.group(1) + "-" + m.group(2) + "-" + m.group(3));
            }
            catch (NumberFormatException | ParseException exception) {
                // empty catch block
            }
            result.season = s;
            LOGGER.trace("add found year as season '{}', date: '{}'", (Object)s, (Object)result.date);
            return result;
        }
        return result;
    }

    private static EpisodeMatchingResult parseRoman(EpisodeMatchingResult result, String name) {
        if (result.episodes.isEmpty()) {
            Pattern regex = romanPattern;
            Matcher m = regex.matcher(name);
            while (m.find()) {
                int ep = 0;
                ep = TvShowEpisodeAndSeasonParser.decodeRoman(m.group(2));
                if (ep <= 0 || result.episodes.contains(ep)) continue;
                result.episodes.add(ep);
                LOGGER.trace("add found EP '{}'", (Object)ep);
            }
        }
        return result;
    }

    private static EpisodeMatchingResult parseEpisodePattern(EpisodeMatchingResult result, String name) {
        if (result.episodes.isEmpty()) {
            Pattern regex = episodePattern2;
            Matcher m = regex.matcher(name);
            while (m.find()) {
                int ep = 0;
                try {
                    ep = Integer.parseInt(m.group(1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (ep <= 0 || result.episodes.contains(ep)) continue;
                result.episodes.add(ep);
                LOGGER.trace("add found EP '{}'", (Object)ep);
            }
        }
        return result;
    }

    private static EpisodeMatchingResult parseSeasonMultiEP2(EpisodeMatchingResult result, String name) {
        Pattern regex = seasonMultiEP2;
        Matcher m = regex.matcher(name);
        while (m.find()) {
            int s = -1;
            try {
                if (m.group(2) != null && result.season == -1) {
                    s = Integer.parseInt(m.group(1));
                }
                String eps = m.group(2);
                Pattern regex2 = episodePattern;
                Matcher m2 = regex2.matcher(eps);
                while (m2.find()) {
                    int ep = 0;
                    try {
                        ep = Integer.parseInt(m2.group(1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (ep <= 0 || result.episodes.contains(ep)) continue;
                    result.episodes.add(ep);
                    LOGGER.trace("add found EP '{}'", (Object)ep);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (s < 0) continue;
            result.season = s;
            LOGGER.trace("add found season '{}'", (Object)s);
        }
        return result;
    }

    private static EpisodeMatchingResult parseSeasonMultiEP(EpisodeMatchingResult result, String name) {
        Pattern regex = seasonMultiEP;
        Matcher m = regex.matcher(name);
        int lastFoundEpisode = 0;
        while (m.find()) {
            int s = -1;
            try {
                s = Integer.parseInt(m.group(1));
                String eps = m.group(2);
                Pattern regex2 = episodePattern;
                Matcher m2 = regex2.matcher(eps);
                while (m2.find()) {
                    int ep = -1;
                    try {
                        ep = Integer.parseInt(m2.group(1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (ep <= -1 || result.episodes.contains(ep) || lastFoundEpisode != 0 && lastFoundEpisode + 1 != ep) continue;
                    lastFoundEpisode = ep;
                    result.episodes.add(ep);
                    LOGGER.trace("add found EP '{}'", (Object)ep);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (s < 0) continue;
            result.season = s;
            LOGGER.trace("add found season '{}", (Object)s);
        }
        return result;
    }

    private static EpisodeMatchingResult parseEpisodeOnly(EpisodeMatchingResult result, String name) {
        Matcher m = EPISODE_ONLY.matcher(name);
        if (m.find()) {
            try {
                int e = Integer.parseInt(m.group(1));
                result.episodes.add(e);
                LOGGER.trace("add found episode '{}'", (Object)e);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    private static EpisodeMatchingResult parseSeasonLong(EpisodeMatchingResult result, String name) {
        Matcher m;
        if (result.season == -1 && (m = SEASON_LONG.matcher(name)).find()) {
            int s = result.season;
            try {
                s = Integer.parseInt(m.group(2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            result.season = s;
            LOGGER.trace("add found season '{}'", (Object)s);
        }
        return result;
    }

    private static EpisodeMatchingResult parseSeasonOnly(EpisodeMatchingResult result, String name) {
        Matcher m;
        if (result.season == -1 && (m = SEASON_ONLY.matcher(name)).find()) {
            int s = result.season;
            try {
                s = Integer.parseInt(m.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            result.season = s;
            LOGGER.trace("add found season '{}'", (Object)s);
        }
        return result;
    }

    private static EpisodeMatchingResult postClean(EpisodeMatchingResult emr) {
        emr.cleanedName = TvShowEpisodeAndSeasonParser.cleanFilename(emr.name, new Pattern[]{SEASON_LONG, seasonMultiEP, seasonMultiEP2, episodePattern, episodePattern2, numbers3Pattern, numbers2Pattern, romanPattern, date1, date2, SEASON_ONLY});
        Collections.sort(emr.episodes);
        LOGGER.trace("returning result '{}'", (Object)emr);
        return emr;
    }

    private static String cleanFilename(String name, Pattern[] patterns) {
        String result = name;
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(result);
            if (!matcher.find()) continue;
            result = matcher.replaceFirst("");
        }
        result = result.replaceAll("^[ \\.\\-_]+", "");
        result = result.replaceAll("[ \\.\\-_]+$", "");
        return result;
    }

    private static int decodeSingleRoman(char letter) {
        switch (letter) {
            case 'M': {
                return 1000;
            }
            case 'D': {
                return 500;
            }
            case 'C': {
                return 100;
            }
            case 'L': {
                return 50;
            }
            case 'X': {
                return 10;
            }
            case 'V': {
                return 5;
            }
            case 'I': {
                return 1;
            }
        }
        return 0;
    }

    public static int decodeRoman(String roman) {
        int result = 0;
        String uRoman = roman.toUpperCase(Locale.ROOT);
        for (int i = 0; i < uRoman.length() - 1; ++i) {
            if (TvShowEpisodeAndSeasonParser.decodeSingleRoman(uRoman.charAt(i)) < TvShowEpisodeAndSeasonParser.decodeSingleRoman(uRoman.charAt(i + 1))) {
                result -= TvShowEpisodeAndSeasonParser.decodeSingleRoman(uRoman.charAt(i));
                continue;
            }
            result += TvShowEpisodeAndSeasonParser.decodeSingleRoman(uRoman.charAt(i));
        }
        return result += TvShowEpisodeAndSeasonParser.decodeSingleRoman(uRoman.charAt(uRoman.length() - 1));
    }

    public static class EpisodeMatchingResult {
        public int season = -1;
        public List<Integer> episodes = new ArrayList<Integer>();
        public String name = "";
        public String cleanedName = "";
        public Date date = null;
        public boolean stackingMarkerFound = false;

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

