/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import java.util.HashMap;
import java.util.Map;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaType;

public class TvShowEpisodeSearchAndScrapeOptions
extends MediaSearchAndScrapeOptions {
    private final Map<String, Object> tvShowIds = new HashMap<String, Object>();

    public TvShowEpisodeSearchAndScrapeOptions() {
        super(MediaType.TV_EPISODE);
    }

    public TvShowEpisodeSearchAndScrapeOptions(Map<String, Object> tvShowIds) {
        super(MediaType.TV_EPISODE);
        this.setTvShowIds(tvShowIds);
    }

    public TvShowEpisodeSearchAndScrapeOptions(TvShowEpisodeSearchAndScrapeOptions original) {
        super(original);
        this.setTvShowIds(original.tvShowIds);
    }

    @Override
    public void setDataFromOtherOptions(MediaSearchAndScrapeOptions original) {
        super.setDataFromOtherOptions(original);
        if (original instanceof TvShowEpisodeSearchAndScrapeOptions) {
            this.setTvShowIds(((TvShowEpisodeSearchAndScrapeOptions)original).tvShowIds);
        }
        if (original instanceof TvShowSearchAndScrapeOptions) {
            this.setTvShowIds(original.getIds());
        }
    }

    public Map<String, Object> getTvShowIds() {
        return this.tvShowIds;
    }

    public void setTvShowIds(Map<String, Object> tvShowIds) {
        if (this.tvShowIds == null) {
            return;
        }
        this.tvShowIds.clear();
        if (tvShowIds == null) {
            return;
        }
        this.tvShowIds.putAll(tvShowIds);
        this.ids.put("tvShowIds", tvShowIds);
    }

    public TvShowSearchAndScrapeOptions createTvShowSearchAndScrapeOptions() {
        TvShowSearchAndScrapeOptions options = new TvShowSearchAndScrapeOptions();
        options.setDataFromOtherOptions(this);
        options.setIds(this.tvShowIds);
        return options;
    }

    public void loadDefaults() {
        this.language = TvShowModuleManager.getInstance().getSettings().getScraperLanguage();
        this.metadataScraper = TvShowModuleManager.getInstance().getTvShowList().getDefaultMediaScraper();
        this.artworkScrapers.addAll(TvShowModuleManager.getInstance().getTvShowList().getDefaultArtworkScrapers());
        this.trailerScrapers.addAll(TvShowModuleManager.getInstance().getTvShowList().getDefaultTrailerScrapers());
        this.subtitleScrapers.addAll(TvShowModuleManager.getInstance().getTvShowList().getDefaultSubtitleScrapers());
    }
}

