/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.tasks.TrailerDownloadTask;
import org.tinymediamanager.core.tasks.YTDownloadTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowRenamer;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.filenaming.TvShowTrailerNaming;
import org.tinymediamanager.core.tvshow.tasks.TvShowTrailerDownloadTask;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.imdb.ImdbTvShowTrailerProvider;

public class TvShowHelpers {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShow.class);
    private static final Pattern SEASON_NUMBER = Pattern.compile("(?i)season(\\d+).*");
    private static final Pattern SEASON_FOLDER_NUMBER = Pattern.compile("(?i).*(\\d+).*");

    private TvShowHelpers() {
        throw new IllegalAccessError();
    }

    public static MediaCertification parseCertificationStringForTvShowSetupCountry(String name) {
        MediaCertification cert = MediaCertification.UNKNOWN;
        if ((name = name.trim()).contains("/")) {
            String[] cs;
            String[] countries;
            for (String c : countries = name.split("/")) {
                if ((c = c.trim()).contains(":")) {
                    cs = c.split(":");
                    cert = MediaCertification.getCertification(TvShowModuleManager.getInstance().getSettings().getCertificationCountry(), cs[1]);
                    if (cert == MediaCertification.UNKNOWN) continue;
                    return cert;
                }
                cert = MediaCertification.getCertification(TvShowModuleManager.getInstance().getSettings().getCertificationCountry(), c);
                if (cert == MediaCertification.UNKNOWN) continue;
                return cert;
            }
            for (String c : countries) {
                if (!((c = c.trim()).contains(":") ? (cert = MediaCertification.findCertification((cs = c.split(":"))[1])) != MediaCertification.UNKNOWN : (cert = MediaCertification.findCertification(c)) != MediaCertification.UNKNOWN)) continue;
                return cert;
            }
        } else if (name.contains(":")) {
            String[] cs = name.split(":");
            cert = MediaCertification.getCertification(TvShowModuleManager.getInstance().getSettings().getCertificationCountry(), cs[1].trim());
            if (cert == MediaCertification.UNKNOWN) {
                cert = MediaCertification.findCertification(cs[1].trim());
            }
        } else {
            cert = MediaCertification.getCertification(TvShowModuleManager.getInstance().getSettings().getCertificationCountry(), name.trim());
        }
        if (cert == MediaCertification.UNKNOWN) {
            cert = MediaCertification.findCertification(name);
        }
        return cert;
    }

    public static String detectSeasonFolder(TvShow tvShow, int season) {
        ArrayList<String> subPaths = new ArrayList<String>();
        Path tvShowPath = tvShow.getPathNIO();
        List<TvShowEpisode> episodes = tvShow.getEpisodesForSeason(season);
        try {
            for (TvShowEpisode episode : episodes) {
                Path videoFilePath = episode.getMainVideoFile().getFileAsPath().getParent();
                Path relativePath = tvShowPath.relativize(videoFilePath);
                int subfolders = relativePath.getNameCount();
                for (int i = 1; i <= subfolders; ++i) {
                    subPaths.add(relativePath.subpath(0, i).toString());
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("could not extract season folder: {}", (Object)e.getMessage());
        }
        if (subPaths.isEmpty()) {
            return "";
        }
        Map<String, Long> subPathCounts = subPaths.stream().collect(Collectors.groupingBy(s -> s, Collectors.counting()));
        Map.Entry entry = subPathCounts.entrySet().stream().max(Comparator.comparing(Map.Entry::getValue)).get();
        if ((double)((Long)entry.getValue()).longValue() >= 0.8 * (double)episodes.size()) {
            return (String)entry.getKey();
        }
        TvShowEpisode episode = new TvShowEpisode();
        episode.setSeason(season);
        return TvShowRenamer.getSeasonFoldername(tvShow, episode);
    }

    public static void startAutomaticTrailerDownload(TvShow tvShow) {
        if (TvShowModuleManager.getInstance().getSettings().isUseTrailerPreference() && TvShowModuleManager.getInstance().getSettings().isAutomaticTrailerDownload() && tvShow.getMediaFiles(MediaFileType.TRAILER).isEmpty() && !tvShow.getTrailer().isEmpty()) {
            TvShowHelpers.downloadBestTrailer(tvShow);
        }
    }

    public static void downloadBestTrailer(TvShow tvShow) {
        if (!tvShow.getTrailer().isEmpty()) {
            TvShowTrailerDownloadTask task = new TvShowTrailerDownloadTask(tvShow);
            TmmTaskManager.getInstance().addDownloadTask(task);
        }
    }

    public static void downloadTrailer(final TvShow tvshow, MediaTrailer trailer) {
        List<TvShowTrailerNaming> trailernames;
        if (StringUtils.isBlank((CharSequence)trailer.getUrl()) || !trailer.getUrl().startsWith("http")) {
            if (StringUtils.isBlank((CharSequence)trailer.getId())) {
                LOGGER.debug("Could not download trailer: no url/id {}", (Object)trailer);
                return;
            }
            String id = trailer.getId();
            if (!id.matches("vi\\d+")) {
                LOGGER.debug("Could not download trailer: id not known {}", (Object)trailer);
                return;
            }
            ImdbTvShowTrailerProvider tp = new ImdbTvShowTrailerProvider();
            String url = tp.getUrlForId(trailer);
            if (url.isEmpty()) {
                LOGGER.debug("Could not download trailer: could not construct url from id {}", (Object)trailer);
                return;
            }
            trailer.setUrl(url);
        }
        final String filename = !(trailernames = TvShowModuleManager.getInstance().getSettings().getTrailerFilenames()).isEmpty() ? tvshow.getTrailerFilename(trailernames.get(0)) : tvshow.getTrailerFilename(TvShowTrailerNaming.TVSHOW_TRAILER);
        try {
            Matcher matcher = Utils.YOUTUBE_PATTERN.matcher(trailer.getUrl());
            if (matcher.matches()) {
                YTDownloadTask task = new YTDownloadTask(trailer, TvShowModuleManager.getInstance().getSettings().getTrailerQuality()){

                    @Override
                    protected Path getDestinationWoExtension() {
                        return tvshow.getPathNIO().resolve(filename);
                    }

                    @Override
                    protected MediaEntity getMediaEntityToAdd() {
                        return tvshow;
                    }
                };
                TmmTaskManager.getInstance().addDownloadTask(task);
            } else {
                TrailerDownloadTask task = new TrailerDownloadTask(trailer){

                    @Override
                    protected Path getDestinationWoExtension() {
                        return tvshow.getPathNIO().resolve(filename);
                    }

                    @Override
                    protected MediaEntity getMediaEntityToAdd() {
                        return tvshow;
                    }
                };
                TmmTaskManager.getInstance().addDownloadTask(task);
            }
        }
        catch (Exception e) {
            LOGGER.error("could not start trailer download: {}", (Object)e.getMessage());
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)tvshow, "message.scrape.trailerfailed", new String[]{":", e.getLocalizedMessage()}));
        }
    }

    public static int detectSeasonFromFileAndFolder(String filename, String foldername) {
        int season = Integer.MIN_VALUE;
        if (filename.startsWith("season-specials") || foldername.equalsIgnoreCase("specials")) {
            season = 0;
        } else if (filename.startsWith("season-all")) {
            season = -1;
        } else {
            Matcher matcher = SEASON_NUMBER.matcher(filename);
            if (matcher.matches()) {
                season = Integer.parseInt(matcher.group(1));
            }
            if (season == Integer.MIN_VALUE && (matcher = SEASON_NUMBER.matcher(foldername)).matches()) {
                season = Integer.parseInt(matcher.group(1));
            }
            if (season == Integer.MIN_VALUE && (matcher = SEASON_FOLDER_NUMBER.matcher(foldername)).matches()) {
                season = Integer.parseInt(matcher.group(1));
            }
        }
        if (season == Integer.MAX_VALUE) {
            season = Integer.MIN_VALUE;
        }
        return season;
    }
}

