/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import com.fasterxml.jackson.databind.ObjectReader;
import java.beans.PropertyChangeListener;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.h2.mvstore.MVMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.tasks.ImageCacheTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowEpisodeAndSeasonParser;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.license.License;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;

public final class TvShowList
extends AbstractModelObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowList.class);
    private static TvShowList instance = null;
    private final List<TvShow> tvShows;
    private final CopyOnWriteArrayList<String> tagsInTvShows;
    private final CopyOnWriteArrayList<String> tagsInEpisodes;
    private final CopyOnWriteArrayList<String> videoCodecsInEpisodes;
    private final CopyOnWriteArrayList<String> videoContainersInEpisodes;
    private final CopyOnWriteArrayList<String> audioCodecsInEpisodes;
    private final CopyOnWriteArrayList<Integer> audioChannelsInEpisodes;
    private final CopyOnWriteArrayList<Double> frameRatesInEpisodes;
    private final CopyOnWriteArrayList<MediaCertification> certificationsInTvShows;
    private final CopyOnWriteArrayList<Integer> audioStreamsInEpisodes;
    private final CopyOnWriteArrayList<String> audioLanguagesInEpisodes;
    private final CopyOnWriteArrayList<Integer> subtitlesInEpisodes;
    private final CopyOnWriteArrayList<String> subtitleLanguagesInEpisodes;
    private final CopyOnWriteArrayList<String> hdrFormatInEpisodes;
    private final CopyOnWriteArrayList<String> audioTitlesInEpisodes;
    private final PropertyChangeListener propertyChangeListener;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    private TvShowList() {
        this.tvShows = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(TvShow.class));
        this.tagsInTvShows = new CopyOnWriteArrayList();
        this.tagsInEpisodes = new CopyOnWriteArrayList();
        this.videoCodecsInEpisodes = new CopyOnWriteArrayList();
        this.videoContainersInEpisodes = new CopyOnWriteArrayList();
        this.audioCodecsInEpisodes = new CopyOnWriteArrayList();
        this.audioChannelsInEpisodes = new CopyOnWriteArrayList();
        this.frameRatesInEpisodes = new CopyOnWriteArrayList();
        this.certificationsInTvShows = new CopyOnWriteArrayList();
        this.audioStreamsInEpisodes = new CopyOnWriteArrayList();
        this.audioLanguagesInEpisodes = new CopyOnWriteArrayList();
        this.subtitlesInEpisodes = new CopyOnWriteArrayList();
        this.subtitleLanguagesInEpisodes = new CopyOnWriteArrayList();
        this.hdrFormatInEpisodes = new CopyOnWriteArrayList();
        this.audioTitlesInEpisodes = new CopyOnWriteArrayList();
        this.propertyChangeListener = evt -> {
            TvShowEpisode episode;
            if ("tags".equals(evt.getPropertyName()) && evt.getSource() instanceof TvShow) {
                TvShow tvShow = (TvShow)evt.getSource();
                this.updateTvShowTags(Collections.singleton(tvShow));
            }
            if ("tags".equals(evt.getPropertyName()) && evt.getSource() instanceof TvShowEpisode) {
                episode = (TvShowEpisode)evt.getSource();
                this.updateEpisodeTags(Collections.singleton(episode));
            }
            if (("mediaFiles".equals(evt.getPropertyName()) || "mediaInformation".equals(evt.getPropertyName())) && evt.getSource() instanceof TvShowEpisode) {
                episode = (TvShowEpisode)evt.getSource();
                this.updateMediaInformationLists(Collections.singleton(episode));
            }
            if ("episodeCount".equals(evt.getPropertyName())) {
                this.firePropertyChange("episodeCount", evt.getOldValue(), evt.getNewValue());
            }
        };
        License.getInstance().addEventListener(() -> {
            this.firePropertyChange("tvShowCount", 0, this.tvShows.size());
            this.firePropertyChange("episodeCount", 0, 1);
        });
    }

    static synchronized TvShowList getInstance() {
        if (instance == null) {
            instance = new TvShowList();
        }
        return instance;
    }

    static void clearInstance() {
        instance = null;
    }

    public List<TvShow> getTvShows() {
        return this.tvShows;
    }

    public List<TvShowEpisode> getEpisodes() {
        ArrayList<TvShowEpisode> newEp = new ArrayList<TvShowEpisode>();
        for (TvShow show : this.tvShows) {
            newEp.addAll(show.getEpisodes());
        }
        return newEp;
    }

    public void debugListDuplicateEpisode() {
        int cnt = 0;
        for (TvShow show : this.tvShows) {
            List<int[]> dupes = show.getDuplicateEpisodes();
            cnt += dupes.size();
            if (dupes.isEmpty()) continue;
            System.out.println("---------------------");
            System.out.println("Dupes found! - " + show.getTitle());
            for (int[] se : dupes) {
                List<TvShowEpisode> eps = show.getEpisode(se[0], se[1]);
                for (TvShowEpisode ep : eps) {
                    System.out.println(Arrays.toString(se) + (String)(eps.size() > 2 ? " MULTI" + eps.size() : "") + " - " + Utils.relPath(show.getPathNIO(), ep.getMainFile().getFileAsPath()));
                }
            }
        }
        System.out.println("Found " + cnt + " episodes with same number!");
    }

    public void debugFindWronglyMatchedEpisodes() {
        for (TvShow show : this.tvShows) {
            boolean first = true;
            for (TvShowEpisode ep : show.getEpisodes()) {
                MediaFile mf = ep.getMainFile();
                String rel = show.getPathNIO().relativize(mf.getFileAsPath()).toString();
                TvShowEpisodeAndSeasonParser.EpisodeMatchingResult result = TvShowEpisodeAndSeasonParser.detectEpisodeFromFilenameAlternative(rel, show.getTitle());
                if (result.episodes.contains(ep.getEpisode()) && result.season == ep.getSeason()) continue;
                if (first) {
                    System.out.println("---------------------");
                    System.out.println("Episode matching found some differences! - " + show.getTitle());
                    first = false;
                }
                System.out.println("S:" + ep.getSeason() + " E:" + ep.getEpisode() + " - " + rel + "   now detected as S:" + result.season + " E:" + result.episodes);
            }
        }
    }

    public List<MediaScraper> getTrailerScrapers(List<String> providerIds) {
        ArrayList<MediaScraper> trailerScrapers = new ArrayList<MediaScraper>();
        for (String providerId : providerIds) {
            MediaScraper trailerScraper;
            if (StringUtils.isBlank((CharSequence)providerId) || (trailerScraper = MediaScraper.getMediaScraperById(providerId, ScraperType.TVSHOW_TRAILER)) == null) continue;
            trailerScrapers.add(trailerScraper);
        }
        return trailerScrapers;
    }

    public List<MediaScraper> getAvailableTrailerScrapers() {
        return MediaScraper.getMediaScrapers(ScraperType.TVSHOW_TRAILER);
    }

    public List<TvShow> getUnscrapedTvShows() {
        return this.tvShows.parallelStream().filter(tvShow -> !tvShow.isScraped()).collect(Collectors.toList());
    }

    public void addTvShow(TvShow newValue) {
        this.readWriteLock.writeLock().lock();
        int oldValue = this.tvShows.size();
        this.tvShows.add(newValue);
        this.readWriteLock.writeLock().unlock();
        newValue.addPropertyChangeListener(this.propertyChangeListener);
        this.firePropertyChange("tvShows", null, this.tvShows);
        this.firePropertyChange("addedTvShow", null, newValue);
        this.firePropertyChange("tvShowCount", oldValue, this.tvShows.size());
    }

    public void removeDatasource(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return;
        }
        for (int i = this.tvShows.size() - 1; i >= 0; --i) {
            TvShow tvShow = this.tvShows.get(i);
            if (!Paths.get(path, new String[0]).equals(Paths.get(tvShow.getDataSource(), new String[0]))) continue;
            this.removeTvShow(tvShow);
        }
    }

    void exchangeDatasource(String oldDatasource, String newDatasource) {
        Path oldPath = Paths.get(oldDatasource, new String[0]);
        List tvShowsToChange = this.tvShows.stream().filter(tvShow -> oldPath.equals(Paths.get(tvShow.getDataSource(), new String[0]))).collect(Collectors.toList());
        ArrayList<MediaFile> imagesToCache = new ArrayList<MediaFile>();
        for (TvShow tvShow2 : tvShowsToChange) {
            Path newTvShowPath;
            Path oldTvShowPath = tvShow2.getPathNIO();
            try {
                newTvShowPath = Paths.get(newDatasource, Paths.get(tvShow2.getDataSource(), new String[0]).relativize(oldTvShowPath).toString());
            }
            catch (Exception e) {
                newTvShowPath = Paths.get(newDatasource, FilenameUtils.separatorsToSystem((String)tvShow2.getPath().replace(tvShow2.getDataSource(), "")));
            }
            tvShow2.setDataSource(newDatasource);
            tvShow2.setPath(newTvShowPath.toAbsolutePath().toString());
            tvShow2.updateMediaFilePath(oldTvShowPath, newTvShowPath);
            for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(tvShow2.getEpisodes())) {
                episode.setDataSource(newDatasource);
                episode.replacePathForRenamedFolder(oldTvShowPath, newTvShowPath);
                episode.updateMediaFilePath(oldTvShowPath, newTvShowPath);
                episode.saveToDb();
                imagesToCache.addAll(episode.getImagesToCache());
            }
            tvShow2.saveToDb();
            imagesToCache.addAll(tvShow2.getImagesToCache());
        }
        if (!imagesToCache.isEmpty()) {
            ImageCacheTask task = new ImageCacheTask(imagesToCache);
            TmmTaskManager.getInstance().addUnnamedTask(task);
        }
    }

    public void removeTvShow(TvShow tvShow) {
        this.readWriteLock.writeLock().lock();
        int oldValue = this.tvShows.size();
        this.tvShows.remove(tvShow);
        this.readWriteLock.writeLock().unlock();
        this.firePropertyChange("tvShows", null, this.tvShows);
        this.firePropertyChange("removedTvShow", null, tvShow);
        this.firePropertyChange("tvShowCount", oldValue, this.tvShows.size());
        for (TvShowEpisode episode : tvShow.getEpisodes()) {
            TvShowModuleManager.getInstance().getTvShowList().removeEpisodeFromDb(episode);
            for (MediaFile mf : episode.getMediaFiles()) {
                if (!mf.isGraphic()) continue;
                ImageCache.invalidateCachedImage(mf);
            }
        }
        try {
            TvShowModuleManager.getInstance().removeTvShowFromDb(tvShow);
        }
        catch (Exception e) {
            LOGGER.error("problem removing TV show from DB: {}", (Object)e.getMessage());
        }
        for (MediaFile mf : tvShow.getMediaFiles()) {
            if (!mf.isGraphic()) continue;
            ImageCache.invalidateCachedImage(mf);
        }
    }

    public void deleteTvShow(TvShow tvShow) {
        this.readWriteLock.writeLock().lock();
        int oldValue = this.tvShows.size();
        this.tvShows.remove(tvShow);
        this.readWriteLock.writeLock().unlock();
        tvShow.deleteFilesSafely();
        for (TvShowEpisode episode : tvShow.getEpisodes()) {
            TvShowModuleManager.getInstance().getTvShowList().removeEpisodeFromDb(episode);
            for (MediaFile mf : episode.getMediaFiles()) {
                if (!mf.isGraphic()) continue;
                ImageCache.invalidateCachedImage(mf);
            }
        }
        try {
            TvShowModuleManager.getInstance().removeTvShowFromDb(tvShow);
        }
        catch (Exception e) {
            LOGGER.error("problem removing TV show from DB: {}", (Object)e.getMessage());
        }
        for (MediaFile mf : tvShow.getMediaFiles()) {
            if (!mf.isGraphic()) continue;
            ImageCache.invalidateCachedImage(mf);
        }
        this.firePropertyChange("tvShows", null, this.tvShows);
        this.firePropertyChange("removedTvShow", null, tvShow);
        this.firePropertyChange("tvShowCount", oldValue, this.tvShows.size());
    }

    public int getTvShowCount() {
        return this.tvShows.size();
    }

    public int getEpisodeCount() {
        int count = 0;
        for (TvShow tvShow : this.tvShows) {
            count += tvShow.getEpisodeCount();
        }
        return count;
    }

    public int getDummyEpisodeCount() {
        int count = 0;
        for (TvShow tvShow : this.tvShows) {
            count += tvShow.getDummyEpisodeCount();
        }
        return count;
    }

    public boolean hasDummyEpisodes() {
        for (TvShow tvShow : this.tvShows) {
            if (tvShow.getDummyEpisodeCount() <= 0) continue;
            return true;
        }
        return false;
    }

    public TvShow lookupTvShow(UUID uuid) {
        for (TvShow tvShow : this.tvShows) {
            if (!tvShow.getDbId().equals(uuid)) continue;
            return tvShow;
        }
        return null;
    }

    void loadTvShowsFromDatabase(MVMap<UUID, String> tvShowMap, MVMap<UUID, String> episodesMap) {
        HashSet tvShowsFromDb = new HashSet();
        ObjectReader tvShowObjectReader = TvShowModuleManager.getInstance().getTvShowObjectReader();
        ArrayList toRemove = new ArrayList();
        long start = System.nanoTime();
        new ArrayList<UUID>(tvShowMap.keyList()).forEach(uuid -> {
            String json = "";
            try {
                json = (String)tvShowMap.get(uuid);
                TvShow tvShow = (TvShow)tvShowObjectReader.readValue(json);
                tvShow.setDbId((UUID)uuid);
                if (!tvShowsFromDb.add(tvShow)) {
                    LOGGER.info("removed duplicate '{}'", (Object)tvShow.getTitle());
                    toRemove.add(uuid);
                }
            }
            catch (Exception e) {
                LOGGER.warn("problem decoding TV show json string: {}", (Object)e.getMessage());
                LOGGER.info("dropping corrupt TV show: {}", (Object)json);
                toRemove.add(uuid);
            }
        });
        long end = System.nanoTime();
        for (Object uuid2 : toRemove) {
            tvShowMap.remove(uuid2);
        }
        LOGGER.info("found {} TV shows in database", (Object)tvShowsFromDb.size());
        LOGGER.debug("took {} ms", (Object)((end - start) / 1000000L));
        HashMap<UUID, TvShow> tvShowUuidMap = new HashMap<UUID, TvShow>();
        for (TvShow tvShow : tvShowsFromDb) {
            tvShowUuidMap.put(tvShow.getDbId(), tvShow);
        }
        toRemove.clear();
        ObjectReader episodeObjectReader = TvShowModuleManager.getInstance().getEpisodeObjectReader();
        ArrayList episodesToCount = new ArrayList();
        start = System.nanoTime();
        new ArrayList<UUID>(episodesMap.keyList()).forEach(uuid -> {
            String json = "";
            try {
                json = (String)episodesMap.get(uuid);
                TvShowEpisode episode = (TvShowEpisode)episodeObjectReader.readValue(json);
                episode.setDbId((UUID)uuid);
                if (this.isEpisodeCorrupt(episode)) {
                    LOGGER.info("episode \"S{}E{}\" without video file - dropping", (Object)episode.getSeason(), (Object)episode.getEpisode());
                    toRemove.add(uuid);
                    return;
                }
                TvShow tvShow = (TvShow)tvShowUuidMap.get(episode.getTvShowDbId());
                if (tvShow != null) {
                    episode.setTvShow(tvShow);
                    tvShow.addEpisode(episode);
                    episodesToCount.add(episode);
                } else {
                    toRemove.add(uuid);
                }
            }
            catch (Exception e) {
                LOGGER.warn("problem decoding episode json string: {}", (Object)e.getMessage());
                LOGGER.info("dropping corrupt episode: {}", (Object)json);
                toRemove.add(uuid);
            }
        });
        end = System.nanoTime();
        for (UUID uuid3 : toRemove) {
            episodesMap.remove((Object)uuid3);
        }
        LOGGER.info("found {} episodes in database", (Object)episodesToCount.size());
        LOGGER.debug("took {} ms", (Object)((end - start) / 1000000L));
        this.tvShows.addAll(tvShowsFromDb);
    }

    void initDataAfterLoading() {
        this.checkAndCleanupMediaFiles();
        ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>();
        for (TvShow tvShow : this.tvShows) {
            tvShow.initializeAfterLoading();
            for (TvShowEpisode episode : tvShow.getEpisodes()) {
                episode.initializeAfterLoading();
                episodes.add(episode);
            }
            tvShow.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.updateTvShowTags(this.tvShows);
        this.updateCertification(this.tvShows);
        this.updateEpisodeTags(episodes);
        this.updateMediaInformationLists(episodes);
    }

    private boolean isEpisodeCorrupt(TvShowEpisode episode) {
        return episode.getMediaFiles(MediaFileType.VIDEO).isEmpty();
    }

    public void persistTvShow(TvShow tvShow) {
        try {
            if (!this.tvShows.contains(tvShow)) {
                throw new IllegalArgumentException(tvShow.getPathNIO().toString());
            }
        }
        catch (Exception e) {
            LOGGER.debug("not persisting TV show - not in tvShowList", (Throwable)e);
            return;
        }
        try {
            TvShowModuleManager.getInstance().persistTvShow(tvShow);
        }
        catch (Exception e) {
            LOGGER.error("failed to persist episode: {} - {}", (Object)tvShow.getTitle(), (Object)e.getMessage());
        }
    }

    public void persistEpisode(TvShowEpisode episode) {
        if (this.isEpisodeCorrupt(episode)) {
            LOGGER.info("episode \"S{}E{}\" without video file/path - dropping", (Object)episode.getSeason(), (Object)episode.getEpisode());
            this.removeEpisodeFromDb(episode);
        } else {
            try {
                TvShowModuleManager.getInstance().persistEpisode(episode);
            }
            catch (Exception e) {
                LOGGER.error("failed to persist episode: {} - S{}E{} - {} : {}", new Object[]{episode.getTvShow().getTitle(), episode.getSeason(), episode.getEpisode(), episode.getTitle(), e.getMessage()});
            }
        }
    }

    public void removeEpisodeFromDb(TvShowEpisode episode) {
        try {
            TvShowModuleManager.getInstance().removeEpisodeFromDb(episode);
        }
        catch (Exception e) {
            LOGGER.error("failed to remove episode: {} - S{}E{} - {} : {}", new Object[]{episode.getTvShow().getTitle(), episode.getSeason(), episode.getEpisode(), episode.getTitle(), e.getMessage()});
        }
    }

    public MediaScraper getDefaultMediaScraper() {
        MediaScraper scraper = MediaScraper.getMediaScraperById(TvShowModuleManager.getInstance().getSettings().getScraper(), ScraperType.TV_SHOW);
        if (scraper == null || !scraper.isEnabled()) {
            scraper = MediaScraper.getMediaScraperById("tmdb", ScraperType.TV_SHOW);
        }
        return scraper;
    }

    public MediaScraper getMediaScraperById(String providerId) {
        return MediaScraper.getMediaScraperById(providerId, ScraperType.TV_SHOW);
    }

    public List<MediaScraper> getAvailableMediaScrapers() {
        List<MediaScraper> availableScrapers = MediaScraper.getMediaScrapers(ScraperType.TV_SHOW);
        availableScrapers.sort(new TvShowMediaScraperComparator());
        return availableScrapers;
    }

    public List<MediaScraper> getAvailableArtworkScrapers() {
        List<MediaScraper> availableScrapers = MediaScraper.getMediaScrapers(ScraperType.TVSHOW_ARTWORK);
        availableScrapers.sort(new TvShowMediaScraperComparator());
        return availableScrapers;
    }

    public List<MediaScraper> getArtworkScrapers(List<String> providerIds) {
        ArrayList<MediaScraper> artworkScrapers = new ArrayList<MediaScraper>();
        for (String providerId : providerIds) {
            MediaScraper artworkScraper;
            if (StringUtils.isBlank((CharSequence)providerId) || (artworkScraper = MediaScraper.getMediaScraperById(providerId, ScraperType.TVSHOW_ARTWORK)) == null) continue;
            artworkScrapers.add(artworkScraper);
        }
        return artworkScrapers;
    }

    public List<MediaScraper> getDefaultArtworkScrapers() {
        List<MediaScraper> defaultScrapers = this.getArtworkScrapers(TvShowModuleManager.getInstance().getSettings().getArtworkScrapers());
        return defaultScrapers.stream().filter(MediaScraper::isActive).collect(Collectors.toList());
    }

    public List<MediaSearchResult> searchTvShow(String searchTerm, int year, Map<String, Object> ids, MediaScraper mediaScraper) throws ScrapeException {
        return this.searchTvShow(searchTerm, year, ids, mediaScraper, TvShowModuleManager.getInstance().getSettings().getScraperLanguage());
    }

    public List<MediaSearchResult> searchTvShow(String searchTerm, int year, Map<String, Object> ids, MediaScraper mediaScraper, MediaLanguages language) throws ScrapeException {
        if (mediaScraper == null || !mediaScraper.isEnabled()) {
            return Collections.emptyList();
        }
        TreeSet<MediaSearchResult> results = new TreeSet<MediaSearchResult>();
        ITvShowMetadataProvider provider = (ITvShowMetadataProvider)mediaScraper.getMediaProvider();
        Pattern tmdbPattern = Pattern.compile("https://www.themoviedb.org/tv/(.*?)-.*");
        TvShowSearchAndScrapeOptions options = new TvShowSearchAndScrapeOptions();
        options.setSearchQuery(searchTerm);
        options.setLanguage(language);
        options.setCertificationCountry(TvShowModuleManager.getInstance().getSettings().getCertificationCountry());
        options.setReleaseDateCountry(TvShowModuleManager.getInstance().getSettings().getReleaseDateCountry());
        if (ids != null) {
            options.setIds(ids);
        }
        if (!searchTerm.isEmpty()) {
            String query = searchTerm.toLowerCase(Locale.ROOT);
            if (MediaIdUtil.isValidImdbId(query)) {
                options.setImdbId(query);
            } else if (query.startsWith("imdb:")) {
                String imdbId = query.replace("imdb:", "");
                if (MediaIdUtil.isValidImdbId(imdbId)) {
                    options.setImdbId(imdbId);
                }
            } else if (query.startsWith("https://www.imdb.com/title/")) {
                String imdbId = query.split("/")[4];
                if (MediaIdUtil.isValidImdbId(imdbId)) {
                    options.setImdbId(imdbId);
                }
            } else if (query.startsWith("tmdb:")) {
                try {
                    int tmdbId = Integer.parseInt(query.replace("tmdb:", ""));
                    if (tmdbId > 0) {
                        options.setTmdbId(tmdbId);
                    }
                }
                catch (Exception tmdbId) {}
            } else if (tmdbPattern.matcher(query).matches()) {
                try {
                    int tmdbId = Integer.parseInt(tmdbPattern.matcher(query).replaceAll("$1"));
                    if (tmdbId > 0) {
                        options.setTmdbId(tmdbId);
                    }
                }
                catch (Exception tmdbId) {}
            } else if (query.startsWith("tvdb:")) {
                try {
                    int tvdbId = Integer.parseInt(query.replace("tvdb:", ""));
                    if (tvdbId > 0) {
                        options.setId("tvdb", tvdbId);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            options.setSearchQuery(searchTerm);
        }
        if (year > 0) {
            options.setSearchYear(year);
        }
        LOGGER.info("=====================================================");
        LOGGER.info("Searching with scraper: {}", (Object)provider.getProviderInfo().getId());
        LOGGER.info("options: {}", (Object)options);
        LOGGER.info("=====================================================");
        results.addAll(provider.search(options));
        if (results.isEmpty() && options.getSearchQuery().matches("^\\d{4}.*")) {
            TvShowSearchAndScrapeOptions o = new TvShowSearchAndScrapeOptions(options);
            o.setSearchQuery(options.getSearchQuery().substring(4));
            LOGGER.info("=====================================================");
            LOGGER.info("Searching again without year in title: {}", (Object)provider.getProviderInfo().getId());
            LOGGER.info("options: {}", (Object)o);
            LOGGER.info("=====================================================");
            results.addAll(provider.search(o));
        }
        return new ArrayList<MediaSearchResult>(results);
    }

    private void updateTvShowTags(Collection<TvShow> tvShows) {
        HashSet tags = new HashSet();
        tvShows.forEach(tvShow -> tags.addAll(tvShow.getTags()));
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.tagsInTvShows, tags)) {
            Utils.removeDuplicateStringFromCollectionIgnoreCase(this.tagsInTvShows);
            this.firePropertyChange("tags", null, this.tagsInTvShows);
        }
    }

    private void updateCertification(Collection<TvShow> tvShows) {
        HashSet certifications = new HashSet();
        tvShows.forEach(tvShow -> certifications.add(tvShow.getCertification()));
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.certificationsInTvShows, certifications)) {
            this.firePropertyChange("certification", null, this.certificationsInTvShows);
        }
    }

    public List<String> getTagsInTvShows() {
        return this.tagsInTvShows;
    }

    private void updateEpisodeTags(Collection<TvShowEpisode> episodes) {
        HashSet tags = new HashSet();
        episodes.forEach(episode -> tags.addAll(episode.getTags()));
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.tagsInEpisodes, tags)) {
            Utils.removeDuplicateStringFromCollectionIgnoreCase(this.tagsInEpisodes);
            this.firePropertyChange("tags", null, this.tagsInEpisodes);
        }
    }

    public Collection<String> getTagsInEpisodes() {
        return this.tagsInEpisodes;
    }

    private void updateMediaInformationLists(Collection<TvShowEpisode> episodes) {
        HashSet<String> videoCodecs = new HashSet<String>();
        HashSet<Double> frameRates = new HashSet<Double>();
        HashMap<String, String> videoContainers = new HashMap<String, String>();
        HashSet<String> audioCodecs = new HashSet<String>();
        HashSet<Integer> audioChannels = new HashSet<Integer>();
        HashSet<Integer> audioStreamCount = new HashSet<Integer>();
        HashSet<String> audioLanguages = new HashSet<String>();
        HashSet<Integer> subtitleStreamCount = new HashSet<Integer>();
        HashSet<String> subtitleLanguages = new HashSet<String>();
        HashSet<String> hdrFormat = new HashSet<String>();
        HashSet<String> audioTitles = new HashSet<String>();
        for (TvShowEpisode episode : episodes) {
            int audioCount = 0;
            int subtitleCount = 0;
            boolean first = true;
            for (MediaFile mf : episode.getMediaFiles(MediaFileType.VIDEO)) {
                if (StringUtils.isNotBlank((CharSequence)mf.getVideoCodec())) {
                    videoCodecs.add(mf.getVideoCodec());
                }
                if (mf.getFrameRate() > 0.0) {
                    frameRates.add(mf.getFrameRate());
                }
                if (StringUtils.isNotBlank((CharSequence)mf.getContainerFormat())) {
                    videoContainers.putIfAbsent(mf.getContainerFormat().toLowerCase(Locale.ROOT), mf.getContainerFormat());
                }
                for (MediaFileAudioStream audio : mf.getAudioStreams()) {
                    if (StringUtils.isNotBlank((CharSequence)audio.getCodec())) {
                        audioCodecs.add(audio.getCodec());
                    }
                    audioChannels.add(audio.getAudioChannels());
                }
                if (first) {
                    audioCount = mf.getAudioStreams().size();
                    audioLanguages.addAll(mf.getAudioLanguagesList());
                    audioTitles.addAll(mf.getAudioTitleList());
                    subtitleCount = mf.getSubtitles().size();
                    subtitleLanguages.addAll(mf.getSubtitleLanguagesList());
                    hdrFormat.add(mf.getHdrFormat());
                }
                first = false;
            }
            for (MediaFile mf : episode.getMediaFiles(MediaFileType.SUBTITLE)) {
                ++subtitleCount;
                subtitleLanguages.addAll(mf.getSubtitleLanguagesList());
            }
            for (MediaFile mf : episode.getMediaFiles(MediaFileType.AUDIO)) {
                ++audioCount;
                audioLanguages.addAll(mf.getAudioLanguagesList());
                audioTitles.addAll(mf.getAudioTitleList());
            }
            audioStreamCount.add(audioCount);
            subtitleStreamCount.add(subtitleCount);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.videoCodecsInEpisodes, videoCodecs)) {
            this.firePropertyChange("videoCodec", null, this.videoCodecsInEpisodes);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.frameRatesInEpisodes, frameRates)) {
            this.firePropertyChange("frameRate", null, this.frameRatesInEpisodes);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.videoContainersInEpisodes, videoContainers.values())) {
            this.firePropertyChange("videoContainer", null, this.videoContainersInEpisodes);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.audioCodecsInEpisodes, audioCodecs)) {
            this.firePropertyChange("audioCodec", null, this.audioCodecsInEpisodes);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.audioChannelsInEpisodes, audioChannels)) {
            this.firePropertyChange("audioChannel", null, this.audioChannelsInEpisodes);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.audioStreamsInEpisodes, audioStreamCount)) {
            this.firePropertyChange("audioStreams", null, this.audioStreamsInEpisodes);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.audioLanguagesInEpisodes, audioLanguages)) {
            this.firePropertyChange("subtitleLanguages", null, this.audioLanguagesInEpisodes);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.subtitlesInEpisodes, subtitleStreamCount)) {
            this.firePropertyChange("countSubtitles", null, this.subtitlesInEpisodes);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.subtitleLanguagesInEpisodes, subtitleLanguages)) {
            this.firePropertyChange("subtitleLanguages", null, this.subtitleLanguagesInEpisodes);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.hdrFormatInEpisodes, hdrFormat)) {
            this.firePropertyChange("hdrFormat", null, this.hdrFormatInEpisodes);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.audioTitlesInEpisodes, audioTitles)) {
            this.firePropertyChange("audioTitle", null, this.audioTitlesInEpisodes);
        }
    }

    public Collection<String> getVideoCodecsInEpisodes() {
        return Collections.unmodifiableList(this.videoCodecsInEpisodes);
    }

    public Collection<String> getVideoContainersInEpisodes() {
        return Collections.unmodifiableList(this.videoContainersInEpisodes);
    }

    public Collection<Double> getFrameRatesInEpisodes() {
        return Collections.unmodifiableList(this.frameRatesInEpisodes);
    }

    public Collection<String> getAudioCodecsInEpisodes() {
        return Collections.unmodifiableList(this.audioCodecsInEpisodes);
    }

    public Collection<Integer> getAudioChannelsInEpisodes() {
        return Collections.unmodifiableList(this.audioChannelsInEpisodes);
    }

    public Collection<MediaCertification> getCertification() {
        return Collections.unmodifiableList(this.certificationsInTvShows);
    }

    public Collection<Integer> getAudioStreamsInEpisodes() {
        return Collections.unmodifiableList(this.audioStreamsInEpisodes);
    }

    public Collection<Integer> getSubtitlesInEpisodes() {
        return Collections.unmodifiableList(this.subtitlesInEpisodes);
    }

    public Collection<String> getAudioLanguagesInEpisodes() {
        return Collections.unmodifiableList(this.audioLanguagesInEpisodes);
    }

    public Collection<String> getSubtitleLanguagesInEpisodes() {
        return Collections.unmodifiableList(this.subtitleLanguagesInEpisodes);
    }

    public Collection<String> getHdrFormatInEpisodes() {
        return Collections.unmodifiableList(this.hdrFormatInEpisodes);
    }

    public Collection<String> getAudioTitlesInEpisodes() {
        return Collections.unmodifiableList(this.audioTitlesInEpisodes);
    }

    public TvShow getTvShowByPath(Path path) {
        for (TvShow tvShow : this.tvShows) {
            if (tvShow.getPathNIO().compareTo(path.toAbsolutePath()) != 0) continue;
            return tvShow;
        }
        return null;
    }

    public static List<TvShowEpisode> getTvEpisodesByFile(TvShow tvShow, Path file) {
        ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>(1);
        if (file == null) {
            return episodes;
        }
        for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(tvShow.getEpisodes())) {
            for (MediaFile mediaFile : new ArrayList<MediaFile>(episode.getMediaFiles())) {
                if (!file.equals(mediaFile.getFile())) continue;
                episodes.add(episode);
            }
        }
        return episodes;
    }

    public void invalidateTitleSortable() {
        ((Stream)this.tvShows.stream().parallel()).forEach(tvShow -> {
            tvShow.clearTitleSortable();
            for (TvShowEpisode episode : tvShow.getEpisodes()) {
                episode.clearTitleSortable();
            }
        });
    }

    public List<TvShow> getNewTvShows() {
        ArrayList<TvShow> newShows = new ArrayList<TvShow>();
        for (TvShow show : this.tvShows) {
            if (!show.isNewlyAdded()) continue;
            newShows.add(show);
        }
        return newShows;
    }

    public List<TvShowEpisode> getNewEpisodes() {
        ArrayList<TvShowEpisode> newEp = new ArrayList<TvShowEpisode>();
        for (TvShow show : this.tvShows) {
            for (TvShowEpisode ep : show.getEpisodes()) {
                if (!ep.isNewlyAdded()) continue;
                newEp.add(ep);
            }
        }
        return newEp;
    }

    public List<TvShowEpisode> getUnscrapedEpisodes() {
        ArrayList<TvShowEpisode> newEp = new ArrayList<TvShowEpisode>();
        for (TvShow show : this.tvShows) {
            for (TvShowEpisode ep : show.getEpisodes()) {
                if (ep.isScraped()) continue;
                newEp.add(ep);
            }
        }
        return newEp;
    }

    private void checkAndCleanupMediaFiles() {
        boolean problemsDetected = false;
        for (TvShow tvShow : this.tvShows) {
            for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(tvShow.getEpisodes())) {
                List<MediaFile> mfs = episode.getMediaFiles(MediaFileType.VIDEO);
                if (!mfs.isEmpty()) continue;
                tvShow.removeEpisode(episode);
                problemsDetected = true;
            }
        }
        if (problemsDetected) {
            LOGGER.warn("episodes without VIDEOs detected");
            Thread thread = new Thread(() -> {
                try {
                    Thread.sleep(15000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Message message = new Message(Message.MessageLevel.SEVERE, "tmm.tvshows", "message.database.corrupteddata");
                MessageManager.instance.pushMessage(message);
            });
            thread.start();
        }
    }

    public List<MediaScraper> getAvailableSubtitleScrapers() {
        List<MediaScraper> availableScrapers = MediaScraper.getMediaScrapers(ScraperType.TVSHOW_SUBTITLE);
        availableScrapers.sort(new TvShowMediaScraperComparator());
        return availableScrapers;
    }

    public List<MediaScraper> getDefaultSubtitleScrapers() {
        List<MediaScraper> defaultScrapers = this.getSubtitleScrapers(TvShowModuleManager.getInstance().getSettings().getSubtitleScrapers());
        return defaultScrapers.stream().filter(MediaScraper::isActive).collect(Collectors.toList());
    }

    public List<MediaScraper> getDefaultTrailerScrapers() {
        List<MediaScraper> defaultScrapers = this.getTrailerScrapers(TvShowModuleManager.getInstance().getSettings().getTrailerScrapers());
        return defaultScrapers.stream().filter(MediaScraper::isActive).collect(Collectors.toList());
    }

    public List<MediaScraper> getSubtitleScrapers(List<String> providerIds) {
        ArrayList<MediaScraper> subtitleScrapers = new ArrayList<MediaScraper>();
        for (String providerId : providerIds) {
            MediaScraper subtitleScraper;
            if (StringUtils.isBlank((CharSequence)providerId) || (subtitleScraper = MediaScraper.getMediaScraperById(providerId, ScraperType.TVSHOW_SUBTITLE)) == null) continue;
            subtitleScrapers.add(subtitleScraper);
        }
        return subtitleScrapers;
    }

    public void searchDuplicateEpisodes() {
        HashMap<CallSite, TvShow> showMap = new HashMap<CallSite, TvShow>();
        for (TvShow tvShow : this.getTvShows()) {
            Map<String, Object> ids = tvShow.getIds();
            for (Map.Entry<String, Object> entry : ids.entrySet()) {
                if ("tmdbSet".equalsIgnoreCase(entry.getKey()) || "tmdbcol".equalsIgnoreCase(entry.getKey())) continue;
                String id = entry.getKey() + String.valueOf(entry.getValue());
                if (showMap.containsKey(id)) {
                    tvShow.setDuplicate();
                    TvShow show2 = (TvShow)showMap.get(id);
                    show2.setDuplicate();
                    continue;
                }
                showMap.put((CallSite)((Object)id), tvShow);
            }
            HashMap<CallSite, TvShowEpisode> episodeMap = new HashMap<CallSite, TvShowEpisode>();
            for (TvShowEpisode episode : tvShow.getEpisodes()) {
                if (episode.getSeason() == -1 || episode.getEpisode() == -1) continue;
                String se = "S" + episode.getSeason() + "E" + episode.getEpisode();
                TvShowEpisode duplicate = (TvShowEpisode)episodeMap.get(se);
                if (duplicate != null) {
                    duplicate.setDuplicate();
                    episode.setDuplicate();
                    continue;
                }
                episodeMap.put((CallSite)((Object)se), episode);
            }
        }
    }

    public List<TvShowScraperMetadataConfig> detectMissingMetadata(TvShow tvShow) {
        return this.detectMissingFields(tvShow, TvShowModuleManager.getInstance().getSettings().getTvShowCheckMetadata());
    }

    public List<TvShowScraperMetadataConfig> detectMissingArtwork(TvShow tvShow) {
        return this.detectMissingFields(tvShow, TvShowModuleManager.getInstance().getSettings().getTvShowCheckArtwork());
    }

    public List<TvShowScraperMetadataConfig> detectMissingFields(TvShow tvshow, List<TvShowScraperMetadataConfig> toCheck) {
        ArrayList<TvShowScraperMetadataConfig> missingMetadata = new ArrayList<TvShowScraperMetadataConfig>();
        for (TvShowScraperMetadataConfig metadataConfig : toCheck) {
            Object value = tvshow.getValueForMetadata(metadataConfig);
            if (value == null) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof String && StringUtils.isBlank((CharSequence)((String)value))) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Number && ((Number)value).intValue() <= 0) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Collection && ((Collection)value).isEmpty()) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Map && ((Map)value).isEmpty()) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value != MediaCertification.UNKNOWN) continue;
            missingMetadata.add(metadataConfig);
        }
        return missingMetadata;
    }

    public List<TvShowScraperMetadataConfig> detectMissingArtwork(TvShowSeason season) {
        return this.detectMissingFields(season, TvShowModuleManager.getInstance().getSettings().getSeasonCheckArtwork());
    }

    public List<TvShowScraperMetadataConfig> detectMissingFields(TvShowSeason season, List<TvShowScraperMetadataConfig> toCheck) {
        ArrayList<TvShowScraperMetadataConfig> missingMetadata = new ArrayList<TvShowScraperMetadataConfig>();
        for (TvShowScraperMetadataConfig metadataConfig : toCheck) {
            Object value = season.getValueForMetadata(metadataConfig);
            if (value == null) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof String && StringUtils.isBlank((CharSequence)((String)value))) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Number && ((Number)value).intValue() <= 0) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Collection && ((Collection)value).isEmpty()) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Map && ((Map)value).isEmpty()) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value != MediaCertification.UNKNOWN) continue;
            missingMetadata.add(metadataConfig);
        }
        return missingMetadata;
    }

    public List<TvShowEpisodeScraperMetadataConfig> detectMissingMetadata(TvShowEpisode episode) {
        if (episode.isDummy() || episode.getSeason() == 0 && !TvShowModuleManager.getInstance().getSettings().isEpisodeSpecialsCheckMissingMetadata()) {
            return Collections.emptyList();
        }
        return this.detectMissingFields(episode, TvShowModuleManager.getInstance().getSettings().getEpisodeCheckMetadata());
    }

    public List<TvShowEpisodeScraperMetadataConfig> detectMissingArtwork(TvShowEpisode episode) {
        if (episode.isDummy() || episode.getSeason() == 0 && !TvShowModuleManager.getInstance().getSettings().isEpisodeSpecialsCheckMissingArtwork()) {
            return Collections.emptyList();
        }
        return this.detectMissingFields(episode, TvShowModuleManager.getInstance().getSettings().getEpisodeCheckArtwork());
    }

    public List<TvShowEpisodeScraperMetadataConfig> detectMissingFields(TvShowEpisode episode, List<TvShowEpisodeScraperMetadataConfig> toCheck) {
        ArrayList<TvShowEpisodeScraperMetadataConfig> missingMetadata = new ArrayList<TvShowEpisodeScraperMetadataConfig>();
        for (TvShowEpisodeScraperMetadataConfig metadataConfig : toCheck) {
            Object value = episode.getValueForMetadata(metadataConfig);
            if (value == null) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof String && StringUtils.isBlank((CharSequence)((String)value))) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Number && ((Number)value).intValue() <= 0) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Collection && ((Collection)value).isEmpty()) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Map && ((Map)value).isEmpty()) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value != MediaCertification.UNKNOWN) continue;
            missingMetadata.add(metadataConfig);
        }
        return missingMetadata;
    }

    private static class TvShowMediaScraperComparator
    implements Comparator<MediaScraper> {
        private TvShowMediaScraperComparator() {
        }

        @Override
        public int compare(MediaScraper o1, MediaScraper o2) {
            if (o1.getPriority() == o2.getPriority()) {
                return o1.getId().compareTo(o2.getId());
            }
            return Integer.compare(o2.getPriority(), o1.getPriority());
        }
    }
}

