/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowRenamer;
import org.tinymediamanager.core.tvshow.TvShowRenamerPreviewContainer;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;

public class TvShowRenamerPreview {
    private final TvShow tvShow;
    private final TvShowRenamerPreviewContainer container;
    private final Map<String, MediaFile> oldFiles;
    private final Set<MediaFile> newFiles;

    public TvShowRenamerPreview(TvShow tvShow) {
        this.tvShow = tvShow;
        this.container = new TvShowRenamerPreviewContainer(tvShow);
        this.oldFiles = new LinkedHashMap<String, MediaFile>();
        this.newFiles = new LinkedHashSet<MediaFile>();
    }

    public TvShowRenamerPreviewContainer generatePreview() {
        this.container.newPath = Paths.get(TvShowRenamer.getTvShowFoldername(TvShowModuleManager.getInstance().getSettings().getRenamerTvShowFoldername(), this.tvShow), new String[0]);
        this.processTvShow();
        this.processEpisodes();
        if (!this.container.newPath.equals(this.container.oldPath)) {
            this.container.needsRename = true;
            for (MediaFile omf : this.newFiles) {
                omf.replacePathForRenamedFolder(this.container.oldPath, this.container.newPath);
            }
        }
        for (MediaFile mf : this.newFiles) {
            if (this.oldFiles.containsKey(mf.getFileAsPath().toString())) continue;
            this.container.needsRename = true;
            break;
        }
        for (MediaFile mf : this.oldFiles.values()) {
            if (this.newFiles.contains(mf)) continue;
            this.container.needsRename = true;
            break;
        }
        this.container.oldMediaFiles.addAll(this.oldFiles.values());
        this.container.newMediaFiles.addAll(this.newFiles);
        return this.container;
    }

    private void processTvShow() {
        for (MediaFile mf : this.tvShow.getMediaFiles()) {
            MediaFile oldMf = new MediaFile(mf);
            oldMf.replacePathForRenamedFolder(this.container.oldPath, this.container.newPath);
            this.oldFiles.put(oldMf.getFileAsPath().toString(), oldMf);
            this.newFiles.addAll(TvShowRenamer.generateFilename(this.tvShow, mf));
        }
    }

    private void processEpisodes() {
        ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>(this.tvShow.getEpisodes());
        Collections.sort(episodes);
        for (TvShowEpisode episode : episodes) {
            MediaFile oldMf;
            MediaFile mainVideoFile = episode.getMainVideoFile();
            String oldVideoBasename = episode.getVideoBasenameWithoutStacking();
            if (episode.getSeason() < 0 || episode.getEpisode() < 0) {
                for (MediaFile mf : episode.getMediaFiles()) {
                    oldMf = new MediaFile(mf);
                    this.oldFiles.put(oldMf.getFileAsPath().toString(), oldMf);
                    MediaFile newMf = new MediaFile(mf);
                    this.newFiles.add(newMf);
                }
                continue;
            }
            if (episode.isDisc()) {
                String seasonFoldername = TvShowRenamer.getSeasonFoldername(episode.getTvShow(), episode);
                Path seasonFolder = episode.getTvShow().getPathNIO();
                if (StringUtils.isNotBlank((CharSequence)seasonFoldername)) {
                    seasonFolder = episode.getTvShow().getPathNIO().resolve(seasonFoldername);
                }
                String newFoldername = FilenameUtils.getBaseName((String)TvShowRenamer.generateFoldername(episode.getTvShow(), mainVideoFile));
                Path newEpFolder = seasonFolder.resolve(newFoldername);
                for (MediaFile mf : episode.getMediaFiles()) {
                    MediaFile oldMf2 = new MediaFile(mf);
                    oldMf2.replacePathForRenamedFolder(this.container.oldPath, this.container.newPath);
                    this.oldFiles.put(oldMf2.getFileAsPath().toString(), oldMf2);
                    MediaFile newMf = new MediaFile(mf);
                    String newMfFolder = newMf.getPath().replace(mainVideoFile.getPath(), newEpFolder.toString());
                    newMf.replacePathForRenamedFolder(mf.getFileAsPath().getParent(), Paths.get(newMfFolder, new String[0]));
                    this.newFiles.add(newMf);
                }
                continue;
            }
            for (MediaFile mf : episode.getMediaFiles()) {
                oldMf = new MediaFile(mf);
                oldMf.replacePathForRenamedFolder(this.container.oldPath, this.container.newPath);
                this.oldFiles.put(oldMf.getFileAsPath().toString(), oldMf);
                this.newFiles.addAll(TvShowRenamer.generateEpisodeFilenames(this.tvShow, mf, oldVideoBasename));
            }
        }
    }
}

