/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.connector;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.MediaSource;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.MovieHelpers;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.ParserUtils;
import org.tinymediamanager.scraper.util.StrgUtils;

public class TvShowEpisodeNfoParser {
    public List<Episode> episodes = new ArrayList<Episode>();

    private TvShowEpisodeNfoParser(Document document) {
        document.outputSettings().prettyPrint(false);
        Elements elements = document.select("episodedetails");
        if (!elements.isEmpty()) {
            for (Element element : elements) {
                Episode episode = new Episode(element);
                if (!StringUtils.isNotBlank((CharSequence)episode.title)) continue;
                this.episodes.add(episode);
            }
            return;
        }
        elements = document.select("recording");
        if (!elements.isEmpty()) {
            Episode episode = new Episode((Element)elements.get(0));
            if (StringUtils.isNotBlank((CharSequence)episode.title)) {
                this.episodes.add(episode);
            }
            return;
        }
    }

    public static TvShowEpisodeNfoParser parseNfo(Path path) throws Exception {
        return new TvShowEpisodeNfoParser(Jsoup.parse((InputStream)new FileInputStream(path.toFile()), (String)"UTF-8", (String)"", (Parser)Parser.xmlParser()));
    }

    public static TvShowEpisodeNfoParser parseNfo(String content) {
        return new TvShowEpisodeNfoParser(Jsoup.parse((String)content, (String)"", (Parser)Parser.xmlParser()));
    }

    public boolean isValidNfo() {
        if (this.episodes.isEmpty()) {
            return false;
        }
        Episode episode = this.episodes.get(0);
        if (StringUtils.isBlank((CharSequence)episode.title)) {
            return false;
        }
        return episode.episode >= 0;
    }

    public List<TvShowEpisode> toTvShowEpisodes() {
        ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>();
        for (Episode episode : this.episodes) {
            episodes.add(episode.toTvShowEpisode());
        }
        return episodes;
    }

    public static class Subtitle {
        public String language;
    }

    public static class Audio {
        public String codec = "";
        public String language = "";
        public int channels = 0;
    }

    public static class Video {
        public String codec = "";
        public float aspect = 0.0f;
        public int width = 0;
        public int height = 0;
        public int durationinseconds;
        public String stereomode = "";
    }

    public static class Fileinfo {
        public List<Video> videos = new ArrayList<Video>();
        public List<Audio> audios = new ArrayList<Audio>();
        public List<Subtitle> subtitles = new ArrayList<Subtitle>();
    }

    public static class Person {
        public String name = "";
        public String role = "";
        public String thumb = "";
        public String profile = "";
        public String tmdbId = "";
        public String imdbId = "";
        public String tvdbId = "";
    }

    public static class Rating {
        public static final String DEFAULT = "default";
        public static final String USER = "user";
        public String id = "";
        public float rating = 0.0f;
        public int votes = 0;
        public int maxValue = 10;
    }

    public static class Episode {
        private static final Logger LOGGER = LoggerFactory.getLogger(Episode.class);
        private static final List<String> IGNORE = Arrays.asList("set", "status");
        private final Element root;
        private final List<String> supportedElements = new ArrayList<String>();
        public String title = "";
        public String originaltitle = "";
        public String showTitle = "";
        public int season = -1;
        public int episode = -1;
        public int displayseason = -1;
        public int displayepisode = -1;
        public String plot = "";
        public int runtime = 0;
        public MediaCertification certification = MediaCertification.UNKNOWN;
        public Date releaseDate = null;
        public boolean watched = false;
        public int playcount = 0;
        public MediaSource source = MediaSource.UNKNOWN;
        public String userNote = "";
        public String originalFileName = "";
        public Map<String, Object> ids = new HashMap<String, Object>();
        public Map<String, Rating> ratings = new HashMap<String, Rating>();
        public List<String> thumbs = new ArrayList<String>();
        public List<MediaGenres> genres = new ArrayList<MediaGenres>();
        public List<String> studios = new ArrayList<String>();
        public List<String> tags = new ArrayList<String>();
        public List<Person> actors = new ArrayList<Person>();
        public List<Person> directors = new ArrayList<Person>();
        public List<Person> credits = new ArrayList<Person>();
        public List<String> unsupportedElements = new ArrayList<String>();
        public int year = 0;
        public int top250 = 0;
        public String outline = "";
        public String tagline = "";
        public String trailer = "";
        public Fileinfo fileinfo = null;
        public String epbookmark = "";
        public Date lastplayed = null;
        public String code = "";
        public Date dateadded = null;
        public String episodenumberend = "";

        private Episode(Element root) {
            this.root = root;
            if ("episodedetails".equalsIgnoreCase(root.tagName())) {
                this.parseKodiStyle();
            } else if ("recording".equalsIgnoreCase(root.tagName())) {
                this.parseNextpvrStyle();
            }
        }

        private void parseKodiStyle() {
            this.parseTag(Episode::parseTitle);
            this.parseTag(Episode::parseOriginalTitle);
            this.parseTag(Episode::parseShowTitle);
            this.parseTag(Episode::parseSeason);
            this.parseTag(Episode::parseEpisode);
            this.parseTag(Episode::parseDisplaySeason);
            this.parseTag(Episode::parseDisplayEpisode);
            this.parseTag(Episode::parseRatingAndVotes);
            this.parseTag(Episode::parseYear);
            this.parseTag(Episode::parseTop250);
            this.parseTag(Episode::parsePlot);
            this.parseTag(Episode::parseOutline);
            this.parseTag(Episode::parseTagline);
            this.parseTag(Episode::parseRuntime);
            this.parseTag(Episode::parseThumbs);
            this.parseTag(Episode::parseCertification);
            this.parseTag(Episode::parseIds);
            this.parseTag(Episode::parseReleaseDate);
            this.parseTag(Episode::parseWatchedAndPlaycount);
            this.parseTag(Episode::parseGenres);
            this.parseTag(Episode::parseStudios);
            this.parseTag(Episode::parseCredits);
            this.parseTag(Episode::parseDirectors);
            this.parseTag(Episode::parseTags);
            this.parseTag(Episode::parseActors);
            this.parseTag(Episode::parseFileinfo);
            this.parseTag(Episode::parseSource);
            this.parseTag(Episode::parseTrailer);
            this.parseTag(Episode::parseEpbookmark);
            this.parseTag(Episode::parseLastplayed);
            this.parseTag(Episode::parseCode);
            this.parseTag(Episode::parseEpisodenumberend);
            this.parseTag(Episode::parseDateadded);
            this.parseTag(Episode::parseOriginalFilename);
            this.parseTag(Episode::parseUserNote);
            this.parseTag(Episode::findUnsupportedElements);
        }

        private void parseNextpvrStyle() {
            this.parseTag(Episode::parseSubtitle);
            this.parseTag(Episode::parseDescription);
            this.parseTag(Episode::parseCertificationInRating);
            this.parseTag(Episode::parseOriginalAirDate);
            this.parseTag(Episode::parseGenres);
            if (StringUtils.isBlank((CharSequence)this.title) && StringUtils.isNotBlank((CharSequence)this.plot)) {
                this.title = this.plot;
            }
        }

        private Void parseTag(Function<Episode, Void> function) {
            try {
                function.apply(this);
            }
            catch (Exception e) {
                LOGGER.warn("problem parsing tag (line {}) - {}", (Object)e.getStackTrace()[0].getLineNumber(), (Object)e.getMessage());
            }
            return null;
        }

        private Element getSingleElement(Element parent, String tag) {
            Elements elements = parent.select(parent.tagName() + " > " + tag);
            if (elements.size() != 1) {
                return null;
            }
            return (Element)elements.get(0);
        }

        private Void parseTitle() {
            this.supportedElements.add("title");
            Element element = this.getSingleElement(this.root, "title");
            if (element != null) {
                this.title = element.ownText();
            }
            return null;
        }

        private Void parseSubtitle() {
            this.supportedElements.add("subtitle");
            Element element = this.getSingleElement(this.root, "subtitle");
            if (element != null) {
                this.title = element.ownText();
            }
            return null;
        }

        private Void parseOriginalTitle() {
            this.supportedElements.add("originaltitle");
            Element element = this.getSingleElement(this.root, "originaltitle");
            if (element != null) {
                this.originaltitle = element.ownText();
            }
            return null;
        }

        private Void parseShowTitle() {
            this.supportedElements.add("showtitle");
            Element element = this.getSingleElement(this.root, "showtitle");
            if (element != null) {
                this.showTitle = element.ownText();
            }
            return null;
        }

        private Void parseSeason() {
            this.supportedElements.add("season");
            Element element = this.getSingleElement(this.root, "season");
            if (element != null) {
                try {
                    this.season = Integer.parseInt(element.ownText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        private Void parseEpisode() {
            this.supportedElements.add("episode");
            Element element = this.getSingleElement(this.root, "episode");
            if (element != null) {
                try {
                    this.episode = Integer.parseInt(element.ownText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        private Void parseDisplaySeason() {
            this.supportedElements.add("displayseason");
            Element element = this.getSingleElement(this.root, "displayseason");
            if (element != null) {
                try {
                    this.displayseason = Integer.parseInt(element.ownText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        private Void parseDisplayEpisode() {
            this.supportedElements.add("displayepisode");
            Element element = this.getSingleElement(this.root, "displayepisode");
            if (element != null) {
                try {
                    this.displayepisode = Integer.parseInt(element.ownText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        private Void parseRatingAndVotes() {
            Rating r;
            this.supportedElements.add("rating");
            this.supportedElements.add("userrating");
            this.supportedElements.add("ratings");
            this.supportedElements.add("votes");
            Element element = this.getSingleElement(this.root, "rating");
            if (element != null) {
                r = new Rating();
                r.id = "default";
                try {
                    r.rating = Float.parseFloat(element.ownText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                element = this.getSingleElement(this.root, "votes");
                if (element != null) {
                    try {
                        r.votes = MetadataUtil.parseInt(element.ownText());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (r.rating > 0.0f) {
                    this.ratings.put(r.id, r);
                }
            }
            if ((element = this.getSingleElement(this.root, "userrating")) != null) {
                try {
                    r = new Rating();
                    r.id = "user";
                    r.rating = Float.parseFloat(element.ownText());
                    if (r.rating > 0.0f) {
                        this.ratings.put(r.id, r);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((element = this.getSingleElement(this.root, "ratings")) != null) {
                for (Element ratingChild : element.select(element.tagName() + " > rating")) {
                    Rating r2 = new Rating();
                    r2.id = ratingChild.attr("name");
                    if ("themoviedb".equals(r2.id)) {
                        r2.id = "tmdb";
                    } else if ("rottenTomatoes".equals(r2.id)) {
                        r2.id = "tomatometerallcritics";
                    } else if ("metascore".equals(r2.id)) {
                        r2.id = "metacritic";
                    }
                    try {
                        r2.maxValue = MetadataUtil.parseInt(ratingChild.attr("max"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    for (Element child : ratingChild.children()) {
                        switch (child.tagName()) {
                            case "value": {
                                try {
                                    r2.rating = Float.parseFloat(child.ownText());
                                }
                                catch (NumberFormatException numberFormatException) {}
                                break;
                            }
                            case "votes": {
                                try {
                                    r2.votes = MetadataUtil.parseInt(child.ownText());
                                    break;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    if (!StringUtils.isNotBlank((CharSequence)r2.id) || !(r2.rating > 0.0f)) continue;
                    this.ratings.put(r2.id, r2);
                }
            }
            return null;
        }

        private Void parseYear() {
            this.supportedElements.add("year");
            Element element = this.getSingleElement(this.root, "year");
            if (element != null) {
                try {
                    this.year = MetadataUtil.parseInt(element.ownText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        private Void parseTop250() {
            this.supportedElements.add("top250");
            Element element = this.getSingleElement(this.root, "top250");
            if (element != null) {
                try {
                    this.top250 = MetadataUtil.parseInt(element.ownText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        private Void parsePlot() {
            this.supportedElements.add("plot");
            Element element = this.getSingleElement(this.root, "plot");
            if (element != null) {
                this.plot = element.wholeText();
            }
            return null;
        }

        private Void parseDescription() {
            this.supportedElements.add("description");
            Element element = this.getSingleElement(this.root, "description");
            if (element != null) {
                this.plot = element.wholeText();
            }
            return null;
        }

        private Void parseOutline() {
            this.supportedElements.add("outline");
            Element element = this.getSingleElement(this.root, "outline");
            if (element != null) {
                this.outline = element.wholeText();
            }
            return null;
        }

        private Void parseTagline() {
            this.supportedElements.add("tagline");
            Element element = this.getSingleElement(this.root, "tagline");
            if (element != null) {
                this.tagline = element.wholeText();
            }
            return null;
        }

        private Void parseRuntime() {
            this.supportedElements.add("runtime");
            Element element = this.getSingleElement(this.root, "runtime");
            if (element != null) {
                try {
                    this.runtime = MetadataUtil.parseInt(element.ownText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        private Void parseThumbs() {
            this.supportedElements.add("thumb");
            Element element = this.getSingleElement(this.root, "thumb");
            if (element != null && element.ownText().matches("https?://.*")) {
                this.thumbs.add(element.ownText());
            }
            return null;
        }

        private Void parseCertification() {
            this.supportedElements.add("certification");
            this.supportedElements.add("mpaa");
            Element element = this.getSingleElement(this.root, "certification");
            if (element == null || StringUtils.isBlank((CharSequence)element.ownText())) {
                element = this.getSingleElement(this.root, "mpaa");
            }
            if (element != null) {
                this.certification = MovieHelpers.parseCertificationStringForMovieSetupCountry(element.ownText());
            }
            return null;
        }

        private Void parseCertificationInRating() {
            this.supportedElements.add("rating");
            Element element = this.getSingleElement(this.root, "rating");
            if (element != null) {
                this.certification = MovieHelpers.parseCertificationStringForMovieSetupCountry(element.ownText());
            }
            return null;
        }

        private Void parseIds() {
            Elements children;
            this.supportedElements.add("id");
            this.supportedElements.add("imdb");
            this.supportedElements.add("tmdbid");
            this.supportedElements.add("ids");
            this.supportedElements.add("uniqueid");
            Element element = this.getSingleElement(this.root, "id");
            if (element != null) {
                try {
                    this.ids.put("tvdb", MetadataUtil.parseInt(element.ownText()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((element = this.getSingleElement(this.root, "uniqueid")) != null && this.ids.get("tvdb") == null) {
                try {
                    this.ids.put("tvdb", MetadataUtil.parseInt(element.ownText()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Elements elements = this.root.select(this.root.tagName() + " > uniqueid");
            for (Element id : elements) {
                try {
                    String value;
                    String key = id.attr("type");
                    if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{key, value = id.ownText()})) continue;
                    if ("unknown".equals(key) && this.ids.get("tvdb") == null) {
                        try {
                            this.ids.put("tvdb", MetadataUtil.parseInt(value));
                        }
                        catch (Exception e) {
                            this.ids.put(key, value);
                        }
                        continue;
                    }
                    try {
                        this.ids.put(key, MetadataUtil.parseInt(value));
                    }
                    catch (Exception e) {
                        this.ids.put(key, value);
                    }
                }
                catch (Exception key) {}
            }
            element = this.getSingleElement(this.root, "imdb");
            if (element != null && MediaIdUtil.isValidImdbId(element.ownText())) {
                this.ids.put("imdb", element.ownText());
            }
            if ((element = this.getSingleElement(this.root, "tmdbId")) != null) {
                try {
                    this.ids.put("tmdb", MetadataUtil.parseInt(element.ownText()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((element = this.getSingleElement(this.root, "ids")) != null) {
                children = element.select(element.tagName() + " > entry");
                for (Element entry : children) {
                    Element key = this.getSingleElement(entry, "key");
                    Element value = this.getSingleElement(entry, "value");
                    if (key == null || value == null || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{key.ownText(), value.ownText()})) continue;
                    try {
                        this.ids.put(key.ownText(), MetadataUtil.parseInt(value.ownText()));
                    }
                    catch (Exception e) {
                        this.ids.put(key.ownText(), value.ownText());
                    }
                }
            }
            if ((element = this.getSingleElement(this.root, "ids")) != null) {
                children = element.children();
                for (Element entry : children) {
                    if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{entry.tagName(), entry.ownText()})) continue;
                    try {
                        this.ids.put(entry.tagName(), MetadataUtil.parseInt(entry.ownText()));
                    }
                    catch (Exception e) {
                        this.ids.put(entry.tagName(), entry.ownText());
                    }
                }
            }
            return null;
        }

        private Void parseReleaseDate() {
            Date date2;
            this.supportedElements.add("aired");
            this.supportedElements.add("premiered");
            Element element = this.getSingleElement(this.root, "aired");
            if (element != null) {
                try {
                    date2 = StrgUtils.parseDate(element.ownText());
                    if (date2 != null) {
                        this.releaseDate = date2;
                    }
                }
                catch (ParseException date2) {
                    // empty catch block
                }
            }
            if (this.releaseDate == null && (element = this.getSingleElement(this.root, "premiered")) != null) {
                try {
                    date2 = StrgUtils.parseDate(element.ownText());
                    if (date2 != null) {
                        this.releaseDate = date2;
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return null;
        }

        private Void parseOriginalAirDate() {
            this.supportedElements.add("original_air_date");
            Element element = this.getSingleElement(this.root, "original_air_date");
            if (element != null) {
                try {
                    Date date = StrgUtils.parseDate(element.ownText());
                    if (date != null) {
                        this.releaseDate = date;
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return null;
        }

        private Void parseWatchedAndPlaycount() {
            this.supportedElements.add("watched");
            this.supportedElements.add("playcount");
            Element element = this.getSingleElement(this.root, "watched");
            if (element != null) {
                try {
                    this.watched = Boolean.parseBoolean(element.ownText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((element = this.getSingleElement(this.root, "playcount")) != null) {
                try {
                    this.playcount = MetadataUtil.parseInt(element.ownText());
                    if (this.playcount > 0) {
                        this.watched = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        private Void parseGenres() {
            this.supportedElements.add("genres");
            this.supportedElements.add("genre");
            Elements elements = null;
            Element element = this.getSingleElement(this.root, "genres");
            elements = element != null ? element.select(element.tagName() + " > genre") : this.root.select(this.root.tagName() + " > genre");
            if (elements != null && !elements.isEmpty()) {
                for (Element genre : elements) {
                    String[] split;
                    if (!StringUtils.isNotBlank((CharSequence)genre.ownText())) continue;
                    for (String sp : split = StringEscapeUtils.unescapeXml((String)genre.ownText()).split("[/&]")) {
                        this.genres.add(MediaGenres.getGenre(sp.trim()));
                    }
                }
            }
            return null;
        }

        private Void parseStudios() {
            this.supportedElements.add("studio");
            Elements elements = this.root.select(this.root.tagName() + " > studio");
            if (elements.size() == 1) {
                try {
                    this.studios.addAll(Arrays.asList(((Element)elements.get(0)).ownText().split("\\s*[,\\/]\\s*")));
                }
                catch (Exception exception) {}
            } else {
                for (Element element : elements) {
                    if (!StringUtils.isNotBlank((CharSequence)element.ownText())) continue;
                    this.studios.add(element.ownText());
                }
            }
            return null;
        }

        private Void parseCredits() {
            this.supportedElements.add("credits");
            Elements elements = this.root.select(this.root.tagName() + " > credits");
            if (elements.size() == 1) {
                try {
                    Element element = (Element)elements.get(0);
                    List<String> creditsNames = ParserUtils.split(element.ownText());
                    for (String credit : creditsNames) {
                        Person person = new Person();
                        person.name = credit;
                        if (creditsNames.size() == 1) {
                            if (StringUtils.isNotBlank((CharSequence)element.attr("tmdbid"))) {
                                person.tmdbId = element.attr("tmdbid");
                            }
                            if (StringUtils.isNotBlank((CharSequence)element.attr("imdbid"))) {
                                person.imdbId = element.attr("imdbid");
                            }
                            if (StringUtils.isNotBlank((CharSequence)element.attr("tvdbid"))) {
                                person.tvdbId = element.attr("tvdbid");
                            }
                        }
                        this.credits.add(person);
                    }
                }
                catch (Exception exception) {}
            } else {
                for (Element element : elements) {
                    if (!StringUtils.isNotBlank((CharSequence)element.ownText())) continue;
                    Person person = new Person();
                    person.name = element.ownText();
                    if (StringUtils.isNotBlank((CharSequence)element.attr("tmdbid"))) {
                        person.tmdbId = element.attr("tmdbid");
                    }
                    if (StringUtils.isNotBlank((CharSequence)element.attr("imdbid"))) {
                        person.imdbId = element.attr("imdbid");
                    }
                    if (StringUtils.isNotBlank((CharSequence)element.attr("tvdbid"))) {
                        person.tvdbId = element.attr("tvdbid");
                    }
                    this.credits.add(person);
                }
            }
            return null;
        }

        private Void parseDirectors() {
            this.supportedElements.add("director");
            Elements elements = this.root.select(this.root.tagName() + " > director");
            if (elements.size() == 1) {
                try {
                    Element element = (Element)elements.get(0);
                    List<String> directorNames = ParserUtils.split(element.ownText());
                    for (String director : directorNames) {
                        Person person = new Person();
                        person.name = director;
                        if (directorNames.size() == 1) {
                            if (StringUtils.isNotBlank((CharSequence)element.attr("tmdbid"))) {
                                person.tmdbId = element.attr("tmdbid");
                            }
                            if (StringUtils.isNotBlank((CharSequence)element.attr("imdbid"))) {
                                person.imdbId = element.attr("imdbid");
                            }
                            if (StringUtils.isNotBlank((CharSequence)element.attr("tvdbid"))) {
                                person.tvdbId = element.attr("tvdbid");
                            }
                        }
                        this.directors.add(person);
                    }
                }
                catch (Exception exception) {}
            } else {
                for (Element element : elements) {
                    if (!StringUtils.isNotBlank((CharSequence)element.ownText())) continue;
                    Person person = new Person();
                    person.name = element.ownText();
                    if (StringUtils.isNotBlank((CharSequence)element.attr("tmdbid"))) {
                        person.tmdbId = element.attr("tmdbid");
                    }
                    if (StringUtils.isNotBlank((CharSequence)element.attr("imdbid"))) {
                        person.imdbId = element.attr("imdbid");
                    }
                    if (StringUtils.isNotBlank((CharSequence)element.attr("tvdbid"))) {
                        person.tvdbId = element.attr("tvdbid");
                    }
                    this.directors.add(person);
                }
            }
            return null;
        }

        private Void parseTags() {
            this.supportedElements.add("tag");
            Elements elements = this.root.select(this.root.tagName() + " > tag");
            for (Element element : elements) {
                if (!StringUtils.isNotBlank((CharSequence)element.ownText())) continue;
                this.tags.add(element.ownText());
            }
            return null;
        }

        private Void parseActors() {
            this.supportedElements.add("actor");
            Elements elements = this.root.select(this.root.tagName() + " > actor");
            for (Element element : elements) {
                Person actor = new Person();
                for (Element child : element.children()) {
                    switch (child.tagName()) {
                        case "name": {
                            actor.name = child.ownText();
                            break;
                        }
                        case "role": {
                            actor.role = child.ownText();
                            break;
                        }
                        case "thumb": {
                            actor.thumb = child.ownText();
                            break;
                        }
                        case "profile": {
                            actor.profile = child.ownText();
                            break;
                        }
                        case "tmdbid": {
                            actor.tmdbId = child.ownText();
                            break;
                        }
                        case "tvdbid": {
                            actor.tvdbId = child.ownText();
                            break;
                        }
                        case "imdbid": {
                            actor.imdbId = child.ownText();
                            break;
                        }
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)actor.name)) continue;
                this.actors.add(actor);
            }
            return null;
        }

        private Void parseFileinfo() {
            this.supportedElements.add("fileinfo");
            Element element = this.getSingleElement(this.root, "fileinfo");
            if (element != null && (element = this.getSingleElement(element, "streamdetails")) != null) {
                this.fileinfo = new Fileinfo();
                for (Element child : element.children()) {
                    switch (child.tagName().toLowerCase(Locale.ROOT)) {
                        case "video": {
                            Video video = this.parseVideo(child);
                            if (video == null) break;
                            this.fileinfo.videos.add(video);
                            break;
                        }
                        case "audio": {
                            Audio audio = this.parseAudio(child);
                            if (audio == null) break;
                            this.fileinfo.audios.add(audio);
                            break;
                        }
                        case "subtitle": {
                            Subtitle subtitle = this.parseSubtitle(child);
                            if (subtitle == null) break;
                            this.fileinfo.subtitles.add(subtitle);
                        }
                    }
                }
            }
            return null;
        }

        private Video parseVideo(Element element) {
            Video video = new Video();
            for (Element child : element.children()) {
                switch (child.tagName().toLowerCase(Locale.ROOT)) {
                    case "codec": {
                        video.codec = child.ownText();
                        break;
                    }
                    case "aspect": {
                        try {
                            video.aspect = Float.parseFloat(child.ownText());
                        }
                        catch (NumberFormatException numberFormatException) {}
                        break;
                    }
                    case "width": {
                        try {
                            video.width = MetadataUtil.parseInt(child.ownText());
                        }
                        catch (NumberFormatException numberFormatException) {}
                        break;
                    }
                    case "height": {
                        try {
                            video.height = MetadataUtil.parseInt(child.ownText());
                        }
                        catch (NumberFormatException numberFormatException) {}
                        break;
                    }
                    case "durationinseconds": {
                        try {
                            video.durationinseconds = MetadataUtil.parseInt(child.ownText());
                        }
                        catch (NumberFormatException numberFormatException) {}
                        break;
                    }
                    case "stereomode": {
                        video.stereomode = child.ownText();
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)video.codec)) {
                return video;
            }
            return null;
        }

        private Audio parseAudio(Element element) {
            Audio audio = new Audio();
            for (Element child : element.children()) {
                switch (child.tagName().toLowerCase(Locale.ROOT)) {
                    case "codec": {
                        audio.codec = child.ownText();
                        break;
                    }
                    case "language": {
                        audio.language = child.ownText();
                        break;
                    }
                    case "channels": {
                        try {
                            audio.channels = MetadataUtil.parseInt(child.ownText());
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)audio.codec)) {
                return audio;
            }
            return null;
        }

        private Subtitle parseSubtitle(Element element) {
            Subtitle subtitle = new Subtitle();
            for (Element child : element.children()) {
                switch (child.tagName().toLowerCase(Locale.ROOT)) {
                    case "language": {
                        subtitle.language = child.ownText();
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)subtitle.language)) {
                return subtitle;
            }
            return null;
        }

        private Void parseSource() {
            this.supportedElements.add("source");
            Element element = this.getSingleElement(this.root, "source");
            if (element != null) {
                try {
                    this.source = MediaSource.getMediaSource(element.ownText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        private Void parseOriginalFilename() {
            this.supportedElements.add("original_filename");
            Element element = this.getSingleElement(this.root, "original_filename");
            if (element != null) {
                this.originalFileName = element.ownText();
            }
            return null;
        }

        private Void parseTrailer() {
            this.supportedElements.add("trailer");
            Element element = this.getSingleElement(this.root, "trailer");
            if (element != null) {
                Pattern pattern = Pattern.compile("plugin://plugin.video.youtube/\\?action=play_video&videoid=(.*)$");
                Matcher matcher = pattern.matcher(element.ownText());
                if (matcher.matches()) {
                    this.trailer = "http://www.youtube.com/watch?v=" + matcher.group(1);
                } else {
                    pattern = Pattern.compile("plugin://plugin.video.hdtrailers_net/video/.*\\?/(.*)$");
                    matcher = pattern.matcher(element.ownText());
                    if (matcher.matches()) {
                        try {
                            this.trailer = URLDecoder.decode(matcher.group(1), "UTF-8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)element.ownText()) && element.ownText().matches("https?://.*")) {
                    this.trailer = element.ownText();
                }
            }
            return null;
        }

        private Void parseEpbookmark() {
            this.supportedElements.add("epbookmark");
            Element element = this.getSingleElement(this.root, "epbookmark");
            if (element != null) {
                this.epbookmark = element.ownText();
            }
            return null;
        }

        private Void parseLastplayed() {
            this.supportedElements.add("lastplayed");
            Element element = this.getSingleElement(this.root, "lastplayed");
            if (element != null) {
                try {
                    Date date = StrgUtils.parseDate(element.ownText());
                    if (date != null) {
                        this.lastplayed = date;
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return null;
        }

        private Void parseCode() {
            this.supportedElements.add("code");
            Element element = this.getSingleElement(this.root, "code");
            if (element != null) {
                this.code = element.ownText();
            }
            return null;
        }

        private Void parseEpisodenumberend() {
            this.supportedElements.add("episodenumberend");
            Element element = this.getSingleElement(this.root, "episodenumberend");
            if (element != null) {
                this.episodenumberend = element.ownText();
            }
            return null;
        }

        private Void parseDateadded() {
            this.supportedElements.add("dateadded");
            Element element = this.getSingleElement(this.root, "dateadded");
            if (element != null) {
                try {
                    Date date = StrgUtils.parseDate(element.ownText());
                    if (date != null) {
                        this.dateadded = date;
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return null;
        }

        private Void findUnsupportedElements() {
            this.supportedElements.add("lockdata");
            for (Element element : this.root.children()) {
                if (IGNORE.contains(element.tagName()) || this.supportedElements.contains(element.tagName())) continue;
                String elementText = element.toString().replaceAll(">\\r?\\n\\s*<", "><");
                this.unsupportedElements.add(elementText);
            }
            return null;
        }

        private Void parseUserNote() {
            this.supportedElements.add("user_note");
            Element element = this.getSingleElement(this.root, "user_note");
            if (element != null) {
                this.userNote = element.ownText();
            }
            return null;
        }

        public TvShowEpisode toTvShowEpisode() {
            TvShowEpisode episode = new TvShowEpisode();
            episode.setTitle(this.title);
            episode.setOriginalTitle(this.originaltitle);
            episode.setSeason(this.season);
            episode.setEpisode(this.episode);
            episode.setDisplayEpisode(this.displayepisode);
            episode.setDisplaySeason(this.displayseason);
            for (Map.Entry<String, Rating> entry : this.ratings.entrySet()) {
                Rating r = entry.getValue();
                episode.setRating(new MediaRating(r.id, r.rating, r.votes, r.maxValue));
            }
            episode.setYear(this.year);
            episode.setFirstAired(this.releaseDate);
            if (this.dateadded != null) {
                episode.setDateAdded(this.dateadded);
            }
            episode.setPlot(this.plot);
            if (!this.thumbs.isEmpty()) {
                episode.setArtworkUrl(this.thumbs.get(0), MediaFileType.THUMB);
            }
            for (Map.Entry<String, Object> entry : this.ids.entrySet()) {
                episode.setId(entry.getKey(), entry.getValue());
            }
            String studio = StringUtils.join(this.studios, (String)" / ");
            if (studio == null) {
                episode.setProductionCompany("");
            } else {
                episode.setProductionCompany(studio);
            }
            episode.setWatched(this.watched);
            episode.setPlaycount(this.playcount);
            episode.setLastWatched(this.lastplayed);
            episode.setMediaSource(this.source);
            ArrayList<org.tinymediamanager.core.entities.Person> arrayList = new ArrayList<org.tinymediamanager.core.entities.Person>();
            for (Person person : this.actors) {
                arrayList.add(this.morphPerson(Person.Type.ACTOR, person));
            }
            episode.addToActors(arrayList);
            ArrayList<org.tinymediamanager.core.entities.Person> newDirectors = new ArrayList<org.tinymediamanager.core.entities.Person>();
            for (Person director : this.directors) {
                if (StringUtils.isBlank((CharSequence)director.role)) {
                    director.role = "Director";
                }
                newDirectors.add(this.morphPerson(Person.Type.DIRECTOR, director));
            }
            episode.addToDirectors(newDirectors);
            ArrayList<org.tinymediamanager.core.entities.Person> arrayList2 = new ArrayList<org.tinymediamanager.core.entities.Person>();
            for (Person writer : this.credits) {
                if (StringUtils.isBlank((CharSequence)writer.role)) {
                    writer.role = "Writer";
                }
                arrayList2.add(this.morphPerson(Person.Type.WRITER, writer));
            }
            episode.addToWriters(arrayList2);
            episode.addToTags(this.tags);
            episode.setOriginalFilename(this.originalFileName);
            episode.setNote(this.userNote);
            return episode;
        }

        private org.tinymediamanager.core.entities.Person morphPerson(Person.Type type, Person nfoPerson) {
            int tvdbId;
            org.tinymediamanager.core.entities.Person person = new org.tinymediamanager.core.entities.Person(type);
            person.setName(nfoPerson.name);
            person.setRole(nfoPerson.role);
            person.setThumbUrl(nfoPerson.thumb);
            person.setProfileUrl(nfoPerson.profile);
            int tmdbId = MetadataUtil.parseInt(nfoPerson.tmdbId, 0);
            if (tmdbId > 0) {
                person.setId("tmdb", tmdbId);
            }
            if (StringUtils.isNotBlank((CharSequence)nfoPerson.imdbId)) {
                person.setId("imdb", nfoPerson.imdbId);
            }
            if ((tvdbId = MetadataUtil.parseInt(nfoPerson.tvdbId, 0)) > 0) {
                person.setId("tvdb", tvdbId);
            }
            return person;
        }
    }
}

