/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.connector;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.tvshow.connector.TvShowGenericXmlConnector;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.w3c.dom.Element;

public class TvShowToXbmcConnector
extends TvShowGenericXmlConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowToXbmcConnector.class);

    public TvShowToXbmcConnector(TvShow tvShow) {
        super(tvShow);
    }

    @Override
    protected void addOwnTags() {
    }

    @Override
    protected void addTrailer() {
        Element trailer = this.document.createElement("trailer");
        for (MediaTrailer mediaTrailer : new ArrayList<MediaTrailer>(this.tvShow.getTrailer())) {
            if (!mediaTrailer.getInNfo().booleanValue() || !mediaTrailer.getUrl().startsWith("http")) continue;
            trailer.setTextContent(this.prepareTrailerForXbmc(mediaTrailer));
            break;
        }
        this.root.appendChild(trailer);
    }

    private String prepareTrailerForXbmc(MediaTrailer trailer) {
        Pattern pattern = Pattern.compile("https{0,1}://.*youtube..*/watch\\?v=(.*)$");
        Matcher matcher = pattern.matcher(trailer.getUrl());
        if (matcher.matches()) {
            return "plugin://plugin.video.youtube/?action=play_video&videoid=" + matcher.group(1);
        }
        pattern = Pattern.compile("https{0,1}://.*(apple.com|yahoo-redir|yahoo.com|youtube.com|moviefone.com|ign.com|hd-trailers.net|aol.com).*");
        matcher = pattern.matcher(trailer.getUrl());
        if (matcher.matches()) {
            try {
                return "plugin://plugin.video.hdtrailers_net/video/" + matcher.group(1) + "/" + URLEncoder.encode(trailer.getUrl(), "UTF-8");
            }
            catch (Exception e) {
                LOGGER.error("failed to escape '{}'", (Object)trailer.getUrl());
            }
        }
        return trailer.getUrl();
    }
}

