/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.entities;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.IMediaInformation;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.MediaAiredStatus;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.TmmDateFormat;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.TrailerQuality;
import org.tinymediamanager.core.TrailerSources;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.MediaSource;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskChain;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowArtworkHelper;
import org.tinymediamanager.core.tvshow.TvShowHelpers;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowMediaFileComparator;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowRenamer;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.connector.TvShowGenericXmlConnector;
import org.tinymediamanager.core.tvshow.connector.TvShowToEmbyConnector;
import org.tinymediamanager.core.tvshow.connector.TvShowToKodiConnector;
import org.tinymediamanager.core.tvshow.connector.TvShowToXbmcConnector;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.core.tvshow.filenaming.TvShowNfoNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowTrailerNaming;
import org.tinymediamanager.core.tvshow.tasks.TvShowActorImageFetcherTask;
import org.tinymediamanager.core.tvshow.tasks.TvShowRenameTask;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MapUtils;
import org.tinymediamanager.scraper.util.StrgUtils;

public class TvShow
extends MediaEntity
implements IMediaInformation {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShow.class);
    private static final Comparator<MediaFile> MEDIA_FILE_COMPARATOR = new TvShowMediaFileComparator();
    public static final Pattern SEASON_ONLY_PATTERN = Pattern.compile("^(s|staffel|season|series)[\\s_.-]*(\\d{1,4})$", 2);
    @JsonProperty
    private int runtime = 0;
    @JsonProperty
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private Date firstAired = null;
    @JsonProperty
    private MediaAiredStatus status = MediaAiredStatus.UNKNOWN;
    @JsonProperty
    private String sortTitle = "";
    @JsonProperty
    private MediaCertification certification = MediaCertification.UNKNOWN;
    @JsonProperty
    private String country = "";
    @JsonProperty
    private final List<MediaGenres> genres = new CopyOnWriteArrayList<MediaGenres>();
    @JsonProperty
    private final Map<Integer, String> seasonTitleMap = new HashMap<Integer, String>(0);
    @JsonProperty
    private final Map<Integer, String> seasonPosterUrlMap = new HashMap<Integer, String>(0);
    @JsonProperty
    private final Map<Integer, String> seasonFanartUrlMap = new HashMap<Integer, String>(0);
    @JsonProperty
    private final Map<Integer, String> seasonBannerUrlMap = new HashMap<Integer, String>(0);
    @JsonProperty
    private final Map<Integer, String> seasonThumbUrlMap = new HashMap<Integer, String>(0);
    @JsonProperty
    private final List<Person> actors = new CopyOnWriteArrayList<Person>();
    @JsonProperty
    private final List<TvShowEpisode> dummyEpisodes = new CopyOnWriteArrayList<TvShowEpisode>();
    @JsonProperty
    private final List<String> extraFanartUrls = new CopyOnWriteArrayList<String>();
    @JsonProperty
    private final List<MediaTrailer> trailer = new CopyOnWriteArrayList<MediaTrailer>();
    private final List<TvShowEpisode> episodes = new CopyOnWriteArrayList<TvShowEpisode>();
    private final Map<Integer, MediaFile> seasonPosters = new HashMap<Integer, MediaFile>(0);
    private final Map<Integer, MediaFile> seasonFanarts = new HashMap<Integer, MediaFile>(0);
    private final Map<Integer, MediaFile> seasonBanners = new HashMap<Integer, MediaFile>(0);
    private final Map<Integer, MediaFile> seasonThumbs = new HashMap<Integer, MediaFile>(0);
    private final List<TvShowSeason> seasons = new CopyOnWriteArrayList<TvShowSeason>();
    private String titleSortable = "";
    private String otherIds = "";
    private Date lastWatched = null;
    private final PropertyChangeListener propertyChangeListener = evt -> {
        if (evt.getSource() instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)evt.getSource();
            switch (evt.getPropertyName()) {
                case "tags": 
                case "mediaInformation": 
                case "mediaFiles": 
                case "subtitles": 
                case "hasSubtitles": {
                    this.firePropertyChange(evt);
                    break;
                }
                case "season": {
                    for (TvShowSeason season : this.seasons) {
                        if (!season.getEpisodes().contains(episode) || season.getSeason() == episode.getSeason()) continue;
                        season.removeEpisode(episode);
                    }
                    this.addToSeason(episode);
                }
            }
        }
    };
    private static final Comparator<MediaTrailer> TRAILER_QUALITY_COMPARATOR = new MediaTrailer.QualityComparator();

    @Override
    protected Comparator<MediaFile> getMediaFileComparator() {
        return MEDIA_FILE_COMPARATOR;
    }

    @Override
    public void setId(String key, Object value) {
        super.setId(key, value);
        this.otherIds = "";
        this.firePropertyChange("otherIds", null, key + ":" + value);
    }

    public String getOtherIds() {
        if (StringUtils.isNotBlank((CharSequence)this.otherIds)) {
            return this.otherIds;
        }
        block12: for (Map.Entry<String, Object> entry : this.getIds().entrySet()) {
            switch (entry.getKey()) {
                case "tvdb": 
                case "imdb": 
                case "tmdb": {
                    continue block12;
                }
                case "imdbId": 
                case "traktId": 
                case "tvShowSeason": {
                    continue block12;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)this.otherIds)) {
                this.otherIds = this.otherIds + "; ";
            }
            this.otherIds = this.otherIds + entry.getKey() + ": " + entry.getValue();
        }
        return this.otherIds;
    }

    @Override
    public void initializeAfterLoading() {
        super.initializeAfterLoading();
        for (TvShowEpisode episode : this.dummyEpisodes) {
            episode.setTvShow(this);
            if (episode.getSeason() <= 0 && !TvShowModuleManager.getInstance().getSettings().isDisplayMissingSpecials() || !TvShowModuleManager.getInstance().getSettings().isDisplayMissingEpisodes()) continue;
            this.addToSeason(episode);
        }
        for (MediaFile mf : this.getMediaFiles(MediaFileType.SEASON_POSTER, MediaFileType.SEASON_BANNER, MediaFileType.SEASON_THUMB, MediaFileType.SEASON_FANART)) {
            if (mf.getFilesize() == 0L) continue;
            try {
                String foldername = this.getPathNIO().relativize(mf.getFileAsPath().getParent()).toString();
                int season = TvShowHelpers.detectSeasonFromFileAndFolder(mf.getFilename(), foldername);
                if (season == Integer.MIN_VALUE) {
                    throw new IllegalStateException("did not find a season number");
                }
                switch (mf.getType()) {
                    case SEASON_POSTER: {
                        this.seasonPosters.put(season, mf);
                        break;
                    }
                    case SEASON_FANART: {
                        this.seasonFanarts.put(season, mf);
                        break;
                    }
                    case SEASON_BANNER: {
                        this.seasonBanners.put(season, mf);
                        break;
                    }
                    case SEASON_THUMB: {
                        this.seasonThumbs.put(season, mf);
                        break;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn("could not parse season number: {} MF: {}", (Object)e.getMessage(), (Object)mf.getFileAsPath().toAbsolutePath());
            }
        }
        for (TvShowEpisode episode : this.episodes) {
            episode.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    public void merge(TvShow other) {
        this.merge(other, false);
    }

    public void forceMerge(TvShow other) {
        this.merge(other, true);
    }

    void merge(TvShow other, boolean force) {
        if (this.locked || other == null) {
            return;
        }
        super.merge(other, force);
        this.setSortTitle(StringUtils.isEmpty((CharSequence)this.sortTitle) || force ? other.sortTitle : this.sortTitle);
        this.setRuntime(this.runtime == 0 || force ? other.runtime : this.runtime);
        this.setFirstAired(this.firstAired == null || force ? other.firstAired : this.firstAired);
        this.setStatus(this.status == MediaAiredStatus.UNKNOWN || force ? other.status : this.status);
        this.setCertification(this.certification == MediaCertification.NOT_RATED || force ? other.certification : this.certification);
        this.setCountry(StringUtils.isEmpty((CharSequence)this.country) || force ? other.country : this.country);
        if (force) {
            this.genres.clear();
            this.actors.clear();
            this.extraFanartUrls.clear();
            this.seasonTitleMap.clear();
            this.seasonPosterUrlMap.clear();
            this.seasonFanartUrlMap.clear();
            this.seasonBannerUrlMap.clear();
            this.seasonThumbUrlMap.clear();
        }
        this.setGenres(other.genres);
        this.setActors(other.actors);
        this.setExtraFanartUrls(other.extraFanartUrls);
        for (Integer season : other.seasonTitleMap.keySet()) {
            this.seasonTitleMap.putIfAbsent(season, other.seasonTitleMap.get(season));
        }
        for (Integer season : other.seasonPosterUrlMap.keySet()) {
            this.seasonPosterUrlMap.putIfAbsent(season, other.seasonPosterUrlMap.get(season));
        }
        for (Integer season : other.seasonFanartUrlMap.keySet()) {
            this.seasonFanartUrlMap.putIfAbsent(season, other.seasonFanartUrlMap.get(season));
        }
        for (Integer season : other.seasonBannerUrlMap.keySet()) {
            this.seasonBannerUrlMap.putIfAbsent(season, other.seasonBannerUrlMap.get(season));
        }
        for (Integer season : other.seasonThumbUrlMap.keySet()) {
            this.seasonThumbUrlMap.putIfAbsent(season, other.seasonThumbUrlMap.get(season));
        }
        for (TvShowEpisode ep : this.episodes) {
            TvShowEpisode otherEP = other.getEpisode(ep.getSeason(), ep.getEpisode()).stream().findFirst().orElse(null);
            ep.merge(otherEP, force);
        }
        for (TvShowEpisode otherEp : other.getEpisodes()) {
            TvShowEpisode ourEP = this.getEpisode(otherEp.getSeason(), otherEp.getEpisode()).stream().findFirst().orElse(null);
            if (ourEP != null) continue;
            TvShowEpisode clone = new TvShowEpisode(otherEp);
            clone.setTvShow(this);
            this.addEpisode(clone);
        }
    }

    @Override
    public void addToMediaFiles(MediaFile mediaFile) {
        super.addToMediaFiles(mediaFile);
        if (mediaFile.getType() == MediaFileType.TRAILER) {
            this.mixinLocalTrailers();
        }
    }

    @Override
    public void setTitle(String newValue) {
        super.setTitle(newValue);
        String oldValue = this.titleSortable;
        this.titleSortable = "";
        this.firePropertyChange("titleSortable", oldValue, this.titleSortable);
    }

    public String getTitleSortable() {
        if (StringUtils.isEmpty((CharSequence)this.titleSortable)) {
            this.titleSortable = Utils.getSortableName(this.getTitle());
        }
        return this.titleSortable;
    }

    public void clearTitleSortable() {
        this.titleSortable = "";
    }

    public String getSortTitle() {
        return this.sortTitle;
    }

    public void setSortTitle(String newValue) {
        String oldValue = this.sortTitle;
        this.sortTitle = newValue;
        this.firePropertyChange("sortTitle", oldValue, newValue);
    }

    @Override
    public MediaRating getRating() {
        MediaRating mediaRating = (MediaRating)this.ratings.get(TvShowModuleManager.getInstance().getSettings().getPreferredRating());
        if (mediaRating == null) {
            mediaRating = MediaMetadata.EMPTY_RATING;
        }
        return mediaRating;
    }

    public List<TvShowEpisode> getEpisodes() {
        return this.episodes;
    }

    public synchronized void addEpisode(TvShowEpisode episode) {
        int oldValue = this.episodes.size();
        this.episodes.add(episode);
        episode.addPropertyChangeListener(this.propertyChangeListener);
        this.addToSeason(episode);
        this.episodes.sort(TvShowEpisode::compareTo);
        this.firePropertyChange("addedEpisode", null, episode);
        this.firePropertyChange("episodeCount", oldValue, this.episodes.size());
    }

    public List<TvShowEpisode> getDummyEpisodes() {
        return this.dummyEpisodes;
    }

    public void setDummyEpisodes(List<TvShowEpisode> dummyEpisodes) {
        for (TvShowEpisode episode : this.dummyEpisodes) {
            this.firePropertyChange("removedEpisode", null, episode);
        }
        this.dummyEpisodes.clear();
        this.dummyEpisodes.addAll(dummyEpisodes);
        for (TvShowEpisode dummy : this.dummyEpisodes) {
            dummy.setTvShow(this);
        }
        if (TvShowModuleManager.getInstance().getSettings().isDisplayMissingEpisodes()) {
            for (TvShowEpisode episode : dummyEpisodes) {
                if (episode.getSeason() <= 0 && !TvShowModuleManager.getInstance().getSettings().isDisplayMissingSpecials()) continue;
                TvShowSeason season = this.getSeasonForEpisode(episode);
                boolean found = false;
                for (TvShowEpisode e : season.getEpisodesForDisplay()) {
                    if (e.isDummy() || (e.getSeason() != episode.getSeason() || e.getEpisode() != episode.getEpisode()) && (e.getDvdSeason() <= 0 || e.getDvdSeason() != episode.getDvdSeason() || e.getDvdEpisode() != episode.getDvdEpisode())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                season.addEpisode(episode);
                this.firePropertyChange("addedEpisode", null, episode);
            }
        }
        this.dummyEpisodes.sort(TvShowEpisode::compareTo);
        this.firePropertyChange("dummyEpisodes", null, dummyEpisodes);
        this.firePropertyChange("episodeCount", 0, this.episodes.size());
    }

    public List<TvShowEpisode> getEpisodesForDisplay() {
        ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>(this.getEpisodes());
        if (TvShowModuleManager.getInstance().getSettings().isDisplayMissingEpisodes()) {
            HashSet<CallSite> availableEpisodes = new HashSet<CallSite>();
            for (TvShowEpisode episode : episodes) {
                if (episode.getSeason() > -1 && episode.getEpisode() > -1) {
                    availableEpisodes.add((CallSite)((Object)("A" + episode.getSeason() + "." + episode.getEpisode())));
                }
                if (episode.getDvdSeason() <= -1 || episode.getDvdEpisode() <= -1) continue;
                availableEpisodes.add((CallSite)((Object)("D" + episode.getSeason() + "." + episode.getEpisode())));
            }
            for (TvShowEpisode episode : this.getDummyEpisodes()) {
                if (episode.getSeason() <= 0 && !TvShowModuleManager.getInstance().getSettings().isDisplayMissingSpecials() || availableEpisodes.contains("A" + episode.getSeason() + "." + episode.getEpisode()) || availableEpisodes.contains("D" + episode.getDvdSeason() + "." + episode.getDvdEpisode())) continue;
                episodes.add(episode);
            }
        }
        return episodes;
    }

    public List<TvShowEpisode> getEpisodesForSeason(int season) {
        return this.episodes.stream().filter(episode -> episode.getSeason() == season).collect(Collectors.toList());
    }

    public int getEpisodeCount() {
        return this.episodes.size();
    }

    public int getDummyEpisodeCount() {
        int count = 0;
        for (TvShowSeason season : this.seasons) {
            for (TvShowEpisode episode : season.getEpisodesForDisplay()) {
                if (!episode.isDummy() || episode.getSeason() <= 0 && !TvShowModuleManager.getInstance().getSettings().isDisplayMissingSpecials()) continue;
                ++count;
            }
        }
        return count;
    }

    private void addToSeason(TvShowEpisode episode) {
        TvShowSeason season = this.getSeasonForEpisode(episode);
        season.addEpisode(episode);
    }

    private void removeFromSeason(TvShowEpisode episode) {
        TvShowSeason season = this.getSeasonForEpisode(episode);
        season.removeEpisode(episode);
    }

    public synchronized TvShowSeason getSeasonForEpisode(TvShowEpisode episode) {
        TvShowSeason season = null;
        for (TvShowSeason s : this.seasons) {
            if (s.getSeason() != episode.getSeason()) continue;
            season = s;
            break;
        }
        if (season == null) {
            int oldValue = this.seasons.size();
            season = new TvShowSeason(episode.getSeason(), this);
            String seasonTitle = this.seasonTitleMap.get(episode.getSeason());
            if (StringUtils.isNotBlank((CharSequence)seasonTitle)) {
                season.setTitle(seasonTitle);
            }
            this.seasons.add(season);
            this.firePropertyChange("addedSeason", null, season);
            this.firePropertyChange("seasonCount", oldValue, this.seasons.size());
        }
        return season;
    }

    public int getSeasonCount() {
        int count = 0;
        for (TvShowSeason season : this.seasons) {
            if (season.isDummy()) continue;
            ++count;
        }
        return count;
    }

    public TvShowSeason getSeason(int seasonNumber) {
        for (TvShowSeason season : this.seasons) {
            if (season.getSeason() != seasonNumber) continue;
            return season;
        }
        return null;
    }

    public void removeEpisode(TvShowEpisode episode) {
        if (this.episodes.contains(episode)) {
            int oldValue = this.episodes.size();
            episode.removePropertyChangeListener(this.propertyChangeListener);
            this.removeFromSeason(episode);
            this.episodes.remove(episode);
            TvShowModuleManager.getInstance().getTvShowList().removeEpisodeFromDb(episode);
            for (MediaFile mf : episode.getMediaFiles()) {
                if (!mf.isGraphic()) continue;
                ImageCache.invalidateCachedImage(mf);
            }
            this.saveToDb();
            this.firePropertyChange("removedEpisode", null, episode);
            this.firePropertyChange("episodeCount", oldValue, this.episodes.size());
            if (TvShowModuleManager.getInstance().getSettings().isDisplayMissingEpisodes() && ListUtils.isEmpty(this.getEpisode(episode.getSeason(), episode.getEpisode()))) {
                for (TvShowEpisode dummy : this.dummyEpisodes) {
                    if (dummy.getSeason() <= 0 && !TvShowModuleManager.getInstance().getSettings().isDisplayMissingSpecials() || dummy.getSeason() != episode.getSeason() || dummy.getEpisode() != episode.getEpisode()) continue;
                    this.addToSeason(dummy);
                    this.firePropertyChange("addedEpisode", null, dummy);
                    break;
                }
            }
        } else if (this.dummyEpisodes.contains(episode)) {
            this.removeFromSeason(episode);
            this.firePropertyChange("removedEpisode", null, episode);
            this.firePropertyChange("episodeCount", 0, this.episodes.size());
        }
    }

    public void deleteEpisode(TvShowEpisode episode) {
        if (this.episodes.contains(episode)) {
            int oldValue = this.episodes.size();
            episode.removePropertyChangeListener(this.propertyChangeListener);
            episode.deleteFilesSafely();
            this.removeFromSeason(episode);
            this.episodes.remove(episode);
            TvShowModuleManager.getInstance().getTvShowList().removeEpisodeFromDb(episode);
            for (MediaFile mf : episode.getMediaFiles()) {
                if (!mf.isGraphic()) continue;
                ImageCache.invalidateCachedImage(mf);
            }
            this.saveToDb();
            this.firePropertyChange("removedEpisode", null, episode);
            this.firePropertyChange("episodeCount", oldValue, this.episodes.size());
        }
    }

    public List<TvShowSeason> getSeasons() {
        return this.seasons;
    }

    public List<MediaGenres> getGenres() {
        return this.genres;
    }

    public void addToGenres(Collection<MediaGenres> newGenres) {
        LinkedHashSet<MediaGenres> newItems = new LinkedHashSet<MediaGenres>();
        for (MediaGenres genre : ListUtils.nullSafe(newGenres)) {
            if (genre == null || this.genres.contains(genre)) continue;
            newItems.add(genre);
        }
        if (newItems.isEmpty()) {
            return;
        }
        this.genres.addAll(newItems);
        this.firePropertyChange("genre", null, newGenres);
        this.firePropertyChange("genresAsString", null, newGenres);
    }

    @JsonSetter
    public void setGenres(List<MediaGenres> newGenres) {
        ListUtils.mergeLists(this.genres, newGenres);
        this.firePropertyChange("genre", null, this.genres);
        this.firePropertyChange("genresAsString", null, this.genres);
    }

    public void removeGenre(MediaGenres genre) {
        if (this.genres.contains(genre)) {
            this.genres.remove(genre);
            this.firePropertyChange("genre", null, genre);
            this.firePropertyChange("genresAsString", null, genre);
        }
    }

    public void removeAllGenres() {
        this.genres.clear();
        this.firePropertyChange("genre", null, this.genres);
        this.firePropertyChange("genresAsString", null, this.genres);
    }

    public String getGenresAsString() {
        StringBuilder sb = new StringBuilder();
        for (MediaGenres genre : this.genres) {
            if (!StringUtils.isEmpty((CharSequence)sb)) {
                sb.append(", ");
            }
            sb.append(genre != null ? genre.getLocalizedName() : "null");
        }
        return sb.toString();
    }

    public void setMetadata(MediaMetadata metadata, List<TvShowScraperMetadataConfig> config, boolean overwriteExistingItems) {
        if (this.locked) {
            LOGGER.debug("TV show locked, but setMetadata has been called!");
            return;
        }
        if (metadata == null) {
            LOGGER.error("metadata was null");
            return;
        }
        if (metadata.getIds().isEmpty()) {
            LOGGER.warn("wanted to save empty metadata for {}", (Object)this.getTitle());
            return;
        }
        boolean matchFound = false;
        for (Map.Entry<String, Object> entry : metadata.getIds().entrySet()) {
            if (entry.getValue() == null || !entry.getValue().equals(this.getId(entry.getKey()))) continue;
            matchFound = true;
            break;
        }
        if (!matchFound && overwriteExistingItems) {
            this.ids.clear();
        }
        if (overwriteExistingItems) {
            this.setIds(metadata.getIds());
        } else {
            for (Map.Entry<String, Object> entry : metadata.getIds().entrySet()) {
                if (this.ids.containsKey(entry.getKey())) continue;
                this.setId(entry.getKey(), entry.getValue());
            }
        }
        if (config.contains(TvShowScraperMetadataConfig.TITLE) && StringUtils.isNotBlank((CharSequence)metadata.getTitle()) && (overwriteExistingItems || StringUtils.isBlank((CharSequence)this.getTitle()))) {
            if (TvShowModuleManager.getInstance().getSettings().getCapitalWordsInTitles()) {
                this.setTitle(WordUtils.capitalize((String)metadata.getTitle()));
            } else {
                this.setTitle(metadata.getTitle());
            }
        }
        if (config.contains(TvShowScraperMetadataConfig.ORIGINAL_TITLE) && (overwriteExistingItems || StringUtils.isBlank((CharSequence)this.getOriginalTitle()))) {
            if (TvShowModuleManager.getInstance().getSettings().getCapitalWordsInTitles()) {
                this.setOriginalTitle(WordUtils.capitalize((String)metadata.getOriginalTitle()));
            } else {
                this.setOriginalTitle(metadata.getOriginalTitle());
            }
        }
        if (config.contains(TvShowScraperMetadataConfig.PLOT) && (overwriteExistingItems || StringUtils.isBlank((CharSequence)this.getPlot()))) {
            this.setPlot(metadata.getPlot());
        }
        if (config.contains(TvShowScraperMetadataConfig.YEAR) && (overwriteExistingItems || this.getYear() <= 0)) {
            this.setYear(metadata.getYear());
        }
        if (config.contains(TvShowScraperMetadataConfig.RATING)) {
            HashMap<String, MediaRating> newRatings = new HashMap<String, MediaRating>();
            if (matchFound || !overwriteExistingItems) {
                newRatings.putAll(this.getRatings());
            }
            for (MediaRating mediaRating : metadata.getRatings()) {
                if (overwriteExistingItems) {
                    newRatings.put(mediaRating.getId(), mediaRating);
                    continue;
                }
                newRatings.putIfAbsent(mediaRating.getId(), mediaRating);
            }
            this.setRatings(newRatings);
        }
        if (config.contains(TvShowScraperMetadataConfig.AIRED) && (overwriteExistingItems || this.getFirstAired() == null)) {
            this.setFirstAired(metadata.getReleaseDate());
        }
        if (config.contains(TvShowScraperMetadataConfig.STATUS) && (overwriteExistingItems || this.getStatus() == null || this.getStatus() == MediaAiredStatus.UNKNOWN)) {
            this.setStatus(metadata.getStatus());
        }
        if (config.contains(TvShowScraperMetadataConfig.RUNTIME) && (overwriteExistingItems || this.getRuntime() <= 0)) {
            this.setRuntime(metadata.getRuntime());
        }
        if (config.contains(TvShowScraperMetadataConfig.COUNTRY) && (overwriteExistingItems || StringUtils.isBlank((CharSequence)this.getCountry()))) {
            this.setCountry(StringUtils.join(metadata.getCountries(), (String)", "));
        }
        if (config.contains(TvShowScraperMetadataConfig.STUDIO) && (overwriteExistingItems || StringUtils.isBlank((CharSequence)this.getProductionCompany()))) {
            this.setProductionCompany(StringUtils.join(metadata.getProductionCompanies(), (String)", "));
        }
        if (config.contains(TvShowScraperMetadataConfig.CERTIFICATION) && (overwriteExistingItems || this.getCertification() == null || this.getCertification() == MediaCertification.UNKNOWN) && !metadata.getCertifications().isEmpty()) {
            if (metadata.getCertifications().size() > 1) {
                if (!metadata.getCertifications().get(0).name().startsWith("US_TV")) {
                    this.setCertification(metadata.getCertifications().get(1));
                } else {
                    this.setCertification(metadata.getCertifications().get(0));
                }
            } else {
                this.setCertification(metadata.getCertifications().get(0));
            }
        }
        if (config.contains(TvShowScraperMetadataConfig.ACTORS)) {
            if (!matchFound || overwriteExistingItems) {
                this.actors.clear();
            }
            this.setActors(metadata.getCastMembers(Person.Type.ACTOR));
        }
        if (config.contains(TvShowScraperMetadataConfig.GENRES)) {
            if (!matchFound || overwriteExistingItems) {
                this.genres.clear();
            }
            this.setGenres(metadata.getGenres());
        }
        if (config.contains(TvShowScraperMetadataConfig.TAGS)) {
            if (!matchFound || overwriteExistingItems) {
                this.removeAllTags();
            }
            this.addToTags(metadata.getTags());
        }
        if (config.contains(TvShowScraperMetadataConfig.SEASON_NAMES)) {
            for (Map.Entry<Object, Object> entry : metadata.getSeasonNames().entrySet()) {
                Matcher matcher = SEASON_ONLY_PATTERN.matcher((CharSequence)entry.getValue());
                if (matcher.find()) continue;
                if (overwriteExistingItems) {
                    this.seasonTitleMap.put((Integer)entry.getKey(), (String)entry.getValue());
                    continue;
                }
                this.seasonTitleMap.putIfAbsent((Integer)entry.getKey(), (String)entry.getValue());
            }
            for (TvShowSeason tvShowSeason : this.getSeasons()) {
                String seasonTitle;
                if (tvShowSeason.isDummy() || !StringUtils.isNotBlank((CharSequence)(seasonTitle = this.seasonTitleMap.get(tvShowSeason.getSeason()))) || !StringUtils.isBlank((CharSequence)tvShowSeason.getTitle()) && !overwriteExistingItems) continue;
                tvShowSeason.setTitle(seasonTitle);
            }
        }
        this.writeNFO();
        this.saveToDb();
        this.postProcess(config, overwriteExistingItems);
    }

    public void setArtwork(List<MediaArtwork> artwork, List<TvShowScraperMetadataConfig> config, boolean overwrite) {
        TvShowArtworkHelper.setArtwork(this, artwork, config, overwrite);
    }

    public void downloadArtwork(MediaFileType type) {
        TvShowArtworkHelper.downloadArtwork(this, type);
    }

    public void downloadSeasonArtwork(int season, MediaArtwork.MediaArtworkType artworkType) {
        TvShowArtworkHelper.downloadSeasonArtwork(this, season, artworkType);
    }

    public void writeNFO() {
        TvShowGenericXmlConnector connector;
        List<TvShowNfoNaming> nfoNamings = TvShowModuleManager.getInstance().getSettings().getNfoFilenames();
        if (nfoNamings.isEmpty()) {
            return;
        }
        switch (TvShowModuleManager.getInstance().getSettings().getTvShowConnector()) {
            case XBMC: 
            case MEDIAPORTAL: {
                connector = new TvShowToXbmcConnector(this);
                break;
            }
            case EMBY: {
                connector = new TvShowToEmbyConnector(this);
                break;
            }
            default: {
                connector = new TvShowToKodiConnector(this);
            }
        }
        try {
            connector.write(nfoNamings);
            this.firePropertyChange("hasNfoFile", false, true);
        }
        catch (Exception e) {
            LOGGER.error("could not write NFO file - '{}'", (Object)e.getMessage());
        }
    }

    private void postProcess(List<TvShowScraperMetadataConfig> config, final boolean overwriteExistingItems) {
        TmmTaskChain taskChain = new TmmTaskChain();
        if (TvShowModuleManager.getInstance().getSettings().isRenameAfterScrape()) {
            taskChain.add(new TvShowRenameTask(Collections.singletonList(this), null, true));
        }
        if (ScraperMetadataConfig.containsAnyCast(config) && TvShowModuleManager.getInstance().getSettings().isWriteActorImages()) {
            taskChain.add(new TmmTask(TmmResourceBundle.getString("tvshow.downloadactorimages"), 1, TmmTaskHandle.TaskType.BACKGROUND_TASK){

                @Override
                protected void doInBackground() {
                    TvShow.this.writeActorImages(overwriteExistingItems);
                }
            });
        }
        taskChain.run();
    }

    public Boolean getHasNfoFile() {
        List<MediaFile> nfos = this.getMediaFiles(MediaFileType.NFO);
        return nfos != null && !nfos.isEmpty();
    }

    public Boolean getHasTrailer() {
        if (this.trailer != null && !this.trailer.isEmpty()) {
            return true;
        }
        if (!this.getMediaFiles(MediaFileType.TRAILER).isEmpty()) {
            return true;
        }
        return false;
    }

    public Boolean getHasMusicTheme() {
        return !this.getMediaFiles(MediaFileType.THEME).isEmpty();
    }

    public Boolean getHasNote() {
        return StringUtils.isNotBlank((CharSequence)this.note);
    }

    public Boolean getHasSeasonAndEpisodeImages() {
        TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();
        for (TvShowSeason season : this.seasons) {
            if (tvShowList.detectMissingArtwork(season).isEmpty() && season.getHasEpisodeImages().booleanValue()) continue;
            return false;
        }
        return true;
    }

    public Boolean getHasEpisodeMetadata() {
        TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();
        for (TvShowEpisode episode : this.episodes) {
            if (tvShowList.detectMissingMetadata(episode).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public String getImdbId() {
        return this.getIdAsString("imdb");
    }

    public void setImdbId(String newValue) {
        this.setId("imdb", newValue);
    }

    public String getTvdbId() {
        return this.getIdAsString("tvdb");
    }

    public void setTvdbId(String newValue) {
        this.setId("tvdb", newValue);
    }

    public int getTraktId() {
        return this.getIdAsInt("trakt");
    }

    public void setTraktId(int newValue) {
        this.setId("trakt", newValue);
    }

    public int getTmdbId() {
        return this.getIdAsInt("tmdb");
    }

    public void setTmdbId(int newValue) {
        this.setId("tmdb", newValue);
    }

    public Date getFirstAired() {
        return this.firstAired;
    }

    @JsonIgnore
    public void setFirstAired(Date newValue) {
        Date oldValue = this.firstAired;
        this.firstAired = newValue;
        this.firePropertyChange("firstAired", oldValue, newValue);
        this.firePropertyChange("firstAiredAsString", oldValue, newValue);
    }

    @Override
    public Date getReleaseDate() {
        return this.firstAired;
    }

    public String getFirstAiredFormatted() {
        if (this.firstAired == null) {
            return "";
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(this.firstAired);
    }

    public String getFirstAiredAsString() {
        if (this.firstAired == null) {
            return "";
        }
        return TmmDateFormat.MEDIUM_DATE_FORMAT.format(this.firstAired);
    }

    public void setFirstAired(String aired) {
        try {
            this.setFirstAired(StrgUtils.parseDate(aired));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public MediaAiredStatus getStatus() {
        return this.status;
    }

    public void setStatus(MediaAiredStatus newValue) {
        MediaAiredStatus oldValue = this.status;
        this.status = newValue;
        this.firePropertyChange("status", (Object)oldValue, (Object)newValue);
    }

    public int getRuntime() {
        return this.runtime;
    }

    public void setRuntime(int newValue) {
        int oldValue = this.runtime;
        this.runtime = newValue;
        this.firePropertyChange("runtime", oldValue, newValue);
    }

    public void addToActors(Collection<Person> newActors) {
        LinkedHashSet<Person> newItems = new LinkedHashSet<Person>();
        for (Person person : ListUtils.nullSafe(newActors)) {
            if (person == null || this.actors.contains(person)) continue;
            if (person.getType() != Person.Type.ACTOR) {
                return;
            }
            newItems.add(person);
        }
        if (newItems.isEmpty()) {
            return;
        }
        this.actors.addAll(newItems);
        this.firePropertyChange("actors", null, this.actors);
    }

    public List<Person> getActors() {
        return this.actors;
    }

    public void removeActors() {
        this.actors.clear();
        this.firePropertyChange("actors", null, this.getActors());
    }

    @JsonSetter
    public void setActors(List<Person> newActors) {
        this.mergePersons(this.actors, newActors);
        this.firePropertyChange("actors", null, this.getActors());
    }

    @Override
    public MediaCertification getCertification() {
        return this.certification;
    }

    public void setCertification(MediaCertification newValue) {
        this.certification = newValue;
        this.firePropertyChange("certification", null, (Object)newValue);
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String newValue) {
        String oldValue = this.country;
        this.country = newValue;
        this.firePropertyChange("country", oldValue, newValue);
    }

    public List<TvShowEpisode> getEpisodesToScrape() {
        ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>();
        for (TvShowEpisode episode : this.episodes) {
            if (episode.getFirstAired() == null && (episode.getSeason() <= -1 || episode.getEpisode() <= -1)) continue;
            episodes.add(episode);
        }
        return episodes;
    }

    public boolean isWatched() {
        boolean episodeFound = false;
        boolean watched = true;
        for (TvShowEpisode episode : this.episodes) {
            if (episode.isDummy()) continue;
            episodeFound = true;
            watched = watched && episode.isWatched();
        }
        if (episodeFound) {
            return watched;
        }
        return false;
    }

    public boolean hasEpisodeSubtitles() {
        boolean subtitles = true;
        for (TvShowEpisode episode : this.episodes) {
            if (episode.getHasSubtitles()) continue;
            subtitles = false;
            break;
        }
        return subtitles;
    }

    public Date getLastWatched() {
        return this.lastWatched;
    }

    public void setLastWatched(Date lastWatched) {
        this.lastWatched = lastWatched;
    }

    public List<MediaTrailer> getTrailer() {
        return this.trailer;
    }

    public void addToTrailer(Collection<MediaTrailer> newTrailers) {
        LinkedHashSet<MediaTrailer> newItems = new LinkedHashSet<MediaTrailer>();
        for (MediaTrailer trailer : ListUtils.nullSafe(newTrailers)) {
            if (trailer == null || this.trailer.contains(trailer)) continue;
            newItems.add(trailer);
        }
        if (newItems.isEmpty()) {
            return;
        }
        this.trailer.addAll(newItems);
        this.firePropertyChange("trailer", null, this.trailer);
    }

    public void removeAllTrailers() {
        this.trailer.clear();
        this.firePropertyChange("trailer", null, this.trailer);
    }

    public void setTrailers(List<MediaTrailer> trailers) {
        MediaTrailer preferredTrailer = null;
        this.removeAllTrailers();
        ArrayList<MediaTrailer> newItems = new ArrayList<MediaTrailer>();
        if (TvShowModuleManager.getInstance().getSettings().isUseTrailerPreference()) {
            TrailerQuality desiredQuality = TvShowModuleManager.getInstance().getSettings().getTrailerQuality();
            TrailerSources desiredSource = TvShowModuleManager.getInstance().getSettings().getTrailerSource();
            for (MediaTrailer trailer : trailers) {
                if (!desiredQuality.containsQuality(trailer.getQuality()) || !desiredSource.containsSource(trailer.getProvider())) continue;
                trailer.setInNfo(Boolean.TRUE);
                preferredTrailer = trailer;
                break;
            }
            if (preferredTrailer == null) {
                for (MediaTrailer trailer : trailers) {
                    if (!desiredQuality.containsQuality(trailer.getQuality())) continue;
                    trailer.setInNfo(Boolean.TRUE);
                    preferredTrailer = trailer;
                    break;
                }
            }
            if (preferredTrailer == null) {
                ArrayList<MediaTrailer> sortedTrailers = new ArrayList<MediaTrailer>(trailers);
                sortedTrailers.sort(TRAILER_QUALITY_COMPARATOR);
                for (MediaTrailer trailer : sortedTrailers) {
                    if (desiredQuality.ordinal() < TrailerQuality.getTrailerQuality(trailer.getQuality()).ordinal()) continue;
                    trailer.setInNfo(Boolean.TRUE);
                    preferredTrailer = trailer;
                    break;
                }
            }
        }
        if (preferredTrailer == null && !trailers.isEmpty()) {
            ArrayList<MediaTrailer> sortedTrailers = new ArrayList<MediaTrailer>(trailers);
            sortedTrailers.sort(TRAILER_QUALITY_COMPARATOR);
            preferredTrailer = (MediaTrailer)sortedTrailers.get(0);
            preferredTrailer.setInNfo(Boolean.TRUE);
        }
        if (preferredTrailer != null) {
            newItems.add(preferredTrailer);
        }
        for (MediaTrailer trailer : trailers) {
            if (preferredTrailer != null && preferredTrailer == trailer) continue;
            if (preferredTrailer == null && this.trailer.isEmpty() && trailer.getUrl().startsWith("http")) {
                trailer.setInNfo(Boolean.TRUE);
            }
            newItems.add(preferredTrailer);
        }
        this.addToTrailer(newItems);
        this.mixinLocalTrailers();
    }

    public String getTrailerFilename(TvShowTrailerNaming trailer) {
        return FilenameUtils.removeExtension((String)TvShowRenamer.replaceInvalidCharacters(trailer.getFilename(this.getTitle(), "ext")));
    }

    public void setSeasonArtworkUrl(int season, String url, MediaArtwork.MediaArtworkType artworkType) {
        switch (artworkType) {
            case SEASON_POSTER: {
                this.seasonPosterUrlMap.put(season, url);
                break;
            }
            case SEASON_FANART: {
                this.seasonFanartUrlMap.put(season, url);
                break;
            }
            case SEASON_BANNER: {
                this.seasonBannerUrlMap.put(season, url);
                break;
            }
            case SEASON_THUMB: {
                this.seasonThumbUrlMap.put(season, url);
                break;
            }
            default: {
                return;
            }
        }
    }

    public String getSeasonArtworkUrl(int season, MediaArtwork.MediaArtworkType artworkType) {
        String url = null;
        switch (artworkType) {
            case SEASON_POSTER: {
                url = this.seasonPosterUrlMap.get(season);
                break;
            }
            case SEASON_FANART: {
                url = this.seasonFanartUrlMap.get(season);
                break;
            }
            case SEASON_BANNER: {
                url = this.seasonBannerUrlMap.get(season);
                break;
            }
            case SEASON_THUMB: {
                url = this.seasonThumbUrlMap.get(season);
                break;
            }
        }
        if (StringUtils.isBlank(url)) {
            return "";
        }
        return url;
    }

    public Map<Integer, String> getSeasonArtworkUrls(MediaArtwork.MediaArtworkType artworkType) {
        switch (artworkType) {
            case SEASON_POSTER: {
                return MapUtils.sortByKey(this.seasonPosterUrlMap);
            }
            case SEASON_FANART: {
                return MapUtils.sortByKey(this.seasonFanartUrlMap);
            }
            case SEASON_BANNER: {
                return MapUtils.sortByKey(this.seasonBannerUrlMap);
            }
            case SEASON_THUMB: {
                return MapUtils.sortByKey(this.seasonThumbUrlMap);
            }
        }
        return new HashMap<Integer, String>(0);
    }

    public String getSeasonArtwork(int season, MediaArtwork.MediaArtworkType artworkType) {
        MediaFile artworkFile = null;
        switch (artworkType) {
            case SEASON_POSTER: {
                artworkFile = this.seasonPosters.get(season);
                break;
            }
            case SEASON_FANART: {
                artworkFile = this.seasonFanarts.get(season);
                break;
            }
            case SEASON_BANNER: {
                artworkFile = this.seasonBanners.get(season);
                break;
            }
            case SEASON_THUMB: {
                artworkFile = this.seasonThumbs.get(season);
                break;
            }
        }
        if (artworkFile != null) {
            return artworkFile.getFile().toString();
        }
        return "";
    }

    public Map<Integer, MediaFile> getSeasonArtworks(MediaArtwork.MediaArtworkType artworkType) {
        switch (artworkType) {
            case SEASON_POSTER: {
                return MapUtils.sortByKey(this.seasonPosters);
            }
            case SEASON_FANART: {
                return MapUtils.sortByKey(this.seasonFanarts);
            }
            case SEASON_BANNER: {
                return MapUtils.sortByKey(this.seasonBanners);
            }
            case SEASON_THUMB: {
                return MapUtils.sortByKey(this.seasonThumbs);
            }
        }
        return new HashMap<Integer, MediaFile>(0);
    }

    public void deleteSeasonArtworkFiles(int season, MediaArtwork.MediaArtworkType artworkType) {
        MediaFile mf = null;
        switch (artworkType) {
            case SEASON_POSTER: {
                mf = this.seasonPosters.get(season);
                this.seasonPosters.remove(season);
                break;
            }
            case SEASON_FANART: {
                mf = this.seasonFanarts.get(season);
                this.seasonFanarts.remove(season);
                break;
            }
            case SEASON_BANNER: {
                mf = this.seasonBanners.get(season);
                this.seasonBanners.remove(season);
                break;
            }
            case SEASON_THUMB: {
                mf = this.seasonThumbs.get(season);
                this.seasonThumbs.remove(season);
                break;
            }
            default: {
                return;
            }
        }
        if (mf != null) {
            mf.deleteSafely(this.getDataSource());
            this.removeFromMediaFiles(mf);
        }
    }

    Dimension getSeasonArtworkSize(int season, MediaArtwork.MediaArtworkType type) {
        MediaFile artworkFile = null;
        switch (type) {
            case SEASON_POSTER: {
                artworkFile = this.seasonPosters.get(season);
                break;
            }
            case SEASON_FANART: {
                artworkFile = this.seasonFanarts.get(season);
                break;
            }
            case SEASON_BANNER: {
                artworkFile = this.seasonBanners.get(season);
                break;
            }
            case SEASON_THUMB: {
                artworkFile = this.seasonThumbs.get(season);
                break;
            }
        }
        if (artworkFile != null) {
            return new Dimension(artworkFile.getVideoWidth(), artworkFile.getVideoHeight());
        }
        return new Dimension(0, 0);
    }

    public void setSeasonArtwork(int season, MediaFile mf) {
        MediaFile oldMf = null;
        MediaArtwork.MediaArtworkType artworkType = MediaFileType.getMediaArtworkType(mf.getType());
        switch (artworkType) {
            case SEASON_POSTER: {
                oldMf = this.seasonPosters.get(season);
                break;
            }
            case SEASON_FANART: {
                oldMf = this.seasonFanarts.get(season);
                break;
            }
            case SEASON_BANNER: {
                oldMf = this.seasonBanners.get(season);
                break;
            }
            case SEASON_THUMB: {
                oldMf = this.seasonThumbs.get(season);
                break;
            }
            default: {
                return;
            }
        }
        if (oldMf != null && oldMf.equals(mf)) {
            return;
        }
        this.addToMediaFiles(mf);
        switch (artworkType) {
            case SEASON_POSTER: {
                this.seasonPosters.put(season, mf);
                break;
            }
            case SEASON_FANART: {
                this.seasonFanarts.put(season, mf);
                break;
            }
            case SEASON_BANNER: {
                this.seasonBanners.put(season, mf);
                break;
            }
            case SEASON_THUMB: {
                this.seasonThumbs.put(season, mf);
                break;
            }
        }
    }

    void clearSeasonArtwork(int season, MediaArtwork.MediaArtworkType artworkType) {
        MediaFile mf = null;
        switch (artworkType) {
            case SEASON_POSTER: {
                mf = this.seasonPosters.get(season);
                this.seasonPosters.remove(season);
                break;
            }
            case SEASON_FANART: {
                mf = this.seasonFanarts.get(season);
                this.seasonFanarts.remove(season);
                break;
            }
            case SEASON_BANNER: {
                mf = this.seasonBanners.get(season);
                this.seasonBanners.remove(season);
                break;
            }
            case SEASON_THUMB: {
                mf = this.seasonThumbs.get(season);
                this.seasonThumbs.remove(season);
                break;
            }
            default: {
                return;
            }
        }
        if (mf != null) {
            this.removeFromMediaFiles(mf);
        }
    }

    public void removeSeasonArtwork(MediaFile mediaFile) {
        switch (mediaFile.getType()) {
            case SEASON_POSTER: {
                this.seasonPosters.values().remove(mediaFile);
                break;
            }
            case SEASON_FANART: {
                this.seasonFanarts.values().remove(mediaFile);
                break;
            }
            case SEASON_BANNER: {
                this.seasonBanners.values().remove(mediaFile);
                break;
            }
            case SEASON_THUMB: {
                this.seasonThumbs.values().remove(mediaFile);
                break;
            }
        }
    }

    void clearSeasonArtworkUrl(int season, MediaArtwork.MediaArtworkType artworkType) {
        switch (artworkType) {
            case SEASON_POSTER: {
                this.seasonPosterUrlMap.remove(season);
                break;
            }
            case SEASON_FANART: {
                this.seasonFanartUrlMap.remove(season);
                break;
            }
            case SEASON_BANNER: {
                this.seasonBannerUrlMap.remove(season);
                break;
            }
            case SEASON_THUMB: {
                this.seasonThumbUrlMap.remove(season);
                break;
            }
            default: {
                return;
            }
        }
    }

    public List<String> getExtraFanartUrls() {
        return this.extraFanartUrls;
    }

    @JsonSetter
    public void setExtraFanartUrls(List<String> extraFanartUrls) {
        ListUtils.mergeLists(this.extraFanartUrls, extraFanartUrls);
    }

    public List<MediaFile> getEpisodesMediaFiles() {
        ArrayList<MediaFile> mediaFiles = new ArrayList<MediaFile>();
        for (TvShowEpisode episode : this.episodes) {
            for (MediaFile mf : episode.getMediaFiles()) {
                if (mediaFiles.contains(mf)) continue;
                mediaFiles.add(mf);
            }
        }
        return mediaFiles;
    }

    @Override
    public List<MediaFile> getImagesToCache() {
        ArrayList<MediaFile> filesToCache = new ArrayList<MediaFile>();
        for (MediaFile mf : this.getMediaFiles()) {
            if (!mf.isGraphic()) continue;
            filesToCache.add(mf);
        }
        if (TvShowModuleManager.getInstance().getSettings().isWriteActorImages()) {
            filesToCache.addAll(this.listActorFiles());
        }
        for (TvShowSeason season : new ArrayList<TvShowSeason>(this.getSeasons())) {
            filesToCache.addAll(season.getImagesToCache());
        }
        for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(this.episodes)) {
            filesToCache.addAll(episode.getImagesToCache());
        }
        return filesToCache;
    }

    @Override
    public synchronized void callbackForWrittenArtwork(MediaArtwork.MediaArtworkType type) {
    }

    @Override
    public void saveToDb() {
        TvShowModuleManager.getInstance().getTvShowList().persistTvShow(this);
    }

    public List<int[]> getDuplicateEpisodes() {
        ArrayList<Integer> see = new ArrayList<Integer>();
        ArrayList<int[]> dupes = new ArrayList<int[]>();
        for (TvShowEpisode ep : this.episodes) {
            if (ep.getSeason() == -1 || ep.getEpisode() == -1) continue;
            int num = ep.getSeason() * 10000 + ep.getEpisode();
            if (!see.contains(num)) {
                see.add(num);
                continue;
            }
            int[] dupe = new int[]{ep.getSeason(), ep.getEpisode()};
            if (dupes.stream().anyMatch(c -> Arrays.equals(c, dupe))) continue;
            dupes.add(dupe);
        }
        return dupes;
    }

    public List<TvShowEpisode> getEpisode(int season, int episode) {
        if (season == -1 || episode == -1) {
            return Collections.emptyList();
        }
        return this.episodes.stream().filter(e -> e.getSeason() == season && e.getEpisode() == episode).collect(Collectors.toList());
    }

    public boolean hasNewlyAddedEpisodes() {
        for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(this.episodes)) {
            if (!episode.isNewlyAdded()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected float calculateScrapeScore() {
        float score = super.calculateScrapeScore();
        score += (float)Utils.returnOneWhenFilled(this.runtime);
        score += (float)Utils.returnOneWhenFilled(this.firstAired);
        if (this.status != MediaAiredStatus.UNKNOWN) {
            score += 1.0f;
        }
        if (this.certification != MediaCertification.UNKNOWN) {
            score += 1.0f;
        }
        score += (float)Utils.returnOneWhenFilled(this.country);
        score += (float)Utils.returnOneWhenFilled(this.seasonPosterUrlMap);
        score += (float)Utils.returnOneWhenFilled(this.seasonBannerUrlMap);
        score += (float)Utils.returnOneWhenFilled(this.seasonThumbUrlMap);
        score += (float)Utils.returnOneWhenFilled(this.seasonTitleMap);
        score += (float)Utils.returnOneWhenFilled(this.extraFanartUrls);
        score += (float)Utils.returnOneWhenFilled(this.actors);
        return score += (float)Utils.returnOneWhenFilled(this.trailer);
    }

    public void writeActorImages(boolean overwriteExistingItems) {
        TvShowActorImageFetcherTask task = new TvShowActorImageFetcherTask(this);
        task.setOverwriteExistingItems(overwriteExistingItems);
        TmmTaskManager.getInstance().addImageDownloadTask(task);
    }

    public void addSeasonTitle(int season, String title) {
        if (StringUtils.isNotBlank((CharSequence)title)) {
            this.seasonTitleMap.put(season, title);
        } else {
            this.seasonTitleMap.remove(season);
        }
        this.firePropertyChange("seasonTitle", null, this.seasonTitleMap);
    }

    public Map<Integer, String> getSeasonTitles() {
        return this.seasonTitleMap;
    }

    private List<MediaFile> listActorFiles() {
        if (!Files.exists(this.getPathNIO().resolve(".actors"), new LinkOption[0])) {
            return Collections.emptyList();
        }
        ArrayList<MediaFile> fileNames = new ArrayList<MediaFile>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.getPathNIO().resolve(".actors"));){
            for (Path path : directoryStream) {
                MediaFile mf;
                if (!Utils.isRegularFile(path) || !(mf = new MediaFile(path)).isGraphic()) continue;
                fileNames.add(mf);
            }
        }
        catch (IOException e) {
            LOGGER.debug("Cannot get actors: {}", (Object)this.getPathNIO().resolve(".actors"));
        }
        return fileNames;
    }

    public boolean deleteFilesSafely() {
        return Utils.deleteDirectorySafely(this.getPathNIO(), this.getDataSource());
    }

    @Override
    public MediaFile getMainFile() {
        return this.getMainVideoFile();
    }

    @Override
    public MediaFile getMainVideoFile() {
        return new MediaFile();
    }

    @Override
    public String getMediaInfoVideoFormat() {
        return "";
    }

    @Override
    public String getMediaInfoVideoResolution() {
        return "";
    }

    @Override
    public float getMediaInfoAspectRatio() {
        return 0.0f;
    }

    @Override
    public Float getMediaInfoAspectRatio2() {
        return null;
    }

    @Override
    public String getMediaInfoVideoCodec() {
        return "";
    }

    @Override
    public double getMediaInfoFrameRate() {
        return 0.0;
    }

    @Override
    public String getVideoHDRFormat() {
        return "";
    }

    @Override
    public boolean isVideoIn3D() {
        return false;
    }

    @Override
    public String getMediaInfoAudioCodec() {
        return "";
    }

    @Override
    public List<String> getMediaInfoAudioCodecList() {
        return Collections.emptyList();
    }

    @Override
    public String getMediaInfoAudioChannels() {
        return "";
    }

    @Override
    public List<String> getMediaInfoAudioChannelList() {
        return Collections.emptyList();
    }

    @Override
    public String getMediaInfoAudioChannelsDot() {
        return "";
    }

    @Override
    public List<String> getMediaInfoAudioChannelDotList() {
        return Collections.emptyList();
    }

    @Override
    public String getMediaInfoAudioLanguage() {
        return "";
    }

    @Override
    public List<String> getMediaInfoAudioLanguageList() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getMediaInfoSubtitleLanguageList() {
        return Collections.emptyList();
    }

    @Override
    public String getMediaInfoContainerFormat() {
        return "";
    }

    @Override
    public int getMediaInfoVideoBitDepth() {
        return 0;
    }

    @Override
    public MediaSource getMediaInfoSource() {
        return MediaSource.UNKNOWN;
    }

    @Override
    public long getVideoFilesize() {
        long filesize = 0L;
        for (TvShowEpisode episode : this.episodes) {
            filesize += episode.getVideoFilesize();
        }
        return filesize;
    }

    @Override
    public long getTotalFilesize() {
        long filesize = 0L;
        for (TvShowEpisode episode : this.episodes) {
            filesize += episode.getTotalFilesize();
        }
        return filesize;
    }

    @Override
    protected void fireAddedEventForMediaFile(MediaFile mediaFile) {
        super.fireAddedEventForMediaFile(mediaFile);
        if (mediaFile.getType() == MediaFileType.TRAILER) {
            this.firePropertyChange("trailer", false, true);
        }
    }

    @Override
    protected void fireRemoveEventForMediaFile(MediaFile mediaFile) {
        super.fireRemoveEventForMediaFile(mediaFile);
        if (mediaFile.getType() == MediaFileType.TRAILER) {
            this.firePropertyChange("trailer", true, false);
        }
    }

    private void mixinLocalTrailers() {
        for (int i = this.trailer.size() - 1; i >= 0; --i) {
            MediaTrailer mediaTrailer = this.trailer.get(i);
            if (!"downloaded".equalsIgnoreCase(mediaTrailer.getProvider())) continue;
            this.trailer.remove(i);
        }
        for (MediaFile mf : this.getMediaFiles(MediaFileType.TRAILER)) {
            LOGGER.debug("adding local trailer {}", (Object)mf.getFilename());
            MediaTrailer mt = new MediaTrailer();
            mt.setName(mf.getFilename());
            mt.setProvider("downloaded");
            mt.setQuality(mf.getVideoFormat());
            mt.setInNfo(false);
            mt.setUrl(mf.getFile().toUri().toString());
            this.trailer.add(0, mt);
            this.firePropertyChange("trailer", null, this.trailer);
        }
    }

    @Override
    public void callbackForGatheredMediainformation(MediaFile mediaFile) {
        if (mediaFile.getType() == MediaFileType.TRAILER) {
            this.mixinLocalTrailers();
        }
    }

    public Object getValueForMetadata(TvShowScraperMetadataConfig metadataConfig) {
        switch (metadataConfig) {
            case ID: {
                return this.getIds();
            }
            case TITLE: {
                return this.getTitle();
            }
            case ORIGINAL_TITLE: {
                return this.getOriginalTitle();
            }
            case PLOT: {
                return this.getPlot();
            }
            case YEAR: {
                return this.getYear();
            }
            case AIRED: {
                return this.getFirstAired();
            }
            case RATING: {
                return this.getRatings();
            }
            case RUNTIME: {
                return this.getRuntime();
            }
            case CERTIFICATION: {
                return this.getCertification();
            }
            case GENRES: {
                return this.getGenres();
            }
            case COUNTRY: {
                return this.getCountry();
            }
            case STUDIO: {
                return this.getProductionCompany();
            }
            case STATUS: {
                return this.getStatus();
            }
            case TAGS: {
                return this.getTags();
            }
            case TRAILER: {
                return this.getMediaFiles(MediaFileType.TRAILER);
            }
            case ACTORS: {
                return this.getActors();
            }
            case POSTER: {
                return this.getMediaFiles(MediaFileType.POSTER);
            }
            case FANART: {
                return this.getMediaFiles(MediaFileType.FANART);
            }
            case BANNER: {
                return this.getMediaFiles(MediaFileType.BANNER);
            }
            case CLEARART: {
                return this.getMediaFiles(MediaFileType.CLEARART);
            }
            case THUMB: {
                return this.getMediaFiles(MediaFileType.THUMB);
            }
            case LOGO: {
                return this.getMediaFiles(MediaFileType.LOGO);
            }
            case CLEARLOGO: {
                return this.getMediaFiles(MediaFileType.CLEARLOGO);
            }
            case DISCART: {
                return this.getMediaFiles(MediaFileType.DISC);
            }
            case KEYART: {
                return this.getMediaFiles(MediaFileType.KEYART);
            }
            case EXTRAFANART: {
                return this.getMediaFiles(MediaFileType.EXTRAFANART);
            }
            case CHARACTERART: {
                return this.getMediaFiles(MediaFileType.CHARACTERART);
            }
            case SEASON_NAMES: {
                for (TvShowSeason season : this.seasons) {
                    if (season.getSeason() < 0 || season.isDummy() || season.getSeason() == 0 && !TvShowModuleManager.getInstance().getSettings().isEpisodeSpecialsCheckMissingMetadata() || !StringUtils.isBlank((CharSequence)this.seasonTitleMap.get(season.getSeason()))) continue;
                    return null;
                }
                return "all seasonnames found";
            }
            case SEASON_POSTER: {
                return this.getMediaFiles(MediaFileType.SEASON_POSTER);
            }
            case SEASON_FANART: {
                return this.getMediaFiles(MediaFileType.SEASON_FANART);
            }
            case SEASON_BANNER: {
                return this.getMediaFiles(MediaFileType.SEASON_BANNER);
            }
            case SEASON_THUMB: {
                return this.getMediaFiles(MediaFileType.SEASON_THUMB);
            }
            case THEME: {
                return this.getMediaFiles(MediaFileType.THEME);
            }
        }
        return null;
    }
}

