/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.filenaming;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.tvshow.ITvShowSeasonFileNaming;
import org.tinymediamanager.core.tvshow.TvShowHelpers;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;

public enum TvShowSeasonFanartNaming implements ITvShowSeasonFileNaming
{
    SEASON_FANART{

        @Override
        public String getFilename(TvShow tvShow, int season, String extension) {
            if (season == -1) {
                return "season-all-fanart." + extension;
            }
            if (season == 0 && TvShowModuleManager.getInstance().getSettings().isSpecialSeason()) {
                return "season-specials-fanart." + extension;
            }
            if (season > -1) {
                return String.format("season%02d-fanart.%s", season, extension);
            }
            return "";
        }
    }
    ,
    SEASON_FOLDER{

        @Override
        public String getFilename(TvShow tvShow, int season, String extension) {
            String seasonFoldername = TvShowHelpers.detectSeasonFolder(tvShow, season);
            if (StringUtils.isBlank((CharSequence)seasonFoldername)) {
                return SEASON_FANART.getFilename(tvShow, season, extension);
            }
            String filename = seasonFoldername + File.separator;
            if (season == -1) {
                filename = filename + "season-all-fanart";
            } else if (season == 0 && TvShowModuleManager.getInstance().getSettings().isSpecialSeason()) {
                filename = filename + "season-specials-fanart";
            } else if (season > -1) {
                filename = filename + String.format("season%02d-fanart", season);
            } else {
                return "";
            }
            return filename + "." + extension;
        }
    };

}

