/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.filenaming;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.tvshow.ITvShowSeasonFileNaming;
import org.tinymediamanager.core.tvshow.TvShowHelpers;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;

public enum TvShowSeasonThumbNaming implements ITvShowSeasonFileNaming
{
    SEASON_THUMB{

        @Override
        public String getFilename(TvShow tvShow, int season, String extension) {
            if (season == -1) {
                return "season-all-thumb." + extension;
            }
            if (season == 0 && TvShowModuleManager.getInstance().getSettings().isSpecialSeason()) {
                return "season-specials-thumb." + extension;
            }
            if (season > -1) {
                return String.format("season%02d-thumb.%s", season, extension);
            }
            return "";
        }
    }
    ,
    SEASON_LANDSCAPE{

        @Override
        public String getFilename(TvShow tvShow, int season, String extension) {
            if (season == -1) {
                return "season-all-landscape." + extension;
            }
            if (season == 0 && TvShowModuleManager.getInstance().getSettings().isSpecialSeason()) {
                return "season-specials-landscape." + extension;
            }
            if (season > -1) {
                return String.format("season%02d-landscape.%s", season, extension);
            }
            return "";
        }
    }
    ,
    SEASON_FOLDER{

        @Override
        public String getFilename(TvShow tvShow, int season, String extension) {
            String seasonFoldername = TvShowHelpers.detectSeasonFolder(tvShow, season);
            if (StringUtils.isBlank((CharSequence)seasonFoldername)) {
                return SEASON_THUMB.getFilename(tvShow, season, extension);
            }
            String filename = seasonFoldername + File.separator;
            if (season == -1) {
                filename = filename + "season-all-thumb";
            } else if (season == 0 && TvShowModuleManager.getInstance().getSettings().isSpecialSeason()) {
                filename = filename + "season-specials-thumb";
            } else if (season > -1) {
                filename = filename + String.format("season%02d-thumb", season);
            } else {
                return "";
            }
            return filename + "." + extension;
        }
    }
    ,
    SEASON_FOLDER_LANDSCAPE{

        @Override
        public String getFilename(TvShow tvShow, int season, String extension) {
            String seasonFoldername = TvShowHelpers.detectSeasonFolder(tvShow, season);
            if (StringUtils.isBlank((CharSequence)seasonFoldername)) {
                return SEASON_THUMB.getFilename(tvShow, season, extension);
            }
            String filename = seasonFoldername + File.separator;
            if (season == -1) {
                filename = filename + "season-all-landscape";
            } else if (season == 0 && TvShowModuleManager.getInstance().getSettings().isSpecialSeason()) {
                filename = filename + "season-specials-landscape";
            } else if (season > -1) {
                filename = filename + String.format("season%02d-landscape", season);
            } else {
                return "";
            }
            return filename + "." + extension;
        }
    };

}

