/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowArtworkProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.rating.RatingProvider;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.thirdparty.trakttv.TvShowSyncTraktTvTask;

public class TvShowEpisodeScrapeTask
extends TmmTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowEpisodeScrapeTask.class);
    private final List<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>();
    private final List<TvShowEpisodeScraperMetadataConfig> config = new ArrayList<TvShowEpisodeScraperMetadataConfig>();
    private final TvShowEpisodeSearchAndScrapeOptions scrapeOptions;
    private final boolean overwrite;

    public TvShowEpisodeScrapeTask(List<TvShowEpisode> episodes, TvShowEpisodeSearchAndScrapeOptions options, List<TvShowEpisodeScraperMetadataConfig> config, boolean overwrite) {
        super(TmmResourceBundle.getString("tvshow.scraping"), episodes.size(), TmmTaskHandle.TaskType.BACKGROUND_TASK);
        this.episodes.addAll(episodes);
        this.config.addAll(config);
        this.scrapeOptions = options;
        this.overwrite = overwrite;
    }

    @Override
    public void doInBackground() {
        this.setWorkUnits(this.episodes.size());
        MediaScraper mediaScraper = this.scrapeOptions.getMetadataScraper();
        if (!mediaScraper.isEnabled()) {
            return;
        }
        int count = 0;
        for (TvShowEpisode tvShowEpisode : this.episodes) {
            this.publishState(count++);
            if (tvShowEpisode.getTvShow().getIds().isEmpty()) {
                LOGGER.info("we cannot scrape (no ID): {} - {}", (Object)tvShowEpisode.getTvShow().getTitle(), (Object)tvShowEpisode.getTitle());
                continue;
            }
            TvShowEpisodeSearchAndScrapeOptions options = new TvShowEpisodeSearchAndScrapeOptions(this.scrapeOptions);
            MediaMetadata md = new MediaMetadata(mediaScraper.getMediaProvider().getProviderInfo().getId());
            md.setScrapeOptions(options);
            md.setReleaseDate(tvShowEpisode.getFirstAired());
            options.setMetadata(md);
            options.setIds(tvShowEpisode.getIds());
            if (tvShowEpisode.isDvdOrder()) {
                options.setId("dvdSeasonNr", String.valueOf(tvShowEpisode.getDvdSeason()));
                options.setId("dvdEpisodeNr", String.valueOf(tvShowEpisode.getDvdEpisode()));
            } else {
                options.setId("seasonNr", String.valueOf(tvShowEpisode.getAiredSeason()));
                options.setId("episodeNr", String.valueOf(tvShowEpisode.getAiredEpisode()));
            }
            options.setTvShowIds(tvShowEpisode.getTvShow().getIds());
            try {
                LOGGER.info("=====================================================");
                LOGGER.info("Scrape metadata with scraper: {}", (Object)mediaScraper.getMediaProvider().getProviderInfo().getId());
                LOGGER.info(options.toString());
                LOGGER.info("=====================================================");
                MediaMetadata metadata = ((ITvShowMetadataProvider)mediaScraper.getMediaProvider()).getMetadata(options);
                MediaIdUtil.injectMissingIds(metadata.getIds(), MediaType.TV_EPISODE);
                if (TvShowModuleManager.getInstance().getSettings().isFetchAllRatings() && this.config.contains(TvShowEpisodeScraperMetadataConfig.RATING)) {
                    HashMap<String, Object> ids = new HashMap<String, Object>(metadata.getIds());
                    ids.put("tvShowIds", new HashMap<String, Object>(tvShowEpisode.getTvShow().getIds()));
                    for (MediaRating rating : ListUtils.nullSafe(RatingProvider.getRatings(ids, MediaType.TV_EPISODE))) {
                        if (metadata.getRatings().contains(rating)) continue;
                        metadata.addRating(rating);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)metadata.getTitle())) {
                    tvShowEpisode.setMetadata(metadata, this.config, this.overwrite);
                    tvShowEpisode.setLastScraperId(this.scrapeOptions.getMetadataScraper().getId());
                    tvShowEpisode.setLastScrapeLanguage(this.scrapeOptions.getLanguage().name());
                    tvShowEpisode.saveToDb();
                }
                if (this.cancel) {
                    return;
                }
                if (ScraperMetadataConfig.containsAnyArtwork(this.config)) {
                    List<MediaArtwork> artworks = this.getArtwork(tvShowEpisode, metadata, options);
                    artworks.addAll(metadata.getMediaArt(MediaArtwork.MediaArtworkType.THUMB));
                    if (this.config.contains(TvShowEpisodeScraperMetadataConfig.THUMB) && (this.overwrite || StringUtils.isBlank((CharSequence)tvShowEpisode.getArtworkFilename(MediaFileType.THUMB)))) {
                        for (MediaArtwork art : artworks) {
                            if (art.getType() != MediaArtwork.MediaArtworkType.THUMB || !StringUtils.isNotBlank((CharSequence)art.getDefaultUrl())) continue;
                            tvShowEpisode.setArtworkUrl(art.getDefaultUrl(), MediaFileType.THUMB);
                            tvShowEpisode.downloadArtwork(MediaFileType.THUMB, false);
                            break;
                        }
                    }
                }
                if (!this.cancel) continue;
                return;
            }
            catch (MissingIdException e) {
                LOGGER.warn("missing id for scrape");
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, tvShowEpisode, "scraper.error.missingid"));
            }
            catch (NothingFoundException ignored) {
                LOGGER.debug("nothing found");
            }
            catch (ScrapeException e) {
                LOGGER.error("scrape error - '{}'", (Object)e.getMessage());
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)tvShowEpisode, "message.scrape.metadataepisodefailed", new String[]{":", e.getLocalizedMessage()}));
            }
            catch (Exception e) {
                LOGGER.warn("could not scrape episode - unknown error", (Throwable)e);
            }
        }
        if (this.cancel) {
            return;
        }
        if (TvShowModuleManager.getInstance().getSettings().getSyncTrakt()) {
            HashSet<TvShow> tvShows = new HashSet<TvShow>();
            for (TvShowEpisode episode : this.episodes) {
                tvShows.add(episode.getTvShow());
            }
            TvShowSyncTraktTvTask tvShowSyncTraktTvTask = new TvShowSyncTraktTvTask(new ArrayList<TvShow>(tvShows));
            tvShowSyncTraktTvTask.setSyncCollection(TvShowModuleManager.getInstance().getSettings().getSyncTraktCollection());
            tvShowSyncTraktTvTask.setSyncWatched(TvShowModuleManager.getInstance().getSettings().getSyncTraktWatched());
            tvShowSyncTraktTvTask.setSyncRating(TvShowModuleManager.getInstance().getSettings().getSyncTraktRating());
            TmmTaskManager.getInstance().addUnnamedTask(tvShowSyncTraktTvTask);
        }
    }

    private List<MediaArtwork> getArtwork(TvShowEpisode episode, MediaMetadata metadata, TvShowEpisodeSearchAndScrapeOptions scrapeOptions) {
        ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
        ArtworkSearchAndScrapeOptions options = new ArtworkSearchAndScrapeOptions(MediaType.TV_EPISODE);
        options.setDataFromOtherOptions(scrapeOptions);
        options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
        options.setMetadata(metadata);
        options.setIds(episode.getIds());
        options.setId("tvShowIds", episode.getTvShow().getIds());
        options.setId("mediaFile", episode.getMainFile());
        for (MediaScraper artworkScraper : scrapeOptions.getArtworkScrapers()) {
            ITvShowArtworkProvider artworkProvider = (ITvShowArtworkProvider)artworkScraper.getMediaProvider();
            try {
                artwork.addAll(artworkProvider.getArtwork(options));
            }
            catch (MissingIdException ignored) {
                LOGGER.debug("no id available for scraper {}", (Object)artworkScraper.getId());
            }
            catch (NothingFoundException e) {
                LOGGER.debug("did not find artwork for '{}' - S{}/E{}", new Object[]{episode.getTvShow().getTitle(), episode.getSeason(), episode.getEpisode()});
            }
            catch (ScrapeException e) {
                LOGGER.error("getArtwork", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)episode, "message.scrape.tvshowartworkfailed", new String[]{":", e.getLocalizedMessage()}));
            }
        }
        return artwork;
    }
}

