/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.core.tvshow.TvShowArtworkHelper;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowArtworkProvider;

public class TvShowMissingArtworkDownloadTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowMissingArtworkDownloadTask.class);
    private final Collection<TvShow> tvShows;
    private final Collection<TvShowEpisode> episodes;
    private final TvShowSearchAndScrapeOptions scrapeOptions;
    private final List<TvShowScraperMetadataConfig> tvShowScraperMetadataConfig;
    private final List<TvShowEpisodeScraperMetadataConfig> episodeScraperMetadataConfig;

    public TvShowMissingArtworkDownloadTask(Collection<TvShow> tvShows, Collection<TvShowEpisode> episodes, TvShowSearchAndScrapeOptions scrapeOptions, List<TvShowScraperMetadataConfig> tvShowScraperMetadataConfig, List<TvShowEpisodeScraperMetadataConfig> episodeScraperMetadataConfig) {
        super(TmmResourceBundle.getString("task.missingartwork"));
        this.tvShows = new ArrayList<TvShow>(tvShows);
        this.episodes = new ArrayList<TvShowEpisode>(episodes);
        this.scrapeOptions = scrapeOptions;
        this.tvShowScraperMetadataConfig = tvShowScraperMetadataConfig;
        this.episodeScraperMetadataConfig = episodeScraperMetadataConfig;
        for (TvShow show : this.tvShows) {
            for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(show.getEpisodes())) {
                if (this.episodes.contains(episode)) continue;
                this.episodes.add(episode);
            }
        }
    }

    @Override
    protected void doInBackground() {
        LOGGER.info("Getting missing artwork");
        this.initThreadPool(3, "scrapeMissingTvShowArtwork");
        this.start();
        for (TvShow show : this.tvShows) {
            if (this.cancel) break;
            if (!TvShowArtworkHelper.hasMissingArtwork(show, this.tvShowScraperMetadataConfig)) continue;
            this.submitTask(new TvShowWorker(show, this.scrapeOptions));
        }
        for (TvShowEpisode episode : this.episodes) {
            if (this.cancel) break;
            if (!TvShowArtworkHelper.hasMissingArtwork(episode, this.episodeScraperMetadataConfig)) continue;
            this.submitTask(new TvShowEpisodeWorker(episode, this.scrapeOptions));
        }
        this.waitForCompletionOrCancel();
        LOGGER.info("Done getting missing artwork");
    }

    @Override
    public void callback(Object obj) {
        this.publishState((String)obj, this.progressDone);
    }

    private static class TvShowEpisodeWorker
    implements Runnable {
        private final TvShowEpisode episode;
        private final ArtworkSearchAndScrapeOptions options;

        private TvShowEpisodeWorker(TvShowEpisode episode, MediaSearchAndScrapeOptions scrapeOptions) {
            this.episode = episode;
            this.options = new ArtworkSearchAndScrapeOptions(MediaType.TV_EPISODE);
            this.options.setDataFromOtherOptions(scrapeOptions);
            this.options.setIds(Collections.emptyMap());
            this.options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
            this.options.setLanguage(TvShowModuleManager.getInstance().getSettings().getScraperLanguage());
            this.options.setFanartSize(TvShowModuleManager.getInstance().getSettings().getImageFanartSize());
            this.options.setPosterSize(TvShowModuleManager.getInstance().getSettings().getImagePosterSize());
            this.options.setId("tvShowIds", episode.getTvShow().getIds());
            this.options.setId("mediaFile", episode.getMainFile());
            for (Map.Entry<String, Object> entry : episode.getIds().entrySet()) {
                this.options.setId(entry.getKey(), entry.getValue().toString());
            }
            if (episode.isDvdOrder()) {
                this.options.setId("dvdSeasonNr", String.valueOf(episode.getDvdSeason()));
                this.options.setId("dvdEpisodeNr", String.valueOf(episode.getDvdEpisode()));
            } else {
                this.options.setId("seasonNr", String.valueOf(episode.getAiredSeason()));
                this.options.setId("episodeNr", String.valueOf(episode.getAiredEpisode()));
            }
            this.options.setArtworkType(MediaArtwork.MediaArtworkType.THUMB);
        }

        @Override
        public void run() {
            try {
                ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
                for (MediaScraper artworkScraper : this.options.getArtworkScrapers()) {
                    ITvShowArtworkProvider artworkProvider = (ITvShowArtworkProvider)artworkScraper.getMediaProvider();
                    try {
                        artwork.addAll(artworkProvider.getArtwork(this.options));
                        if (artwork.isEmpty()) continue;
                        break;
                    }
                    catch (MissingIdException ignored) {
                        LOGGER.debug("no id found for scraper {}", (Object)artworkProvider.getProviderInfo());
                    }
                    catch (NothingFoundException e) {
                        LOGGER.debug("did not find artwork for '{}' - S{}/E{}", new Object[]{this.episode.getTvShow().getTitle(), this.episode.getSeason(), this.episode.getEpisode()});
                    }
                    catch (ScrapeException e) {
                        LOGGER.error("getArtwork", (Throwable)e);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.episode, "message.scrape.tvshowartworkfailed", new String[]{":", e.getLocalizedMessage()}));
                    }
                }
                if (!artwork.isEmpty()) {
                    this.episode.setArtworkUrl(((MediaArtwork)artwork.get(0)).getDefaultUrl(), MediaFileType.THUMB);
                    this.episode.downloadArtwork(MediaFileType.THUMB);
                }
            }
            catch (Exception e) {
                LOGGER.error("Thread crashed", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"TvShowMissingArtwork", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
            }
        }
    }

    private static class TvShowWorker
    implements Runnable {
        private final TvShow tvShow;
        private final ArtworkSearchAndScrapeOptions options;

        private TvShowWorker(TvShow tvShow, MediaSearchAndScrapeOptions scrapeOptions) {
            this.tvShow = tvShow;
            this.options = new ArtworkSearchAndScrapeOptions(MediaType.TV_SHOW);
            this.options.setDataFromOtherOptions(scrapeOptions);
            this.options.setIds(Collections.emptyMap());
            this.options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
            this.options.setLanguage(TvShowModuleManager.getInstance().getSettings().getScraperLanguage());
            this.options.setFanartSize(TvShowModuleManager.getInstance().getSettings().getImageFanartSize());
            this.options.setPosterSize(TvShowModuleManager.getInstance().getSettings().getImagePosterSize());
            for (Map.Entry<String, Object> entry : tvShow.getIds().entrySet()) {
                this.options.setId(entry.getKey(), entry.getValue().toString());
            }
        }

        @Override
        public void run() {
            try {
                ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
                for (MediaScraper artworkScraper : this.options.getArtworkScrapers()) {
                    ITvShowArtworkProvider artworkProvider = (ITvShowArtworkProvider)artworkScraper.getMediaProvider();
                    try {
                        artwork.addAll(artworkProvider.getArtwork(this.options));
                    }
                    catch (MissingIdException ignored) {
                        LOGGER.debug("no id found for scraper {}", (Object)artworkProvider.getProviderInfo());
                    }
                    catch (NothingFoundException e) {
                        LOGGER.debug("did not find artwork for '{}'", (Object)this.tvShow.getTitle());
                    }
                    catch (ScrapeException e) {
                        LOGGER.error("getArtwork", (Throwable)e);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.tvShow, "message.scrape.tvshowartworkfailed", new String[]{":", e.getLocalizedMessage()}));
                    }
                }
                if (!artwork.isEmpty()) {
                    TvShowArtworkHelper.downloadMissingArtwork(this.tvShow, artwork);
                }
            }
            catch (Exception e) {
                LOGGER.error("Thread crashed", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"TvShowMissingArtwork", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
            }
        }
    }
}

