/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowHelpers;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.tasks.TvShowEpisodeScrapeTask;
import org.tinymediamanager.core.tvshow.tasks.TvShowThemeDownloadTask;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.TrailerSearchAndScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowArtworkProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowTrailerProvider;
import org.tinymediamanager.scraper.rating.RatingProvider;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.thirdparty.trakttv.TvShowSyncTraktTvTask;

public class TvShowScrapeTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowScrapeTask.class);
    private final TvShowScrapeParams tvShowScrapeParams;

    public TvShowScrapeTask(TvShowScrapeParams tvShowScrapeParams) {
        super(TmmResourceBundle.getString("tvshow.scraping"));
        this.tvShowScrapeParams = tvShowScrapeParams;
    }

    @Override
    protected void doInBackground() {
        MediaScraper mediaMetadataScraper = this.tvShowScrapeParams.scrapeOptions.getMetadataScraper();
        if (!mediaMetadataScraper.isEnabled()) {
            return;
        }
        LOGGER.debug("start scraping tv shows...");
        this.start();
        this.initThreadPool(3, "scrape");
        for (TvShow tvShow : this.tvShowScrapeParams.tvShowsToScrape) {
            this.submitTask(new Worker(tvShow));
        }
        this.waitForCompletionOrCancel();
        if (TvShowModuleManager.getInstance().getSettings().getSyncTrakt()) {
            TvShowSyncTraktTvTask task = new TvShowSyncTraktTvTask(this.tvShowScrapeParams.tvShowsToScrape);
            task.setSyncCollection(TvShowModuleManager.getInstance().getSettings().getSyncTraktCollection());
            task.setSyncWatched(TvShowModuleManager.getInstance().getSettings().getSyncTraktWatched());
            task.setSyncRating(TvShowModuleManager.getInstance().getSettings().getSyncTraktRating());
            TmmTaskManager.getInstance().addUnnamedTask(task);
        }
        LOGGER.debug("done scraping tv shows...");
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    public static class TvShowScrapeParams {
        private final List<TvShow> tvShowsToScrape;
        private final TvShowSearchAndScrapeOptions scrapeOptions;
        private final List<TvShowScraperMetadataConfig> tvShowScraperMetadataConfig = new ArrayList<TvShowScraperMetadataConfig>();
        private final List<TvShowEpisodeScraperMetadataConfig> episodeScraperMetadataConfig = new ArrayList<TvShowEpisodeScraperMetadataConfig>();
        private boolean doSearch;
        private boolean overwriteExistingItems;

        public TvShowScrapeParams(List<TvShow> tvShowsToScrape, TvShowSearchAndScrapeOptions scrapeOptions, List<TvShowScraperMetadataConfig> tvShowScraperMetadataConfig, List<TvShowEpisodeScraperMetadataConfig> episodeScraperMetadataConfig) {
            this.tvShowsToScrape = tvShowsToScrape;
            this.scrapeOptions = scrapeOptions;
            this.tvShowScraperMetadataConfig.addAll(tvShowScraperMetadataConfig);
            this.episodeScraperMetadataConfig.addAll(episodeScraperMetadataConfig);
            this.doSearch = true;
            this.overwriteExistingItems = true;
        }

        public TvShowScrapeParams setDoSearch(boolean doSearch) {
            this.doSearch = doSearch;
            return this;
        }

        public TvShowScrapeParams setOverwriteExistingItems(boolean overwriteExistingItems) {
            this.overwriteExistingItems = overwriteExistingItems;
            return this;
        }
    }

    private class Worker
    implements Runnable {
        private final TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();
        private final TvShow tvShow;

        private Worker(TvShow tvShow) {
            this.tvShow = tvShow;
        }

        @Override
        public void run() {
            block33: {
                try {
                    MediaScraper mediaMetadataScraper = TvShowScrapeTask.this.tvShowScrapeParams.scrapeOptions.getMetadataScraper();
                    List<MediaScraper> trailerScrapers = TvShowScrapeTask.this.tvShowScrapeParams.scrapeOptions.getTrailerScrapers();
                    MediaSearchResult result1 = null;
                    if (TvShowScrapeTask.this.tvShowScrapeParams.doSearch) {
                        List<MediaSearchResult> results = this.tvShowList.searchTvShow(this.tvShow.getTitle(), this.tvShow.getYear(), this.tvShow.getIds(), mediaMetadataScraper);
                        if (ListUtils.isNotEmpty(results)) {
                            result1 = results.get(0);
                            if (results.size() > 1) {
                                MediaSearchResult result2 = results.get(1);
                                if (result1.getScore() == 1.0f && result2.getScore() == 1.0f) {
                                    LOGGER.info("two 100% results, can't decide which to take - ignore result");
                                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.tvShow, "tvshow.scrape.nomatchfound"));
                                    return;
                                }
                                if ((double)result1.getScore() < 0.75) {
                                    LOGGER.info("score is lower than 0.75 ({}) - ignore result", (Object)Float.valueOf(result1.getScore()));
                                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.tvShow, "tvshow.scrape.nomatchfound"));
                                    return;
                                }
                            }
                        } else {
                            LOGGER.info("no result found for {}", (Object)this.tvShow.getTitle());
                            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.tvShow, "tvshow.scrape.nomatchfound"));
                        }
                    }
                    if (TvShowScrapeTask.this.cancel) {
                        return;
                    }
                    if ((!TvShowScrapeTask.this.tvShowScrapeParams.doSearch || result1 == null) && TvShowScrapeTask.this.tvShowScrapeParams.doSearch) break block33;
                    try {
                        TvShowSearchAndScrapeOptions options = new TvShowSearchAndScrapeOptions(TvShowScrapeTask.this.tvShowScrapeParams.scrapeOptions);
                        options.setSearchResult(result1);
                        if (TvShowScrapeTask.this.tvShowScrapeParams.doSearch) {
                            options.setIds(result1.getIds());
                        } else {
                            options.setIds(this.tvShow.getIds());
                        }
                        if (result1 != null) {
                            mediaMetadataScraper = this.tvShowList.getMediaScraperById(result1.getProviderId());
                        }
                        MediaMetadata md = null;
                        if (ScraperMetadataConfig.containsAnyMetadata(TvShowScrapeTask.this.tvShowScrapeParams.tvShowScraperMetadataConfig) || ScraperMetadataConfig.containsAnyCast(TvShowScrapeTask.this.tvShowScrapeParams.tvShowScraperMetadataConfig)) {
                            LOGGER.info("=====================================================");
                            LOGGER.info("Scraper metadata with scraper: {}", (Object)mediaMetadataScraper.getMediaProvider().getProviderInfo().getId());
                            LOGGER.info(options.toString());
                            LOGGER.info("=====================================================");
                            md = ((ITvShowMetadataProvider)mediaMetadataScraper.getMediaProvider()).getMetadata(options);
                            MediaIdUtil.injectMissingIds(md.getIds(), MediaType.TV_SHOW);
                            if (MovieModuleManager.getInstance().getSettings().isFetchAllRatings() && TvShowScrapeTask.this.tvShowScrapeParams.tvShowScraperMetadataConfig.contains(TvShowScraperMetadataConfig.RATING)) {
                                for (MediaRating mediaRating : ListUtils.nullSafe(RatingProvider.getRatings(md.getIds(), MediaType.TV_SHOW))) {
                                    if (md.getRatings().contains(mediaRating)) continue;
                                    md.addRating(mediaRating);
                                }
                            }
                            this.tvShow.setMetadata(md, TvShowScrapeTask.this.tvShowScrapeParams.tvShowScraperMetadataConfig, TvShowScrapeTask.this.tvShowScrapeParams.overwriteExistingItems);
                            this.tvShow.setLastScraperId(TvShowScrapeTask.this.tvShowScrapeParams.scrapeOptions.getMetadataScraper().getId());
                            this.tvShow.setLastScrapeLanguage(TvShowScrapeTask.this.tvShowScrapeParams.scrapeOptions.getLanguage().name());
                        }
                        ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>();
                        try {
                            for (MediaMetadata me : ((ITvShowMetadataProvider)mediaMetadataScraper.getMediaProvider()).getEpisodeList(options)) {
                                TvShowEpisode ep = new TvShowEpisode();
                                ep.setEpisode(me.getEpisodeNumber());
                                ep.setSeason(me.getSeasonNumber());
                                ep.setDvdEpisode(me.getDvdEpisodeNumber());
                                ep.setDvdSeason(me.getDvdSeasonNumber());
                                ep.setFirstAired(me.getReleaseDate());
                                ep.setTitle(me.getTitle());
                                ep.setOriginalTitle(me.getOriginalTitle());
                                ep.setPlot(me.getPlot());
                                ep.setActors(me.getCastMembers(Person.Type.ACTOR));
                                ep.setDirectors(me.getCastMembers(Person.Type.DIRECTOR));
                                ep.setWriters(me.getCastMembers(Person.Type.WRITER));
                                HashMap<String, MediaRating> newRatings = new HashMap<String, MediaRating>();
                                for (MediaRating mediaRating : me.getRatings()) {
                                    newRatings.put(mediaRating.getId(), mediaRating);
                                }
                                ep.setRatings(newRatings);
                                episodes.add(ep);
                            }
                        }
                        catch (MissingIdException missingIdException) {
                            LOGGER.warn("missing id for scrape");
                            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.tvShow, "scraper.error.missingid"));
                        }
                        catch (ScrapeException scrapeException) {
                            LOGGER.error("searchMovieFallback", (Throwable)scrapeException);
                            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.tvShow, "message.scrape.episodelistfailed", new String[]{":", scrapeException.getLocalizedMessage()}));
                        }
                        this.tvShow.setDummyEpisodes(episodes);
                        this.tvShow.saveToDb();
                        if (TvShowScrapeTask.this.cancel) {
                            return;
                        }
                        if (ScraperMetadataConfig.containsAnyArtwork(TvShowScrapeTask.this.tvShowScrapeParams.tvShowScraperMetadataConfig)) {
                            this.tvShow.setArtwork(this.getArtwork(this.tvShow, md), TvShowScrapeTask.this.tvShowScrapeParams.tvShowScraperMetadataConfig, TvShowScrapeTask.this.tvShowScrapeParams.overwriteExistingItems);
                        }
                        if (TvShowScrapeTask.this.cancel) {
                            return;
                        }
                        if (TvShowScrapeTask.this.tvShowScrapeParams.tvShowScraperMetadataConfig.contains(TvShowScraperMetadataConfig.TRAILER)) {
                            this.tvShow.setTrailers(this.getTrailers(this.tvShow, md, trailerScrapers));
                            this.tvShow.saveToDb();
                            this.tvShow.writeNFO();
                            TvShowHelpers.startAutomaticTrailerDownload(this.tvShow);
                        }
                        if (TvShowScrapeTask.this.cancel) {
                            return;
                        }
                        if (TvShowScrapeTask.this.tvShowScrapeParams.tvShowScraperMetadataConfig.contains(TvShowScraperMetadataConfig.THEME)) {
                            TmmTaskManager.getInstance().addUnnamedTask(new TvShowThemeDownloadTask(Collections.singletonList(this.tvShow), TvShowScrapeTask.this.tvShowScrapeParams.overwriteExistingItems));
                        }
                        if (TvShowScrapeTask.this.cancel) {
                            return;
                        }
                        if (TvShowScrapeTask.this.tvShowScrapeParams.episodeScraperMetadataConfig.isEmpty()) break block33;
                        List<TvShowEpisode> list = this.tvShow.getEpisodesToScrape();
                        TvShowEpisodeSearchAndScrapeOptions options1 = new TvShowEpisodeSearchAndScrapeOptions();
                        options1.setDataFromOtherOptions(options);
                        for (TvShowEpisode episode : list) {
                            if (!TvShowScrapeTask.this.cancel) {
                                TvShowEpisodeScrapeTask task = new TvShowEpisodeScrapeTask(Collections.singletonList(episode), options1, TvShowScrapeTask.this.tvShowScrapeParams.episodeScraperMetadataConfig, TvShowScrapeTask.this.tvShowScrapeParams.overwriteExistingItems);
                                task.run();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (MissingIdException e) {
                        LOGGER.warn("missing id for scrape");
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.tvShow, "scraper.error.missingid"));
                    }
                    catch (NothingFoundException e) {
                        LOGGER.debug("nothing found");
                    }
                    catch (ScrapeException e) {
                        LOGGER.error("getTvShowMetadata", (Throwable)e);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.tvShow, "message.scrape.metadatatvshowfailed", new String[]{":", e.getLocalizedMessage()}));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Thread crashed", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"TvShowScraper", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
                }
            }
        }

        private List<MediaArtwork> getArtwork(TvShow tvShow, MediaMetadata metadata) {
            ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
            ArtworkSearchAndScrapeOptions options = new ArtworkSearchAndScrapeOptions(MediaType.TV_SHOW);
            options.setDataFromOtherOptions(TvShowScrapeTask.this.tvShowScrapeParams.scrapeOptions);
            options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
            options.setFanartSize(TvShowModuleManager.getInstance().getSettings().getImageFanartSize());
            options.setPosterSize(TvShowModuleManager.getInstance().getSettings().getImagePosterSize());
            options.setMetadata(metadata);
            for (Map.Entry<String, Object> entry : tvShow.getIds().entrySet()) {
                options.setId(entry.getKey(), entry.getValue().toString());
            }
            for (MediaScraper artworkScraper : TvShowScrapeTask.this.tvShowScrapeParams.scrapeOptions.getArtworkScrapers()) {
                ITvShowArtworkProvider artworkProvider = (ITvShowArtworkProvider)artworkScraper.getMediaProvider();
                try {
                    artwork.addAll(artworkProvider.getArtwork(options));
                }
                catch (MissingIdException ignored) {
                    LOGGER.debug("no id avaiable for scraper {}", (Object)artworkScraper.getId());
                }
                catch (NothingFoundException e) {
                    LOGGER.debug("did not find artwork for '{}'", (Object)tvShow.getTitle());
                }
                catch (ScrapeException e) {
                    LOGGER.error("getArtwork", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)tvShow, "message.scrape.tvshowartworkfailed", new String[]{":", e.getLocalizedMessage()}));
                }
            }
            return artwork;
        }

        private List<MediaTrailer> getTrailers(TvShow tvShow, MediaMetadata metadata, List<MediaScraper> trailerScrapers) {
            ArrayList<MediaTrailer> trailers = new ArrayList<MediaTrailer>();
            TrailerSearchAndScrapeOptions options = new TrailerSearchAndScrapeOptions(MediaType.TV_SHOW);
            options.setDataFromOtherOptions(TvShowScrapeTask.this.tvShowScrapeParams.scrapeOptions);
            options.setMetadata(metadata);
            for (Map.Entry<String, Object> entry : tvShow.getIds().entrySet()) {
                options.setId(entry.getKey(), entry.getValue().toString());
            }
            for (MediaScraper trailerScraper : trailerScrapers) {
                try {
                    ITvShowTrailerProvider trailerProvider = (ITvShowTrailerProvider)trailerScraper.getMediaProvider();
                    trailers.addAll(trailerProvider.getTrailers(options));
                }
                catch (MissingIdException e) {
                    LOGGER.debug("no usable ID found for scraper {}", (Object)trailerScraper.getMediaProvider().getProviderInfo().getId());
                }
                catch (ScrapeException e) {
                    LOGGER.error("getTrailers", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)tvShow, "message.scrape.trailerfailed", new String[]{":", e.getLocalizedMessage()}));
                }
            }
            return trailers;
        }
    }
}

