/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;

public abstract class MediaSearchAndScrapeOptions {
    protected final MediaType type;
    protected final Map<String, Object> ids = new HashMap<String, Object>();
    protected MediaLanguages language = MediaLanguages.en;
    protected CountryCode certificationCountry = CountryCode.US;
    protected String releaseDateCountry = "";
    protected String searchQuery = "";
    protected int searchYear = -1;
    protected MediaScraper metadataScraper;
    protected List<MediaScraper> artworkScrapers = new ArrayList<MediaScraper>();
    protected List<MediaScraper> trailerScrapers = new ArrayList<MediaScraper>();
    protected List<MediaScraper> subtitleScrapers = new ArrayList<MediaScraper>();
    protected MediaSearchResult searchResult;
    protected MediaMetadata metadata;

    protected MediaSearchAndScrapeOptions(MediaType type) {
        this.type = type;
    }

    protected MediaSearchAndScrapeOptions(MediaSearchAndScrapeOptions original) {
        this(original.type);
        this.setDataFromOtherOptions(original);
    }

    public void setDataFromOtherOptions(MediaSearchAndScrapeOptions original) {
        this.setIds(original.ids);
        this.language = original.language;
        this.certificationCountry = original.certificationCountry;
        this.releaseDateCountry = original.releaseDateCountry;
        this.searchQuery = original.searchQuery;
        this.searchYear = original.searchYear;
        this.searchResult = original.searchResult;
        this.metadata = original.metadata;
        this.metadataScraper = original.metadataScraper;
        this.setArtworkScraper(original.artworkScrapers);
        this.setTrailerScraper(original.trailerScrapers);
        this.setSubtitleScraper(original.subtitleScrapers);
    }

    public MediaType getMediaType() {
        return this.type;
    }

    public MediaLanguages getLanguage() {
        return this.language;
    }

    public CountryCode getCertificationCountry() {
        return this.certificationCountry;
    }

    public String getReleaseDateCountry() {
        return this.releaseDateCountry;
    }

    public void setReleaseDateCountry(String releaseDateCountry) {
        this.releaseDateCountry = releaseDateCountry;
    }

    public void setLanguage(MediaLanguages language) {
        this.language = language;
    }

    public void setCertificationCountry(CountryCode certificationCountry) {
        this.certificationCountry = certificationCountry;
    }

    public String getSearchQuery() {
        return this.searchQuery;
    }

    public void setSearchQuery(String searchQuery) {
        this.searchQuery = searchQuery;
    }

    public int getSearchYear() {
        return this.searchYear;
    }

    public void setSearchYear(int searchYear) {
        this.searchYear = searchYear;
    }

    public Map<String, Object> getIds() {
        return Collections.unmodifiableMap(this.ids);
    }

    public String getIdAsString(String providerId) {
        Object id = this.ids.get(providerId);
        if (id != null) {
            return String.valueOf(id);
        }
        return null;
    }

    public Integer getIdAsInteger(String providerId) {
        Object id = this.ids.get(providerId);
        if (id != null) {
            if (id instanceof Integer) {
                return (Integer)id;
            }
            if (id instanceof String) {
                try {
                    return Integer.parseInt((String)id);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public int getIdAsInt(String providerId) {
        return this.getIdAsIntOrDefault(providerId, 0);
    }

    public int getIdAsIntOrDefault(String providerId, int defaultValue) {
        Integer id = this.getIdAsInteger(providerId);
        if (id == null) {
            return defaultValue;
        }
        return id;
    }

    public void setId(String providerId, Object id) {
        this.ids.put(providerId, id);
    }

    public void setIds(Map<String, Object> newIds) {
        this.ids.clear();
        this.ids.putAll(newIds);
    }

    public String getImdbId() {
        Object obj = this.ids.get("imdb");
        if (obj == null && (obj = this.ids.get("imdbId")) == null) {
            return "";
        }
        return obj.toString();
    }

    public int getTmdbId() {
        Integer id = this.getIdAsInteger("tmdb");
        if (id == null || id == 0) {
            id = this.getIdAsInteger("tmdbId");
        }
        if (id != null) {
            return id;
        }
        return 0;
    }

    public void setImdbId(String imdbId) {
        this.ids.put("imdb", imdbId);
    }

    public void setTmdbId(int tmdbId) {
        this.ids.put("tmdb", tmdbId);
    }

    public MediaSearchResult getSearchResult() {
        return this.searchResult;
    }

    public void setSearchResult(MediaSearchResult searchResult) {
        this.searchResult = searchResult;
    }

    public MediaMetadata getMetadata() {
        if (this.metadata != null) {
            return this.metadata;
        }
        if (this.searchResult != null) {
            return this.searchResult.getMediaMetadata();
        }
        return null;
    }

    public void setMetadata(MediaMetadata metadata) {
        this.metadata = metadata;
    }

    public MediaScraper getMetadataScraper() {
        return this.metadataScraper;
    }

    public List<MediaScraper> getArtworkScrapers() {
        return this.artworkScrapers;
    }

    public List<MediaScraper> getTrailerScrapers() {
        return this.trailerScrapers;
    }

    public List<MediaScraper> getSubtitleScrapers() {
        return this.subtitleScrapers;
    }

    public void setMetadataScraper(MediaScraper metadataScraper) {
        this.metadataScraper = metadataScraper;
    }

    public void setArtworkScraper(List<MediaScraper> artworkScrapers) {
        this.artworkScrapers.clear();
        this.artworkScrapers.addAll(artworkScrapers);
    }

    public void setTrailerScraper(List<MediaScraper> trailerScraper) {
        this.trailerScrapers.clear();
        this.trailerScrapers.addAll(trailerScraper);
    }

    public void setSubtitleScraper(List<MediaScraper> subtitleScraper) {
        this.subtitleScrapers.clear();
        this.subtitleScrapers.addAll(subtitleScraper);
    }

    public String toString() {
        return new ReflectionToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE){

            protected boolean accept(Field f) {
                return super.accept(f) && !"metadata".equals(f.getName());
            }
        }.toString();
    }
}

