/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.StrgUtils;

public class MediaSearchResult
implements Comparable<MediaSearchResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaSearchResult.class);
    private final Map<String, Object> ids = new HashMap<String, Object>();
    private MediaType type;
    private String providerId;
    private String url = "";
    private String title = "";
    private String overview = "";
    private int year = 0;
    private String originalTitle = "";
    private String originalLanguage = "";
    private float score = 0.0f;
    private MediaMetadata metadata = null;
    private String posterUrl = "";

    public MediaSearchResult(String providerId, MediaType type) {
        this.providerId = providerId;
        this.type = type;
    }

    public MediaSearchResult(String providerId, MediaType type, float score) {
        this.providerId = providerId;
        this.type = type;
        this.score = score;
    }

    public MediaSearchResult(String providerId, MediaType type, String id, String title, int year, float score) {
        this.providerId = providerId;
        this.type = type;
        this.ids.put(providerId, StrgUtils.getNonNullString(id));
        this.title = StrgUtils.getNonNullString(title);
        this.year = year;
        this.score = score;
    }

    private MediaSearchResult(Builder builder) {
        this.type = builder.type;
        this.setProviderId(builder.providerId);
        this.setId(builder.id);
        this.setUrl(builder.url);
        this.setTitle(builder.title);
        this.setOverview(builder.overview);
        this.setYear(builder.year);
        this.setOriginalTitle(builder.originalTitle);
        this.setOriginalLanguage(builder.originalLanguage);
        this.setScore(builder.score);
        this.setMetadata(builder.metadata);
        this.setPosterUrl(builder.posterUrl);
    }

    public void mergeFrom(MediaSearchResult msr) {
        if (msr == null || !StringUtils.equals((CharSequence)this.providerId, (CharSequence)msr.providerId) || this.type != msr.getMediaType()) {
            return;
        }
        this.url = StringUtils.isEmpty((CharSequence)this.url) ? msr.getUrl() : this.url;
        this.title = StringUtils.isEmpty((CharSequence)this.title) ? msr.getTitle() : this.title;
        this.year = this.year == 0 ? msr.getYear() : this.year;
        this.originalTitle = StringUtils.isEmpty((CharSequence)this.originalTitle) ? msr.getOriginalTitle() : this.originalTitle;
        this.originalLanguage = StringUtils.isEmpty((CharSequence)this.originalLanguage) ? msr.getOriginalLanguage() : this.originalLanguage;
        this.posterUrl = StringUtils.isEmpty((CharSequence)this.posterUrl) ? msr.getPosterUrl() : this.posterUrl;
        for (String key : msr.getIds().keySet()) {
            if (this.ids.containsKey(key)) continue;
            this.ids.put(key, msr.getIds().get(key));
        }
        if (this.metadata == null) {
            this.metadata = msr.getMediaMetadata();
        } else {
            this.metadata.mergeFrom(msr.getMediaMetadata());
        }
    }

    public void mergeFrom(MediaMetadata mediaMetadata) {
        if (mediaMetadata == null) {
            return;
        }
        this.metadata = mediaMetadata;
        this.ids.putAll(mediaMetadata.getIds());
        this.setTitle(mediaMetadata.getTitle());
        this.setOriginalTitle(mediaMetadata.getOriginalTitle());
        this.setYear(mediaMetadata.getYear());
        this.setOverview(mediaMetadata.getPlot());
        if (!mediaMetadata.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).isEmpty()) {
            MediaArtwork poster = mediaMetadata.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).get(0);
            this.setPosterUrl(poster.getDefaultUrl());
        }
    }

    public String getOriginalTitle() {
        return this.originalTitle;
    }

    public void setOriginalTitle(String originalTitle) {
        this.originalTitle = StrgUtils.getNonNullString(originalTitle);
    }

    public String getOriginalLanguage() {
        return this.originalLanguage;
    }

    public void setOriginalLanguage(String originalLanguage) {
        this.originalLanguage = StrgUtils.getNonNullString(originalLanguage);
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = StrgUtils.getNonNullString(title);
    }

    public String getOverview() {
        return this.overview;
    }

    public void setOverview(String overview) {
        this.overview = overview;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public void setYear(Integer year) {
        if (year != null) {
            this.setYear((int)year);
        }
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public void setScore(Float score) {
        if (score != null) {
            this.setScore(score.floatValue());
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = StrgUtils.getNonNullString(url);
    }

    public MediaType getMediaType() {
        return this.type;
    }

    public void setMediaType(MediaType type) {
        this.type = type;
    }

    public Object getId() {
        return this.ids.get(this.providerId);
    }

    public void setId(String id) {
        this.ids.put(this.providerId, StrgUtils.getNonNullString(id));
    }

    public void setId(String providerId, String id) {
        this.ids.put(providerId, StrgUtils.getNonNullString(id));
    }

    public void setIds(Map<String, Object> ids) {
        if (ids == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : ids.entrySet()) {
            if (entry.getValue() == null) continue;
            this.setId(entry.getKey(), entry.getValue().toString());
        }
    }

    public String getIMDBId() {
        String imdbId = "";
        Object obj = this.ids.get("imdb");
        if (obj != null) {
            imdbId = obj.toString();
        }
        if (!MediaIdUtil.isValidImdbId(imdbId) && (obj = this.ids.get("imdbId")) != null) {
            imdbId = obj.toString();
        }
        if (StringUtils.isBlank((CharSequence)imdbId)) {
            return "";
        }
        return imdbId;
    }

    public int getIdAsInt(String key) {
        int id = 0;
        try {
            id = Integer.parseInt(String.valueOf(this.ids.get(key)));
        }
        catch (Exception e) {
            return 0;
        }
        return id;
    }

    public String getIdAsString(String key) {
        Object obj = this.ids.get(key);
        if (obj == null) {
            return "";
        }
        return String.valueOf(obj);
    }

    public Map<String, Object> getIds() {
        return this.ids;
    }

    public void setIMDBId(String imdbid) {
        if (MediaIdUtil.isValidImdbId(imdbid)) {
            this.ids.put("imdb", imdbid);
        }
    }

    public MediaMetadata getMediaMetadata() {
        return this.metadata;
    }

    public void setMetadata(MediaMetadata md) {
        this.metadata = md;
    }

    public String getPosterUrl() {
        return this.posterUrl;
    }

    public void calculateScore(MediaSearchAndScrapeOptions options) {
        float calculatedScore = Math.max(MetadataUtil.calculateScore(options.getSearchQuery(), this.title), MetadataUtil.calculateScore(options.getSearchQuery(), this.originalTitle));
        float yearPenalty = MetadataUtil.calculateYearPenalty(options.getSearchYear(), this.year);
        if (yearPenalty > 0.0f) {
            LOGGER.trace("parsed year does not match search result year - downgrading score by {}", (Object)Float.valueOf(yearPenalty));
            calculatedScore -= yearPenalty;
        }
        if (StringUtils.isBlank((CharSequence)this.posterUrl)) {
            LOGGER.trace("no poster - downgrading score by 0.01");
            calculatedScore -= 0.01f;
        }
        LOGGER.debug(String.format("Similarity Score: [%s] [%s / %s]=[%s]", options.getSearchQuery(), this.title, this.originalTitle, Float.valueOf(calculatedScore)));
        this.setScore(calculatedScore);
    }

    public void setPosterUrl(String posterUrl) {
        this.posterUrl = StrgUtils.getNonNullString(posterUrl);
    }

    @Override
    public int compareTo(MediaSearchResult arg0) {
        if (this.getScore() < arg0.getScore()) {
            return 1;
        }
        if (this.getScore() == arg0.getScore()) {
            if (this.year == arg0.getYear()) {
                return Integer.compare(this.hashCode(), arg0.hashCode());
            }
            return Integer.compare(this.getYear(), arg0.getYear());
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaSearchResult result = (MediaSearchResult)o;
        return Objects.equals(this.providerId, result.providerId) && Objects.equals((Object)this.type, (Object)result.type) && Objects.equals(this.title, result.title) && this.ids.equals(result.ids);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.providerId, this.type, this.title, this.ids});
    }

    public String toString() {
        return new ReflectionToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE){

            protected boolean accept(Field f) {
                return super.accept(f) && !f.getName().equals("metadata");
            }
        }.toString();
    }

    public static final class Builder {
        private final MediaType type;
        private String id;
        private String providerId;
        private String url;
        private String title;
        private String overview;
        private int year;
        private String originalTitle;
        private String originalLanguage;
        private float score;
        private MediaMetadata metadata;
        private String posterUrl;

        public Builder(@Nonnull MediaType type) {
            this.type = type;
        }

        @Nonnull
        public Builder providerId(@Nonnull String val) {
            this.providerId = val;
            return this;
        }

        @Nonnull
        public Builder id(@Nonnull String val) {
            this.id = val;
            return this;
        }

        @Nonnull
        public Builder url(@Nonnull String val) {
            this.url = val;
            return this;
        }

        @Nonnull
        public Builder title(@Nonnull String val) {
            this.title = val;
            return this;
        }

        @Nonnull
        public Builder overview(@Nonnull String val) {
            this.overview = val;
            return this;
        }

        @Nonnull
        public Builder year(int val) {
            this.year = val;
            return this;
        }

        @Nonnull
        public Builder originalTitle(@Nonnull String val) {
            this.originalTitle = val;
            return this;
        }

        @Nonnull
        public Builder originalLanguage(@Nonnull String val) {
            this.originalLanguage = val;
            return this;
        }

        @Nonnull
        public Builder score(float val) {
            this.score = val;
            return this;
        }

        @Nonnull
        public Builder metadata(@Nonnull MediaMetadata val) {
            this.metadata = val;
            return this;
        }

        @Nonnull
        public Builder posterUrl(@Nonnull String val) {
            this.posterUrl = val;
            return this;
        }

        @Nonnull
        public MediaSearchResult build() {
            return new MediaSearchResult(this);
        }
    }
}

