/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tinymediamanager.scraper.util.StrgUtils;

public class SubtitleSearchResult
implements Comparable<SubtitleSearchResult> {
    private String providerId;
    private String id = "";
    private String title = "";
    private String releaseName = "";
    private int stackCount = 0;
    private String url = "";
    private float score = 0.0f;
    private float rating = 0.0f;

    public SubtitleSearchResult(String providerId) {
        this.providerId = providerId;
    }

    public SubtitleSearchResult(String providerId, float score) {
        this.providerId = providerId;
        this.score = score;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getReleaseName() {
        return this.releaseName;
    }

    public void setReleaseName(String releaseName) {
        this.releaseName = StrgUtils.getNonNullString(releaseName);
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = StrgUtils.getNonNullString(title);
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public void setScore(Float score) {
        if (score != null) {
            this.setScore(score.floatValue());
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = StrgUtils.getNonNullString(url);
    }

    public float getRating() {
        return this.rating;
    }

    public void setRating(float rating) {
        this.rating = rating;
    }

    public int getStackCount() {
        return this.stackCount;
    }

    public void setStackCount(int stackCount) {
        this.stackCount = stackCount;
    }

    @Override
    public int compareTo(SubtitleSearchResult arg0) {
        if (this.getScore() < arg0.getScore()) {
            return -1;
        }
        if (this.getScore() == arg0.getScore() && this.getRating() < arg0.getRating()) {
            return -1;
        }
        if (this.getScore() == arg0.getScore() && this.getRating() == arg0.getRating()) {
            return 0;
        }
        return 1;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).toString();
    }
}

