/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.anidb;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.anidb.AniDbTvShowMetadataProvider;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.util.StrgUtils;

class AniDbMetadataParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(AniDbMetadataParser.class);
    private static final String IMAGE_SERVER = "http://img7.anidb.net/pics/anime/";

    private AniDbMetadataParser() {
        throw new IllegalAccessError();
    }

    static void fillAnimeMetadata(MediaMetadata md, String language, Element anime, MediaProviderInfo providerInfo) {
        for (Element e : anime.children()) {
            switch (e.tagName()) {
                case "startdate": {
                    AniDbMetadataParser.fillDateMetadata(md, e);
                    break;
                }
                case "titles": {
                    AniDbMetadataParser.fillTitleMetadata(md, language, e);
                    break;
                }
                case "description": {
                    md.setPlot(e.text());
                    break;
                }
                case "ratings": {
                    AniDbMetadataParser.fillRatingsMetadata(md, e);
                    break;
                }
                case "tags": {
                    AniDbMetadataParser.fillTagsMetadata(md, e, providerInfo.getConfig().getValueAsInteger("numberOfTags"), providerInfo.getConfig().getValueAsInteger("minimumTagsWeight"));
                    break;
                }
                case "picture": {
                    AniDbMetadataParser.fillArtworkMetadata(md, language, e, providerInfo.getId());
                    break;
                }
                case "characters": {
                    AniDbMetadataParser.fillActorsMetadata(md, e);
                    break;
                }
            }
        }
        md.addGenre(MediaGenres.ANIME);
    }

    private static void fillDateMetadata(MediaMetadata md, Element startDate) {
        try {
            Date date = StrgUtils.parseDate(startDate.text());
            if (date == null) {
                return;
            }
            md.setReleaseDate(date);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            md.setYear(calendar.get(1));
        }
        catch (ParseException ex) {
            LOGGER.debug("could not parse date: {}", (Object)startDate.text());
        }
    }

    private static void fillTitleMetadata(MediaMetadata md, String language, Element titles) {
        String titleEN = "";
        String titleScraperLangu = "";
        String titleMain = "";
        for (Element title : titles.children()) {
            if ("short".equals(title.attr("type"))) continue;
            boolean synonym = "synonym".equals(title.attr("type"));
            if ("main".equalsIgnoreCase(title.attr("type")) && (!synonym || StringUtils.isBlank((CharSequence)titleMain))) {
                titleMain = title.text();
            }
            if ("en".equalsIgnoreCase(title.attr("xml:lang")) && (!synonym || StringUtils.isBlank((CharSequence)titleEN))) {
                titleEN = title.text();
            }
            if (!language.equalsIgnoreCase(title.attr("xml:lang")) || synonym && !StringUtils.isBlank((CharSequence)titleScraperLangu)) continue;
            titleScraperLangu = title.text();
        }
        if (StringUtils.isNotBlank((CharSequence)titleMain)) {
            md.setOriginalTitle(titleMain);
        }
        if (StringUtils.isNotBlank((CharSequence)titleScraperLangu)) {
            md.setTitle(titleScraperLangu);
        } else if (StringUtils.isNotBlank((CharSequence)titleEN)) {
            md.setTitle(titleEN);
        } else {
            md.setTitle(titleMain);
        }
    }

    private static void fillRatingsMetadata(MediaMetadata md, Element ratings) {
        for (Element rating : ratings.children()) {
            if (!"temporary".equalsIgnoreCase(rating.tagName())) continue;
            try {
                MediaRating mediaRating = new MediaRating("anidb");
                mediaRating.setRating(Float.parseFloat(rating.text()));
                mediaRating.setVotes(Integer.parseInt(rating.attr("count")));
                mediaRating.setMaxValue(10);
                md.addRating(mediaRating);
                break;
            }
            catch (NumberFormatException ex) {
                LOGGER.debug("could not parse rating: {} - {}", (Object)rating.text(), (Object)rating.attr("count"));
            }
        }
    }

    private static void fillTagsMetadata(MediaMetadata md, Element tags, Integer maxTags, Integer minWeight) {
        for (Element tag : tags.children()) {
            Element name = tag.getElementsByTag("name").first();
            int weight = 0;
            try {
                weight = Integer.parseInt(tag.attr("weight"));
            }
            catch (Exception ex) {
                LOGGER.trace("Could not parse tags weight: {}", (Object)ex.getMessage());
            }
            if (name == null || weight < minWeight) continue;
            md.addTag(name.text());
            if (md.getTags().size() < maxTags) continue;
            break;
        }
    }

    private static void fillArtworkMetadata(MediaMetadata md, String language, Element picture, String providerId) {
        MediaArtwork ma = new MediaArtwork(providerId, MediaArtwork.MediaArtworkType.POSTER);
        ma.setPreviewUrl(IMAGE_SERVER + picture.text());
        ma.setDefaultUrl(IMAGE_SERVER + picture.text());
        ma.setOriginalUrl(IMAGE_SERVER + picture.text());
        ma.setLanguage(language);
        md.addMediaArt(ma);
    }

    private static void fillActorsMetadata(MediaMetadata md, Element characters) {
        for (Element character : characters.children()) {
            Person member = new Person(Person.Type.ACTOR);
            for (Element characterInfo : character.children()) {
                if ("name".equalsIgnoreCase(characterInfo.tagName())) {
                    member.setRole(characterInfo.text());
                }
                if (!"seiyuu".equalsIgnoreCase(characterInfo.tagName())) continue;
                member.setName(characterInfo.text());
                String image = characterInfo.attr("picture");
                if (!StringUtils.isNotBlank((CharSequence)image)) continue;
                member.setThumbUrl(IMAGE_SERVER + image);
            }
            md.addCastMember(member);
        }
    }

    static List<AniDbTvShowMetadataProvider.Episode> parseEpisodes(@Nullable Element episodes) {
        if (episodes == null) {
            return new ArrayList<AniDbTvShowMetadataProvider.Episode>();
        }
        return episodes.children().stream().filter(e -> e.tagName().equals("episode")).map(AniDbMetadataParser::parseEpisode).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static AniDbTvShowMetadataProvider.Episode parseEpisode(Element episodeElement) {
        AniDbTvShowMetadataProvider.Episode.Builder builder = new AniDbTvShowMetadataProvider.Episode.Builder();
        try {
            builder.id(Integer.parseInt(episodeElement.attr("id")));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        for (Element episodeInfo : episodeElement.children()) {
            if ("epno".equalsIgnoreCase(episodeInfo.tagName())) {
                String type = episodeInfo.attr("type");
                try {
                    if ("1".equals(type)) {
                        builder.season(1);
                        builder.episode(Integer.parseInt(episodeInfo.text()));
                        continue;
                    }
                    if ("2".equals(type)) {
                        builder.season(0);
                        builder.episode(Integer.parseInt(episodeInfo.text().replaceAll("[^0-9]+", "")));
                        continue;
                    }
                    return null;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
            }
            if ("length".equalsIgnoreCase(episodeInfo.tagName())) {
                try {
                    builder.runtime(Integer.parseInt(episodeInfo.text()));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("airdate".equalsIgnoreCase(episodeInfo.tagName())) {
                try {
                    builder.airdate(StrgUtils.parseDate(episodeInfo.text()));
                }
                catch (Exception exception) {}
                continue;
            }
            if ("rating".equalsIgnoreCase(episodeInfo.tagName())) {
                try {
                    builder.rating(Float.parseFloat(episodeInfo.text()));
                    builder.votes(Integer.parseInt(episodeInfo.attr("votes")));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("title".equalsIgnoreCase(episodeInfo.tagName())) {
                try {
                    builder.titles(episodeInfo.attr("xml:lang").toLowerCase(Locale.ROOT), episodeInfo.text());
                }
                catch (Exception exception) {}
                continue;
            }
            if (!"summary".equalsIgnoreCase(episodeInfo.tagName())) continue;
            builder.summary(episodeInfo.text());
        }
        return builder.build();
    }
}

