/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.anidb;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.anidb.AniDbMetadataParser;
import org.tinymediamanager.scraper.anidb.AniDbMetadataProvider;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowArtworkProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.util.Similarity;

public class AniDbTvShowMetadataProvider
extends AniDbMetadataProvider
implements ITvShowMetadataProvider,
ITvShowArtworkProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AniDbTvShowMetadataProvider.class);

    @Override
    protected MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo info = new MediaProviderInfo("anidb", "tvshow", "aniDB", "<html><h3>aniDB</h3><br />AniDB stands for Anime DataBase. AniDB is a non-profit anime database that is open freely to the public.</html>", AniDbTvShowMetadataProvider.class.getResource("/org/tinymediamanager/scraper/anidb_net.png"), -10);
        info.getConfig().addInteger("numberOfTags", 10);
        info.getConfig().addInteger("minimumTagsWeight", 200);
        info.getConfig().addBoolean("characterImage", false);
        info.getConfig().load();
        return info;
    }

    @Override
    public MediaMetadata getMetadata(TvShowEpisodeSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getMetadata(): {}", (Object)options);
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        MediaMetadata md = null;
        int seasonNr = options.getIdAsIntOrDefault("seasonNr", -1);
        int episodeNr = options.getIdAsIntOrDefault("episodeNr", -1);
        if (seasonNr == -1 || episodeNr == -1) {
            throw new MissingIdException("seasonNr", "episodeNr");
        }
        List<MediaMetadata> episodes = this.getEpisodeList(options.createTvShowSearchAndScrapeOptions());
        for (MediaMetadata episode : episodes) {
            if (episode.getEpisodeNumber() != episodeNr || episode.getSeasonNumber() != seasonNr) continue;
            md = episode;
            break;
        }
        if (md == null) {
            throw new NothingFoundException();
        }
        return md;
    }

    @Override
    public List<MediaMetadata> getEpisodeList(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        ArrayList<MediaMetadata> episodes = new ArrayList<MediaMetadata>();
        String language = options.getLanguage().getLanguage();
        String id = options.getIdAsString(this.providerInfo.getId());
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new MissingIdException(new String[]{this.providerInfo.getId()});
        }
        Document doc = this.requestAnimeDocument(options);
        if (doc == null || doc.children().isEmpty()) {
            return episodes;
        }
        for (Episode ep : AniDbMetadataParser.parseEpisodes(doc.getElementsByTag("episodes").first())) {
            MediaMetadata md = new MediaMetadata(this.providerInfo.getId());
            md.setScrapeOptions(options);
            md.setTitle(ep.titles.get(language));
            md.setSeasonNumber(ep.season);
            md.setEpisodeNumber(ep.episode);
            if (StringUtils.isBlank((CharSequence)md.getTitle())) {
                md.setTitle(ep.titles.get("en"));
            }
            if (StringUtils.isBlank((CharSequence)md.getTitle())) {
                md.setTitle(ep.titles.get("x-jat"));
            }
            md.setPlot(ep.summary);
            if (ep.rating > 0.0f) {
                MediaRating rating = new MediaRating(this.providerInfo.getId());
                rating.setRating(ep.rating);
                rating.setVotes(ep.votes);
                rating.setMaxValue(10);
                md.addRating(rating);
            }
            md.setRuntime(ep.runtime);
            md.setReleaseDate(ep.airdate);
            md.setId(this.providerInfo.getId(), ep.id);
            episodes.add(md);
        }
        return episodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSet<MediaSearchResult> search(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("search(): {}", (Object)options);
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        Class<AniDbTvShowMetadataProvider> clazz = AniDbTvShowMetadataProvider.class;
        synchronized (AniDbTvShowMetadataProvider.class) {
            if (this.showsForLookup.isEmpty()) {
                this.buildTitleHashMap();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            String searchString = "";
            if (StringUtils.isNotEmpty((CharSequence)options.getSearchQuery())) {
                searchString = options.getSearchQuery();
            }
            if (StringUtils.isEmpty((CharSequence)searchString)) {
                return new TreeSet<MediaSearchResult>();
            }
            String finalSearchString = searchString;
            return this.showsForLookup.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).map(show -> new MediaSearchResult.Builder(MediaType.TV_SHOW).providerId(this.providerInfo.getId()).id(String.valueOf(show.aniDbId)).title(show.title).score(Similarity.compareStrings(show.title, finalSearchString)).build()).filter(msr -> msr.getScore() >= 0.75f).collect(Collectors.toCollection(TreeSet::new));
        }
    }

    @Override
    public List<MediaArtwork> getArtwork(ArtworkSearchAndScrapeOptions options) throws ScrapeException {
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
        String id = "";
        if (options.getMetadata() != null && this.getId().equals(options.getMetadata().getProviderId())) {
            id = options.getMetadata().getIdAsString(this.providerInfo.getId());
        }
        if (StringUtils.isEmpty((CharSequence)id)) {
            id = options.getIdAsString(this.providerInfo.getId());
        }
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new MissingIdException(new String[]{this.providerInfo.getId()});
        }
        switch (options.getArtworkType()) {
            case ALL: 
            case POSTER: {
                MediaMetadata md;
                try {
                    TvShowSearchAndScrapeOptions tvShowSearchAndScrapeOptions = new TvShowSearchAndScrapeOptions();
                    tvShowSearchAndScrapeOptions.setDataFromOtherOptions(options);
                    md = this.getMetadata(tvShowSearchAndScrapeOptions);
                }
                catch (Exception e) {
                    LOGGER.error("could not get artwork: {}", (Object)e.getMessage());
                    throw new ScrapeException(e);
                }
                artwork.addAll(md.getMediaArt(MediaArtwork.MediaArtworkType.POSTER));
                break;
            }
            default: {
                return artwork;
            }
        }
        return artwork;
    }

    @Override
    public MediaMetadata getMetadata(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getMetadata(): {}", (Object)options);
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        Document doc = this.requestAnimeDocument(options);
        if (doc == null || doc.children().isEmpty()) {
            return null;
        }
        MediaMetadata md = new MediaMetadata(this.providerInfo.getId());
        md.setScrapeOptions(options);
        String language = options.getLanguage().getLanguage();
        String id = options.getIdAsString(this.providerInfo.getId());
        md.setId(this.providerInfo.getId(), id);
        AniDbMetadataParser.fillAnimeMetadata(md, language, doc.child(0), this.providerInfo);
        return md;
    }

    static class Episode {
        int id;
        int episode = -1;
        int season = -1;
        int runtime = 0;
        Date airdate = null;
        float rating = 0.0f;
        int votes = 0;
        String summary = "";
        Map<String, String> titles;

        private Episode(Builder builder) {
            this.id = builder.id;
            this.episode = builder.episode;
            this.season = builder.season;
            this.runtime = builder.runtime;
            this.airdate = builder.airdate;
            this.rating = builder.rating;
            this.votes = builder.votes;
            this.summary = builder.summary;
            this.titles = builder.titles;
        }

        public static final class Builder {
            private int id = -1;
            private int episode = -1;
            private int season = -1;
            private int runtime = 0;
            private Date airdate = null;
            private float rating = 0.0f;
            private int votes = 0;
            private String summary = "";
            private Map<String, String> titles = new HashMap<String, String>();

            @Nonnull
            public Builder id(int val) {
                this.id = val;
                return this;
            }

            @Nonnull
            public Builder episode(int val) {
                this.episode = val;
                return this;
            }

            @Nonnull
            public Builder season(int val) {
                this.season = val;
                return this;
            }

            @Nonnull
            public Builder runtime(int val) {
                this.runtime = val;
                return this;
            }

            @Nonnull
            public Builder airdate(@Nonnull Date val) {
                this.airdate = val;
                return this;
            }

            @Nonnull
            public Builder rating(float val) {
                this.rating = val;
                return this;
            }

            @Nonnull
            public Builder votes(int val) {
                this.votes = val;
                return this;
            }

            @Nonnull
            public Builder summary(@Nonnull String val) {
                this.summary = val;
                return this;
            }

            @Nonnull
            public Builder titles(@Nonnull Map<String, String> val) {
                this.titles = val;
                return this;
            }

            @Nonnull
            public Builder titles(@Nonnull String language, @Nonnull String title) {
                this.titles.put(language, title);
                return this;
            }

            @Nonnull
            public Episode build() {
                return new Episode(this);
            }
        }
    }
}

