/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.entities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.scraper.util.StrgUtils;

public class MediaArtwork {
    private final String providerId;
    private final MediaArtworkType type;
    private String imdbId;
    private int tmdbId;
    private int season = -1;
    private String previewUrl = "";
    private String defaultUrl = "";
    private String originalUrl = "";
    private String language = "";
    private int sizeOrder = 0;
    private int likes = 0;
    private boolean animated = false;
    private final List<ImageSizeAndUrl> imageSizes = new ArrayList<ImageSizeAndUrl>();

    public MediaArtwork(String providerId, MediaArtworkType type) {
        this.providerId = providerId;
        this.type = type;
    }

    public MediaArtwork(MediaArtwork oldArtwork, MediaArtworkType type) {
        this.imdbId = oldArtwork.getImdbId();
        this.tmdbId = oldArtwork.getTmdbId();
        this.season = oldArtwork.getSeason();
        this.previewUrl = oldArtwork.getPreviewUrl();
        this.defaultUrl = oldArtwork.getDefaultUrl();
        this.originalUrl = oldArtwork.getOriginalUrl();
        this.language = oldArtwork.getLanguage();
        this.providerId = oldArtwork.getProviderId();
        this.sizeOrder = oldArtwork.getSizeOrder();
        this.likes = oldArtwork.getLikes();
        for (ImageSizeAndUrl oldImageSizeAndUrl : oldArtwork.getImageSizes()) {
            this.imageSizes.add(new ImageSizeAndUrl(oldImageSizeAndUrl.width, oldImageSizeAndUrl.height, oldImageSizeAndUrl.url));
        }
        this.type = type;
    }

    public String getPreviewUrl() {
        if (StringUtils.isBlank((CharSequence)this.previewUrl)) {
            return this.defaultUrl;
        }
        return this.previewUrl;
    }

    public void setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
    }

    public String getDefaultUrl() {
        if (this.defaultUrl.isEmpty()) {
            return this.originalUrl;
        }
        return this.defaultUrl;
    }

    public void setDefaultUrl(String defaultUrl) {
        this.defaultUrl = defaultUrl;
    }

    public String getOriginalUrl() {
        return this.originalUrl;
    }

    public void setOriginalUrl(String originalUrl) {
        this.originalUrl = originalUrl;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public MediaArtworkType getType() {
        return this.type;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = StrgUtils.getNonNullString(language);
    }

    public int getTmdbId() {
        return this.tmdbId;
    }

    public void setTmdbId(int tmdbId) {
        this.tmdbId = tmdbId;
    }

    public String getImdbId() {
        return this.imdbId;
    }

    public void setImdbId(String imdbId) {
        this.imdbId = StrgUtils.getNonNullString(imdbId);
    }

    public void addImageSize(int width, int height, String url) {
        this.imageSizes.add(new ImageSizeAndUrl(width, height, url));
    }

    public List<ImageSizeAndUrl> getImageSizes() {
        ArrayList<ImageSizeAndUrl> descImageSizes = new ArrayList<ImageSizeAndUrl>(this.imageSizes);
        descImageSizes.sort(Collections.reverseOrder());
        return descImageSizes;
    }

    public ImageSizeAndUrl getSmallestArtwork() {
        if (!this.imageSizes.isEmpty()) {
            ArrayList<ImageSizeAndUrl> ascImageSizes = new ArrayList<ImageSizeAndUrl>(this.imageSizes);
            Collections.sort(ascImageSizes);
            ImageSizeAndUrl smallestImage = (ImageSizeAndUrl)ascImageSizes.get(0);
            if (smallestImage != null) {
                return smallestImage;
            }
        }
        return null;
    }

    public ImageSizeAndUrl getBiggestArtwork() {
        if (!this.imageSizes.isEmpty()) {
            ArrayList<ImageSizeAndUrl> descImageSizes = new ArrayList<ImageSizeAndUrl>(this.imageSizes);
            descImageSizes.sort(Collections.reverseOrder());
            ImageSizeAndUrl biggestImage = (ImageSizeAndUrl)descImageSizes.get(0);
            if (biggestImage != null) {
                return biggestImage;
            }
        }
        return null;
    }

    public int getSizeOrder() {
        return this.sizeOrder;
    }

    public void setSizeOrder(int sizeOrder) {
        this.sizeOrder = sizeOrder;
    }

    public int getLikes() {
        return this.likes;
    }

    public void setLikes(int likes) {
        this.likes = likes;
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void setAnimated(boolean animated) {
        this.animated = animated;
    }

    public int getSeason() {
        return this.season;
    }

    public void setSeason(int season) {
        this.season = season;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static class MediaArtworkComparator
    implements Comparator<MediaArtwork> {
        private String preferredLangu;

        public MediaArtworkComparator(String language) {
            this.preferredLangu = language;
        }

        @Override
        public int compare(MediaArtwork arg0, MediaArtwork arg1) {
            if (Objects.equals(this.preferredLangu, arg0.getLanguage()) && !Objects.equals(this.preferredLangu, arg1.getLanguage())) {
                return -1;
            }
            if (!Objects.equals(this.preferredLangu, arg0.getLanguage()) && Objects.equals(this.preferredLangu, arg1.getLanguage())) {
                return 1;
            }
            if ("en".equals(arg0.getLanguage()) && !"en".equals(arg1.getLanguage())) {
                return -1;
            }
            if (!"en".equals(arg0.getLanguage()) && "en".equals(arg1.getLanguage())) {
                return 1;
            }
            if (arg0.getSizeOrder() == arg1.getSizeOrder()) {
                if (arg0.getLikes() == arg1.getLikes()) {
                    return 0;
                }
                return arg0.getLikes() > arg1.getLikes() ? -1 : 1;
            }
            return arg0.getSizeOrder() > arg1.getSizeOrder() ? -1 : 1;
        }
    }

    public static class ImageSizeAndUrl
    implements Comparable<ImageSizeAndUrl> {
        private final int width;
        private final int height;
        private final String url;

        public ImageSizeAndUrl(int width, int height, String url) {
            this.width = width;
            this.height = height;
            this.url = StrgUtils.getNonNullString(url);
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public String getUrl() {
            return this.url;
        }

        @Override
        public int compareTo(ImageSizeAndUrl obj) {
            if (obj == null) {
                return 1;
            }
            return this.width * this.height - obj.width * obj.height;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImageSizeAndUrl that = (ImageSizeAndUrl)o;
            return this.width == that.width && this.height == that.height && this.url.equals(that.url);
        }

        public int hashCode() {
            return Objects.hash(this.width, this.height, this.url);
        }

        public String toString() {
            return this.width + "x" + this.height;
        }
    }

    public static enum FanartSizes {
        XLARGE(TmmResourceBundle.getString("Settings.image.xlarge") + ": ~3840x2160px", 16),
        LARGE(TmmResourceBundle.getString("Settings.image.large") + ": ~1920x1080px", 8),
        MEDIUM(TmmResourceBundle.getString("Settings.image.medium") + ": ~1280x720px", 2),
        SMALL(TmmResourceBundle.getString("Settings.image.small") + ": ~300x168px", 1);

        private final String text;
        private final int order;

        private FanartSizes(String text, int order) {
            this.text = text;
            this.order = order;
        }

        public String toString() {
            return this.text;
        }

        public int getOrder() {
            return this.order;
        }
    }

    public static enum PosterSizes {
        XLARGE(TmmResourceBundle.getString("Settings.image.xlarge") + ": ~2000x3000px", 16),
        LARGE(TmmResourceBundle.getString("Settings.image.large") + ": ~1000x1500px", 8),
        BIG(TmmResourceBundle.getString("Settings.image.big") + ": ~500x750px", 4),
        MEDIUM(TmmResourceBundle.getString("Settings.image.medium") + ": ~342x513px", 2),
        SMALL(TmmResourceBundle.getString("Settings.image.small") + ": ~185x277px", 1);

        private final String text;
        private final int order;

        private PosterSizes(String text, int order) {
            this.text = text;
            this.order = order;
        }

        public String toString() {
            return this.text;
        }

        public int getOrder() {
            return this.order;
        }
    }

    public static enum MediaArtworkType {
        BACKGROUND,
        BANNER,
        POSTER,
        ACTOR,
        SEASON_POSTER,
        SEASON_FANART,
        SEASON_BANNER,
        SEASON_THUMB,
        THUMB,
        CLEARART,
        KEYART,
        CHARACTERART,
        DISC,
        LOGO,
        CLEARLOGO,
        ALL;

    }
}

