/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.entities;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.scraper.util.LanguageUtils;

public enum MediaLanguages {
    af("Afrikaans"),
    ar("\u0627\u0644\u0639\u064e\u0631\u064e\u0628\u0650\u064a\u064e\u0651\u0629"),
    az("Az\u0259rbaycan"),
    be("\u0431\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430\u044f \u043c\u043e\u0432\u0430"),
    bg("\u0431\u044a\u043b\u0433\u0430\u0440\u0441\u043a\u0438 \u0435\u0437\u0438\u043a"),
    bm("Bamanankan"),
    bn("\u09ac\u09be\u0982\u09b2\u09be"),
    bs("Bosanski"),
    ca("Catal\u00e0"),
    ch("Finu' Chamorro"),
    cn("\u5e7f\u5dde\u8bdd / \u5ee3\u5dde\u8a71"),
    cs("\u010cesk\u00fd"),
    cy("Cymraeg"),
    da("Dansk"),
    de("Deutsch"),
    ee("\u00c8\u028begbe"),
    el("\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac"),
    en("English"),
    es("Espa\u00f1ol"),
    es_MX("Espa\u00f1ol (Mexico)"),
    et("Eesti"),
    eu("Euskera"),
    fa("\u0641\u0627\u0631\u0633\u06cc"),
    fi("Suomi"),
    fr("Fran\u00e7aise"),
    fr_CA("Fran\u00e7ais canadien"),
    ff("Fulfulde"),
    ga("Gaeilge"),
    gl("Galego"),
    ha("Hausa"),
    he("\u05e2\u05d1\u05e8\u05d9\u05ea"),
    hi("\u0939\u093f\u0928\u094d\u0926\u0940"),
    hr("hrvatski jezik"),
    hu("Magyar"),
    hy("\u0540\u0561\u0575\u0565\u0580\u0565\u0576"),
    id("Bahasa Indonesia"),
    is("\u00cdslenska"),
    it("Italiano"),
    ja("\u65e5\u672c\u8a9e"),
    ka("\u10e5\u10d0\u10e0\u10d7\u10e3\u10da\u10d8"),
    kk("\u049b\u0430\u0437\u0430\u049b"),
    ko("\ud55c\uad6d\uc5b4"),
    la("Latin"),
    lv("Latvie\u0161u"),
    lt("Lietuvi\u0173"),
    mk("\u043c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0438 \u0458\u0430\u0437\u0438\u043a"),
    ms("Bahasa melayu"),
    mt("Malti"),
    nb("Bokm\u00e5l"),
    nl("Nederlands, Vlaams"),
    no("Norsk"),
    pa("\u0a2a\u0a70\u0a1c\u0a3e\u0a2c\u0a40"),
    pl("Polski"),
    ps("\u067e\u069a\u062a\u0648"),
    pt("Portugu\u00eas"),
    pt_BR("Portugu\u00eas (Brasil)"),
    rn("Kirundi"),
    ro("Rom\u00e2n\u0103"),
    ru("\u0420\u0443\u0441\u0441\u043a\u0438\u0439"),
    rw("Kinyarwanda"),
    si("\u0dc3\u0dd2\u0d82\u0dc4\u0dbd"),
    sk("Sloven\u010dina"),
    sl("Sloven\u0161\u010dina"),
    so("Somali"),
    sq("Shqip"),
    sr("\u0441\u0440\u043f\u0441\u043a\u0438 / Srpski"),
    sv("Svenska"),
    sw("Kiswahili"),
    ta("\u0ba4\u0bae\u0bbf\u0bb4\u0bcd"),
    te("\u0c24\u0c46\u0c32\u0c41\u0c17\u0c41"),
    th("\u0e20\u0e32\u0e29\u0e32\u0e44\u0e17\u0e22"),
    tr("T\u00fcrk\u00e7e"),
    uk("\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430"),
    ur("\u0627\u0631\u062f\u0648"),
    uz("ozbek"),
    vi("Ti\u1ebfng Vi\u1ec7t"),
    wo("Wolof"),
    yo("\u00c8d\u00e8 Yor\u00f9b\u00e1"),
    zh("\u4e2d\u6587"),
    zh_CN("\u5927\u9646\u7b80\u4f53"),
    zh_HK("\u9999\u6e2f\u7e41\u9ad4"),
    zh_SG("\u65b0\u52a0\u5761\u7b80\u4f53"),
    zh_TW("\u81fa\u7063\u7e41\u9ad4"),
    zu("isiZulu"),
    none("-");

    private final String title;
    private final String displayTitle;
    private static final Map<String, MediaLanguages> lookup;

    private static Map<String, MediaLanguages> prepareLookup() {
        HashMap<String, MediaLanguages> mlMap = new HashMap<String, MediaLanguages>();
        for (MediaLanguages lang : MediaLanguages.values()) {
            mlMap.put(lang.getTitle(), lang);
            mlMap.put(lang.name(), lang);
        }
        return mlMap;
    }

    public static MediaLanguages get(String title) {
        MediaLanguages entry = lookup.get(title);
        if (entry == null) {
            entry = lookup.get(LanguageUtils.getIso2LanguageFromLocalizedString(title));
        }
        if (entry == null) {
            entry = en;
        }
        return entry;
    }

    private MediaLanguages(String title) {
        this.title = title;
        Locale locale = Locale.forLanguageTag(this.name());
        this.displayTitle = locale != null && StringUtils.isNotBlank((CharSequence)locale.getDisplayLanguage()) && !this.name().equals(locale.getDisplayLanguage()) ? locale.getDisplayLanguage() : title;
    }

    public String getTitle() {
        return this.title;
    }

    public String getLanguage() {
        if (this == none) {
            return "";
        }
        return this.name().substring(0, 2);
    }

    public String toString() {
        return this.displayTitle;
    }

    public Locale toLocale() {
        if (this == none) {
            return null;
        }
        return LocaleUtils.toLocale((String)this.name());
    }

    public static MediaLanguages[] valuesSorted() {
        TreeMap<String, MediaLanguages> map = new TreeMap<String, MediaLanguages>(String.CASE_INSENSITIVE_ORDER);
        for (MediaLanguages ml : MediaLanguages.values()) {
            if (ml == none) continue;
            map.put(ml.toString(), ml);
        }
        return map.values().toArray(new MediaLanguages[0]);
    }

    public static MediaLanguages[] allValuesSorted() {
        TreeMap<String, MediaLanguages> map = new TreeMap<String, MediaLanguages>(String.CASE_INSENSITIVE_ORDER);
        for (MediaLanguages ml : MediaLanguages.values()) {
            map.put(ml.toString(), ml);
        }
        return map.values().toArray(new MediaLanguages[0]);
    }

    static {
        lookup = MediaLanguages.prepareLookup();
    }
}

