/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.exceptions;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class HttpException
extends IOException {
    private static final long serialVersionUID = 2161692612692312193L;
    private final String url;
    private final int statusCode;
    private final String message;

    public HttpException(String message) {
        this(null, 0, message);
    }

    public HttpException(String url, String message) {
        this(url, 0, message);
    }

    public HttpException(int statusCode, String message) {
        this(null, statusCode, message);
    }

    public HttpException(String url, int statusCode, String message) {
        this.url = url;
        this.statusCode = statusCode;
        this.message = message;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String toString() {
        if (StringUtils.isNotBlank((CharSequence)this.url) && this.statusCode > 0) {
            return "HTTP " + this.statusCode + " / " + this.message + " | " + this.url;
        }
        if (StringUtils.isNotBlank((CharSequence)this.url)) {
            return this.message + " | " + this.url;
        }
        if (this.statusCode > 0) {
            return "HTTP " + this.statusCode + " / " + this.message;
        }
        return this.message;
    }

    @Override
    public String getMessage() {
        return this.toString();
    }
}

