/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.ffmpeg;

import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.addon.FFmpegAddon;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.mediainfo.MediaInfoFile;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.thirdparty.FFmpeg;

abstract class FFmpegArtworkProvider
implements IMediaProvider {
    static final String ID = "ffmpeg";
    private final MediaProviderInfo providerInfo = this.createMediaProviderInfo();

    FFmpegArtworkProvider() {
    }

    protected abstract String getSubId();

    protected MediaProviderInfo createMediaProviderInfo() {
        return new MediaProviderInfo(ID, this.getSubId(), ID, "<html><h3>FFmpeg</h3><br />The FFmpeg artwork provider is a meta provider which uses the local FFmpeg installation to extract several stills from your video files</html>", FFmpegArtworkProvider.class.getResource("/org/tinymediamanager/scraper/ffmpeg.svg"));
    }

    @Override
    public String getId() {
        return this.providerInfo.getId();
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    @Override
    public boolean isActive() {
        return this.isFeatureEnabled() && (StringUtils.isNotBlank((CharSequence)Settings.getInstance().getMediaFramework()) || new FFmpegAddon().isAvailable());
    }

    public List<MediaArtwork> getArtwork(ArtworkSearchAndScrapeOptions options) throws ScrapeException {
        if (!FFmpeg.isAvailable()) {
            throw new MissingIdException(new String[]{"FFmpeg"});
        }
        Object mf = options.getIds().get("mediaFile");
        if (!(mf instanceof MediaFile)) {
            throw new ScrapeException(new FileNotFoundException());
        }
        MediaFile mediaFile = (MediaFile)mf;
        if (mediaFile.isISO() || mediaFile.getDuration() == 0) {
            return Collections.emptyList();
        }
        if (mediaFile.isDiscFile()) {
            return this.createStillsFromDiscFiles(mediaFile, options);
        }
        return this.createStillsFromPlainFile(mediaFile, options);
    }

    private List<MediaArtwork> createStillsFromPlainFile(MediaFile mediaFile, ArtworkSearchAndScrapeOptions options) {
        int duration = mediaFile.getDuration();
        int count = this.providerInfo.getConfig().getValueAsInteger("count");
        int start = this.providerInfo.getConfig().getValueAsInteger("start");
        int end = this.providerInfo.getConfig().getValueAsInteger("end");
        if (start <= 0) {
            start = 1;
        } else if (start >= 100) {
            start = 99;
        }
        if (end <= 0) {
            end = 1;
        } else if (end >= 100) {
            end = 99;
        }
        if (start > end) {
            int temp = start;
            start = end;
            end = temp;
        }
        if (count <= 0) {
            count = 1;
        }
        float increment = (float)(end - start) / (100.0f * (float)count);
        ArrayList<MediaArtwork> artworks = new ArrayList<MediaArtwork>();
        Random random = new Random(System.nanoTime());
        for (int i = 0; i < count; ++i) {
            int second = (int)((float)duration * ((float)start / 100.0f + (float)i * increment));
            int variance = (int)((double)((float)duration * increment) * (-0.5 + random.nextDouble()));
            if (second + variance <= 0 || second + variance > duration) {
                variance = 0;
            }
            try {
                MediaArtwork still;
                Path tempFile = Paths.get(Utils.getTempFolder(), "ffmpeg-still." + System.currentTimeMillis() + ".jpg");
                FFmpeg.createStill(mediaFile.getFile(), tempFile, second + variance);
                int width = mediaFile.getVideoWidth();
                int height = mediaFile.getVideoHeight();
                int artworkSizeOrder = this.detectArtworkSizeOrder(width);
                if (this.isFanartEnabled() && (options.getArtworkType() == MediaArtwork.MediaArtworkType.ALL || options.getArtworkType() == MediaArtwork.MediaArtworkType.BACKGROUND)) {
                    still = new MediaArtwork(this.getId(), MediaArtwork.MediaArtworkType.BACKGROUND);
                    still.addImageSize(width, height, "file:/" + tempFile.toAbsolutePath());
                    still.setDefaultUrl("file:/" + tempFile.toAbsolutePath());
                    still.setOriginalUrl("file:/" + tempFile.toAbsolutePath());
                    still.setSizeOrder(artworkSizeOrder);
                    still.setLanguage("-");
                    artworks.add(still);
                }
                if (!this.isThumbEnabled() || options.getArtworkType() != MediaArtwork.MediaArtworkType.ALL && options.getArtworkType() != MediaArtwork.MediaArtworkType.THUMB) continue;
                still = new MediaArtwork(this.getId(), MediaArtwork.MediaArtworkType.THUMB);
                still.addImageSize(width, height, "file:/" + tempFile.toAbsolutePath());
                still.setDefaultUrl("file:/" + tempFile.toAbsolutePath());
                still.setOriginalUrl("file:/" + tempFile.toAbsolutePath());
                still.setSizeOrder(artworkSizeOrder);
                still.setLanguage("-");
                artworks.add(still);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return artworks;
    }

    private List<MediaArtwork> createStillsFromDiscFiles(MediaFile mediaFile, ArtworkSearchAndScrapeOptions options) throws ScrapeException {
        int duration = mediaFile.getDuration();
        int count = this.providerInfo.getConfig().getValueAsInteger("count");
        int start = this.providerInfo.getConfig().getValueAsInteger("start");
        int end = this.providerInfo.getConfig().getValueAsInteger("end");
        if (count <= 0 || start <= 0 || end >= 100 || start > end) {
            throw new ScrapeException(new IllegalArgumentException());
        }
        float increment = (float)(end - start) / (100.0f * (float)count);
        List<MediaInfoFile> files = MediaFileHelper.detectRelevantFiles(mediaFile);
        for (int i = files.size() - 1; i >= 0; --i) {
            String ext = files.get(i).getFileExtension();
            if (ext.equalsIgnoreCase("vob") || ext.equalsIgnoreCase("m2ts") || ext.equalsIgnoreCase("evo")) continue;
            files.remove(i);
        }
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        int countPerFile = (int)Math.ceil((double)count / (double)files.size());
        int fileDuration = duration / files.size();
        ArrayList<MediaArtwork> artworks = new ArrayList<MediaArtwork>();
        for (int fileIndex = 0; fileIndex < files.size(); ++fileIndex) {
            Path path = Paths.get(files.get(fileIndex).getPath(), files.get(fileIndex).getFilename());
            for (int i = 0; i < countPerFile; ++i) {
                int second = (int)((float)fileDuration * ((float)start / 100.0f + (float)i * increment));
                try {
                    MediaArtwork still;
                    Path tempFile = Paths.get(Utils.getTempFolder(), "ffmpeg-still." + System.currentTimeMillis() + ".jpg");
                    FFmpeg.createStill(path, tempFile, second);
                    int width = mediaFile.getVideoWidth();
                    int height = mediaFile.getVideoHeight();
                    int artworkSizeOrder = this.detectArtworkSizeOrder(width);
                    if (this.isFanartEnabled() && (options.getArtworkType() == MediaArtwork.MediaArtworkType.ALL || options.getArtworkType() == MediaArtwork.MediaArtworkType.BACKGROUND)) {
                        still = new MediaArtwork(this.getId(), MediaArtwork.MediaArtworkType.BACKGROUND);
                        still.addImageSize(width, height, "file:/" + tempFile.toAbsolutePath());
                        still.setDefaultUrl("file:/" + tempFile.toAbsolutePath());
                        still.setOriginalUrl("file:/" + tempFile.toAbsolutePath());
                        still.setSizeOrder(artworkSizeOrder);
                        still.setLanguage("-");
                        artworks.add(still);
                    }
                    if (!this.isThumbEnabled() || options.getArtworkType() != MediaArtwork.MediaArtworkType.ALL && options.getArtworkType() != MediaArtwork.MediaArtworkType.THUMB) continue;
                    still = new MediaArtwork(this.getId(), MediaArtwork.MediaArtworkType.THUMB);
                    still.addImageSize(width, height, "file:/" + tempFile.toAbsolutePath());
                    still.setDefaultUrl("file:/" + tempFile.toAbsolutePath());
                    still.setOriginalUrl("file:/" + tempFile.toAbsolutePath());
                    still.setSizeOrder(artworkSizeOrder);
                    still.setLanguage("-");
                    artworks.add(still);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return artworks;
    }

    private int detectArtworkSizeOrder(int width) {
        if (width >= 3840) {
            return MediaArtwork.FanartSizes.XLARGE.getOrder();
        }
        if (width >= 1920) {
            return MediaArtwork.FanartSizes.LARGE.getOrder();
        }
        if (width >= 1280) {
            return MediaArtwork.FanartSizes.MEDIUM.getOrder();
        }
        return MediaArtwork.FanartSizes.SMALL.getOrder();
    }

    protected abstract boolean isFanartEnabled();

    protected abstract boolean isThumbEnabled();
}

