/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.http;

import java.net.MalformedURLException;
import java.util.concurrent.TimeUnit;
import okhttp3.CacheControl;
import okhttp3.Interceptor;
import okhttp3.Response;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.http.Url;

public class OnDiskCachedUrl
extends Url {
    public OnDiskCachedUrl(String url) throws MalformedURLException {
        super(url);
        this.client = TmmHttpClient.newBuilder(true).build();
    }

    public OnDiskCachedUrl(String url, int timeToLive, TimeUnit timeUnit) throws MalformedURLException {
        super(url);
        this.client = TmmHttpClient.newBuilder(true).addNetworkInterceptor(this.provideCacheInterceptor(timeToLive, timeUnit)).build();
    }

    private Interceptor provideCacheInterceptor(int timeToLive, TimeUnit timeUnit) {
        return chain -> {
            Response response = chain.proceed(chain.request());
            if (!response.isSuccessful()) {
                return response;
            }
            CacheControl cacheControl = new CacheControl.Builder().maxAge(timeToLive, timeUnit).build();
            return response.newBuilder().header("Cache-Control", cacheControl.toString()).build();
        };
    }
}

