/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.http;

import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import okhttp3.Connection;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TmmHttpLoggingInterceptor
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmmHttpLoggingInterceptor.class);
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final int HTTP_CONTINUE = 100;
    private static final int MAX_TEXT_BODY_LENGTH = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        Buffer buffer;
        Request request = chain.request();
        try {
            RequestBody requestBody = request.body();
            boolean hasRequestBody = requestBody != null;
            Connection connection = chain.connection();
            String logUrl = request.url().toString().replaceAll("api_key=\\w+", "api_key=<API_KEY>").replaceAll("api/\\d+\\w+", "api/<API_KEY>").replaceAll("apikey=\\w+", "apikey=<API_KEY>");
            String requestStartMessage = "--> " + request.method() + " " + logUrl + (String)(connection != null ? " " + connection.protocol() : "");
            LOGGER.trace(requestStartMessage);
            if (!hasRequestBody || TmmHttpLoggingInterceptor.bodyHasUnknownEncoding(request.headers())) {
                LOGGER.trace("--> END {}", (Object)request.method());
            } else {
                buffer = new Buffer();
                requestBody.writeTo((BufferedSink)buffer);
                Charset charset = UTF8;
                MediaType contentType = requestBody.contentType();
                if (contentType != null) {
                    charset = contentType.charset(UTF8);
                }
                LOGGER.trace("");
                if (TmmHttpLoggingInterceptor.isPlaintext(buffer)) {
                    String content = buffer.readString(charset);
                    if (content.length() > 1000) {
                        LOGGER.trace("{}...", (Object)content.substring(0, 1000));
                    } else {
                        LOGGER.trace(content);
                    }
                    LOGGER.trace("--> END {} ({}-byte body)", (Object)request.method(), (Object)requestBody.contentLength());
                } else {
                    LOGGER.trace("--> END {}", (Object)request.method());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Problem in HTTP logging detected: {}", (Object)e.getMessage());
        }
        long startNs = System.nanoTime();
        try {
            response = chain.proceed(request);
        }
        catch (Exception e) {
            LOGGER.trace("<-- HTTP FAILED: {}", (Object)e.getMessage());
            throw e;
        }
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        buffer = null;
        try {
            ResponseBody responseBody = response.body();
            long contentLength = responseBody.contentLength();
            Object bodySize = contentLength != -1L ? contentLength + "-byte" : "unknown-length";
            String logUrl = response.request().url().toString().replaceAll("api_key=\\w+", "api_key=<API_KEY>").replaceAll("api/\\d+\\w+", "api/<API_KEY>").replaceAll("apikey=\\w+", "apikey=<API_KEY>");
            LOGGER.debug("<-- " + response.code() + (String)(response.message().isEmpty() ? "" : " " + response.message()) + " " + logUrl + " (" + tookMs + "ms, " + (String)bodySize + " body)");
            if (!TmmHttpLoggingInterceptor.hasBody(response) || TmmHttpLoggingInterceptor.bodyHasUnknownEncoding(response.headers())) {
                LOGGER.trace("<-- END HTTP");
            } else if (TmmHttpLoggingInterceptor.isTextResponse(response)) {
                BufferedSource source = responseBody.source();
                source.request(Long.MAX_VALUE);
                buffer = source.getBuffer();
                contentLength = buffer.size();
                Charset charset = UTF8;
                MediaType contentType = responseBody.contentType();
                if (contentType != null) {
                    charset = contentType.charset(UTF8);
                }
                if (!TmmHttpLoggingInterceptor.isPlaintext(buffer)) {
                    LOGGER.trace("");
                    LOGGER.trace("<-- END HTTP (binary {}-byte body omitted)", (Object)buffer.size());
                    Response response2 = response;
                    return response2;
                }
                if (contentLength != 0L) {
                    LOGGER.trace("");
                    String content = buffer.clone().readString(charset);
                    if (content.length() > 1000) {
                        LOGGER.trace("{}...", (Object)content.substring(0, 1000));
                    } else {
                        LOGGER.trace(content);
                    }
                }
                LOGGER.trace("<-- END HTTP ({}-byte body)", (Object)contentLength);
            }
        }
        catch (Exception e) {
            LOGGER.error("Problem in HTTP logging detected: {}", (Object)e.getMessage());
        }
        finally {
            if (buffer != null) {
                buffer.close();
            }
        }
        return response;
    }

    private static boolean bodyHasUnknownEncoding(Headers headers) {
        String contentEncoding = headers.get("Content-Encoding");
        return contentEncoding != null && !contentEncoding.equalsIgnoreCase("identity") && !contentEncoding.equalsIgnoreCase("gzip") && !contentEncoding.equalsIgnoreCase("br");
    }

    private static boolean isTextResponse(Response response) {
        MediaType type = response.body().contentType();
        if (type == null || type.subtype() == null) {
            return false;
        }
        switch (type.subtype().toLowerCase(Locale.ROOT)) {
            case "json": 
            case "xml": {
                return true;
            }
        }
        return false;
    }

    private static long contentLength(Headers headers) {
        return TmmHttpLoggingInterceptor.stringToLong(headers.get("Content-Length"));
    }

    private static long stringToLong(String s) {
        if (s == null) {
            return -1L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public static boolean hasBody(Response response) {
        if (response.request().method().equals("HEAD")) {
            return false;
        }
        int responseCode = response.code();
        if ((responseCode < 100 || responseCode >= 200) && responseCode != 204 && responseCode != 304) {
            return true;
        }
        return TmmHttpLoggingInterceptor.contentLength(response.headers()) != -1L || "chunked".equalsIgnoreCase(response.header("Transfer-Encoding"));
    }

    static boolean isPlaintext(Buffer buffer) {
        try {
            Buffer prefix = new Buffer();
            long byteCount = buffer.size() < 64L ? buffer.size() : 64L;
            buffer.copyTo(prefix, 0L, byteCount);
            for (int i = 0; i < 16 && !prefix.exhausted(); ++i) {
                int codePoint = prefix.readUtf8CodePoint();
                if (!Character.isISOControl(codePoint) || Character.isWhitespace(codePoint)) continue;
                return false;
            }
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }
}

