/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.imdb;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.config.MediaProviderConfig;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.http.InMemoryCachedUrl;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.scraper.imdb.ResultCategory;
import org.tinymediamanager.scraper.imdb.entities.ImdbCast;
import org.tinymediamanager.scraper.imdb.entities.ImdbChartTitleEdge;
import org.tinymediamanager.scraper.imdb.entities.ImdbCountry;
import org.tinymediamanager.scraper.imdb.entities.ImdbCredits;
import org.tinymediamanager.scraper.imdb.entities.ImdbCrew;
import org.tinymediamanager.scraper.imdb.entities.ImdbEpisodeNumber;
import org.tinymediamanager.scraper.imdb.entities.ImdbGenre;
import org.tinymediamanager.scraper.imdb.entities.ImdbIdTextType;
import org.tinymediamanager.scraper.imdb.entities.ImdbImage;
import org.tinymediamanager.scraper.imdb.entities.ImdbKeyword;
import org.tinymediamanager.scraper.imdb.entities.ImdbPlaintext;
import org.tinymediamanager.scraper.imdb.entities.ImdbPlaybackUrl;
import org.tinymediamanager.scraper.imdb.entities.ImdbSearchResult;
import org.tinymediamanager.scraper.imdb.entities.ImdbTitleKeyword;
import org.tinymediamanager.scraper.imdb.entities.ImdbVideo;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.util.JsonUtils;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.scraper.util.UrlUtil;

public abstract class ImdbParser {
    static final Pattern IMDB_ID_PATTERN = Pattern.compile("/title/(tt[0-9]{6,})/");
    static final Pattern PERSON_ID_PATTERN = Pattern.compile("/name/(nm[0-9]{6,})/");
    static final Pattern MOVIE_PATTERN = Pattern.compile("^.*?\\(\\d{4}\\)$");
    static final Pattern TV_MOVIE_PATTERN = Pattern.compile("^.*?\\(\\d{4}\\s+TV Movie\\)$");
    static final Pattern TV_SERIES_PATTERN = Pattern.compile("^.*?\\(\\d{4}\\)\\s+\\((TV Series|TV Mini[ -]Series)\\)$");
    static final Pattern SHORT_PATTERN = Pattern.compile("^.*?\\(\\d{4}\\)\\s+\\((Short|Video)\\)$");
    static final Pattern VIDEOGAME_PATTERN = Pattern.compile("^.*?\\(\\d{4}\\)\\s+\\(Video Game\\)$");
    static final Pattern IMAGE_SCALING_PATTERN = Pattern.compile("S([XY])(.*?)_CR(\\d*),(\\d*),(\\d*),(\\d*)");
    static final String INCLUDE_MOVIE = "includeMovieResults";
    static final String INCLUDE_TV_MOVIE = "includeTvMovieResults";
    static final String INCLUDE_TV_SERIES = "includeTvSeriesResults";
    static final String INCLUDE_SHORT = "includeShortResults";
    static final String INCLUDE_VIDEOGAME = "includeVideogameResults";
    static final String INCLUDE_PODCAST = "includePodcastResults";
    static final String INCLUDE_ADULT = "includeAdultResults";
    static final String INCLUDE_METACRITIC = "includeMetacritic";
    static final String USE_TMDB_FOR_MOVIES = "useTmdbForMovies";
    static final String USE_TMDB_FOR_TV_SHOWS = "useTmdbForTvShows";
    static final String SCRAPE_COLLETION_INFO = "scrapeCollectionInfo";
    static final String SCRAPE_KEYWORDS_PAGE = "scrapeKeywordsPage";
    static final String SCRAPE_UNCREDITED_ACTORS = "scrapeUncreditedActors";
    static final String SCRAPE_LANGUAGE_NAMES = "scrapeLanguageNames";
    static final String LOCAL_RELEASE_DATE = "localReleaseDate";
    static final String INCLUDE_PREMIERE_DATE = "includePremiereDate";
    static final String MAX_KEYWORD_COUNT = "maxKeywordCount";
    protected final IMediaProvider metadataProvider;
    protected final MediaType type;
    protected final MediaProviderConfig config;
    protected final ExecutorService executor;
    private ObjectMapper mapper = new ObjectMapper();

    protected ImdbParser(IMediaProvider mediaProvider, MediaType type, ExecutorService executor) {
        this.metadataProvider = mediaProvider;
        this.type = type;
        this.config = mediaProvider.getProviderInfo().getConfig();
        this.executor = executor;
    }

    protected abstract Logger getLogger();

    protected abstract MediaMetadata getMetadata(MediaSearchAndScrapeOptions var1) throws ScrapeException;

    protected boolean isIncludeMovieResults() {
        return this.config.getValueAsBool(INCLUDE_MOVIE, false);
    }

    protected boolean isIncludeTvMovieResults() {
        return this.config.getValueAsBool(INCLUDE_TV_MOVIE, false);
    }

    protected boolean isIncludeTvSeriesResults() {
        return this.config.getValueAsBool(INCLUDE_TV_SERIES, false);
    }

    protected boolean isIncludeShortResults() {
        return this.config.getValueAsBool(INCLUDE_SHORT, false);
    }

    protected boolean isIncludeVideogameResults() {
        return this.config.getValueAsBool(INCLUDE_VIDEOGAME, false);
    }

    protected boolean isIncludeAdultResults() {
        return this.config.getValueAsBool(INCLUDE_ADULT, false);
    }

    protected boolean isIncludePodcastResults() {
        return this.config.getValueAsBool(INCLUDE_PODCAST, false);
    }

    protected boolean isUseTmdbForMovies() {
        return this.config.getValueAsBool(USE_TMDB_FOR_MOVIES, false);
    }

    protected boolean isUseTmdbForTvShows() {
        return this.config.getValueAsBool(USE_TMDB_FOR_TV_SHOWS, false);
    }

    protected boolean isScrapeUncreditedActors() {
        return this.config.getValueAsBool(SCRAPE_UNCREDITED_ACTORS, false);
    }

    protected boolean isScrapeLanguageNames() {
        return this.config.getValueAsBool(SCRAPE_LANGUAGE_NAMES, false);
    }

    protected boolean isScrapeCollectionInfo() {
        return this.config.getValueAsBool(SCRAPE_COLLETION_INFO, false);
    }

    protected boolean isScrapeKeywordsPage() {
        return this.config.getValueAsBool(SCRAPE_KEYWORDS_PAGE, false);
    }

    protected boolean isScrapeMetacriticRatings() {
        return this.config.getValueAsBool(INCLUDE_METACRITIC, false);
    }

    protected int getMaxKeywordCount() {
        Integer value = this.config.getValueAsInteger(MAX_KEYWORD_COUNT);
        if (value == null) {
            return 5;
        }
        return value;
    }

    @Deprecated
    protected boolean includeSearchResult(String text) {
        if (text.contains("(TV Episode)")) {
            return false;
        }
        ResultCategory category = this.getResultCategory(text.trim());
        if (category == null) {
            return false;
        }
        switch (category) {
            case MOVIE: {
                return this.isIncludeMovieResults();
            }
            case TV_MOVIE: {
                return this.isIncludeTvMovieResults();
            }
            case TV_SERIES: {
                return this.isIncludeTvSeriesResults();
            }
            case SHORT: {
                return this.isIncludeShortResults();
            }
            case VIDEOGAME: {
                return this.isIncludeVideogameResults();
            }
        }
        return false;
    }

    @Deprecated
    protected ResultCategory getResultCategory(String text) {
        Matcher matcher = MOVIE_PATTERN.matcher(text);
        if (matcher.matches()) {
            return ResultCategory.MOVIE;
        }
        matcher = TV_MOVIE_PATTERN.matcher(text);
        if (matcher.matches()) {
            return ResultCategory.TV_MOVIE;
        }
        matcher = TV_SERIES_PATTERN.matcher(text);
        if (matcher.matches()) {
            return ResultCategory.TV_SERIES;
        }
        matcher = SHORT_PATTERN.matcher(text);
        if (matcher.matches()) {
            return ResultCategory.SHORT;
        }
        matcher = VIDEOGAME_PATTERN.matcher(text);
        if (matcher.matches()) {
            return ResultCategory.VIDEOGAME;
        }
        return null;
    }

    protected String constructUrl(String ... parts) throws ScrapeException {
        try {
            return this.metadataProvider.getApiKey() + String.join((CharSequence)"", parts);
        }
        catch (Exception e) {
            throw new ScrapeException(e);
        }
    }

    protected String decode(String source) {
        return new String(Base64.getDecoder().decode(source), StandardCharsets.UTF_8);
    }

    protected SortedSet<MediaSearchResult> search(MediaSearchAndScrapeOptions options) throws ScrapeException {
        String content;
        MediaSearchResult sr;
        InMemoryCachedUrl url;
        this.getLogger().debug("search(): {}", (Object)options);
        TreeSet<MediaSearchResult> results = new TreeSet<MediaSearchResult>();
        String searchTerm = "";
        if (StringUtils.isNotEmpty((CharSequence)options.getImdbId())) {
            searchTerm = options.getImdbId();
        }
        if (StringUtils.isEmpty((CharSequence)searchTerm)) {
            searchTerm = options.getSearchQuery();
        }
        if (StringUtils.isEmpty((CharSequence)searchTerm)) {
            return results;
        }
        String language = options.getLanguage().getLanguage();
        String country = options.getCertificationCountry().getAlpha2();
        searchTerm = MetadataUtil.removeNonSearchCharacters(searchTerm);
        this.getLogger().debug("========= BEGIN IMDB Scraper Search for: {}", (Object)searchTerm);
        Document doc = null;
        boolean advancedSearch = false;
        try {
            if (advancedSearch) {
                Object cats = "";
                if (options.getMediaType() == MediaType.MOVIE) {
                    cats = "&title_type=feature,documentary";
                    if (this.isIncludeShortResults()) {
                        cats = (String)cats + ",short,tv_short";
                    }
                    if (this.isIncludeTvMovieResults()) {
                        cats = (String)cats + ",tv_movie,tv_special";
                    }
                    if (this.isIncludeVideogameResults()) {
                        cats = (String)cats + ",video_game";
                    }
                } else if (options.getMediaType() == MediaType.TV_SHOW) {
                    cats = "&title_type=tv_series,tv_miniseries";
                    if (this.isIncludePodcastResults()) {
                        cats = (String)cats + ",podcast_series";
                    }
                }
                if (this.isIncludeAdultResults()) {
                    cats = (String)cats + "&adult=include";
                }
                url = new InMemoryCachedUrl(this.constructUrl(new String[]{"search/title/?title=", URLEncoder.encode(searchTerm, StandardCharsets.UTF_8), cats}));
            } else {
                url = new InMemoryCachedUrl(this.constructUrl("find/?q=", URLEncoder.encode(searchTerm, StandardCharsets.UTF_8), "&s=tt&ttype=ft,tv"));
            }
            url.addHeader("Accept-Language", ImdbParser.getAcceptLanguage(language, country));
        }
        catch (Exception e) {
            this.getLogger().debug("tried to fetch search response", (Throwable)e);
            throw new ScrapeException(e);
        }
        try (InputStream is = ((Url)url).getInputStream();){
            doc = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"");
            doc.setBaseUri(this.metadataProvider.getApiKey());
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.getLogger().debug("tried to fetch search response", (Throwable)e);
            throw new ScrapeException(e);
        }
        if (doc == null) {
            return Collections.emptySortedSet();
        }
        try {
            String json = doc.getElementById("__NEXT_DATA__").data();
            if (!json.isEmpty()) {
                JsonNode node = this.mapper.readTree(json);
                JsonNode resultsNode = node.at("/props/pageProps/titleResults/results");
                if (resultsNode.isMissingNode()) {
                    MediaMetadata md = new MediaMetadata("imdb");
                    this.parseDetailPageJson(doc, options, md);
                    sr = md.toSearchResult(options.getMediaType());
                    sr.setScore(1.0f);
                    results.add(sr);
                } else {
                    for (ImdbSearchResult result : JsonUtils.parseList(this.mapper, resultsNode, ImdbSearchResult.class)) {
                        MediaSearchResult sr2 = this.parseJsonSearchResults(result, options);
                        if (sr2 == null || !options.getMediaType().equals((Object)result.getMediaType())) continue;
                        results.add(sr2);
                    }
                }
                if (!results.isEmpty()) {
                    return results;
                }
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Error parsing JSON - '{}'", (Object)e.getMessage());
        }
        Elements pageType = doc.getElementsByAttributeValue("property", "imdb:pageType");
        if (!pageType.isEmpty() && (content = ((Element)pageType.get(0)).attr("content")).equalsIgnoreCase("title")) {
            MediaSearchResult sr3 = new MediaSearchResult("imdb", options.getMediaType());
            Elements pageConst = doc.getElementsByAttributeValue("property", "imdb:pageConst");
            content = ((Element)pageConst.get(0)).attr("content");
            if (MediaIdUtil.isValidImdbId(content)) {
                sr3.setId("imdb", content);
            } else if (MediaIdUtil.isValidImdbId(searchTerm)) {
                sr3.setId("imdb", searchTerm);
            }
            Elements titleYear = doc.getElementsByAttributeValue("property", "og:title");
            if (!titleYear.isEmpty()) {
                content = ((Element)titleYear.get(0)).attr("content");
                String title = StrgUtils.substr(content, "(.*?)\\(");
                String year = StrgUtils.substr(content, ".*?(\\d{4}).*");
                sr3.setTitle(title);
                sr3.setYear(MetadataUtil.parseInt(year, 0));
            }
            results.add(sr3);
        }
        Elements elements = doc.getElementsByClass("ipc-metadata-list-summary-item");
        for (Element tr : elements) {
            sr = this.parseSearchResultsNewStyle(tr, options);
            if (sr != null && options.getMediaType() == sr.getMediaType()) {
                results.add(sr);
            }
            if (results.size() < 80) continue;
            break;
        }
        if (elements.isEmpty()) {
            elements = doc.getElementsByClass("findResult");
            for (Element tr : elements) {
                if (!"tr".equalsIgnoreCase(tr.tagName())) continue;
                sr = this.parseSearchResults(tr, options);
                if (sr != null) {
                    results.add(sr);
                }
                if (results.size() < 80) continue;
                break;
            }
        }
        if (elements.isEmpty()) {
            elements = doc.getElementsByClass("lister-item");
            for (Element tr : elements) {
                sr = this.parseAdvancedSearchResults(tr, options);
                if (sr != null) {
                    results.add(sr);
                }
                if (results.size() < 80) continue;
                break;
            }
        }
        return results;
    }

    private MediaSearchResult parseJsonSearchResults(ImdbSearchResult result, MediaSearchAndScrapeOptions options) {
        MediaSearchResult sr = new MediaSearchResult("imdb", options.getMediaType());
        sr.setIMDBId(result.getId());
        sr.setTitle(result.titleNameText);
        String year = result.titleReleaseText;
        if (!year.isEmpty()) {
            if (year.length() == 4) {
                sr.setYear(MetadataUtil.parseInt(year, 0));
            } else if (year.matches("\\d{4}-?.*")) {
                sr.setYear(MetadataUtil.parseInt(year.substring(0, 4), 0));
            }
        }
        if (result.titlePosterImageModel != null) {
            sr.setPosterUrl(result.titlePosterImageModel.url);
        }
        if (sr.getIMDBId().equals(options.getImdbId())) {
            sr.setScore(1.0f);
        } else {
            sr.calculateScore(options);
        }
        return sr;
    }

    private MediaSearchResult parseAdvancedSearchResults(Element tr, MediaSearchAndScrapeOptions options) {
        MediaSearchResult sr = new MediaSearchResult("imdb", options.getMediaType());
        String movieId = "";
        Element header = null;
        try {
            header = (Element)tr.getElementsByClass("lister-item-header").get(0);
            sr.setTitle(header.getElementsByTag("a").text());
            sr.setUrl(header.getElementsByTag("a").attr("href"));
            movieId = StrgUtils.substr(sr.getUrl(), ".*?(tt\\d+).*");
            sr.setIMDBId(movieId);
        }
        catch (Exception e) {
            return null;
        }
        try {
            String yr = ((Element)header.getElementsByClass("lister-item-year").get(0)).text();
            String year = StrgUtils.substr(yr, ".*?(\\d{4}).*");
            sr.setYear(MetadataUtil.parseInt(year, 0));
        }
        catch (Exception yr) {
            // empty catch block
        }
        try {
            Element img = (Element)tr.getElementsByClass("lister-item-image").get(0);
            String imgurlSmall = ((Element)img.getElementsByAttribute("loadlate").get(0)).attr("loadlate");
            sr.setPosterUrl(imgurlSmall);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (movieId.equals(options.getImdbId())) {
            sr.setScore(1.0f);
        } else {
            sr.calculateScore(options);
        }
        return sr;
    }

    private MediaSearchResult parseSearchResults(Element tr, MediaSearchAndScrapeOptions options) {
        String movieName = "";
        String movieId = "";
        int year = 0;
        Elements tds = tr.getElementsByClass("result_text");
        block2: for (Object element : tds) {
            if (!"td".equalsIgnoreCase(element.tagName()) || !this.includeSearchResult(element.ownText().replace("aka", ""))) continue;
            String localizedName = "";
            Elements italics = element.getElementsByTag("i");
            if (!italics.isEmpty()) {
                localizedName = italics.text().replace("\"", "");
            }
            Elements anchors = element.getElementsByTag("a");
            for (Element a : anchors) {
                if (!StringUtils.isNotEmpty((CharSequence)a.text())) continue;
                movieName = StringUtils.isNotBlank((CharSequence)localizedName) && !options.getLanguage().getLanguage().equals("en") ? localizedName : a.text();
                String href = a.attr("href");
                Matcher matcher = IMDB_ID_PATTERN.matcher(href);
                while (matcher.find()) {
                    if (matcher.group(1) == null) continue;
                    movieId = matcher.group(1);
                }
                Pattern yearPattern = Pattern.compile("\\(([0-9]{4})|/\\)");
                matcher = yearPattern.matcher(element.text());
                while (matcher.find()) {
                    if (matcher.group(1) == null) continue;
                    try {
                        year = Integer.parseInt(matcher.group(1));
                        continue block2;
                    }
                    catch (Exception exception) {
                    }
                }
                continue block2;
            }
        }
        String posterUrl = "";
        tds = tr.getElementsByClass("primary_photo");
        for (Element element : tds) {
            Elements imgs = element.getElementsByTag("img");
            for (Element img : imgs) {
                posterUrl = img.attr("src");
                posterUrl = posterUrl.replaceAll("UX[0-9]{2,4}_", "");
                posterUrl = posterUrl.replaceAll("UY[0-9]{2,4}_", "");
                posterUrl = posterUrl.replaceAll("CR[0-9]{1,3},[0-9]{1,3},[0-9]{1,3},[0-9]{1,3}_", "");
            }
        }
        if (StringUtils.isEmpty((CharSequence)movieName) || StringUtils.isEmpty((CharSequence)movieId)) {
            return null;
        }
        MediaSearchResult sr = new MediaSearchResult("imdb", options.getMediaType());
        sr.setTitle(movieName);
        sr.setIMDBId(movieId);
        sr.setYear(year);
        sr.setPosterUrl(posterUrl);
        if (movieId.equals(options.getImdbId())) {
            sr.setScore(1.0f);
        } else {
            sr.calculateScore(options);
        }
        return sr;
    }

    private MediaSearchResult parseSearchResultsNewStyle(Element element, MediaSearchAndScrapeOptions options) {
        Element img;
        MediaSearchResult sr = new MediaSearchResult("imdb", options.getMediaType());
        Element titleEl = element.getElementsByClass("ipc-metadata-list-summary-item__t").first();
        if (titleEl != null) {
            sr.setTitle(titleEl.text());
            String href = titleEl.absUrl("href");
            sr.setUrl(href);
            Matcher matcher = IMDB_ID_PATTERN.matcher(href);
            while (matcher.find()) {
                if (matcher.group(1) == null) continue;
                sr.setIMDBId(matcher.group(1));
            }
        }
        if ((img = element.getElementsByClass("ipc-image").first()) != null) {
            String posterUrl = img.attr("src");
            posterUrl = posterUrl.replaceAll("UX[0-9]{2,4}_", "");
            posterUrl = posterUrl.replaceAll("UY[0-9]{2,4}_", "");
            posterUrl = posterUrl.replaceAll("CR[0-9]{1,3},[0-9]{1,3},[0-9]{1,3},[0-9]{1,3}_", "");
            sr.setPosterUrl(posterUrl);
        }
        Elements items = element.getElementsByClass("ipc-metadata-list-summary-item__li");
        for (Element span : items) {
            String text = span.text();
            if (text.matches("\\d{4}[-]?.*")) {
                int year = MetadataUtil.parseInt(text.substring(0, 4));
                sr.setYear(year);
                continue;
            }
            if (!text.matches("S\\d+\\.E\\d+")) continue;
            sr.setMediaType(MediaType.TV_EPISODE);
        }
        if (sr.getIMDBId().equals(options.getImdbId())) {
            sr.setScore(1.0f);
        } else {
            sr.calculateScore(options);
        }
        return sr;
    }

    protected static String getAcceptLanguage(String language, String country) {
        Locale jreLocale;
        String combined;
        String combined2;
        Locale localeFromLanguage;
        ArrayList<Object> languageString = new ArrayList<Object>();
        if (StringUtils.isNotBlank((CharSequence)language) && StringUtils.isNotBlank((CharSequence)country) && LocaleUtils.isAvailableLocale((Locale)new Locale(language, country))) {
            String combined3 = language + "-" + country;
            languageString.add(combined3.toLowerCase(Locale.ROOT));
        }
        if ((localeFromLanguage = UrlUtil.getLocaleFromLanguage(language)) != null && !languageString.contains(combined2 = language + "-" + localeFromLanguage.getCountry().toLowerCase(Locale.ROOT))) {
            languageString.add(combined2);
        }
        if (StringUtils.isNotBlank((CharSequence)language)) {
            languageString.add(language.toLowerCase(Locale.ROOT));
        }
        if (!languageString.contains(combined = ((jreLocale = Locale.getDefault()).getLanguage() + "-" + jreLocale.getCountry()).toLowerCase(Locale.ROOT))) {
            languageString.add(combined);
        }
        if (!languageString.contains(jreLocale.getLanguage().toLowerCase(Locale.ROOT))) {
            languageString.add(jreLocale.getLanguage().toLowerCase(Locale.ROOT));
        }
        if (!languageString.contains("en-us")) {
            languageString.add("en-us");
        }
        if (!languageString.contains("en")) {
            languageString.add("en");
        }
        StringBuilder languages = new StringBuilder();
        float qualifier = 1.0f;
        for (String string : languageString) {
            if (languages.length() > 0) {
                languages.append(",");
            }
            languages.append(string);
            if (qualifier < 1.0f) {
                languages.append(String.format(Locale.US, ";q=%1.1f", Float.valueOf(qualifier)));
            }
            qualifier = (float)((double)qualifier - 0.1);
        }
        return languages.toString().toLowerCase(Locale.ROOT);
    }

    protected void parseDetailPageJson(Document doc, MediaSearchAndScrapeOptions options, MediaMetadata md) throws Exception {
        try {
            JsonNode primaryImage;
            ImdbImage imdbImage;
            MediaRating rating;
            String json = doc.getElementById("__NEXT_DATA__").data();
            JsonNode node = this.mapper.readTree(json);
            String certCountry = "";
            String responseLangu = node.at("/props/pageProps/requestContext/sidecar/localizationResponse/languageForTranslations").asText();
            if (responseLangu.isEmpty()) {
                responseLangu = node.at("/props/pageProps/requestContext/sidecar/localizationResponse/userLanguage").asText();
            }
            if (!responseLangu.isEmpty()) {
                Locale l = Locale.forLanguageTag(responseLangu);
                certCountry = l.getCountry();
            }
            md.setId("imdb", node.at("/props/pageProps/aboveTheFoldData/id").asText());
            md.setTitle(node.at("/props/pageProps/aboveTheFoldData/titleText/text").asText());
            md.setOriginalTitle(node.at("/props/pageProps/aboveTheFoldData/originalTitleText/text").asText());
            if (md.getOriginalTitle().isEmpty()) {
                md.setOriginalTitle(md.getTitle());
            }
            md.setYear(node.at("/props/pageProps/aboveTheFoldData/releaseYear/year").asInt(0));
            JsonNode plotNode = node.at("/props/pageProps/aboveTheFoldData/plot/plotText");
            ImdbPlaintext plot = JsonUtils.parseObject(this.mapper, plotNode, ImdbPlaintext.class);
            if (plot != null) {
                md.setPlot(plot.plainText);
            }
            int y = node.at("/props/pageProps/aboveTheFoldData/releaseDate/year").asInt(0);
            int m = node.at("/props/pageProps/aboveTheFoldData/releaseDate/month").asInt(0);
            int d = node.at("/props/pageProps/aboveTheFoldData/releaseDate/day").asInt(0);
            Date date = new GregorianCalendar(y, m - 1, d).getTime();
            md.setReleaseDate(date);
            md.setRuntime(node.at("/props/pageProps/aboveTheFoldData/runtime/seconds").asInt(0) / 60);
            JsonNode agg = node.at("/props/pageProps/aboveTheFoldData/ratingsSummary/aggregateRating");
            if (!agg.isMissingNode()) {
                rating = new MediaRating("imdb");
                rating.setRating(agg.floatValue());
                rating.setVotes(node.at("/props/pageProps/aboveTheFoldData/ratingsSummary/voteCount").asInt(0));
                rating.setMaxValue(10);
                if (rating.getRating() > 0.0f) {
                    md.addRating(rating);
                }
            }
            if (this.isScrapeMetacriticRatings()) {
                rating = new MediaRating("metacritic");
                rating.setRating(node.at("/props/pageProps/aboveTheFoldData/metacritic/metascore/score").asInt(0));
                rating.setMaxValue(100);
                if (rating.getRating() > 0.0f) {
                    md.addRating(rating);
                }
            }
            JsonNode genreNode = node.at("/props/pageProps/aboveTheFoldData/genres/genres");
            for (ImdbGenre imdbGenre : JsonUtils.parseList(this.mapper, genreNode, ImdbGenre.class)) {
                md.addGenre(imdbGenre.toTmm());
            }
            if (this.isScrapeKeywordsPage()) {
                JsonNode keywordsNode = node.at("/props/pageProps/aboveTheFoldData/keywords/edges");
                for (ImdbKeyword kw : JsonUtils.parseList(this.mapper, keywordsNode, ImdbKeyword.class)) {
                    md.addTag(kw.node.text);
                }
            }
            if ((imdbImage = JsonUtils.parseObject(this.mapper, primaryImage = node.at("/props/pageProps/aboveTheFoldData/primaryImage"), ImdbImage.class)) != null) {
                MediaArtwork poster = new MediaArtwork("imdb", MediaArtwork.MediaArtworkType.POSTER);
                if (options.getMediaType() == MediaType.TV_EPISODE) {
                    poster = new MediaArtwork("imdb", MediaArtwork.MediaArtworkType.THUMB);
                }
                poster.setOriginalUrl(imdbImage.url);
                poster.setPreviewUrl(imdbImage.url);
                poster.setImdbId(imdbImage.id);
                poster.addImageSize(imdbImage.width, imdbImage.height, imdbImage.url);
                md.addMediaArt(poster);
            }
            JsonNode primaryTrailers = node.at("/props/pageProps/aboveTheFoldData/primaryVideos/edges");
            for (JsonNode vid : ListUtils.nullSafe(primaryTrailers)) {
                ImdbVideo video = JsonUtils.parseObject(this.mapper, vid.get("node"), ImdbVideo.class);
                for (ImdbPlaybackUrl vidurl : ListUtils.nullSafe(video.playbackURLs)) {
                    if (vidurl.displayName.value.equalsIgnoreCase("AUTO")) continue;
                    MediaTrailer mediaTrailer = new MediaTrailer();
                    mediaTrailer.setProvider("imdb");
                    mediaTrailer.setScrapedBy("imdb");
                    mediaTrailer.setId(video.id);
                    mediaTrailer.setDate(video.createdDate);
                    mediaTrailer.setName(video.name.value);
                    mediaTrailer.setQuality(vidurl.displayName.value);
                    md.addTrailer(mediaTrailer);
                }
            }
            JsonNode epNode = node.at("/props/pageProps/aboveTheFoldData/series/episodeNumber");
            ImdbEpisodeNumber ep = JsonUtils.parseObject(this.mapper, epNode, ImdbEpisodeNumber.class);
            if (ep != null) {
                md.setEpisodeNumber(ep.episodeNumber);
                md.setSeasonNumber(ep.seasonNumber);
            }
            JsonNode titleMainImages = node.at("/props/pageProps/mainColumnData/titleMainImages/edges");
            for (Object fanart : ListUtils.nullSafe(titleMainImages)) {
                ImdbImage imdbImage2 = JsonUtils.parseObject(this.mapper, fanart.get("node"), ImdbImage.class);
                if (imdbImage2 == null || imdbImage2.width <= imdbImage2.height) continue;
                MediaArtwork mediaArtwork = new MediaArtwork("imdb", MediaArtwork.MediaArtworkType.BACKGROUND);
                mediaArtwork.setOriginalUrl(imdbImage2.url);
                mediaArtwork.setPreviewUrl(imdbImage2.url);
                mediaArtwork.setImdbId(imdbImage2.id);
                mediaArtwork.addImageSize(imdbImage2.width, imdbImage2.height, imdbImage2.url);
                md.addMediaArt(mediaArtwork);
            }
            JsonNode directorsNode = node.at("/props/pageProps/mainColumnData/directors");
            for (ImdbCredits imdbCredits : JsonUtils.parseList(this.mapper, directorsNode, ImdbCredits.class)) {
                for (ImdbCrew imdbCrew : imdbCredits.credits) {
                    Person person = imdbCrew.toTmm(Person.Type.DIRECTOR);
                    person.setRole(imdbCredits.category.text);
                    md.addCastMember(person);
                }
            }
            JsonNode writersNode = node.at("/props/pageProps/mainColumnData/writers");
            for (ImdbCredits imdbCredits : JsonUtils.parseList(this.mapper, writersNode, ImdbCredits.class)) {
                for (ImdbCrew imdbCrew : imdbCredits.credits) {
                    Person p = imdbCrew.toTmm(Person.Type.WRITER);
                    p.setRole(imdbCredits.category.text);
                    md.addCastMember(p);
                }
            }
            JsonNode jsonNode = node.at("/props/pageProps/mainColumnData/cast/edges");
            for (JsonNode jsonNode2 : ListUtils.nullSafe(jsonNode)) {
                ImdbCast imdbCast = JsonUtils.parseObject(this.mapper, jsonNode2.get("node"), ImdbCast.class);
                md.addCastMember(imdbCast.toTmm(Person.Type.ACTOR));
            }
            JsonNode jsonNode3 = node.at("/props/pageProps/mainColumnData/spokenLanguages/spokenLanguages");
            for (ImdbIdTextType imdbIdTextType : JsonUtils.parseList(this.mapper, jsonNode3, ImdbIdTextType.class)) {
                if (this.isScrapeLanguageNames()) {
                    md.addSpokenLanguage(imdbIdTextType.text);
                    continue;
                }
                md.addSpokenLanguage(imdbIdTextType.id);
            }
            JsonNode jsonNode4 = node.at("/props/pageProps/mainColumnData/countriesOfOrigin/countries");
            for (ImdbCountry country : JsonUtils.parseList(this.mapper, jsonNode4, ImdbCountry.class)) {
                if (this.isScrapeLanguageNames()) {
                    md.addCountry(country.text);
                    continue;
                }
                md.addCountry(country.id);
            }
            JsonNode jsonNode5 = node.at("/props/pageProps/mainColumnData/production/edges");
            for (JsonNode p : ListUtils.nullSafe(jsonNode5)) {
                md.addProductionCompany(p.at("/node/company/companyText/text").asText());
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Error parsing JSON: '{}'", (Throwable)e);
            throw e;
        }
    }

    protected String getFreshUrlForTrailer(MediaTrailer trailer) throws Exception {
        ImdbWorker worker = new ImdbWorker(this.constructUrl("video/", trailer.getId()), "", "", true);
        Future<Document> futureVid = this.executor.submit(worker);
        Document doc = futureVid.get();
        String json = doc.getElementById("__NEXT_DATA__").data();
        JsonNode node = this.mapper.readTree(json);
        JsonNode vidNode = node.at("/props/pageProps/videoPlaybackData/video");
        if (!vidNode.isMissingNode()) {
            ImdbVideo video = JsonUtils.parseObject(this.mapper, vidNode, ImdbVideo.class);
            for (ImdbPlaybackUrl vid : ListUtils.nullSafe(video.playbackURLs)) {
                if (!vid.displayName.value.equals(trailer.getQuality())) continue;
                return vid.url;
            }
        }
        return "";
    }

    protected void parseReferencePage(Document doc, MediaSearchAndScrapeOptions options, MediaMetadata md) {
        Element producersElement;
        Element writersElement;
        Element castTableElement;
        Element directorsElement;
        Element releaseDateElement;
        Element topRatedElement;
        Element ratingElement;
        Element poster;
        String content;
        int startOfYear;
        Element originalTitleYear;
        Element title = doc.getElementsByAttributeValue("name", "title").first();
        if (title != null) {
            int yearStart;
            String movieTitle = this.cleanString(title.attr("content"));
            if (movieTitle.contains("TV Mini-Series")) {
                md.addGenre(MediaGenres.MINI_SERIES);
            }
            if ((yearStart = movieTitle.lastIndexOf(40)) > 0) {
                movieTitle = movieTitle.substring(0, yearStart - 1).trim();
                md.setTitle(movieTitle);
            }
        }
        if ((originalTitleYear = doc.getElementsByAttributeValue("property", "og:title").first()) != null && (startOfYear = (content = originalTitleYear.attr("content")).lastIndexOf(40)) > 0) {
            String originalTitle = content.substring(0, startOfYear - 1).trim();
            md.setOriginalTitle(originalTitle);
            String yearText = content.substring(startOfYear);
            Pattern yearPattern = Pattern.compile("[1-2][0-9]{3}");
            Matcher matcher = yearPattern.matcher(yearText);
            while (matcher.find()) {
                if (matcher.group(0) == null) continue;
                String movieYear = matcher.group(0);
                try {
                    md.setYear(Integer.parseInt(movieYear));
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
        if ((poster = doc.getElementsByAttributeValue("property", "og:image").first()) != null) {
            int startOfExtension;
            int parameterStart;
            Object posterUrl = poster.attr("content");
            int fileStart = ((String)posterUrl).lastIndexOf(47);
            if (fileStart > 0 && (parameterStart = ((String)posterUrl).indexOf(95, fileStart)) > 0 && (startOfExtension = ((String)posterUrl).lastIndexOf(46)) > parameterStart) {
                posterUrl = ((String)posterUrl).substring(0, parameterStart) + ((String)posterUrl).substring(startOfExtension);
            }
            this.processMediaArt(md, MediaArtwork.MediaArtworkType.POSTER, (String)posterUrl);
        }
        if ((ratingElement = doc.getElementsByClass("ipl-rating-star__rating").first()) != null) {
            String ratingAsString = ratingElement.ownText().replace(",", ".");
            Element votesElement = doc.getElementsByClass("ipl-rating-star__total-votes").first();
            if (votesElement != null) {
                String countAsString = votesElement.ownText().replaceAll("[.,()]", "").trim();
                try {
                    MediaRating rating = new MediaRating("imdb");
                    rating.setRating(Float.parseFloat(ratingAsString));
                    rating.setVotes(MetadataUtil.parseInt(countAsString));
                    md.addRating(rating);
                }
                catch (Exception e) {
                    this.getLogger().trace("could not parse rating/vote count: {}", (Object)e.getMessage());
                }
            }
        }
        if ((topRatedElement = doc.getElementsByAttributeValue("href", "/chart/top").first()) != null) {
            Pattern topPattern = Pattern.compile("Top Rated Movies: #([0-9]{1,3})");
            Matcher matcher = topPattern.matcher(topRatedElement.ownText());
            while (matcher.find()) {
                if (matcher.group(1) == null) continue;
                try {
                    String top250Text = matcher.group(1);
                    md.setTop250(Integer.parseInt(top250Text));
                }
                catch (Exception e) {
                    this.getLogger().trace("could not parse top250: {}", (Object)e.getMessage());
                }
            }
        }
        if ((releaseDateElement = doc.getElementsByAttributeValue("href", "/title/" + options.getImdbId().toLowerCase(Locale.ROOT) + "/releaseinfo").first()) != null) {
            String releaseDateText = releaseDateElement.ownText();
            int startOfCountry = releaseDateText.indexOf(40);
            if (startOfCountry > 0) {
                releaseDateText = releaseDateText.substring(0, startOfCountry - 1).trim();
            }
            md.setReleaseDate(this.parseDate(releaseDateText));
        }
        Elements elements = doc.getElementsByClass("ipl-zebra-list__label");
        block10: for (Object element : elements) {
            MediaCertification certification;
            String certText;
            Matcher matcher;
            Pattern pattern;
            Element runtimeElement;
            Element nextElement;
            Element taglineElement;
            if (!"td".equals(element.tag().getName())) continue;
            String elementText = element.ownText();
            if (elementText.equals("Plot Keywords")) {
                this.parseKeywords((Element)element, md);
            }
            if (elementText.equals("Taglines") && !this.isUseTmdbForMovies() && (taglineElement = element.nextElementSibling()) != null) {
                String tagline = this.cleanString(taglineElement.ownText().replace("\u00bb", ""));
                md.setTagline(tagline);
            }
            if (elementText.equals("Genres") && (nextElement = element.nextElementSibling()) != null) {
                Elements genreElements = nextElement.getElementsByAttributeValueStarting("href", "/genre/");
                for (Element genreElement : genreElements) {
                    String genreText = genreElement.ownText();
                    md.addGenre(this.getTmmGenre(genreText));
                }
            }
            if (elementText.equals("Runtime") && (nextElement = element.nextElementSibling()) != null && (runtimeElement = nextElement.getElementsByClass("ipl-inline-list__item").first()) != null) {
                int runtime;
                block62: {
                    String first = runtimeElement.ownText().split("\\|")[0];
                    String runtimeAsString = this.cleanString(first.replace("min", ""));
                    runtime = 0;
                    try {
                        runtime = Integer.parseInt(runtimeAsString);
                    }
                    catch (Exception e) {
                        Pattern runtimePattern = Pattern.compile("([0-9]{2,3})");
                        Matcher matcher2 = runtimePattern.matcher(runtimeAsString);
                        if (!matcher2.find()) break block62;
                        runtime = Integer.parseInt(matcher2.group(0));
                    }
                }
                md.setRuntime(runtime);
            }
            if (elementText.equals("Country") && (nextElement = element.nextElementSibling()) != null) {
                Elements countryElements = nextElement.getElementsByAttributeValueStarting("href", "/country/");
                pattern = Pattern.compile("/country/(.*)");
                for (Element countryElement : countryElements) {
                    matcher = pattern.matcher(countryElement.attr("href"));
                    if (!matcher.matches()) continue;
                    if (this.isScrapeLanguageNames()) {
                        md.addCountry(LanguageUtils.getLocalizedCountryForLanguage(options.getLanguage().getLanguage(), countryElement.text(), matcher.group(1)));
                        continue;
                    }
                    md.addCountry(matcher.group(1));
                }
            }
            if (elementText.equals("Language") && (nextElement = element.nextElementSibling()) != null) {
                Elements languageElements = nextElement.getElementsByAttributeValueStarting("href", "/language/");
                pattern = Pattern.compile("/language/(.*)");
                for (Element languageElement : languageElements) {
                    matcher = pattern.matcher(languageElement.attr("href"));
                    if (!matcher.matches()) continue;
                    if (this.isScrapeLanguageNames()) {
                        md.addSpokenLanguage(LanguageUtils.getLocalizedLanguageNameFromLocalizedString(options.getLanguage().toLocale(), languageElement.text(), matcher.group(1)));
                        continue;
                    }
                    md.addSpokenLanguage(matcher.group(1));
                }
            }
            if (!elementText.equals("Certification") || (nextElement = element.nextElementSibling()) == null) continue;
            String languageCode = options.getCertificationCountry().getAlpha2();
            Elements certificationElements = nextElement.getElementsByAttributeValueStarting("href", "/search/title?certificates=" + languageCode);
            boolean done = false;
            for (Element certificationElement : certificationElements) {
                certText = certificationElement.ownText();
                int startOfCert = certText.indexOf(58);
                if (startOfCert > 0 && certText.length() > startOfCert + 1) {
                    certText = certText.substring(startOfCert + 1);
                }
                if ((certification = MediaCertification.getCertification(options.getCertificationCountry(), certText)) == null) continue;
                md.addCertification(certification);
                done = true;
            }
            if (done || !languageCode.equals("DE")) continue;
            certificationElements = nextElement.getElementsByAttributeValueStarting("href", "/search/title?certificates=XWG");
            for (Element certificationElement : certificationElements) {
                certText = certificationElement.ownText();
                int startOfCert = certText.indexOf(58);
                if (startOfCert > 0 && certText.length() > startOfCert + 1) {
                    certText = certText.substring(startOfCert + 1);
                }
                if ((certification = MediaCertification.getCertification(options.getCertificationCountry(), certText)) == null) continue;
                md.addCertification(certification);
                continue block10;
            }
        }
        for (directorsElement = doc.getElementById("directors"); directorsElement != null && !"header".equals(directorsElement.tag().getName()); directorsElement = directorsElement.parent()) {
        }
        if (directorsElement != null) {
            directorsElement = directorsElement.nextElementSibling();
        }
        if (directorsElement != null) {
            for (Element directorElement : directorsElement.getElementsByClass("name")) {
                Matcher matcher;
                String director = directorElement.text().trim();
                Person cm = new Person(Person.Type.DIRECTOR, director);
                Element anchor = directorElement.getElementsByAttributeValueStarting("href", "/name/").first();
                if (anchor != null && (matcher = PERSON_ID_PATTERN.matcher(anchor.attr("href"))).find()) {
                    if (matcher.group(0) != null) {
                        cm.setProfileUrl("http://www.imdb.com" + matcher.group(0));
                    }
                    if (matcher.group(1) != null) {
                        cm.setId("imdb", matcher.group(1));
                    }
                }
                md.addCastMember(cm);
            }
        }
        if ((castTableElement = doc.getElementsByClass("cast_list").first()) != null) {
            Elements castListLabel = castTableElement.getElementsByClass("castlist_label");
            Elements tr = castTableElement.getElementsByTag("tr");
            for (Element row : tr) {
                if (!this.isScrapeUncreditedActors() && castListLabel.size() > 1 && row.children().contains(castListLabel.get(1))) break;
                Person cm = this.parseCastMember(row);
                if (cm == null || !StringUtils.isNotEmpty((CharSequence)cm.getName())) continue;
                cm.setType(Person.Type.ACTOR);
                md.addCastMember(cm);
            }
        }
        for (writersElement = doc.getElementById("writers"); writersElement != null && !"header".equals(writersElement.tag().getName()); writersElement = writersElement.parent()) {
        }
        if (writersElement != null) {
            writersElement = writersElement.nextElementSibling();
        }
        if (writersElement != null) {
            Elements writersElements = writersElement.getElementsByAttributeValueStarting("href", "/name/");
            for (Object writerElement : writersElements) {
                Matcher matcher;
                String writer = this.cleanString(writerElement.ownText());
                Person cm = new Person(Person.Type.WRITER, writer);
                Element anchor = writerElement.getElementsByAttributeValueStarting("href", "/name/").first();
                if (anchor != null && (matcher = PERSON_ID_PATTERN.matcher(anchor.attr("href"))).find()) {
                    if (matcher.group(0) != null) {
                        cm.setProfileUrl("http://www.imdb.com" + matcher.group(0));
                    }
                    if (matcher.group(1) != null) {
                        cm.setId("imdb", matcher.group(1));
                    }
                }
                md.addCastMember(cm);
            }
        }
        for (producersElement = doc.getElementById("producers"); producersElement != null && !"header".equals(producersElement.tag().getName()); producersElement = producersElement.parent()) {
        }
        if (producersElement != null) {
            producersElement = producersElement.nextElementSibling();
        }
        if (producersElement != null) {
            Elements producersElements = producersElement.getElementsByAttributeValueStarting("href", "/name/");
            for (Element producerElement : producersElements) {
                String producer = this.cleanString(producerElement.ownText());
                Person cm = new Person(Person.Type.PRODUCER, producer);
                md.addCastMember(cm);
            }
        }
        Elements prodCompHeaderElements = doc.getElementsByClass("ipl-list-title");
        Element prodCompHeaderElement = null;
        for (Element possibleProdCompHeaderEl : prodCompHeaderElements) {
            if (!possibleProdCompHeaderEl.ownText().equals("Production Companies")) continue;
            prodCompHeaderElement = possibleProdCompHeaderEl;
            break;
        }
        while (prodCompHeaderElement != null && !"header".equals(prodCompHeaderElement.tag().getName())) {
            prodCompHeaderElement = prodCompHeaderElement.parent();
        }
        if (prodCompHeaderElement != null) {
            prodCompHeaderElement = prodCompHeaderElement.nextElementSibling();
        }
        if (prodCompHeaderElement != null) {
            Elements prodCompElements = prodCompHeaderElement.getElementsByAttributeValueStarting("href", "/company/");
            for (Element prodCompElement : prodCompElements) {
                String prodComp = prodCompElement.ownText();
                md.addProductionCompany(prodComp);
            }
        }
    }

    private void parseKeywords(Element element, MediaMetadata md) {
        Element parent = element.nextElementSibling();
        Elements keywords = parent.getElementsByClass("ipl-inline-list__item");
        for (Element keyword : keywords) {
            Element a = keyword.getElementsByTag("a").first();
            if (a == null || a.attr("href").contains("/keywords")) continue;
            md.addTag(a.ownText());
        }
    }

    protected void parseKeywordsPage(Document doc, MediaSearchAndScrapeOptions options, MediaMetadata md) {
        int maxKeywordCount = this.getMaxKeywordCount();
        int counter = md.getTags().size();
        try {
            String json = doc.getElementById("__NEXT_DATA__").data();
            JsonNode node = this.mapper.readTree(json);
            JsonNode keywordsNode = node.at("/props/pageProps/contentData/section/items");
            for (ImdbTitleKeyword kw : JsonUtils.parseList(this.mapper, keywordsNode, ImdbTitleKeyword.class)) {
                md.addTag(kw.rowTitle);
                if (++counter < maxKeywordCount) continue;
                break;
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Error parsing JSON: '{}'", (Throwable)e);
        }
        if (md.getTags().size() < maxKeywordCount) {
            counter = 0;
            Elements keywords = doc.getElementsByClass("ipc-metadata-list-summary-item__t");
            for (Element keyword : keywords) {
                if (!StringUtils.isNotBlank((CharSequence)keyword.text())) continue;
                md.addTag(keyword.text());
                if (++counter < maxKeywordCount) continue;
                break;
            }
        }
        if (md.getTags().size() < maxKeywordCount) {
            counter = 0;
            Element div = doc.getElementById("keywords_content");
            if (div != null) {
                Elements keywords = div.getElementsByClass("sodatext");
                for (Element keyword : keywords) {
                    if (!StringUtils.isNotBlank((CharSequence)keyword.text())) continue;
                    md.addTag(keyword.text());
                    if (++counter < maxKeywordCount) continue;
                    break;
                }
            }
        }
    }

    protected void parsePlotsummaryPage(Document doc, MediaSearchAndScrapeOptions options, MediaMetadata md) {
        Elements p;
        Element zebraList;
        if (md.getPlot().isEmpty()) {
            Elements sum = doc.getElementsByClass("ipc-html-content-inner-div");
            String plot = this.cleanString(sum.text());
            md.setPlot(plot);
        }
        if (md.getPlot().isEmpty() && (zebraList = doc.getElementById("plot-summaries-content")) != null && !(p = zebraList.getElementsByClass("ipl-zebra-list__item")).isEmpty()) {
            Element em = (Element)p.get(0);
            Elements authors = em.getElementsByClass("author-container");
            if (!authors.isEmpty()) {
                ((Element)authors.get(0)).remove();
            }
            if (!"no-summary-content".equals(em.id())) {
                String plot = this.cleanString(em.text());
                md.setPlot(plot);
            }
        }
    }

    protected void parseReleaseinfoPage(Document doc, MediaSearchAndScrapeOptions options, MediaMetadata md) {
        Date parsedDate;
        Element column;
        String country;
        Matcher matcher;
        Element anchor;
        Date parsedDate2;
        Element column2;
        Elements rows;
        Date releaseDate = null;
        Pattern pattern = Pattern.compile("/calendar/\\?region=(.{2})");
        String releaseDateCountry = options.getReleaseDateCountry();
        boolean parseLocalReleaseDate = Boolean.TRUE.equals(this.config.getValueAsBool(LOCAL_RELEASE_DATE, false));
        boolean includePremiereDate = Boolean.TRUE.equals(this.config.getValueAsBool(INCLUDE_PREMIERE_DATE, true));
        Element tableReleaseDates = doc.getElementById("release_dates");
        if (tableReleaseDates != null) {
            rows = tableReleaseDates.getElementsByTag("tr");
            for (Element row : rows) {
                if (row.text().contains("(premiere)") && !includePremiereDate) continue;
                if (!parseLocalReleaseDate) {
                    column2 = row.getElementsByClass("release_date").first();
                    if (column2 == null || (parsedDate2 = this.parseDate(column2.text())) == null) continue;
                    releaseDate = parsedDate2;
                    break;
                }
                anchor = row.getElementsByAttributeValueStarting("href", "/calendar/").first();
                if (anchor == null || !(matcher = pattern.matcher(anchor.attr("href"))).find()) continue;
                country = matcher.group(1);
                column = row.getElementsByClass("release_date").first();
                if (column == null || (parsedDate = this.parseDate(column.text())) == null || !releaseDateCountry.equalsIgnoreCase(country)) continue;
                releaseDate = parsedDate;
                break;
            }
        }
        if (releaseDate == null) {
            rows = doc.getElementsByClass("release-date-item");
            for (Element row : rows) {
                if (row.text().contains("(premiere)") && !includePremiereDate) continue;
                if (!parseLocalReleaseDate) {
                    column2 = row.getElementsByClass("release-date-item__date").first();
                    parsedDate2 = this.parseDate(column2.text());
                    if (parsedDate2 == null) continue;
                    releaseDate = parsedDate2;
                    break;
                }
                anchor = row.getElementsByAttributeValueStarting("href", "/calendar/").first();
                if (anchor == null || !(matcher = pattern.matcher(anchor.attr("href"))).find()) continue;
                country = matcher.group(1);
                column = row.getElementsByClass("release-date-item__date").first();
                if (column == null || (parsedDate = this.parseDate(column.text())) == null || !releaseDateCountry.equalsIgnoreCase(country)) continue;
                releaseDate = parsedDate;
                break;
            }
        }
        if (releaseDate == null && tableReleaseDates != null) {
            rows = tableReleaseDates.getElementsByTag("tr");
            for (Element row : rows) {
                if (row.text().contains("(premiere)") && !includePremiereDate || (parsedDate2 = this.parseDate((column2 = row.getElementsByClass("release_date").first()).text())) == null) continue;
                releaseDate = parsedDate2;
                break;
            }
        }
        if (releaseDate == null) {
            rows = doc.getElementsByClass("release-date-item");
            for (Element row : rows) {
                if (row.text().contains("(premiere)") && !includePremiereDate || (parsedDate2 = this.parseDate((column2 = row.getElementsByClass("release-date-item__date").first()).text())) == null) continue;
                releaseDate = parsedDate2;
                break;
            }
        }
        if (releaseDate != null) {
            md.setReleaseDate(releaseDate);
        }
    }

    protected Person parseCastMember(Element row) {
        Matcher matcher;
        Element nameElement = row.getElementsByAttributeValueStarting("itemprop", "name").first();
        if (nameElement == null) {
            return null;
        }
        String name = this.cleanString(nameElement.ownText());
        String characterName = "";
        Element characterElement = row.getElementsByClass("character").first();
        if (characterElement != null) {
            characterName = this.cleanString(characterElement.text());
            characterName = characterName.replaceAll("\\(.*?\\)$", "").trim();
        }
        String image = "";
        Element imageElement = row.getElementsByTag("img").first();
        if (imageElement != null) {
            String imageSrc = imageElement.attr("loadlate");
            if (StringUtils.isNotBlank((CharSequence)imageSrc)) {
                imageSrc = this.scaleImage(imageSrc, 300, 450);
            }
            image = imageSrc;
        }
        Object profilePath = "";
        String id = "";
        Element anchor = row.getElementsByAttributeValueStarting("href", "/name/").first();
        if (anchor != null && (matcher = PERSON_ID_PATTERN.matcher(anchor.attr("href"))).find()) {
            if (matcher.group(0) != null) {
                profilePath = "http://www.imdb.com" + matcher.group(0);
            }
            if (matcher.group(1) != null) {
                id = matcher.group(1);
            }
        }
        Person cm = new Person();
        cm.setId("imdb", id);
        cm.setName(name);
        cm.setRole(characterName);
        cm.setThumbUrl(image);
        cm.setProfileUrl((String)profilePath);
        return cm;
    }

    private String scaleImage(String url, int desiredWidth, int desiredHeight) {
        String imageSrc = url;
        Matcher matcher = IMAGE_SCALING_PATTERN.matcher(imageSrc);
        if (matcher.find()) {
            try {
                String direction = matcher.group(1);
                int scaling = MetadataUtil.parseInt(matcher.group(2), 0);
                int cropLeft = MetadataUtil.parseInt(matcher.group(3));
                int cropTop = MetadataUtil.parseInt(matcher.group(4));
                int actualWidth = MetadataUtil.parseInt(matcher.group(5));
                int actualHeight = MetadataUtil.parseInt(matcher.group(6));
                if (scaling > 0) {
                    if ("X".equals(direction)) {
                        imageSrc = imageSrc.replace("SX" + scaling, "UY" + desiredHeight);
                    } else if ("Y".equals(direction)) {
                        imageSrc = imageSrc.replace("SY" + scaling, "UY" + desiredHeight);
                    }
                    int newCropLeft = cropLeft;
                    int newCropTop = cropTop;
                    float scaleFactor = (float)actualWidth / (float)actualHeight > (float)desiredWidth / (float)desiredHeight ? (float)desiredHeight / (float)actualHeight : (float)desiredWidth / (float)actualWidth;
                    if (cropLeft > 0) {
                        newCropLeft = (int)((float)cropLeft * scaleFactor + ((float)actualWidth * scaleFactor - (float)desiredWidth) / 2.0f);
                    }
                    if (cropTop > 0) {
                        newCropTop = (int)((float)cropTop * scaleFactor + ((float)actualHeight * scaleFactor - (float)desiredHeight) / 2.0f);
                    }
                    imageSrc = imageSrc.replace("CR" + cropLeft + "," + cropTop + "," + actualWidth + "," + actualHeight, "CR" + newCropLeft + "," + newCropTop + "," + desiredWidth + "," + desiredHeight);
                }
            }
            catch (Exception e) {
                this.getLogger().debug("Could not parse scaling/cropping params - '{}'", (Object)e.getMessage());
            }
        }
        return imageSrc;
    }

    protected Date parseDate(String dateAsSting) {
        try {
            return StrgUtils.parseDate(dateAsSting);
        }
        catch (ParseException e) {
            this.getLogger().trace("could not parse date: {}", (Object)e.getMessage());
            return null;
        }
    }

    protected Map<String, Integer> parseTop250(String url) {
        HashMap<String, Integer> titles = new HashMap<String, Integer>();
        try {
            ImdbWorker worker = new ImdbWorker(this.constructUrl(url), "en", "US", true);
            Future<Document> futureTop250 = this.executor.submit(worker);
            Document doc = futureTop250.get();
            String json = doc.getElementById("__NEXT_DATA__").data();
            if (!json.isEmpty()) {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode node = mapper.readTree(json);
                JsonNode chartNode = node.at("/props/pageProps/pageData/chartTitles/edges");
                for (ImdbChartTitleEdge ch : JsonUtils.parseList(mapper, chartNode, ImdbChartTitleEdge.class)) {
                    titles.put(ch.node.id, ch.currentRank);
                }
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Could not get TOP250 listing - '{}'", (Object)e.getMessage());
        }
        return titles;
    }

    protected void processMediaArt(MediaMetadata md, MediaArtwork.MediaArtworkType type, String image) {
        MediaArtwork ma = new MediaArtwork("imdb", type);
        ma.setDefaultUrl(image);
        ma.setOriginalUrl(image);
        String extension = FilenameUtils.getExtension((String)image);
        String previewUrl = image.replace("." + extension, "_SX342." + extension);
        ma.setPreviewUrl(previewUrl);
        md.addMediaArt(ma);
    }

    protected void adoptArtworkToOptions(MediaArtwork artwork, ArtworkSearchAndScrapeOptions options) {
        int width = 0;
        int height = 0;
        switch (options.getPosterSize()) {
            case SMALL: {
                width = 185;
                height = 277;
                break;
            }
            case MEDIUM: {
                width = 342;
                height = 513;
                break;
            }
            case BIG: {
                width = 500;
                height = 750;
                break;
            }
            case LARGE: {
                width = 1000;
                height = 1500;
                break;
            }
            case XLARGE: {
                width = 2000;
                height = 3000;
            }
        }
        if (width > 0 && height > 0) {
            MediaArtwork.ImageSizeAndUrl originalSize;
            MediaArtwork.ImageSizeAndUrl imageSizeAndUrl = originalSize = !artwork.getImageSizes().isEmpty() ? artwork.getImageSizes().get(0) : null;
            if (originalSize != null) {
                if (originalSize.getWidth() > width || originalSize.getHeight() > height) {
                    String image = artwork.getDefaultUrl();
                    String extension = FilenameUtils.getExtension((String)image);
                    String defaultUrl = image.replace("." + extension, "_UX" + width + "." + extension);
                    artwork.setDefaultUrl(defaultUrl);
                    artwork.setSizeOrder(options.getPosterSize().getOrder());
                    artwork.setLanguage("");
                    artwork.addImageSize(width, height, defaultUrl);
                }
            } else {
                String image = artwork.getDefaultUrl();
                String extension = FilenameUtils.getExtension((String)image);
                String defaultUrl = image.replace("." + extension, "_UX" + width + "." + extension);
                artwork.setDefaultUrl(defaultUrl);
                artwork.setSizeOrder(options.getPosterSize().getOrder());
                artwork.setLanguage("");
                artwork.addImageSize(width, height, defaultUrl);
            }
        }
    }

    protected String cleanString(String oldString) {
        if (StringUtils.isEmpty((CharSequence)oldString)) {
            return "";
        }
        String newString = StringUtils.trim((String)oldString.replace(String.valueOf('\u00a0'), " "));
        if (newString.startsWith("\"") && newString.endsWith("\"")) {
            newString = StringUtils.stripEnd((String)StringUtils.stripStart((String)newString, (String)"\""), (String)"\"");
        }
        return newString;
    }

    protected MediaGenres getTmmGenre(String genre) {
        MediaGenres g = null;
        if (StringUtils.isBlank((CharSequence)genre)) {
            return null;
        }
        if (genre.equals("Action")) {
            g = MediaGenres.ACTION;
        } else if (genre.equals("Adult")) {
            g = MediaGenres.EROTIC;
        } else if (genre.equals("Adventure")) {
            g = MediaGenres.ADVENTURE;
        } else if (genre.equals("Animation")) {
            g = MediaGenres.ANIMATION;
        } else if (genre.equals("Biography")) {
            g = MediaGenres.BIOGRAPHY;
        } else if (genre.equals("Comedy")) {
            g = MediaGenres.COMEDY;
        } else if (genre.equals("Crime")) {
            g = MediaGenres.CRIME;
        } else if (genre.equals("Documentary")) {
            g = MediaGenres.DOCUMENTARY;
        } else if (genre.equals("Drama")) {
            g = MediaGenres.DRAMA;
        } else if (genre.equals("Family")) {
            g = MediaGenres.FAMILY;
        } else if (genre.equals("Fantasy")) {
            g = MediaGenres.FANTASY;
        } else if (genre.equals("Film-Noir")) {
            g = MediaGenres.FILM_NOIR;
        } else if (genre.equals("Game-Show")) {
            g = MediaGenres.GAME_SHOW;
        } else if (genre.equals("History")) {
            g = MediaGenres.HISTORY;
        } else if (genre.equals("Horror")) {
            g = MediaGenres.HORROR;
        } else if (genre.equals("Music")) {
            g = MediaGenres.MUSIC;
        } else if (genre.equals("Musical")) {
            g = MediaGenres.MUSICAL;
        } else if (genre.equals("Mystery")) {
            g = MediaGenres.MYSTERY;
        } else if (genre.equals("News")) {
            g = MediaGenres.NEWS;
        } else if (genre.equals("Reality-TV")) {
            g = MediaGenres.REALITY_TV;
        } else if (genre.equals("Romance")) {
            g = MediaGenres.ROMANCE;
        } else if (genre.equals("Sci-Fi")) {
            g = MediaGenres.SCIENCE_FICTION;
        } else if (genre.equals("Short")) {
            g = MediaGenres.SHORT;
        } else if (genre.equals("Sport")) {
            g = MediaGenres.SPORT;
        } else if (genre.equals("Talk-Show")) {
            g = MediaGenres.TALK_SHOW;
        } else if (genre.equals("Thriller")) {
            g = MediaGenres.THRILLER;
        } else if (genre.equals("War")) {
            g = MediaGenres.WAR;
        } else if (genre.equals("Western")) {
            g = MediaGenres.WESTERN;
        }
        if (g == null) {
            g = MediaGenres.getGenre(genre);
        }
        return g;
    }

    protected class ImdbWorker
    implements Callable<Document> {
        private final String pageUrl;
        private final String language;
        private final String country;
        private final boolean useCachedUrl;

        ImdbWorker(String url, String language, String country) {
            this(url, language, country, true);
        }

        ImdbWorker(String url, String language, String country, boolean useCachedUrl) {
            this.pageUrl = url;
            this.language = language;
            this.country = country;
            this.useCachedUrl = useCachedUrl;
        }

        @Override
        public Document call() throws Exception {
            Url url;
            Document doc = null;
            try {
                url = this.useCachedUrl ? new InMemoryCachedUrl(this.pageUrl) : new Url(this.pageUrl);
                url.addHeader("Accept-Language", ImdbParser.getAcceptLanguage(this.language, this.country));
            }
            catch (Exception e) {
                ImdbParser.this.getLogger().debug("tried to fetch imdb page {} - {}", (Object)this.pageUrl, (Object)e);
                throw new ScrapeException(e);
            }
            try (InputStream is = url.getInputStream();){
                doc = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"");
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                ImdbParser.this.getLogger().debug("tried to fetch imdb page {} - {}", (Object)this.pageUrl, (Object)e);
                throw e;
            }
            return doc;
        }
    }
}

