/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.kodi;

import java.io.ByteArrayInputStream;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.translate.UnicodeUnescaper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IKodiMetadataProvider;
import org.tinymediamanager.scraper.kodi.KodiAddonProcessor;
import org.tinymediamanager.scraper.kodi.KodiScraper;
import org.tinymediamanager.scraper.kodi.KodiScraperParser;
import org.tinymediamanager.scraper.kodi.KodiUrl;
import org.tinymediamanager.scraper.kodi.KodiUtil;
import org.tinymediamanager.scraper.util.DOMUtils;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public abstract class AbstractKodiMetadataProvider
implements IKodiMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractKodiMetadataProvider.class);
    private final UnicodeUnescaper uu = new UnicodeUnescaper();
    private final DocumentBuilderFactory factory;
    public KodiScraper scraper;
    protected KodiAddonProcessor processor = null;
    private String baseImageUrl = "";

    public AbstractKodiMetadataProvider(KodiScraper scraper) {
        KodiScraperParser parser = new KodiScraperParser();
        try {
            scraper = parser.parseScraper(scraper, KodiUtil.commonXmls);
        }
        catch (Exception e) {
            LOGGER.error("Failed to Load Kodi Scraper: {}", (Object)scraper);
            throw new RuntimeException("Failed to Load Kodi Scraper: " + scraper, e);
        }
        this.scraper = scraper;
        this.factory = DocumentBuilderFactory.newInstance();
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return this.scraper.getProviderInfo();
    }

    @Override
    public String getId() {
        return this.scraper.getId();
    }

    protected SortedSet<MediaSearchResult> _search(MediaSearchAndScrapeOptions options) throws ScrapeException {
        this.processor = new KodiAddonProcessor(this.scraper);
        TreeSet<MediaSearchResult> l = new TreeSet<MediaSearchResult>();
        String arg = options.getSearchQuery();
        if (StringUtils.isBlank((CharSequence)arg)) {
            return l;
        }
        String[] args = this.parseTitle(arg);
        String title = args[0];
        int year = 0;
        if (options.getSearchYear() != 0) {
            year = options.getSearchYear();
        }
        try {
            KodiUrl url = this.processor.getSearchUrl(title, year > 0 ? String.valueOf(year) : "");
            if (url == null) {
                return l;
            }
            String xmlString = this.processor.getSearchResults(url);
            LOGGER.trace("========= BEGIN Kodi Scraper Search Xml Results: Url: {}", (Object)url);
            LOGGER.trace(xmlString);
            LOGGER.trace("========= END Kodi Scraper Search Xml Results: Url: {}", (Object)url);
            Document xml = this.parseXmlString(xmlString);
            NodeList nl = xml.getElementsByTagName("entity");
            for (int i = 0; i < nl.getLength(); ++i) {
                try {
                    Element el = (Element)nl.item(i);
                    NodeList titleList = el.getElementsByTagName("title");
                    String t = titleList.item(0).getTextContent();
                    NodeList yearList = el.getElementsByTagName("year");
                    String y = yearList == null || yearList.getLength() == 0 ? "" : yearList.item(0).getTextContent();
                    NodeList urlList = el.getElementsByTagName("url");
                    KodiUrl u = new KodiUrl((Element)urlList.item(0));
                    MediaSearchResult sr = new MediaSearchResult(this.scraper.getProviderInfo().getId(), options.getMediaType());
                    String id = DOMUtils.getElementValue(el, "id");
                    sr.setId(id);
                    sr.setUrl(u.toExternalForm());
                    sr.setProviderId(this.scraper.getProviderInfo().getId());
                    if (u.toExternalForm().contains("imdb")) {
                        sr.setIMDBId(id);
                    }
                    sr.setTitle(t);
                    try {
                        sr.setYear(Integer.parseInt(y));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    sr.calculateScore(options);
                    l.add(sr);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("Error process an xml node!  Ignoring it from the search results.");
                }
            }
            return l;
        }
        catch (Exception e) {
            LOGGER.error("problem searching: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
    }

    private boolean yearDiffers(int i1, int i2) {
        return i1 > 0 && i2 > 0 && i1 != i2;
    }

    protected MediaMetadata _getMetadata(MediaSearchAndScrapeOptions options) throws ScrapeException {
        try {
            MediaMetadata md = new MediaMetadata(this.scraper.getProviderInfo().getId());
            md.setScrapeOptions(options);
            MediaSearchResult result = options.getSearchResult();
            if (result.getIMDBId() != null && result.getIMDBId().contains("tt")) {
                md.setId("imdb", result.getIMDBId());
            }
            String id = result.getIdAsString(result.getProviderId());
            String xmlDetails = this.processor.getDetails(new KodiUrl(result.getUrl()), id);
            if (!StringUtils.isEmpty((CharSequence)id)) {
                md.setId(this.scraper.getProviderInfo().getId(), result.getId());
            }
            xmlDetails = xmlDetails.replace("&nbsp;", " ");
            this.processXmlContent(xmlDetails, md, result);
            if (!StringUtils.isEmpty((CharSequence)result.getUrl()) && md.getId("imdb") != null) {
                md.setId("imdb", this.parseIMDBID(result.getUrl()));
            }
            return md;
        }
        catch (Exception e) {
            LOGGER.error("problem scraping: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
    }

    private String parseIMDBID(String url) {
        if (url == null) {
            return null;
        }
        Pattern p = Pattern.compile("/(tt[0-9]+)/");
        Matcher m = p.matcher(url);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    protected String innerXml(Node node) {
        DOMImplementationLS lsImpl = (DOMImplementationLS)node.getOwnerDocument().getImplementation().getFeature("LS", "3.0");
        LSSerializer lsSerializer = lsImpl.createLSSerializer();
        lsSerializer.getDomConfig().setParameter("xml-declaration", false);
        NodeList childNodes = node.getChildNodes();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            sb.append(lsSerializer.writeToString(childNodes.item(i)));
        }
        return sb.toString();
    }

    protected Document parseXmlString(String xmlString) throws Exception {
        DocumentBuilder parser = this.factory.newDocumentBuilder();
        String xml = xmlString;
        xml = this.uu.translate((CharSequence)xml);
        xml = StringEscapeUtils.unescapeHtml4((String)xml);
        xml = StringEscapeUtils.unescapeXml((String)xml);
        xml = StringEscapeUtils.unescapeXml((String)xml);
        xml = StringEscapeUtils.unescapeXml((String)xml);
        xml = xml.replaceAll("\\&", "\\&amp;");
        Document doc = null;
        for (String charset : new String[]{"UTF-8", "ISO-8859-1", "US-ASCII"}) {
            try {
                doc = parser.parse(new ByteArrayInputStream(xml.getBytes(charset)));
                break;
            }
            catch (Throwable t) {
                LOGGER.error("Failed to parse xml using charset: " + charset + " - " + t.getMessage());
            }
        }
        if (doc == null) {
            LOGGER.error("Unabled to parse xml string");
            LOGGER.trace(xml);
            throw new Exception("Unable to parse xml!");
        }
        return doc;
    }

    protected void addMetadata(MediaMetadata md, Element details) {
        String pic;
        Person cm;
        int i;
        String runtime;
        String studio;
        String country;
        String tagline;
        String premiered;
        String aired;
        String year;
        String plot;
        String originalTitle;
        LOGGER.trace("Processing <details> node....");
        NodeList subDetails = details.getElementsByTagName("details");
        String title = this.getInfoFromScraperFunctionOrBase("title", details, subDetails);
        if (StringUtils.isNotBlank((CharSequence)title)) {
            md.setTitle(title);
        }
        if (StringUtils.isNotBlank((CharSequence)(originalTitle = this.getInfoFromScraperFunctionOrBase("originaltitle", details, subDetails)))) {
            md.setOriginalTitle(originalTitle);
        }
        if (StringUtils.isNotBlank((CharSequence)(plot = this.getInfoFromScraperFunctionOrBase("plot", details, subDetails)))) {
            md.setPlot(plot);
        }
        if (StringUtils.isNotBlank((CharSequence)(year = this.getInfoFromScraperFunctionOrBase("year", details, subDetails)))) {
            try {
                md.setYear(Integer.parseInt(year));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(aired = this.getInfoFromScraperFunctionOrBase("aired", details, subDetails)))) {
            try {
                md.setReleaseDate(StrgUtils.parseDate(aired));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(premiered = this.getInfoFromScraperFunctionOrBase("premiered", details, subDetails)))) {
            try {
                md.setReleaseDate(StrgUtils.parseDate(premiered));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (md.getYear() == 0 && md.getReleaseDate() != null) {
            LocalDate localDate = md.getReleaseDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            md.setYear(localDate.getYear());
        }
        if (StringUtils.isNotBlank((CharSequence)(tagline = this.getInfoFromScraperFunctionOrBase("tagline", details, subDetails)))) {
            md.setTagline(tagline);
        }
        NodeList nlr = details.getElementsByTagName("rating");
        for (int i2 = 0; i2 < nlr.getLength(); ++i2) {
            Element rating = (Element)nlr.item(i2);
            String id = rating.getAttribute("name");
            if (id == null || id.isEmpty()) {
                id = this.getProviderInfo().getId();
            }
            MediaRating rat = new MediaRating(id);
            float value = 0.0f;
            Element val = DOMUtils.getElementByTagName(rating, "value");
            if (val == null) {
                value = NumberUtils.toFloat((String)rating.getTextContent().trim());
                String votes = this.getInfoFromScraperFunctionOrBase("votes", details, subDetails);
                if (StringUtils.isNotBlank((CharSequence)votes)) {
                    try {
                        rat.setVotes(Integer.parseInt(votes));
                    }
                    catch (NumberFormatException ignored) {
                        LOGGER.trace("unparsable votecount: {}", (Object)votes);
                    }
                }
            } else {
                value = NumberUtils.toFloat((String)val.getTextContent().trim());
                rat.setVotes(DOMUtils.getElementIntValue(rating, "votes"));
            }
            rat.setRating(value);
            int maxValue = NumberUtils.toInt((String)rating.getAttribute("max"));
            if (maxValue > 0) {
                rat.setMaxValue(maxValue);
            } else if (value > 10.0f) {
                rat.setMaxValue(100);
            }
            md.addRating(rat);
        }
        String set = this.getInfoFromScraperFunctionOrBase("set", details, subDetails);
        if (StringUtils.isNotBlank((CharSequence)set)) {
            md.setCollectionName(set);
        }
        if (StringUtils.isNotBlank((CharSequence)(country = this.getInfoFromScraperFunctionOrBase("country", details, subDetails)))) {
            md.setCountries(Arrays.asList(country));
        }
        if (StringUtils.isNotBlank((CharSequence)(studio = this.getInfoFromScraperFunctionOrBase("studio", details, subDetails)))) {
            md.setProductionCompanies(Arrays.asList(studio));
        }
        if (StringUtils.isNotBlank((CharSequence)(runtime = this.getInfoFromScraperFunctionOrBase("runtime", details, subDetails)))) {
            try {
                md.setRuntime(Integer.parseInt(runtime));
            }
            catch (NumberFormatException value) {
                // empty catch block
            }
        }
        for (int i3 = 0; i3 < subDetails.getLength(); ++i3) {
            Element el = (Element)subDetails.item(i3);
            Node n = el.getFirstChild();
            if (n == null || n.hasChildNodes() || !el.getTextContent().startsWith("http")) continue;
            this.baseImageUrl = el.getTextContent();
        }
        NodeList nl = details.getElementsByTagName("fanart");
        for (i = 0; i < nl.getLength(); ++i) {
            Element fanart = (Element)nl.item(i);
            String url = fanart.getAttribute("url");
            NodeList thumbs = fanart.getElementsByTagName("thumb");
            if (thumbs != null && thumbs.getLength() > 0) {
                this.processMediaArt(md, MediaArtwork.MediaArtworkType.BACKGROUND, "Backgrounds", thumbs, url);
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)url)) continue;
            this.processMediaArt(md, MediaArtwork.MediaArtworkType.BACKGROUND, "Background", url);
        }
        nl = details.getElementsByTagName("thumb");
        for (i = 0; i < nl.getLength(); ++i) {
            Element poster = (Element)nl.item(i);
            if (!poster.getParentNode().getNodeName().equals("details")) continue;
            this.processMediaArt(md, MediaArtwork.MediaArtworkType.POSTER, "Poster", poster, this.baseImageUrl);
        }
        nl = details.getElementsByTagName("actor");
        for (i = 0; i < nl.getLength(); ++i) {
            Element actor = (Element)nl.item(i);
            cm = new Person(Person.Type.ACTOR);
            cm.setName(DOMUtils.getElementValue(actor, "name"));
            cm.setRole(DOMUtils.getElementValue(actor, "role"));
            pic = DOMUtils.getElementValue(actor, "thumb");
            if (StringUtils.isNotBlank((CharSequence)pic)) {
                cm.setThumbUrl((String)(pic.startsWith("http") ? pic : this.baseImageUrl + pic));
            }
            md.addCastMember(cm);
        }
        nl = details.getElementsByTagName("director");
        for (i = 0; i < nl.getLength(); ++i) {
            Element el = (Element)nl.item(i);
            cm = new Person(Person.Type.DIRECTOR);
            cm.setName(StringUtils.trim((String)el.getTextContent()));
            pic = DOMUtils.getElementValue(el, "thumb");
            if (StringUtils.isNotBlank((CharSequence)pic)) {
                cm.setThumbUrl((String)(pic.startsWith("http") ? pic : this.baseImageUrl + pic));
            }
            md.addCastMember(cm);
        }
        nl = details.getElementsByTagName("credits");
        for (i = 0; i < nl.getLength(); ++i) {
            Element el = (Element)nl.item(i);
            cm = new Person(Person.Type.WRITER);
            cm.setName(StringUtils.trim((String)el.getTextContent()));
            pic = DOMUtils.getElementValue(el, "thumb");
            if (StringUtils.isNotBlank((CharSequence)pic)) {
                cm.setThumbUrl((String)(pic.startsWith("http") ? pic : this.baseImageUrl + pic));
            }
            md.addCastMember(cm);
        }
        nl = details.getElementsByTagName("genre");
        for (i = 0; i < nl.getLength(); ++i) {
            MediaGenres genre;
            Element el = (Element)nl.item(i);
            String g = StringUtils.trim((String)el.getTextContent());
            if (g == null || g.isEmpty() || (genre = MediaGenres.getGenre(g)) == null) continue;
            md.addGenre(genre);
        }
    }

    private String getInfoFromScraperFunctionOrBase(String tag, Element details, NodeList subDetails) {
        String info = "";
        for (int i = 0; i < subDetails.getLength(); ++i) {
            Element subDetail = (Element)subDetails.item(i);
            NodeList nl = subDetail.getElementsByTagName(tag);
            if (nl.getLength() > 0) {
                Element el = (Element)nl.item(0);
                info = el.getTextContent();
            }
            if (!StringUtils.isBlank((CharSequence)info)) break;
        }
        if (StringUtils.isBlank((CharSequence)info)) {
            info = DOMUtils.getElementValue(details, tag);
        }
        return info;
    }

    private void processMediaArt(MediaMetadata md, MediaArtwork.MediaArtworkType type, String label, NodeList els, String baseUrl) {
        for (int i = 0; i < els.getLength(); ++i) {
            Element e = (Element)els.item(i);
            Object image = e.getTextContent();
            if (image != null) {
                image = ((String)image).trim();
            }
            if (baseUrl != null) {
                baseUrl = baseUrl.trim();
                image = baseUrl + (String)image;
            }
            this.processMediaArt(md, type, label, (String)image);
        }
    }

    private void processMediaArt(MediaMetadata md, MediaArtwork.MediaArtworkType type, String label, Element e, String baseUrl) {
        Object image = e.getTextContent();
        if (image != null) {
            image = ((String)image).trim();
        }
        if (baseUrl != null) {
            baseUrl = baseUrl.trim();
            image = baseUrl + (String)image;
        }
        this.processMediaArt(md, type, label, (String)image);
        if (type == MediaArtwork.MediaArtworkType.POSTER) {
            this.processMediaArt(md, MediaArtwork.MediaArtworkType.BACKGROUND, label, (String)image);
        }
    }

    private void processMediaArt(MediaMetadata md, MediaArtwork.MediaArtworkType type, String label, String image) {
        MediaArtwork ma = new MediaArtwork(md.getProviderId(), type);
        ma.setPreviewUrl(image);
        ma.setOriginalUrl(image);
        ma.setDefaultUrl(image);
        md.addMediaArt(ma);
    }

    private String[] parseTitle(String title) {
        String[] v = new String[]{"", ""};
        if (title == null) {
            return v;
        }
        Pattern p = Pattern.compile("(.*)\\s+\\(?([0-9]{4})\\)?", 2);
        Matcher m = p.matcher(title);
        if (m.find()) {
            v[0] = m.group(1);
            v[1] = m.group(2);
        } else {
            v[0] = title;
        }
        return v;
    }

    protected String lz(int num) {
        return String.format("%02d", num);
    }

    protected String elementToString(Element el) {
        try {
            DOMImplementationLS lsImpl = (DOMImplementationLS)el.getOwnerDocument().getImplementation().getFeature("LS", "3.0");
            LSSerializer serializer = lsImpl.createLSSerializer();
            serializer.getDomConfig().setParameter("xml-declaration", false);
            return serializer.writeToString(el);
        }
        catch (Exception e) {
            LOGGER.error("Could not parse XML element!");
            return null;
        }
    }

    protected abstract void processXmlContent(String var1, MediaMetadata var2, MediaSearchResult var3) throws Exception;
}

