/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.mpdbtv;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.mpdbtv.MpdbMetadataProvider;
import org.tinymediamanager.scraper.mpdbtv.entities.Actor;
import org.tinymediamanager.scraper.mpdbtv.entities.Director;
import org.tinymediamanager.scraper.mpdbtv.entities.Genre;
import org.tinymediamanager.scraper.mpdbtv.entities.MovieEntity;
import org.tinymediamanager.scraper.mpdbtv.entities.Producer;
import org.tinymediamanager.scraper.mpdbtv.entities.Release;
import org.tinymediamanager.scraper.mpdbtv.entities.SearchEntity;
import org.tinymediamanager.scraper.mpdbtv.entities.Studio;
import org.tinymediamanager.scraper.mpdbtv.entities.Trailer;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import retrofit2.Response;

public class MpdbMovieMetadataProvider
extends MpdbMetadataProvider
implements IMovieMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(MpdbMovieMetadataProvider.class);
    private final MediaProviderInfo providerInfo = this.createMediaProviderInfo();

    @Override
    protected String getSubId() {
        return "movie";
    }

    @Override
    public SortedSet<MediaSearchResult> search(MovieSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("search(): {}", (Object)options);
        this.initAPI();
        TreeSet<MediaSearchResult> results = new TreeSet<MediaSearchResult>();
        ArrayList searchResult = new ArrayList();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.getAboKey(), this.getUserName()})) {
            LOGGER.warn("no username/ABO Key found");
            throw new ScrapeException(new HttpException(401, "Unauthorized"));
        }
        options.setLanguage(MediaLanguages.fr);
        LOGGER.info("========= BEGIN MPDB.tv Scraper Search for Movie: {} ", (Object)options.getSearchQuery());
        try {
            Response<List<SearchEntity>> response = this.controller.getSearchInformation(this.getEncodedUserName(), this.getSubscriptionKey(), options.getSearchQuery(), options.getLanguage().toLocale(), true, "json");
            if (!response.isSuccessful()) {
                String message = "";
                try {
                    message = response.errorBody().string();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                LOGGER.warn("request was not successful: HTTP/{} - {}", (Object)response.code(), (Object)message);
                throw new HttpException(response.code(), response.message());
            }
            if (response.isSuccessful()) {
                searchResult.addAll((Collection)response.body());
            }
        }
        catch (Exception e) {
            LOGGER.error("error searching: {} ", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (searchResult.isEmpty()) {
            LOGGER.warn("no result from MPDB.tv");
            return results;
        }
        for (SearchEntity entity : searchResult) {
            MediaSearchResult result = new MediaSearchResult(this.providerInfo.getId(), MediaType.MOVIE);
            result.setId(this.providerInfo.getId(), entity.id);
            result.setOriginalTitle(StringEscapeUtils.unescapeHtml4((String)entity.original_title));
            if (StringUtils.isEmpty((CharSequence)entity.title)) {
                result.setTitle(StringEscapeUtils.unescapeHtml4((String)entity.original_title));
            } else {
                result.setTitle(StringEscapeUtils.unescapeHtml4((String)entity.title));
            }
            result.setYear(entity.year);
            if (MediaIdUtil.isValidImdbId(entity.id_imdb)) {
                result.setId("imdb_id", entity.id_imdb);
            }
            result.setId("allocine_id", entity.id_allocine);
            result.setUrl(entity.url);
            result.setPosterUrl(entity.posterUrl);
            result.calculateScore(options);
            results.add(result);
        }
        return results;
    }

    @Override
    public MediaMetadata getMetadata(MovieSearchAndScrapeOptions mediaScrapeOptions) throws ScrapeException {
        Person mediaCastMember;
        LOGGER.debug("getMetadata(): {}", (Object)mediaScrapeOptions);
        this.initAPI();
        MediaMetadata metadata = new MediaMetadata(this.providerInfo.getId());
        metadata.setScrapeOptions(mediaScrapeOptions);
        MovieEntity scrapeResult = null;
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.getAboKey(), this.getUserName()})) {
            LOGGER.warn("no username/ABO Key found");
            throw new ScrapeException(new HttpException(401, "Unauthorized"));
        }
        mediaScrapeOptions.setLanguage(MediaLanguages.fr);
        int id = mediaScrapeOptions.getIdAsIntOrDefault(this.providerInfo.getId(), 0);
        if (id == 0) {
            LOGGER.debug("Cannot get artwork - no mpdb id set");
            throw new MissingIdException(new String[]{this.getId()});
        }
        LOGGER.info("========= BEGIN MPDB.tv scraping");
        try {
            Response<MovieEntity> response = this.controller.getScrapeInformation(this.getEncodedUserName(), this.getSubscriptionKey(), id, mediaScrapeOptions.getLanguage().toLocale(), null, "json");
            if (!response.isSuccessful()) {
                String message = "";
                try {
                    message = response.errorBody().string();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                LOGGER.warn("request was not successful: HTTP/{} - {}", (Object)response.code(), (Object)message);
                throw new HttpException(response.code(), response.message());
            }
            if (response.isSuccessful()) {
                scrapeResult = (MovieEntity)response.body();
            }
        }
        catch (Exception e) {
            LOGGER.error("error searching: {} ", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (scrapeResult == null) {
            LOGGER.warn("no result from MPDB.tv");
            return metadata;
        }
        if (scrapeResult.rating != null) {
            MediaRating rating = new MediaRating("mpdb.tv");
            rating.setRating(scrapeResult.rating.floatValue());
            rating.setVotes(scrapeResult.ratingVotes);
            rating.setMaxValue(10);
            metadata.addRating(rating);
        }
        ArrayList<MediaGenres> mediaGenres = new ArrayList<MediaGenres>();
        for (Genre genre : scrapeResult.genres) {
            mediaGenres.add(MediaGenres.getGenre(genre.name));
        }
        metadata.setGenres(mediaGenres);
        ArrayList<MediaTrailer> mediaTrailers = new ArrayList<MediaTrailer>();
        for (Trailer trailer : scrapeResult.trailers) {
            MediaTrailer mt = new MediaTrailer();
            mt.setName(scrapeResult.title);
            mt.setUrl(trailer.url);
            mt.setQuality(trailer.quality);
            mediaTrailers.add(mt);
        }
        metadata.setTrailers(mediaTrailers);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Studio studio : scrapeResult.studios) {
            arrayList.add(studio.name);
        }
        metadata.setProductionCompanies(arrayList);
        ArrayList<Person> arrayList2 = new ArrayList<Person>();
        for (Director director : scrapeResult.directors) {
            mediaCastMember = new Person(Person.Type.DIRECTOR);
            mediaCastMember.setId(this.providerInfo.getId(), director.id);
            mediaCastMember.setName(director.name);
            mediaCastMember.setRole(director.departement);
            mediaCastMember.setThumbUrl(director.thumb);
            mediaCastMember.setId(this.providerInfo.getId(), director.id);
            arrayList2.add(mediaCastMember);
        }
        for (Actor actor : scrapeResult.actors) {
            mediaCastMember = new Person(Person.Type.ACTOR);
            mediaCastMember.setId(this.providerInfo.getId(), actor.id);
            mediaCastMember.setName(actor.name);
            mediaCastMember.setRole(actor.role);
            mediaCastMember.setThumbUrl(actor.thumb);
            arrayList2.add(mediaCastMember);
        }
        for (Producer producer : scrapeResult.producers) {
            mediaCastMember = new Person(Person.Type.PRODUCER);
            mediaCastMember.setId(this.providerInfo.getId(), producer.id);
            mediaCastMember.setName(producer.name);
            mediaCastMember.setRole(producer.departement);
            mediaCastMember.setThumbUrl(producer.thumb);
            arrayList2.add(mediaCastMember);
        }
        metadata.setCastMembers(arrayList2);
        for (Release release : scrapeResult.releases) {
            if (!release.countryId.equals(mediaScrapeOptions.getLanguage().getLanguage().toUpperCase())) continue;
            metadata.setYear(release.year);
        }
        metadata.setId(this.getId(), scrapeResult.id);
        metadata.setId("allocine", scrapeResult.idAllocine);
        if (MediaIdUtil.isValidImdbId(scrapeResult.idImdb)) {
            metadata.setId("imdb", scrapeResult.idImdb);
        }
        metadata.setId("tmdb", scrapeResult.idTmdb);
        metadata.setTagline(scrapeResult.tagline);
        metadata.setReleaseDate(new Date(scrapeResult.firstRelease.intValue()));
        metadata.setTitle(scrapeResult.title);
        metadata.setOriginalTitle(scrapeResult.originalTitle);
        metadata.setRuntime(scrapeResult.runtime);
        metadata.setPlot(scrapeResult.plot);
        return metadata;
    }
}

