/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.ofdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.scraper.TrailerSearchAndScrapeOptions;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieTrailerProvider;
import org.tinymediamanager.scraper.ofdb.OfdbMetadataProvider;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.scraper.util.UrlUtil;

public class OfdbMovieTrailerProvider
extends OfdbMetadataProvider
implements IMovieTrailerProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(OfdbMovieTrailerProvider.class);

    @Override
    protected String getSubId() {
        return "movie_trailer";
    }

    @Override
    public List<MediaTrailer> getTrailers(TrailerSearchAndScrapeOptions options) throws ScrapeException {
        Document doc;
        LOGGER.debug("getTrailers(): {}", (Object)options);
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        ArrayList<MediaTrailer> trailers = new ArrayList<MediaTrailer>();
        String ofdbId = options.getIdAsString(this.getId());
        String imdbId = options.getImdbId();
        Object detailUrl = "";
        if (options.getSearchResult() != null) {
            detailUrl = options.getSearchResult().getUrl();
        }
        if (((String)detailUrl).isEmpty() && StringUtils.isNotBlank((CharSequence)ofdbId)) {
            try {
                detailUrl = this.getApiKey() + "/view.php?page=film&fid=" + ofdbId;
            }
            catch (Exception e) {
                throw new ScrapeException(e);
            }
        }
        if (((String)detailUrl).isEmpty() && MediaIdUtil.isValidImdbId(imdbId)) {
            try {
                doc = UrlUtil.parseDocumentFromUrl(this.getApiKey() + "/view.php?page=suchergebnis&Kat=IMDb&SText=" + options.getImdbId());
                Elements filme = doc.getElementsByAttributeValueMatching("href", "film\\/\\d+,");
                if (filme == null || filme.isEmpty()) {
                    LOGGER.debug("Did not find movie via ImdbId");
                    return Collections.emptyList();
                }
                detailUrl = this.getApiKey() + "/" + StrgUtils.substr(filme.first().toString(), "href=\\\"(.*?)\\\"");
            }
            catch (Exception e) {
                LOGGER.warn("failed IMDB search: {}", (Object)e.getMessage());
            }
        }
        if (((String)detailUrl).isEmpty()) {
            LOGGER.debug("Neither OFDB, nor IMDB id not found");
            throw new MissingIdException(new String[]{"imdb"});
        }
        try {
            doc = UrlUtil.parseDocumentFromUrl((String)detailUrl);
            Pattern regex = Pattern.compile("return '(.*?)';");
            Matcher m = regex.matcher(doc.toString());
            while (m.find()) {
                String s = m.group(1);
                String tname = StrgUtils.substr(s, "<b>(.*?)</b>");
                String tpix = StrgUtils.substr(s, "raquo; (.*?)x<br>");
                Pattern lr = Pattern.compile("<a href=\"(.*?)\">(.*?)</a>");
                Matcher lm = lr.matcher(s);
                while (lm.find()) {
                    String turl = lm.group(1);
                    MediaTrailer trailer = new MediaTrailer();
                    trailer.setName(tname);
                    trailer.setQuality(tpix);
                    trailer.setProvider("filmtrailer");
                    trailer.setScrapedBy(this.getProviderInfo().getId());
                    trailer.setUrl(turl);
                    LOGGER.debug(trailer.toString());
                    trailers.add(trailer);
                }
            }
            regex = Pattern.compile("<i>(.*?)</i>(.*?)<br>", 32);
            m = regex.matcher(doc.getElementsByClass("clips").html());
            while (m.find()) {
                String tname = m.group(1).trim();
                tname = tname.replaceFirst(":$", "");
                String urls = m.group(2);
                Pattern lr = Pattern.compile("<a href=\"(.*?)\">(.*?)</a>");
                Matcher lm = lr.matcher(urls);
                while (lm.find()) {
                    String tformat;
                    String turl = lm.group(1);
                    String tpix = "";
                    switch (tformat = lm.group(2).replaceAll("&nbsp;", "").trim()) {
                        case "small": {
                            tpix = "90p";
                            break;
                        }
                        case "medium": {
                            tpix = "136p";
                            break;
                        }
                        case "large": {
                            tpix = "180p";
                            break;
                        }
                        case "xlarge": {
                            tpix = "226p";
                            break;
                        }
                        case "xxlarge": {
                            tpix = "360p";
                            break;
                        }
                    }
                    MediaTrailer trailer = new MediaTrailer();
                    trailer.setName(tname);
                    trailer.setQuality(tpix);
                    trailer.setProvider("filmtrailer");
                    trailer.setUrl(turl);
                    trailer.setScrapedBy(this.getProviderInfo().getId());
                    LOGGER.debug(trailer.toString());
                    trailers.add(trailer);
                }
            }
            Elements yt = doc.getElementsByAttributeValueContaining("href", "youtu");
            for (Element el : yt) {
                if (!el.text().contains("Offizieller Trailer") && !el.text().contains("Deutscher Trailer")) continue;
                MediaTrailer trailer = new MediaTrailer();
                trailer.setName(el.text());
                trailer.setProvider("youtube");
                trailer.setUrl(el.attr("href"));
                trailer.setScrapedBy(this.getId());
                LOGGER.debug(trailer.toString());
                trailers.add(trailer);
            }
        }
        catch (Exception e) {
            throw new ScrapeException(e);
        }
        return trailers;
    }
}

