/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.omdb;

import java.io.InterruptedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieImdbMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IRatingProvider;
import org.tinymediamanager.scraper.omdb.OmdbMetadataProvider;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.UrlUtil;

public class OmdbMovieMetadataProvider
extends OmdbMetadataProvider
implements IMovieMetadataProvider,
IMovieImdbMetadataProvider,
IRatingProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(OmdbMovieMetadataProvider.class);

    @Override
    protected String getSubId() {
        return "movie";
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public MediaMetadata getMetadata(MovieSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getMetadata(): '{}'", (Object)options);
        if (options.getSearchResult() != null && options.getSearchResult().getMediaMetadata() != null && this.getId().equals(options.getSearchResult().getMediaMetadata().getProviderId())) {
            return options.getSearchResult().getMediaMetadata();
        }
        String imdbId = this.getImdbId(options);
        if (!MediaIdUtil.isValidImdbId(imdbId)) {
            LOGGER.warn("no imdb id found");
            throw new MissingIdException(new String[]{"imdb"});
        }
        Document doc = null;
        try {
            doc = UrlUtil.parseDocumentFromUrl("https://www.omdbapi.com/?apikey=" + this.getApiKey() + "&i=" + imdbId + "&type=movie&plot=full&tomatoes=true&r=xml");
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.error("error searching: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (doc == null || doc.childrenSize() == 0) {
            LOGGER.warn("no result found");
            throw new NothingFoundException();
        }
        MediaMetadata metadata = this.parseDetail(doc, "movie");
        if (metadata == null) {
            LOGGER.warn("no result found");
            throw new NothingFoundException();
        }
        metadata.setScrapeOptions(options);
        return metadata;
    }

    @Override
    public SortedSet<MediaSearchResult> search(MovieSearchAndScrapeOptions query) throws ScrapeException {
        LOGGER.debug("search(): '{}'", (Object)query);
        TreeSet<MediaSearchResult> mediaResult = new TreeSet<MediaSearchResult>();
        if (MediaIdUtil.isValidImdbId(query.getImdbId())) {
            try {
                MediaMetadata md = this.getMetadata(query);
                MediaSearchResult result = new MediaSearchResult(this.getId(), MediaType.MOVIE);
                result.setMetadata(md);
                result.setTitle(md.getTitle());
                result.setIMDBId(query.getImdbId());
                result.setYear(md.getYear());
                for (MediaArtwork artwork : md.getMediaArt(MediaArtwork.MediaArtworkType.POSTER)) {
                    result.setPosterUrl(artwork.getPreviewUrl());
                }
                result.setScore(1.0f);
                mediaResult.add(result);
                return mediaResult;
            }
            catch (Exception e) {
                LOGGER.debug("could not fetch data with imdb id - '{}'", (Object)e.getMessage());
            }
        }
        Document doc = null;
        try {
            doc = UrlUtil.parseDocumentFromUrl("https://www.omdbapi.com/?apikey=" + this.getApiKey() + "&s=" + UrlUtil.encode(query.getSearchQuery()) + "&type=movie&page=1&r=xml");
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.error("error searching: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (doc == null || doc.childrenSize() == 0) {
            LOGGER.warn("no result found");
            throw new NothingFoundException();
        }
        List<MediaSearchResult> searchResults = this.parseSearchResults(doc, MediaType.MOVIE);
        if (searchResults.isEmpty()) {
            try {
                MediaMetadata md;
                doc = UrlUtil.parseDocumentFromUrl("https://www.omdbapi.com/?apikey=" + this.getApiKey() + "&t=" + UrlUtil.encode(query.getSearchQuery()) + "&type=movie&r=xml");
                if (doc != null && doc.childrenSize() != 0 && (md = this.parseDetail(doc, "movie")) != null) {
                    md.setScrapeOptions(query);
                    MediaSearchResult searchResult = new MediaSearchResult(this.getId(), MediaType.MOVIE);
                    searchResult.mergeFrom(md);
                    searchResults = Collections.singletonList(searchResult);
                }
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.error("error searching: {}", (Object)e.getMessage());
                throw new ScrapeException(e);
            }
        }
        for (MediaSearchResult searchResult : searchResults) {
            searchResult.calculateScore(query);
            mediaResult.add(searchResult);
        }
        return mediaResult;
    }

    @Override
    public List<MediaRating> getRatings(Map<String, Object> ids, MediaType mediaType) throws ScrapeException {
        if (mediaType != MediaType.MOVIE) {
            return Collections.emptyList();
        }
        LOGGER.debug("getRatings(): {}", ids);
        MovieSearchAndScrapeOptions options = new MovieSearchAndScrapeOptions();
        options.setIds(ids);
        try {
            return this.getMetadata(options).getRatings();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }
}

