/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.rating;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.interfaces.IRatingProvider;
import org.tinymediamanager.scraper.rating.ImdbRating;
import org.tinymediamanager.scraper.rating.WikidataRating;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;

public class RatingProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(RatingProvider.class);

    private RatingProvider() {
        throw new IllegalAccessError();
    }

    public static MediaRating getImdbRating(String imdbId) {
        List<MediaRating> ratings = RatingProvider.getRatings(Collections.singletonMap("imdb", imdbId), Collections.singletonList(RatingSource.IMDB), null);
        if (!ratings.isEmpty()) {
            return ratings.get(0);
        }
        return null;
    }

    public static List<MediaRating> getRatings(Map<String, Object> ids, MediaType mediaType) {
        return RatingProvider.getRatings(ids, Arrays.asList(RatingSource.values()), mediaType);
    }

    public static List<MediaRating> getRatings(Map<String, Object> ids, List<RatingSource> sources, MediaType mediaType) {
        MediaRating rating;
        ArrayList<MediaRating> ratings = new ArrayList<MediaRating>();
        ArrayList<RatingSource> missingRatings = new ArrayList<RatingSource>(sources);
        String imdbId = MediaIdUtil.getIdAsString(ids, "imdb");
        if (!MediaIdUtil.isValidImdbId(imdbId)) {
            MediaIdUtil.injectMissingIds(ids, mediaType);
        }
        if (missingRatings.contains((Object)RatingSource.IMDB) && MediaIdUtil.isValidImdbId(imdbId) && (rating = new ImdbRating().getImdbRating(imdbId)) != null) {
            ratings.add(rating);
            missingRatings.remove((Object)RatingSource.IMDB);
        }
        if (missingRatings.contains((Object)RatingSource.METACRITIC)) {
            RatingProvider.callScraper("imdb", mediaType, missingRatings, ids, ratings);
        }
        if (ListUtils.containsAny(missingRatings, RatingSource.ROTTEN_TOMATOES_AVG_RATING, RatingSource.ROTTEN_TOMATOES_AVG_RATING) && MediaIdUtil.isValidImdbId(imdbId)) {
            RatingProvider.callScraper("omdbapi", mediaType, missingRatings, ids, ratings);
        }
        if (ListUtils.containsAny(missingRatings, RatingSource.METACRITIC, RatingSource.ROTTEN_TOMATOES_AVG_RATING, RatingSource.ROTTEN_TOMATOES_AVG_RATING) && MediaIdUtil.isValidImdbId(imdbId)) {
            List<MediaRating> ratingsFromWikidata = new WikidataRating().getRatings(imdbId);
            for (MediaRating rating2 : ratingsFromWikidata) {
                RatingSource source = RatingProvider.parseRatingSource(rating2.getId());
                if (!missingRatings.contains((Object)source) || ratings.contains(rating2)) continue;
                ratings.add(rating2);
                missingRatings.remove((Object)source);
            }
        }
        if (missingRatings.contains((Object)RatingSource.TMDB)) {
            RatingProvider.callScraper("tmdb", mediaType, missingRatings, ids, ratings);
        }
        if (missingRatings.contains((Object)RatingSource.TRAKT_TV)) {
            RatingProvider.callScraper("trakt", mediaType, missingRatings, ids, ratings);
        }
        return ratings;
    }

    private static void callScraper(String scraperId, MediaType mediaType, List<RatingSource> sources, Map<String, Object> ids, List<MediaRating> ratings) {
        MediaScraper scraper = MediaScraper.getMediaScraperById(scraperId, MediaType.getScraperTypeForMediaType(mediaType));
        if (scraper != null && scraper.isEnabled() && scraper.getMediaProvider() instanceof IRatingProvider) {
            try {
                List<MediaRating> ratingsFromScraper = ((IRatingProvider)((Object)scraper.getMediaProvider())).getRatings(ids, mediaType);
                for (MediaRating rating : ratingsFromScraper) {
                    RatingSource source = RatingProvider.parseRatingSource(rating.getId());
                    if (!sources.contains((Object)source) || ratings.contains(rating)) continue;
                    ratings.add(rating);
                    sources.remove((Object)source);
                }
            }
            catch (Exception e) {
                LOGGER.debug("could not get {} ratings - '{}'", (Object)scraperId, (Object)e.getMessage());
            }
        }
    }

    public static synchronized void shutdown() {
        ImdbRating.shutdown();
    }

    private static RatingSource parseRatingSource(String id) {
        switch (id) {
            case "metacritic": {
                return RatingSource.METACRITIC;
            }
            case "imdb": {
                return RatingSource.IMDB;
            }
            case "tmdb": {
                return RatingSource.TMDB;
            }
            case "tomatometerallcritics": {
                return RatingSource.ROTTEN_TOMATOES_TOMATOMETER;
            }
            case "tomatometeravgcritics": {
                return RatingSource.ROTTEN_TOMATOES_AVG_RATING;
            }
            case "trakt": {
                return RatingSource.TRAKT_TV;
            }
        }
        return null;
    }

    public static enum RatingSource {
        IMDB("IMDb"),
        TMDB("TMDB"),
        METACRITIC("Metacritic"),
        ROTTEN_TOMATOES_TOMATOMETER("Rotten Tomatoes - Tomatometer"),
        ROTTEN_TOMATOES_AVG_RATING("Rotten Tomatoes - Audience Score"),
        TRAKT_TV("Trakt.tv");

        private final String title;

        private RatingSource(String title) {
            this.title = title;
        }

        public String toString() {
            return this.title;
        }

        public static List<RatingSource> getRatingSourcesForMovies() {
            return Arrays.asList(RatingSource.values());
        }

        public static List<RatingSource> getRatingSourcesForTvShows() {
            ArrayList<RatingSource> ratingSources = new ArrayList<RatingSource>();
            for (RatingSource ratingSource : RatingSource.values()) {
                if (ratingSource == METACRITIC || ratingSource == ROTTEN_TOMATOES_AVG_RATING || ratingSource == ROTTEN_TOMATOES_TOMATOMETER) continue;
                ratingSources.add(ratingSource);
            }
            return ratingSources;
        }
    }
}

