/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.thetvdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.thetvdb.TheTvDbController;
import org.tinymediamanager.scraper.thetvdb.entities.ArtworkBaseRecord;
import org.tinymediamanager.scraper.thetvdb.entities.ArtworkTypeRecord;
import org.tinymediamanager.scraper.thetvdb.entities.ArtworkTypeResponse;
import org.tinymediamanager.scraper.thetvdb.entities.Character;
import org.tinymediamanager.scraper.thetvdb.entities.SearchResultResponse;
import org.tinymediamanager.scraper.util.LanguageUtils;
import retrofit2.Response;

abstract class TheTvDbMetadataProvider
implements IMediaProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TheTvDbMetadataProvider.class);
    private static final String ID = "tvdb";
    protected static final String FALLBACK_LANGUAGE = "fallbackLanguage";
    protected static final Pattern ID_PATTERN = Pattern.compile("\\d{3,}");
    private final MediaProviderInfo providerInfo;
    private final Map<Integer, ArtworkTypeRecord> artworkTypes = new HashMap<Integer, ArtworkTypeRecord>();
    protected TheTvDbController tvdb;

    TheTvDbMetadataProvider() {
        this.providerInfo = this.createMediaProviderInfo();
    }

    protected abstract Logger getLogger();

    protected abstract String getSubId();

    protected MediaProviderInfo createMediaProviderInfo() {
        return new MediaProviderInfo(ID, this.getSubId(), "thetvdb.com", "<html><h3>The TVDB</h3><br />An open database for television fans. This scraper is able to scrape TV series metadata and artwork</html>", TheTvDbMetadataProvider.class.getResource("/org/tinymediamanager/scraper/thetvdb_com.svg"), 30);
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    @Override
    public boolean isActive() {
        return this.isFeatureEnabled() && this.isApiKeyAvailable(this.providerInfo.getConfig().getValue("apiKey"));
    }

    String getAuthToken() {
        String userApiKey = this.providerInfo.getConfig().getValue("apiKey");
        String userPin = this.providerInfo.getConfig().getValue("pin");
        if (StringUtils.isNotBlank((CharSequence)userApiKey)) {
            this.tvdb.setUserApiKey(userApiKey);
            this.tvdb.setUserPin(userPin);
            try {
                return TheTvDbController.login(userApiKey, userPin);
            }
            catch (Exception e) {
                LOGGER.warn("could not logon with the user entered key - '{}'", (Object)e.getMessage());
            }
        }
        return this.getApiKey();
    }

    protected synchronized void initAPI() throws ScrapeException {
        if (this.tvdb != null) {
            String userApiKey = this.providerInfo.getConfig().getValue("apiKey");
            String userPin = this.providerInfo.getConfig().getValue("pin");
            if (!(!StringUtils.isNotBlank((CharSequence)userApiKey) || userApiKey.equals(this.tvdb.getUserApiKey()) && userPin.equals(this.tvdb.getUserPin()))) {
                this.tvdb = null;
            } else if (StringUtils.isBlank((CharSequence)userApiKey) && StringUtils.isNotBlank((CharSequence)this.tvdb.getUserApiKey())) {
                this.tvdb = null;
            }
        }
        if (this.tvdb == null) {
            if (!this.isActive()) {
                throw new ScrapeException(new FeatureNotEnabledException(this));
            }
            try {
                this.tvdb = new TheTvDbController();
                this.tvdb.setAuthToken(this.getAuthToken());
                this.artworkTypes.clear();
                for (ArtworkTypeRecord artworkTypeRecord : Objects.requireNonNull((ArtworkTypeResponse)this.tvdb.getConfigService().getArtworkTypes().execute().body()).data) {
                    if (artworkTypeRecord.width <= 0 || artworkTypeRecord.height <= 0) continue;
                    this.artworkTypes.put(artworkTypeRecord.id, artworkTypeRecord);
                }
            }
            catch (Exception e) {
                this.getLogger().warn("could not initialize API: {}", (Object)e.getMessage());
                this.tvdb = null;
                throw new ScrapeException(e);
            }
        }
    }

    protected String clearYearFromTitle(String title, int year) {
        return title.replaceAll("\\(" + year + "\\)$", "").trim();
    }

    protected ArtworkTypeRecord getArtworkType(Integer id) {
        if (id == null) {
            return null;
        }
        return this.artworkTypes.get(id);
    }

    protected String parseLocalizedText(MediaLanguages desiredLanguage, Map<String, String> localizedTexts) {
        String text;
        if (localizedTexts == null) {
            return "";
        }
        String iso3LanguageTag = LanguageUtils.getIso3Language(desiredLanguage.toLocale());
        if ("pob".equals(iso3LanguageTag)) {
            iso3LanguageTag = "pt";
        }
        if (StringUtils.isNotBlank((CharSequence)(text = localizedTexts.get(iso3LanguageTag)))) {
            return text;
        }
        return "";
    }

    protected List<Person> parseCastMembers(List<Character> characters) {
        if (characters == null) {
            return Collections.emptyList();
        }
        characters.sort(Comparator.comparingInt(o -> o.sort));
        ArrayList<Person> members = new ArrayList<Person>();
        block6: for (Character character : characters) {
            Person member;
            switch (character.type) {
                case 1: {
                    member = new Person(Person.Type.DIRECTOR);
                    break;
                }
                case 2: {
                    member = new Person(Person.Type.WRITER);
                    break;
                }
                case 3: 
                case 4: {
                    member = new Person(Person.Type.ACTOR);
                    member.setRole(character.name);
                    break;
                }
                case 7: {
                    member = new Person(Person.Type.PRODUCER);
                    break;
                }
                default: {
                    continue block6;
                }
            }
            member.setId(this.getId(), character.peopleId);
            member.setName(character.personName);
            if (StringUtils.isNotBlank((CharSequence)character.image)) {
                member.setThumbUrl(character.image);
            }
            if (StringUtils.isNotBlank((CharSequence)character.url)) {
                member.setProfileUrl(character.url);
            }
            members.add(member);
        }
        return members;
    }

    protected MediaArtwork parseArtwork(ArtworkBaseRecord image) {
        if (image.id == null) {
            return null;
        }
        MediaArtwork ma = null;
        switch (image.type) {
            case 1: 
            case 16: {
                ma = new MediaArtwork(this.getProviderInfo().getId(), MediaArtwork.MediaArtworkType.BANNER);
                break;
            }
            case 2: 
            case 14: {
                ma = new MediaArtwork(this.getProviderInfo().getId(), MediaArtwork.MediaArtworkType.POSTER);
                break;
            }
            case 3: 
            case 15: {
                ma = new MediaArtwork(this.getProviderInfo().getId(), MediaArtwork.MediaArtworkType.BACKGROUND);
                break;
            }
            case 6: {
                ma = new MediaArtwork(this.getProviderInfo().getId(), MediaArtwork.MediaArtworkType.SEASON_BANNER);
                break;
            }
            case 7: {
                ma = new MediaArtwork(this.getProviderInfo().getId(), MediaArtwork.MediaArtworkType.SEASON_POSTER);
                break;
            }
            case 8: {
                ma = new MediaArtwork(this.getProviderInfo().getId(), MediaArtwork.MediaArtworkType.SEASON_THUMB);
                break;
            }
            case 11: 
            case 12: {
                ma = new MediaArtwork(this.getProviderInfo().getId(), MediaArtwork.MediaArtworkType.THUMB);
                break;
            }
            default: {
                return null;
            }
        }
        ArtworkTypeRecord artworkType = this.getArtworkType(image.type);
        if (artworkType != null) {
            int width = artworkType.width;
            int height = artworkType.height;
            ma.addImageSize(width, height, image.image);
            switch (ma.getType()) {
                case POSTER: {
                    if (width >= 1000) {
                        ma.setSizeOrder(MediaArtwork.PosterSizes.LARGE.getOrder());
                        break;
                    }
                    if (width >= 500) {
                        ma.setSizeOrder(MediaArtwork.PosterSizes.BIG.getOrder());
                        break;
                    }
                    if (width >= 342) {
                        ma.setSizeOrder(MediaArtwork.PosterSizes.MEDIUM.getOrder());
                        break;
                    }
                    ma.setSizeOrder(MediaArtwork.PosterSizes.SMALL.getOrder());
                    break;
                }
                case BACKGROUND: {
                    if (width >= 3840) {
                        ma.setSizeOrder(MediaArtwork.FanartSizes.XLARGE.getOrder());
                    }
                    if (width >= 1920) {
                        ma.setSizeOrder(MediaArtwork.FanartSizes.LARGE.getOrder());
                        break;
                    }
                    if (width >= 1280) {
                        ma.setSizeOrder(MediaArtwork.FanartSizes.MEDIUM.getOrder());
                        break;
                    }
                    ma.setSizeOrder(MediaArtwork.FanartSizes.SMALL.getOrder());
                    break;
                }
            }
        }
        if (ma.getType() == MediaArtwork.MediaArtworkType.SEASON_BANNER || ma.getType() == MediaArtwork.MediaArtworkType.SEASON_POSTER) {
            ma.setSizeOrder(MediaArtwork.FanartSizes.LARGE.getOrder());
        } else if (ma.getType() == MediaArtwork.MediaArtworkType.BANNER) {
            ma.setSizeOrder(MediaArtwork.FanartSizes.MEDIUM.getOrder());
        }
        ma.setDefaultUrl(image.image);
        ma.setOriginalUrl(image.image);
        if (StringUtils.isNotBlank((CharSequence)image.thumbnail)) {
            ma.setPreviewUrl(image.thumbnail);
        } else {
            ma.setPreviewUrl(ma.getDefaultUrl());
        }
        if (StringUtils.isBlank((CharSequence)image.language)) {
            ma.setLanguage("-");
        } else {
            ma.setLanguage(LanguageUtils.getIso2LanguageFromLocalizedString(image.language));
        }
        if ((ma.getType() == MediaArtwork.MediaArtworkType.SEASON_BANNER || ma.getType() == MediaArtwork.MediaArtworkType.SEASON_POSTER || ma.getType() == MediaArtwork.MediaArtworkType.SEASON_THUMB) && image.season != null) {
            ma.setSeason(image.season);
        }
        return ma;
    }

    protected MediaSearchResult morphMediaMetadataToSearchResult(MediaMetadata md, MediaType type) {
        MediaSearchResult searchResult = new MediaSearchResult(this.getId(), type);
        searchResult.setTitle(md.getTitle());
        searchResult.setYear(md.getYear());
        searchResult.setIds(md.getIds());
        searchResult.setMetadata(md);
        for (MediaArtwork artwork : md.getMediaArt()) {
            if (artwork.getType() != MediaArtwork.MediaArtworkType.POSTER) continue;
            searchResult.setPosterUrl(artwork.getDefaultUrl());
            break;
        }
        searchResult.setScore(1.0f);
        return searchResult;
    }

    protected int getTvdbIdViaImdbId(String imdbId) {
        try {
            Response httpResponse = this.tvdb.getSearchService().getSearch(imdbId, imdbId).execute();
            if (httpResponse.isSuccessful() && httpResponse.body() != null) {
                return Integer.parseInt(((SearchResultResponse)httpResponse.body()).data.get((int)0).tvdbId);
            }
        }
        catch (Exception e) {
            this.getLogger().debug("could not fetch TVDB via IMDB - '{}'", (Object)e.getMessage());
        }
        return 0;
    }
}

