/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.thetvdb;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaAiredStatus;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMediaIdProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowTvdbMetadataProvider;
import org.tinymediamanager.scraper.thetvdb.TheTvDbMetadataProvider;
import org.tinymediamanager.scraper.thetvdb.entities.ArtworkBaseRecord;
import org.tinymediamanager.scraper.thetvdb.entities.ArtworkTypeRecord;
import org.tinymediamanager.scraper.thetvdb.entities.CompanyBaseRecord;
import org.tinymediamanager.scraper.thetvdb.entities.ContentRating;
import org.tinymediamanager.scraper.thetvdb.entities.EpisodeBaseRecord;
import org.tinymediamanager.scraper.thetvdb.entities.EpisodeExtendedRecord;
import org.tinymediamanager.scraper.thetvdb.entities.EpisodeExtendedResponse;
import org.tinymediamanager.scraper.thetvdb.entities.GenreBaseRecord;
import org.tinymediamanager.scraper.thetvdb.entities.RemoteID;
import org.tinymediamanager.scraper.thetvdb.entities.SearchResultRecord;
import org.tinymediamanager.scraper.thetvdb.entities.SearchResultResponse;
import org.tinymediamanager.scraper.thetvdb.entities.SearchType;
import org.tinymediamanager.scraper.thetvdb.entities.SeasonType;
import org.tinymediamanager.scraper.thetvdb.entities.SeriesEpisodesRecord;
import org.tinymediamanager.scraper.thetvdb.entities.SeriesEpisodesResponse;
import org.tinymediamanager.scraper.thetvdb.entities.SeriesExtendedRecord;
import org.tinymediamanager.scraper.thetvdb.entities.SeriesExtendedResponse;
import org.tinymediamanager.scraper.thetvdb.entities.Translation;
import org.tinymediamanager.scraper.thetvdb.entities.TranslationResponse;
import org.tinymediamanager.scraper.util.CacheMap;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.StrgUtils;
import retrofit2.Response;

public class TheTvDbTvShowMetadataProvider
extends TheTvDbMetadataProvider
implements ITvShowMetadataProvider,
ITvShowTvdbMetadataProvider,
IMediaIdProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TheTvDbTvShowMetadataProvider.class);
    private static final CacheMap<String, List<MediaMetadata>> EPISODE_LIST_CACHE_MAP = new CacheMap(600L, 5L);
    private static final CacheMap<String, MediaMetadata> EPISODE_CACHE_MAP = new CacheMap(600L, 5L);

    @Override
    protected MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo info = super.createMediaProviderInfo();
        info.getConfig().addText("apiKey", "", true);
        info.getConfig().addText("pin", "", true);
        ArrayList<String> fallbackLanguages = new ArrayList<String>();
        for (MediaLanguages mediaLanguages : MediaLanguages.values()) {
            fallbackLanguages.add(mediaLanguages.toString());
        }
        info.getConfig().addSelect("fallbackLanguage", fallbackLanguages.toArray(new String[0]), MediaLanguages.en.toString());
        info.getConfig().load();
        return info;
    }

    @Override
    protected String getSubId() {
        return "tvshow";
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public MediaMetadata getMetadata(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        SeriesExtendedRecord show;
        this.initAPI();
        LOGGER.debug("getMetadata(): {}", (Object)options);
        MediaMetadata md = new MediaMetadata(this.getId());
        md.setScrapeOptions(options);
        int id = options.getIdAsInt(this.getId());
        if (id == 0 && MediaIdUtil.isValidImdbId(options.getImdbId())) {
            id = this.getTvdbIdViaImdbId(options.getImdbId());
        }
        if (id == 0) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{this.getId()});
        }
        Translation baseTranslation = null;
        Translation fallbackTranslation = null;
        try {
            Response translationResponse;
            Object httpResponse;
            String baseLanguage = LanguageUtils.getIso3Language(options.getLanguage().toLocale());
            String fallbackLanguage = LanguageUtils.getIso3Language(MediaLanguages.get(this.getProviderInfo().getConfig().getValue("fallbackLanguage")).toLocale());
            if ("pob".equals(baseLanguage)) {
                baseLanguage = "pt";
            }
            if ("pob".equals(fallbackLanguage)) {
                fallbackLanguage = "pt";
            }
            if (!(httpResponse = this.tvdb.getSeriesService().getSeriesExtended(id).execute()).isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            show = ((SeriesExtendedResponse)httpResponse.body()).data;
            if ((show.nameTranslations.contains(baseLanguage) || show.overviewTranslations.contains(baseLanguage)) && (translationResponse = this.tvdb.getSeriesService().getSeriesTranslation(id, baseLanguage).execute()).isSuccessful()) {
                baseTranslation = ((TranslationResponse)translationResponse.body()).data;
            }
            if ((baseTranslation == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{baseTranslation.name, baseTranslation.overview})) && (show.nameTranslations.contains(fallbackLanguage) || show.overviewTranslations.contains(fallbackLanguage)) && (translationResponse = this.tvdb.getSeriesService().getSeriesTranslation(id, fallbackLanguage).execute()).isSuccessful()) {
                fallbackTranslation = ((TranslationResponse)translationResponse.body()).data;
            }
        }
        catch (Exception e) {
            LOGGER.error("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (show == null) {
            throw new NothingFoundException();
        }
        md.setId(this.getId(), show.id);
        if (baseTranslation != null && StringUtils.isNotBlank((CharSequence)baseTranslation.name)) {
            md.setTitle(baseTranslation.name);
        } else if (fallbackTranslation != null && StringUtils.isNotBlank((CharSequence)fallbackTranslation.overview)) {
            md.setTitle(fallbackTranslation.name);
        } else {
            md.setTitle(show.name);
        }
        md.setOriginalTitle(show.name);
        if (baseTranslation != null && StringUtils.isNotBlank((CharSequence)baseTranslation.overview)) {
            md.setPlot(baseTranslation.overview);
        } else if (fallbackTranslation != null && StringUtils.isNotBlank((CharSequence)fallbackTranslation.overview)) {
            md.setPlot(fallbackTranslation.overview);
        }
        for (RemoteID remoteID : ListUtils.nullSafe(show.remoteIds)) {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{remoteID.sourceName, remoteID.id})) continue;
            switch (remoteID.sourceName) {
                case "IMDB": {
                    if (!MediaIdUtil.isValidImdbId(remoteID.id)) break;
                    md.setId("imdb", remoteID.id);
                    break;
                }
                case "Zap2It": {
                    md.setId("zap2it", remoteID.id);
                    break;
                }
                case "TheMovieDB.com": {
                    md.setId("tmdb", MetadataUtil.parseInt(remoteID.id, 0));
                }
            }
        }
        try {
            md.setReleaseDate(StrgUtils.parseDate(show.firstAired));
        }
        catch (ParseException e) {
            LOGGER.debug("could not parse date: {}", (Object)e.getMessage());
        }
        try {
            Date date = StrgUtils.parseDate(show.firstAired);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int y = calendar.get(1);
            md.setYear(y);
            if (y != 0 && md.getTitle().contains(String.valueOf(y))) {
                LOGGER.debug("Weird TVDB entry - removing date {} from title", (Object)y);
                md.setTitle(this.clearYearFromTitle(md.getTitle(), y));
            }
        }
        catch (Exception e) {
            LOGGER.debug("could not parse date: {}", (Object)e.getMessage());
        }
        if (show.status != null && show.status.id != null) {
            switch (show.status.id) {
                case 1: {
                    md.setStatus(MediaAiredStatus.CONTINUING);
                    break;
                }
                case 2: {
                    md.setStatus(MediaAiredStatus.ENDED);
                    break;
                }
            }
        }
        md.setRuntime(MetadataUtil.unboxInteger(show.averageRuntime, 0));
        if (show.originalNetwork != null) {
            md.addProductionCompany(show.originalNetwork.name);
        }
        if (show.latestNetwork != null) {
            md.addProductionCompany(show.latestNetwork.name);
        }
        for (CompanyBaseRecord company : ListUtils.nullSafe(show.companies)) {
            md.addProductionCompany(company.name);
        }
        if (show.characters != null) {
            for (Person member : this.parseCastMembers(show.characters.stream().filter(character -> character.episodeId == null).collect(Collectors.toList()))) {
                md.addCastMember(member);
            }
        }
        for (GenreBaseRecord genreBaseRecord : ListUtils.nullSafe(show.genres)) {
            md.addGenre(MediaGenres.getGenre(genreBaseRecord.name));
        }
        for (ContentRating contentRating : ListUtils.nullSafe(show.contentRatings)) {
            MediaCertification mediaCertification;
            if (!options.getCertificationCountry().getAlpha3().equalsIgnoreCase(contentRating.country) || (mediaCertification = MediaCertification.findCertification(contentRating.name)) == MediaCertification.UNKNOWN) continue;
            md.addCertification(mediaCertification);
        }
        for (ArtworkBaseRecord artworkBaseRecord : ListUtils.nullSafe(show.artworks)) {
            MediaArtwork mediaArtwork = this.parseArtwork(artworkBaseRecord);
            if (mediaArtwork == null) continue;
            md.addMediaArt(mediaArtwork);
        }
        return md;
    }

    @Override
    public MediaMetadata getMetadata(TvShowEpisodeSearchAndScrapeOptions options) throws ScrapeException {
        EpisodeExtendedRecord episode;
        this.initAPI();
        LOGGER.debug("getMetadata(): {}", (Object)options);
        boolean useDvdOrder = false;
        int showId = options.createTvShowSearchAndScrapeOptions().getIdAsIntOrDefault(this.getId(), 0);
        if (showId == 0) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{this.getId()});
        }
        int episodeTvdbId = options.getIdAsIntOrDefault("tvdb", 0);
        int seasonNr = options.getIdAsIntOrDefault("seasonNr", -1);
        int episodeNr = options.getIdAsIntOrDefault("episodeNr", -1);
        if (seasonNr == -1 || episodeNr == -1) {
            seasonNr = options.getIdAsIntOrDefault("dvdSeasonNr", -1);
            episodeNr = options.getIdAsIntOrDefault("dvdEpisodeNr", -1);
            if (seasonNr != -1 && episodeNr != -1) {
                useDvdOrder = true;
            }
        }
        Date releaseDate = null;
        if (options.getMetadata() != null && options.getMetadata().getReleaseDate() != null) {
            releaseDate = options.getMetadata().getReleaseDate();
        }
        if (releaseDate == null && (seasonNr == -1 || episodeNr == -1) && episodeTvdbId == 0) {
            LOGGER.warn("no aired date/season number/episode number found");
            throw new MissingIdException("episodeNr", "seasonNr");
        }
        List<MediaMetadata> episodes = this.getEpisodeList(options.createTvShowSearchAndScrapeOptions());
        MediaMetadata foundEpisode = null;
        if (episodeTvdbId > 0) {
            for (MediaMetadata episode2 : episodes) {
                if (episodeTvdbId != episode2.getIdAsIntOrDefault("tvdb", 0)) continue;
                foundEpisode = episode2;
                break;
            }
        }
        if (foundEpisode == null) {
            for (MediaMetadata episode2 : episodes) {
                if (useDvdOrder && episode2.getDvdSeasonNumber() == seasonNr && episode2.getDvdEpisodeNumber() == episodeNr) {
                    foundEpisode = episode2;
                    break;
                }
                if (useDvdOrder || episode2.getSeasonNumber() != seasonNr || episode2.getEpisodeNumber() != episodeNr) continue;
                foundEpisode = episode2;
                break;
            }
        }
        if (foundEpisode == null && releaseDate != null) {
            for (MediaMetadata episode2 : episodes) {
                if (episode2.getReleaseDate() != releaseDate) continue;
                foundEpisode = episode2;
                break;
            }
        }
        if (foundEpisode == null) {
            throw new NothingFoundException();
        }
        try {
            MediaMetadata cachedEpisode = EPISODE_CACHE_MAP.get(foundEpisode.getId(this.getId()) + "_" + options.getLanguage().getLanguage());
            if (cachedEpisode != null) {
                return cachedEpisode;
            }
        }
        catch (Exception cachedEpisode) {
            // empty catch block
        }
        try {
            int id = (Integer)foundEpisode.getId(this.getId());
            Response httpResponse = this.tvdb.getEpisodesService().getEpisodeExtended(id).execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            episode = ((EpisodeExtendedResponse)httpResponse.body()).data;
        }
        catch (Exception e) {
            LOGGER.error("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        MediaMetadata md = new MediaMetadata(this.getId());
        md.setScrapeOptions(options);
        md.setId(this.getId(), episode.id);
        md.setSeasonNumber(episode.seasonNumber);
        md.setEpisodeNumber(episode.episodeNumber);
        md.setDvdSeasonNumber(foundEpisode.getDvdSeasonNumber());
        md.setDvdEpisodeNumber(foundEpisode.getDvdEpisodeNumber());
        md.setAbsoluteNumber(foundEpisode.getAbsoluteNumber());
        if (MetadataUtil.unboxInteger(episode.airsBeforeSeason, -1) > -1) {
            md.setDisplaySeasonNumber(MetadataUtil.unboxInteger(episode.airsBeforeSeason));
        }
        if (MetadataUtil.unboxInteger(episode.airsBeforeEpisode, -1) > -1) {
            md.setDisplayEpisodeNumber(MetadataUtil.unboxInteger(episode.airsBeforeEpisode));
        }
        if (MetadataUtil.unboxInteger(episode.airsAfterSeason, -1) > -1) {
            md.setDisplaySeasonNumber(MetadataUtil.unboxInteger(episode.airsAfterSeason));
            md.setDisplayEpisodeNumber(4096);
        }
        md.setTitle(foundEpisode.getTitle());
        md.setOriginalTitle(foundEpisode.getOriginalTitle());
        md.setPlot(foundEpisode.getPlot());
        if (episode.runtime != null) {
            md.setRuntime((int)episode.runtime);
        }
        for (RemoteID remoteID : ListUtils.nullSafe(episode.remoteIDs)) {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{remoteID.sourceName, remoteID.id})) continue;
            switch (remoteID.sourceName) {
                case "IMDB": {
                    if (!MediaIdUtil.isValidImdbId(remoteID.id)) break;
                    md.setId("imdb", remoteID.id);
                    break;
                }
                case "Zap2It": {
                    md.setId("zap2it", remoteID.id);
                    break;
                }
                case "TheMovieDB.com": {
                    md.setId("tmdb", MetadataUtil.parseInt(remoteID.id, 0));
                    break;
                }
            }
        }
        try {
            md.setReleaseDate(StrgUtils.parseDate(episode.aired));
        }
        catch (Exception e) {
            LOGGER.debug("could not parse date: {}", (Object)e.getMessage());
        }
        for (Person member : this.parseCastMembers(episode.characters)) {
            md.addCastMember(member);
        }
        for (ContentRating contentRating : ListUtils.nullSafe(episode.contentRatings)) {
            MediaCertification mediaCertification = MediaCertification.findCertification(contentRating.name);
            if (mediaCertification == MediaCertification.UNKNOWN) continue;
            md.addCertification(mediaCertification);
        }
        if (StringUtils.isNotBlank((CharSequence)episode.image)) {
            MediaArtwork ma = new MediaArtwork(this.getProviderInfo().getId(), MediaArtwork.MediaArtworkType.THUMB);
            ma.setPreviewUrl(episode.image);
            ma.setDefaultUrl(episode.image);
            ma.setOriginalUrl(episode.image);
            ArtworkTypeRecord artworkTypeRecord = this.getArtworkType(episode.imageType);
            if (artworkTypeRecord != null) {
                ma.addImageSize(artworkTypeRecord.width, artworkTypeRecord.height, episode.image);
            }
            md.addMediaArt(ma);
        }
        EPISODE_CACHE_MAP.put(foundEpisode.getId(this.getId()) + "_" + options.getLanguage().getLanguage(), md);
        return md;
    }

    @Override
    public SortedSet<MediaSearchResult> search(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        List<SearchResultRecord> searchResults;
        TreeSet<MediaSearchResult> results;
        block26: {
            int tvdbId;
            this.initAPI();
            LOGGER.debug("search() {}", (Object)options);
            results = new TreeSet<MediaSearchResult>();
            String searchString = "";
            if (StringUtils.isNotBlank((CharSequence)options.getSearchQuery())) {
                searchString = options.getSearchQuery();
            }
            if ((tvdbId = options.getIdAsInt(this.getId())) != 0) {
                LOGGER.debug("found TvDb ID {} - getting direct", (Object)tvdbId);
                try {
                    MediaMetadata md = this.getMetadata(options);
                    if (md != null) {
                        results.add(this.morphMediaMetadataToSearchResult(md, MediaType.TV_SHOW));
                        return results;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("problem getting data vom tvdb via ID: {}", (Object)e.getMessage());
                }
            }
            searchResults = null;
            if (StringUtils.isNotBlank((CharSequence)searchString)) {
                try {
                    Response httpResponse = this.tvdb.getSearchService().getSearch(searchString, SearchType.SERIES).execute();
                    if (!httpResponse.isSuccessful()) {
                        throw new HttpException(httpResponse.code(), httpResponse.message());
                    }
                    searchResults = ((SearchResultResponse)httpResponse.body()).data;
                    if (!ListUtils.isEmpty(searchResults) || !ID_PATTERN.matcher(searchString).matches()) break block26;
                    LOGGER.debug("nothing found, but search term '{}' looks like a TvDb ID - getting direct", (Object)searchString);
                    try {
                        MediaMetadata md = this.getMetadata(options);
                        if (md != null) {
                            results.add(this.morphMediaMetadataToSearchResult(md, MediaType.TV_SHOW));
                            return results;
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("problem getting data vom tvdb via ID: {}", (Object)e.getMessage());
                    }
                }
                catch (Exception e) {
                    LOGGER.error("problem getting data vom tvdb: {}", (Object)e.getMessage());
                    throw new ScrapeException(e);
                }
            }
        }
        if (ListUtils.isEmpty(searchResults)) {
            return results;
        }
        HashMap<String, MediaSearchResult> resultMap = new HashMap<String, MediaSearchResult>();
        for (SearchResultRecord searchResultRecord : searchResults) {
            String title;
            MediaSearchResult result = new MediaSearchResult(this.getId(), options.getMediaType());
            String id = "";
            if (StringUtils.isNotBlank((CharSequence)searchResultRecord.tvdbId)) {
                id = searchResultRecord.tvdbId;
            } else if (StringUtils.isNotBlank((CharSequence)searchResultRecord.id)) {
                id = searchResultRecord.id.replace("series-", "");
            }
            if (StringUtils.isBlank((CharSequence)id)) continue;
            result.setId(id);
            MediaLanguages baseLanguage = options.getLanguage();
            MediaLanguages fallbackLanguage = null;
            if (StringUtils.isNotBlank((CharSequence)this.getProviderInfo().getConfig().getValue("fallbackLanguage"))) {
                fallbackLanguage = MediaLanguages.get(this.getProviderInfo().getConfig().getValue("fallbackLanguage"));
            }
            if (StringUtils.isNotBlank((CharSequence)(title = this.parseLocalizedText(baseLanguage, searchResultRecord.translations)))) {
                result.setTitle(title);
            } else {
                title = this.parseLocalizedText(fallbackLanguage, searchResultRecord.translations);
                if (StringUtils.isNotBlank((CharSequence)title)) {
                    result.setTitle(title);
                } else {
                    result.setTitle(searchResultRecord.name);
                }
            }
            String overview = this.parseLocalizedText(baseLanguage, searchResultRecord.overviews);
            if (StringUtils.isNotBlank((CharSequence)overview)) {
                result.setOverview(overview);
            } else {
                overview = this.parseLocalizedText(fallbackLanguage, searchResultRecord.overviews);
                if (StringUtils.isNotBlank((CharSequence)overview)) {
                    result.setOverview(overview);
                } else {
                    result.setOverview(searchResultRecord.overview);
                }
            }
            result.setYear(MetadataUtil.parseInt(searchResultRecord.year, 0));
            result.setPosterUrl(searchResultRecord.imageUrl);
            result.calculateScore(options);
            resultMap.put(id, result);
        }
        results.addAll(resultMap.values());
        return results;
    }

    @Override
    public List<MediaMetadata> getEpisodeList(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        SeriesEpisodesRecord seriesEpisodesRecord;
        LOGGER.debug("getEpisodeList(): {}", (Object)options);
        this.initAPI();
        Integer showId = options.getIdAsInteger(this.getProviderInfo().getId());
        if (showId == null || showId == 0) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{this.getProviderInfo().getId()});
        }
        List<MediaMetadata> episodes = EPISODE_LIST_CACHE_MAP.get(showId + "_" + options.getLanguage().getLanguage());
        if (ListUtils.isNotEmpty(episodes)) {
            return episodes;
        }
        EnumMap<SeasonType, List> eps = new EnumMap<SeasonType, List>(SeasonType.class);
        int pageSize = 500;
        int counter = 0;
        while ((seriesEpisodesRecord = this.getSeriesEpisodesRecord(showId, SeasonType.DEFAULT, counter)) != null && !ListUtils.isEmpty(seriesEpisodesRecord.episodes)) {
            if (ListUtils.isNotEmpty(seriesEpisodesRecord.episodes)) {
                this.injectEpisodeTranslations(options, showId, counter, seriesEpisodesRecord);
                eps.computeIfAbsent(SeasonType.DEFAULT, seasonType -> new ArrayList()).addAll(seriesEpisodesRecord.episodes);
            }
            if (seriesEpisodesRecord.episodes.size() < pageSize) break;
            ++counter;
        }
        counter = 0;
        while ((seriesEpisodesRecord = this.getSeriesEpisodesRecord(showId, SeasonType.DVD, counter)) != null && !ListUtils.isEmpty(seriesEpisodesRecord.episodes)) {
            if (ListUtils.isNotEmpty(seriesEpisodesRecord.episodes)) {
                eps.computeIfAbsent(SeasonType.DVD, seasonType -> new ArrayList()).addAll(seriesEpisodesRecord.episodes);
            }
            if (seriesEpisodesRecord.episodes.size() < pageSize) break;
            ++counter;
        }
        counter = 0;
        while ((seriesEpisodesRecord = this.getSeriesEpisodesRecord(showId, SeasonType.ABSOLUTE, counter)) != null && !ListUtils.isEmpty(seriesEpisodesRecord.episodes)) {
            if (ListUtils.isNotEmpty(seriesEpisodesRecord.episodes)) {
                eps.computeIfAbsent(SeasonType.ABSOLUTE, seasonType -> new ArrayList()).addAll(seriesEpisodesRecord.episodes);
            }
            if (seriesEpisodesRecord.episodes.size() < pageSize) break;
            ++counter;
        }
        HashMap<Integer, MediaMetadata> episodeMap = new HashMap<Integer, MediaMetadata>();
        for (Map.Entry entry : eps.entrySet()) {
            SeasonType seasonType2 = (SeasonType)((Object)entry.getKey());
            for (EpisodeBaseRecord ep : (List)entry.getValue()) {
                MediaMetadata fromMap = (MediaMetadata)episodeMap.get(ep.id);
                if (fromMap == null) {
                    MediaMetadata episode = new MediaMetadata(this.getProviderInfo().getId());
                    episode.setScrapeOptions(options);
                    episode.setId(this.getProviderInfo().getId(), ep.id);
                    this.setEpisodeNumber(episode, ep, seasonType2);
                    episode.setTitle(ep.name);
                    episode.setPlot(ep.overview);
                    episode.setRuntime(ep.runtime);
                    try {
                        episode.setReleaseDate(StrgUtils.parseDate(ep.aired));
                    }
                    catch (Exception ignored) {
                        LOGGER.trace("Could not parse date: {}", (Object)ep.aired);
                    }
                    episodeMap.put(MetadataUtil.unboxInteger(ep.id), episode);
                    continue;
                }
                this.setEpisodeNumber(fromMap, ep, seasonType2);
            }
        }
        episodes = new ArrayList(episodeMap.values());
        episodes.sort((o1, o2) -> {
            if (o1.getSeasonNumber() != o2.getSeasonNumber()) {
                return o1.getSeasonNumber() - o2.getSeasonNumber();
            }
            return o1.getEpisodeNumber() - o2.getEpisodeNumber();
        });
        if (!episodes.isEmpty()) {
            EPISODE_LIST_CACHE_MAP.put(showId + "_" + options.getLanguage().getLanguage(), episodes);
        }
        return episodes;
    }

    @Override
    public Map<String, Object> getMediaIds(Map<String, Object> ids, MediaType mediaType) throws ScrapeException {
        SeriesExtendedRecord show;
        if (mediaType != MediaType.TV_SHOW) {
            return Collections.emptyMap();
        }
        this.initAPI();
        LOGGER.debug("getMediaIds(): {}", ids);
        int id = MediaIdUtil.getIdAsInt(ids, this.getId());
        if (id == 0 && MediaIdUtil.isValidImdbId(MediaIdUtil.getIdAsString(ids, "imdb"))) {
            id = this.getTvdbIdViaImdbId(MediaIdUtil.getIdAsString(ids, "imdb"));
        }
        if (id == 0) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{this.getId()});
        }
        try {
            Response httpResponse = this.tvdb.getSeriesService().getSeriesExtended(id).execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            show = ((SeriesExtendedResponse)httpResponse.body()).data;
        }
        catch (Exception e) {
            LOGGER.error("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (show == null) {
            throw new NothingFoundException();
        }
        HashMap<String, Object> showIds = new HashMap<String, Object>();
        showIds.put(this.getId(), show.id);
        for (RemoteID remoteID : ListUtils.nullSafe(show.remoteIds)) {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{remoteID.sourceName, remoteID.id})) continue;
            switch (remoteID.sourceName) {
                case "IMDB": {
                    if (!MediaIdUtil.isValidImdbId(remoteID.id)) break;
                    showIds.put("imdb", remoteID.id);
                    break;
                }
                case "Zap2It": {
                    showIds.put("zap2it", remoteID.id);
                    break;
                }
                case "TheMovieDB.com": {
                    showIds.put("tmdb", MetadataUtil.parseInt(remoteID.id, 0));
                    break;
                }
            }
        }
        return showIds;
    }

    private SeriesEpisodesRecord getSeriesEpisodesRecord(int showId, SeasonType seasonType, int counter) {
        try {
            Response httpResponse = this.tvdb.getSeriesService().getSeriesEpisodes(showId, seasonType, counter).execute();
            if (httpResponse.isSuccessful()) {
                SeriesEpisodesResponse response = (SeriesEpisodesResponse)httpResponse.body();
                if (response != null) {
                    return response.data;
                }
            } else if (counter == 0) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
        }
        catch (Exception e) {
            LOGGER.debug("Could not get episode listing for season type '{}' - '{}'  ", (Object)seasonType, (Object)e.getMessage());
        }
        return null;
    }

    private void injectEpisodeTranslations(TvShowSearchAndScrapeOptions options, int showId, int counter, SeriesEpisodesRecord seriesEpisodesRecord) {
        String fallbackLanguage;
        HashMap<EpisodeBaseRecord, String> titleMap = new HashMap<EpisodeBaseRecord, String>();
        HashMap<EpisodeBaseRecord, String> originalTitleMap = new HashMap<EpisodeBaseRecord, String>();
        for (EpisodeBaseRecord toInject : ListUtils.nullSafe(seriesEpisodesRecord.episodes)) {
            titleMap.put(toInject, toInject.name);
            originalTitleMap.put(toInject, toInject.originalName);
            toInject.originalName = null;
            toInject.name = null;
            toInject.overview = null;
        }
        String language = LanguageUtils.getIso3Language(options.getLanguage().toLocale());
        if ("pob".equals(language)) {
            language = "pt";
        }
        if (StringUtils.isNotBlank((CharSequence)language)) {
            try {
                SeriesEpisodesResponse response;
                Response httpResponse = this.tvdb.getSeriesService().getSeriesEpisodes(showId, SeasonType.DEFAULT, language, counter).execute();
                if (httpResponse.isSuccessful() && (response = (SeriesEpisodesResponse)httpResponse.body()) != null && response.data != null) {
                    for (EpisodeBaseRecord toInject : ListUtils.nullSafe(seriesEpisodesRecord.episodes)) {
                        for (EpisodeBaseRecord translation : ListUtils.nullSafe(response.data.episodes)) {
                            if (!Objects.equals(toInject.id, translation.id)) continue;
                            if (language.equals(seriesEpisodesRecord.series.originalLanguage)) {
                                toInject.originalName = translation.name;
                            }
                            if (StringUtils.isNotBlank((CharSequence)translation.name)) {
                                toInject.name = translation.name;
                            }
                            if (!StringUtils.isNotBlank((CharSequence)translation.overview)) continue;
                            toInject.overview = translation.overview;
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.debug("Could not get episode translations - '{}'  ", (Object)e.getMessage());
            }
        }
        if ("pob".equals(fallbackLanguage = LanguageUtils.getIso3Language(MediaLanguages.get(this.getProviderInfo().getConfig().getValue("fallbackLanguage")).toLocale()))) {
            fallbackLanguage = "pt";
        }
        if (StringUtils.isNotBlank((CharSequence)fallbackLanguage) && !fallbackLanguage.equals(language)) {
            try {
                SeriesEpisodesResponse response;
                Response httpResponse = this.tvdb.getSeriesService().getSeriesEpisodes(showId, SeasonType.DEFAULT, fallbackLanguage, counter).execute();
                if (httpResponse.isSuccessful() && (response = (SeriesEpisodesResponse)httpResponse.body()) != null && response.data != null) {
                    for (EpisodeBaseRecord toInject : ListUtils.nullSafe(seriesEpisodesRecord.episodes)) {
                        for (EpisodeBaseRecord translation : ListUtils.nullSafe(response.data.episodes)) {
                            if (!Objects.equals(toInject.id, translation.id)) continue;
                            if (StringUtils.isBlank((CharSequence)toInject.name) && StringUtils.isNotBlank((CharSequence)translation.name)) {
                                toInject.name = translation.name;
                            }
                            if (!StringUtils.isBlank((CharSequence)toInject.overview) || !StringUtils.isNotBlank((CharSequence)translation.overview)) continue;
                            toInject.overview = translation.overview;
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.debug("Could not get episode translations - '{}'  ", (Object)e.getMessage());
            }
        }
        for (EpisodeBaseRecord toInject : ListUtils.nullSafe(seriesEpisodesRecord.episodes)) {
            if (StringUtils.isBlank((CharSequence)toInject.name)) {
                toInject.name = (String)titleMap.get(toInject);
            }
            if (StringUtils.isBlank((CharSequence)toInject.name)) {
                toInject.name = "Episode " + toInject.episodeNumber;
            }
            if (StringUtils.isBlank((CharSequence)toInject.originalName)) {
                toInject.originalName = (String)originalTitleMap.get(toInject);
            }
            if (!StringUtils.isBlank((CharSequence)toInject.originalName)) continue;
            toInject.originalName = "Episode " + toInject.episodeNumber;
        }
    }

    private void setEpisodeNumber(MediaMetadata md, EpisodeBaseRecord ep, SeasonType seasonType) {
        switch (seasonType) {
            case DEFAULT: {
                md.setSeasonNumber(ep.seasonNumber);
                md.setEpisodeNumber(ep.episodeNumber);
                break;
            }
            case DVD: {
                md.setDvdSeasonNumber(ep.seasonNumber);
                md.setDvdEpisodeNumber(ep.episodeNumber);
                break;
            }
            case ABSOLUTE: {
                md.setAbsoluteNumber(ep.episodeNumber);
            }
        }
    }
}

