/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tmdb;

import java.util.Locale;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.tmdb.TmdbController;
import org.tinymediamanager.scraper.tmdb.entities.Configuration;
import org.tinymediamanager.scraper.tmdb.entities.Genre;
import org.tinymediamanager.scraper.tmdb.entities.Translations;
import org.tinymediamanager.scraper.util.MetadataUtil;
import retrofit2.Response;

abstract class TmdbMetadataProvider
implements IMediaProvider {
    static final String ID = "tmdb";
    protected static final String[] PT = new String[]{"af-ZA", "ar-AE", "ar-SA", "be-BY", "bg-BG", "bn-BD", "ca-ES", "ch-GU", "cn-CN", "cs-CZ", "cy-GB", "da-DK", "de-AT", "de-CH", "de-DE", "el-GR", "en-AU", "en-CA", "en-GB", "en-IE", "en-NZ", "en-US", "eo-EO", "es-ES", "es-MX", "et-EE", "eu-ES", "fa-IR", "fi-FI", "fr-CA", "fr-FR", "ga-IE", "gd-GB", "gl-ES", "he-IL", "hi-IN", "hr-HR", "hu-HU", "id-ID", "it-IT", "ja-JP", "ka-GE", "kk-KZ", "kn-IN", "ko-KR", "ky-KG", "lt-LT", "lv-LV", "ml-IN", "mr-IN", "ms-MY", "ms-SG", "nb-NO", "nl-BE", "nl-NL", "no-NO", "pa-IN", "pl-PL", "pt-BR", "pt-PT", "ro-RO", "ru-RU", "si-LK", "sk-SK", "sl-SI", "sq-AL", "sr-RS", "sv-SE", "ta-IN", "te-IN", "th-TH", "tl-PH", "tr-TR", "uk-UA", "vi-VN", "zh-CN", "zh-HK", "zh-SG", "zh-TW", "zu-ZA"};
    private final MediaProviderInfo providerInfo = this.createMediaProviderInfo();
    protected TmdbController api;
    protected Configuration configuration;
    protected String artworkBaseUrl;

    TmdbMetadataProvider() {
    }

    protected abstract String getSubId();

    protected MediaProviderInfo createMediaProviderInfo() {
        return new MediaProviderInfo(ID, this.getSubId(), "themoviedb.org", "<html><h3>The Movie Database (TMDb)</h3><br />The largest free movie database maintained by the community. It provides metadata and artwork<br />in many different languages. Thus it is the first choice for non english users<br /><br />Available languages: multiple</html>", TmdbMetadataProvider.class.getResource("/org/tinymediamanager/scraper/themoviedb_org.svg"), 50);
    }

    @Override
    public boolean isActive() {
        return this.isFeatureEnabled() && this.isApiKeyAvailable(this.providerInfo.getConfig().getValue("apiKey"));
    }

    protected synchronized void initAPI() throws ScrapeException {
        String userApiKey;
        if (this.api != null) {
            userApiKey = this.providerInfo.getConfig().getValue("apiKey");
            if (StringUtils.isNotBlank((CharSequence)userApiKey) && !userApiKey.equals(this.api.apiKey())) {
                this.api = null;
            } else if (StringUtils.isBlank((CharSequence)userApiKey) && !this.getApiKey().equals(this.api.apiKey())) {
                this.api = null;
            }
        }
        if (this.api == null) {
            if (!this.isActive()) {
                throw new ScrapeException(new FeatureNotEnabledException(this));
            }
            try {
                userApiKey = this.providerInfo.getConfig().getValue("apiKey");
                this.api = new TmdbController(StringUtils.isNotBlank((CharSequence)userApiKey) ? userApiKey : this.getApiKey());
                Response response = this.api.configurationService().configuration().execute();
                if (response.code() == 401) {
                    throw new ScrapeException("Invalid TMDB API key");
                }
                if (response.body() == null) {
                    throw new ScrapeException("Could not contact TMDB API - " + response.message());
                }
                this.configuration = (Configuration)response.body();
                this.artworkBaseUrl = this.configuration.images.secure_base_url;
            }
            catch (ScrapeException e) {
                this.getLogger().error("could not initialize the API: {}", (Object)e.getMessage());
                this.api = null;
                throw e;
            }
            catch (Exception e) {
                this.getLogger().error("could not initialize the API: {}", (Object)e.getMessage());
                this.api = null;
                throw new ScrapeException(e);
            }
        }
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    protected abstract Logger getLogger();

    protected Translations.Translation getTranslationForLocale(Translations translations, Locale locale) {
        Translations.Translation ret = null;
        if (translations != null && translations.translations != null && !translations.translations.isEmpty()) {
            for (Translations.Translation tr : translations.translations) {
                if (!tr.iso_639_1.equals(locale.getLanguage()) || !tr.iso_3166_1.equals(locale.getCountry())) continue;
                ret = tr;
                break;
            }
            if (ret == null) {
                block5 : switch (locale.toString()) {
                    case "es_MX": 
                    case "pt_BR": 
                    case "fr_CA": {
                        break;
                    }
                    default: {
                        for (Translations.Translation tr : translations.translations) {
                            if (!tr.iso_639_1.equals(locale.getLanguage()) && !tr.iso_3166_1.equals(locale.getCountry())) continue;
                            ret = tr;
                            break block5;
                        }
                    }
                }
            }
        }
        return ret;
    }

    protected String[] getValuesFromTranslation(Translations translations, Locale locale) {
        String[] ret = new String[]{"", ""};
        Translations.Translation tr = this.getTranslationForLocale(translations, locale);
        if (tr == null || tr.data == null) {
            return ret;
        }
        if (StringUtils.isNotBlank((CharSequence)tr.data.title)) {
            ret[0] = tr.data.title;
        }
        if (StringUtils.isNotBlank((CharSequence)tr.data.name)) {
            ret[0] = tr.data.name;
        }
        if (StringUtils.isNotBlank((CharSequence)tr.data.overview)) {
            ret[1] = tr.data.overview;
        }
        return ret;
    }

    static MediaGenres getTmmGenre(Genre genre) {
        if (genre == null || MetadataUtil.unboxInteger(genre.id) == 0) {
            return null;
        }
        MediaGenres g = null;
        switch (genre.id) {
            case 28: 
            case 10759: {
                g = MediaGenres.ACTION;
                break;
            }
            case 12: {
                g = MediaGenres.ADVENTURE;
                break;
            }
            case 16: {
                g = MediaGenres.ANIMATION;
                break;
            }
            case 35: {
                g = MediaGenres.COMEDY;
                break;
            }
            case 80: {
                g = MediaGenres.CRIME;
                break;
            }
            case 105: {
                g = MediaGenres.DISASTER;
                break;
            }
            case 99: {
                g = MediaGenres.DOCUMENTARY;
                break;
            }
            case 18: {
                g = MediaGenres.DRAMA;
                break;
            }
            case 82: {
                g = MediaGenres.EASTERN;
                break;
            }
            case 2916: {
                g = MediaGenres.EROTIC;
                break;
            }
            case 10751: {
                g = MediaGenres.FAMILY;
                break;
            }
            case 10750: {
                g = MediaGenres.FAN_FILM;
                break;
            }
            case 14: {
                g = MediaGenres.FANTASY;
                break;
            }
            case 10753: {
                g = MediaGenres.FILM_NOIR;
                break;
            }
            case 10769: {
                g = MediaGenres.FOREIGN;
                break;
            }
            case 36: {
                g = MediaGenres.HISTORY;
                break;
            }
            case 10595: {
                g = MediaGenres.HOLIDAY;
                break;
            }
            case 27: {
                g = MediaGenres.HORROR;
                break;
            }
            case 10756: {
                g = MediaGenres.INDIE;
                break;
            }
            case 10402: {
                g = MediaGenres.MUSIC;
                break;
            }
            case 22: {
                g = MediaGenres.MUSICAL;
                break;
            }
            case 9648: {
                g = MediaGenres.MYSTERY;
                break;
            }
            case 10754: {
                g = MediaGenres.NEO_NOIR;
                break;
            }
            case 10763: {
                g = MediaGenres.NEWS;
                break;
            }
            case 10764: {
                g = MediaGenres.REALITY_TV;
                break;
            }
            case 1115: {
                g = MediaGenres.ROAD_MOVIE;
                break;
            }
            case 10749: {
                g = MediaGenres.ROMANCE;
                break;
            }
            case 878: 
            case 10765: {
                g = MediaGenres.SCIENCE_FICTION;
                break;
            }
            case 10755: {
                g = MediaGenres.SHORT;
                break;
            }
            case 10766: {
                g = MediaGenres.SOAP;
                break;
            }
            case 9805: {
                g = MediaGenres.SPORT;
                break;
            }
            case 10758: {
                g = MediaGenres.SPORTING_EVENT;
                break;
            }
            case 10757: {
                g = MediaGenres.SPORTS_FILM;
                break;
            }
            case 10748: {
                g = MediaGenres.SUSPENSE;
                break;
            }
            case 10767: {
                g = MediaGenres.TALK_SHOW;
                break;
            }
            case 10770: {
                g = MediaGenres.TV_MOVIE;
                break;
            }
            case 53: {
                g = MediaGenres.THRILLER;
                break;
            }
            case 10752: 
            case 10768: {
                g = MediaGenres.WAR;
                break;
            }
            case 37: {
                g = MediaGenres.WESTERN;
            }
        }
        if (g == null) {
            g = MediaGenres.getGenre(genre.name);
        }
        return g;
    }

    static String getRequestLanguage(MediaLanguages language) {
        Locale locale;
        String name = language.name();
        if (name.length() > 2) {
            locale = language.toLocale();
        } else {
            locale = new Locale(name, name.toUpperCase(Locale.ROOT));
            if (!LocaleUtils.isAvailableLocale((Locale)locale)) {
                locale = language.toLocale();
            }
        }
        if (locale == null) {
            return null;
        }
        return locale.toLanguageTag();
    }
}

